/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.biz.service.login.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.geoway.design.base.base.dto.ResponseDataBase;
import com.geoway.design.base.exception.ResetPasswordException;
import com.geoway.design.biz.config.ProjectConfig;
import com.geoway.design.biz.entity.SysUserRole;
import com.geoway.design.biz.mapper.SysUserSecurityMapper;
import com.geoway.design.biz.service.login.ISysLoginService;
import com.geoway.design.biz.service.oauth2.IOauth2Service;
import com.geoway.design.biz.service.sys.ISysUserRoleService;
import com.geoway.design.biz.util.PasswordUtil;
import com.geoway.sso.client.enums.GrantTypeEnum;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.RpcAccessToken;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.client.session.redis.RedisSessionMappingStorage;
import com.geoway.sso.client.util.Oauth2Utils;
import com.geoway.sso.client.util.SessionUtils;
import com.geoway.sso.client.util.SsoCheckLogin;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SysLoginServiceImpl
implements ISysLoginService {
    private static final Logger log = LoggerFactory.getLogger(SysLoginServiceImpl.class);
    @Autowired
    private ProjectConfig projectConfig;
    @Autowired
    private RedisSessionMappingStorage sessionMappingStorage;
    @Autowired
    private ISysUserRoleService sysUserRoleService;
    @Autowired
    private IOauth2Service ssoOauth2Service;
    @Autowired
    private SysUserSecurityMapper sysUserSecurityMapper;
    @Autowired
    private PasswordUtil passwordUtil;
    @Value(value="${password.forceChangeInitPWD:true}")
    private Boolean forceChangeInitPWD;
    @Value(value="${sso.setting.singeUser:false}")
    private Boolean singeUser;

    @Override
    public ResponseDataBase checkLogin(String username, String password, String uuid, String code, HttpServletRequest request) {
        ResponseDataBase response = new ResponseDataBase();
        try {
            RpcAccessToken rpcAccessToken = this.ssoOauth2Service.getAccessToken(GrantTypeEnum.PASSWORD_CAPTCHA.getValue(), this.projectConfig.getSsoAppId(), this.projectConfig.getSsoAppSecret(), "", username, password, "", uuid, code);
            SessionUtils.setAccessToken((HttpServletRequest)request, (RpcAccessToken)rpcAccessToken);
            SsoUser user = rpcAccessToken.getUser();
            response.put((Object)"token", (Object)rpcAccessToken.getAccessToken());
            response.put((Object)"userId", (Object)user.getId());
            response.put((Object)"username", (Object)user.getLoginName());
            response.put((Object)"alisname", (Object)user.getUserName());
            response.put((Object)"role", (Object)this.sysUserRoleService.listObjs((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SysUserRole.class).eq(SysUserRole::getUserid, (Object)user.getId())).select(new SFunction[]{SysUserRole::getRoleid}), a -> (String)a));
            response.put((Object)"status", (Object)"OK");
            response.put((Object)"validateType", (Object)"sso");
            response.put((Object)"passwordPolicy", (Object)user.getPasswordPolicy());
            response.put((Object)"userCatalog", (Object)user.getUserCatalog());
            response.put((Object)"regionCode", (Object)user.getRegionCode());
            response.put((Object)"regionName", (Object)user.getRegionName());
        }
        catch (Exception e) {
            if (e instanceof ResetPasswordException) {
                return ResponseDataBase.resetPassword((String)e.getMessage());
            }
            return ResponseDataBase.error((String)e.getMessage());
        }
        return response;
    }

    @Override
    public ResponseDataBase checkLogin(String username, String password, HttpServletRequest request) {
        ResponseDataBase response = new ResponseDataBase();
        try {
            RpcAccessToken rpcAccessToken = this.ssoOauth2Service.getAccessToken(GrantTypeEnum.PASSWORD.getValue(), this.projectConfig.getSsoAppId(), this.projectConfig.getSsoAppSecret(), "", username, password, "", "", "");
            SessionUtils.setAccessToken((HttpServletRequest)request, (RpcAccessToken)rpcAccessToken);
            SsoUser user = rpcAccessToken.getUser();
            response.put((Object)"token", (Object)rpcAccessToken.getAccessToken());
            response.put((Object)"refreshToken", (Object)rpcAccessToken.getRefreshToken());
            response.put((Object)"userId", (Object)user.getId());
            response.put((Object)"username", (Object)user.getLoginName());
            response.put((Object)"alisname", (Object)user.getUserName());
            response.put((Object)"status", (Object)"OK");
            response.put((Object)"validateType", (Object)"sso");
            response.put((Object)"passwordPolicy", (Object)user.getPasswordPolicy());
            response.put((Object)"regionCode", (Object)user.getRegionCode());
            response.put((Object)"regionName", (Object)user.getRegionName());
            response.put((Object)"userCatalog", (Object)user.getUserCatalog());
        }
        catch (Exception e) {
            if (e instanceof ResetPasswordException) {
                return ResponseDataBase.resetPassword((String)e.getMessage());
            }
            return ResponseDataBase.error((String)e.getMessage());
        }
        return response;
    }

    @Override
    public String redirectToSsoLogin(String redirectUri) {
        String loginUrl = "";
        try {
            loginUrl = this.projectConfig.getSsoServerUrl() + "/login" + "?" + "appId" + "=" + this.projectConfig.getSsoAppId() + "&" + "redirectUri" + "=" + URLEncoder.encode(redirectUri, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return loginUrl;
    }

    @Override
    public String getSsoLogoutUrl(String redirectUri, HttpServletRequest request) {
        SsoCheckLogin ssoCheckLogin = new SsoCheckLogin(this.projectConfig.getSsoServerUrl());
        return ssoCheckLogin.userLogut(redirectUri, request);
    }

    @Override
    public Result<RpcAccessToken> getAccessTokenByCode(String code, HttpServletRequest request) {
        Result result = Oauth2Utils.getAccessToken((String)this.projectConfig.getSsoServerUrl(), (String)this.projectConfig.getSsoAppId(), (String)this.projectConfig.getSsoAppSecret(), (String)code);
        this.setAccessTokenInSession((RpcAccessToken)result.getData(), request);
        return result;
    }

    @Override
    public ResponseDataBase restLogout(HttpServletRequest request, String access_token) {
        SessionUtils.invalidate((HttpServletRequest)request);
        Result result = Oauth2Utils.revokeAccessToken((String)this.projectConfig.getSsoServerUrl(), (String)access_token);
        if (result.isSuccess()) {
            return ResponseDataBase.ok();
        }
        return ResponseDataBase.error((String)"\u9000\u51fa\u5931\u8d25");
    }

    @Override
    public boolean checkIsResetPassword(String accessToken) {
        return this.ssoOauth2Service.checkIsResetPassword(accessToken);
    }

    @Override
    public ResponseDataBase validUserOnline(String username, String password) {
        ResponseDataBase response = new ResponseDataBase();
        boolean isLogin = this.ssoOauth2Service.validUserOnline(username, password);
        response.put((Object)"singeUser", (Object)this.singeUser);
        response.put((Object)"isLogin", (Object)isLogin);
        return response;
    }

    private boolean setAccessTokenInSession(RpcAccessToken rpcAccessToken, HttpServletRequest request) {
        if (rpcAccessToken == null) {
            return false;
        }
        SessionUtils.setAccessToken((HttpServletRequest)request, (RpcAccessToken)rpcAccessToken);
        this.recordSession(request, rpcAccessToken.getAccessToken(), rpcAccessToken.getUser().getLoginName());
        return true;
    }

    private void recordSession(HttpServletRequest request, String accessToken, String userName) {
        HttpSession session = request.getSession();
        this.sessionMappingStorage.removeBySessionById(session.getId());
        this.sessionMappingStorage.addSessionById(accessToken, session);
        this.sessionMappingStorage.removeTokenByUserName(userName);
        this.sessionMappingStorage.addTokenByUserName(accessToken, userName);
    }
}

