/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.biz.service.oauth2.impl;

import cn.hutool.core.util.StrUtil;
import com.geoway.design.base.exception.ResetPasswordException;
import com.geoway.design.biz.service.dev.IUnityLoginService;
import com.geoway.design.biz.service.dev.impl.LoginSysFactory;
import com.geoway.design.biz.service.login.ISsoAppService;
import com.geoway.design.biz.service.oauth2.IOauth2Service;
import com.geoway.design.biz.service.sys.SysUserLimitService;
import com.geoway.design.biz.util.GuestUtil;
import com.geoway.sso.client.enums.GrantTypeEnum;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.RpcAccessToken;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.client.util.CookieUtils;
import com.geoway.sso.client.util.SessionUtils;
import com.geoway.sso.server.common.AccessTokenContent;
import com.geoway.sso.server.common.CodeContent;
import com.geoway.sso.server.common.RefreshTokenContent;
import com.geoway.sso.server.session.AccessTokenManager;
import com.geoway.sso.server.session.CodeManager;
import com.geoway.sso.server.session.RefreshTokenManager;
import com.geoway.sso.server.session.TicketGrantingTicketManager;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class Oauth2ServiceImpl
implements IOauth2Service {
    private static final Logger log = LoggerFactory.getLogger(Oauth2ServiceImpl.class);
    @Autowired
    private ISsoAppService ssoAppService;
    @Autowired
    private IUnityLoginService userService;
    @Autowired
    private LoginSysFactory loginSysFactory;
    @Autowired
    private CodeManager codeManager;
    @Autowired
    private AccessTokenManager accessTokenManager;
    @Autowired
    private RefreshTokenManager refreshTokenManager;
    @Autowired
    private TicketGrantingTicketManager ticketGrantingTicketManager;
    @Autowired
    private SysUserLimitService sysUserLimitService;
    @Value(value="${sso.setting.singeUser:false}")
    private Boolean singeUser;

    @Override
    public RpcAccessToken getAccessToken(String grantType, String appId, String appSecret, String code, String username, String password, String tel, String sessionId, String catpcha) {
        String oldToken;
        Result<Void> result = this.validateParam(grantType, code, username, password, sessionId, catpcha);
        if (!result.isSuccess()) {
            throw new RuntimeException(result.getMessage());
        }
        Result<Void> appResult = this.ssoAppService.validate(appId, appSecret);
        if (!appResult.isSuccess()) {
            throw new RuntimeException(appResult.getMessage());
        }
        Result<AccessTokenContent> accessTokenResult = this.validateAuth(grantType, code, username, password, tel, appId, sessionId, catpcha);
        if (accessTokenResult.getCode() == 3003) {
            throw new ResetPasswordException(accessTokenResult.getMessage());
        }
        if (!accessTokenResult.isSuccess()) {
            throw new RuntimeException(accessTokenResult.getMessage());
        }
        String userId = ((AccessTokenContent)accessTokenResult.getData()).getUser().getId();
        boolean isValid = this.sysUserLimitService.isValid(appId, userId);
        if (!isValid) {
            throw new RuntimeException("\u8be5\u7528\u6237\u88ab\u9650\u5236\u8bbf\u95ee\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        if (this.singeUser.booleanValue() && StrUtil.isNotBlank((CharSequence)(oldToken = this.accessTokenManager.getAccessTokenByUserId(userId)))) {
            this.accessTokenManager.removeOnlineUser(userId);
            SessionUtils.invalidate((String)oldToken);
        }
        return this.genereateRpcAccessToken((AccessTokenContent)accessTokenResult.getData(), null);
    }

    @Override
    public RpcAccessToken refreshToken(String appId, String refreshToken) {
        if (GuestUtil.validateGuestToken(refreshToken)) {
            return GuestUtil.getGuestRpcAccessToken(refreshToken);
        }
        if (!this.ssoAppService.exists(appId)) {
            throw new RuntimeException("\u975e\u6cd5\u5e94\u7528");
        }
        RefreshTokenContent refreshTokenContent = this.refreshTokenManager.validate(refreshToken);
        if (refreshTokenContent == null) {
            throw new RuntimeException("refreshToken\u6709\u8bef\u6216\u5df2\u8fc7\u671f");
        }
        AccessTokenContent accessTokenContent = refreshTokenContent.getAccessTokenContent();
        if (!appId.equals(accessTokenContent.getAppId())) {
            throw new RuntimeException("\u975e\u6cd5\u5e94\u7528");
        }
        SsoUser user = this.ticketGrantingTicketManager.getAndRefresh(accessTokenContent.getCodeContent().getTgt());
        if (user == null) {
            throw new RuntimeException("\u670d\u52a1\u7aefsession\u5df2\u8fc7\u671f");
        }
        return this.genereateRpcAccessToken(accessTokenContent, refreshTokenContent.getAccessToken());
    }

    @Override
    public RpcAccessToken queryAccessToken(String token) {
        if (GuestUtil.validateGuestToken(token)) {
            return GuestUtil.getGuestRpcAccessToken(token);
        }
        AccessTokenContent tokenContent = this.accessTokenManager.get(token);
        if (tokenContent != null) {
            RpcAccessToken rpcAccessToken = new RpcAccessToken(token, this.accessTokenManager.getExpiresIn(), tokenContent.getRefreshToken(), tokenContent.getUser());
            return rpcAccessToken;
        }
        throw new RuntimeException("token\u6709\u8bef\u6216\u5df2\u8fc7\u671f");
    }

    @Override
    public void revokeAccessToken(String token) {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        HttpServletResponse response = servletRequestAttributes.getResponse();
        AccessTokenContent tokenContent = this.accessTokenManager.get(token);
        if (tokenContent != null) {
            String tgt = tokenContent.getCodeContent().getTgt();
            this.ticketGrantingTicketManager.remove(tgt);
            CookieUtils.removeCookie((String)"TGC", (String)"/", (HttpServletResponse)response);
            this.accessTokenManager.remove(tgt);
            this.accessTokenManager.removeToken(token);
            if (this.singeUser.booleanValue()) {
                this.accessTokenManager.removeOnlineUser(tokenContent.getUser().getId());
            }
        } else {
            throw new RuntimeException("token\u6709\u8bef\u6216\u5df2\u8fc7\u671f");
        }
    }

    @Override
    public String queryCurrentUserId(HttpServletRequest request) {
        SsoUser ssoUser = this.queryCurrentSsoUser(request);
        if (ssoUser != null) {
            return ssoUser.getId();
        }
        return null;
    }

    @Override
    public SsoUser queryCurrentSsoUser(HttpServletRequest request) {
        AccessTokenContent accessTokenContent;
        String accessToken = request.getParameter("token");
        if (StrUtil.isBlank((CharSequence)accessToken)) {
            accessToken = request.getHeader("access_token");
        }
        if (StrUtil.isBlank((CharSequence)accessToken)) {
            accessToken = request.getHeader("access-token");
        }
        if ((accessTokenContent = this.accessTokenManager.get(accessToken)) != null) {
            return accessTokenContent.getUser();
        }
        return null;
    }

    @Override
    public RpcAccessToken getAccessToken(String appId, String appSecret, String username, String password, String accessToken) {
        String oldToken;
        Result<Void> appResult = this.ssoAppService.validate(appId, appSecret);
        if (!appResult.isSuccess()) {
            throw new RuntimeException(appResult.getMessage());
        }
        Result<SsoUser> loginResult = this.userService.login(username, password);
        if (!loginResult.isSuccess()) {
            throw new RuntimeException(loginResult.getMessage());
        }
        SsoUser user = (SsoUser)loginResult.getData();
        user.setToken(accessToken);
        String tgt = this.ticketGrantingTicketManager.generate((SsoUser)loginResult.getData());
        CodeContent codeContent = new CodeContent(tgt, false, null);
        AccessTokenContent accessTokenContent = new AccessTokenContent(codeContent, user, appId, null);
        String userId = accessTokenContent.getUser().getId();
        boolean isValid = this.sysUserLimitService.isValid(appId, userId);
        if (!isValid) {
            throw new RuntimeException("\u8be5\u7528\u6237\u88ab\u9650\u5236\u8bbf\u95ee\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        if (this.singeUser.booleanValue() && StrUtil.isNotBlank((CharSequence)(oldToken = this.accessTokenManager.getAccessTokenByUserId(userId)))) {
            this.accessTokenManager.removeOnlineUser(userId);
            SessionUtils.invalidate((String)oldToken);
        }
        return this.genereateRpcAccessToken2(accessTokenContent);
    }

    @Override
    public boolean checkIsResetPassword(String token) {
        RpcAccessToken rpcToken = this.queryAccessToken(token);
        if (rpcToken != null && rpcToken.getUser() != null) {
            return this.loginSysFactory.getService().checkIsResetPassword(rpcToken.getUser().getUserid());
        }
        return false;
    }

    @Override
    public boolean validUserOnline(String username, String password) {
        boolean flag = false;
        Result<SsoUser> loginResult = this.userService.login(username, password);
        if (loginResult == null) {
            return false;
        }
        if (!loginResult.isSuccess() || loginResult.getData() == null) {
            return false;
        }
        String token = this.accessTokenManager.getAccessTokenByUserId(((SsoUser)loginResult.getData()).getUserid());
        flag = StrUtil.isNotBlank((CharSequence)token);
        return flag;
    }

    private Result<Void> validateParam(String grantType, String code, String username, String password, String sessionId, String catpcha) {
        if (GrantTypeEnum.AUTHORIZATION_CODE.getValue().equals(grantType)) {
            if (StringUtils.isEmpty((Object)code)) {
                return Result.createError((String)"code\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else if (GrantTypeEnum.PASSWORD.getValue().equals(grantType)) {
            if (StringUtils.isEmpty((Object)username) || StringUtils.isEmpty((Object)password)) {
                return Result.createError((String)"username\u548cpassword\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else if (GrantTypeEnum.PASSWORD_CAPTCHA.getValue().equals(grantType)) {
            if (StringUtils.isEmpty((Object)username) || StringUtils.isEmpty((Object)password)) {
                return Result.createError((String)"username\u548cpassword\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)sessionId) || StringUtils.isEmpty((Object)catpcha)) {
                return Result.createError((String)"\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else {
            return Result.createError((String)"\u6388\u6743\u65b9\u5f0f\u4e0d\u652f\u6301");
        }
        return Result.success();
    }

    private Result<AccessTokenContent> validateAuth(String grantType, String code, String username, String password, String tel, String appId, String sessionId, String catpcha) {
        AccessTokenContent authDto = null;
        if (GrantTypeEnum.AUTHORIZATION_CODE.getValue().equals(grantType)) {
            CodeContent codeContent = this.codeManager.getAndRemove(code);
            if (codeContent == null) {
                return Result.createError((String)"code\u6709\u8bef\u6216\u5df2\u8fc7\u671f");
            }
            SsoUser user = this.ticketGrantingTicketManager.getAndRefresh(codeContent.getTgt());
            if (user == null) {
                return Result.createError((String)"\u670d\u52a1\u7aefsession\u5df2\u8fc7\u671f");
            }
            authDto = new AccessTokenContent(codeContent, user, appId, null);
        } else if (GrantTypeEnum.PASSWORD.getValue().equals(grantType)) {
            ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
            HttpServletRequest request = servletRequestAttributes.getRequest();
            Result<SsoUser> loginResult = this.userService.login(username, password, tel, sessionId, catpcha, request);
            if (loginResult.getCode() == 3003) {
                return Result.createNeedResetPassword((String)loginResult.getMessage());
            }
            if (!loginResult.isSuccess()) {
                return Result.createError((String)loginResult.getMessage());
            }
            SsoUser user = (SsoUser)loginResult.getData();
            String tgt = this.ticketGrantingTicketManager.generate((SsoUser)loginResult.getData());
            CodeContent codeContent = new CodeContent(tgt, false, null);
            authDto = new AccessTokenContent(codeContent, user, appId, null);
        } else if (GrantTypeEnum.PASSWORD_CAPTCHA.getValue().equals(grantType)) {
            ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
            HttpServletRequest request = servletRequestAttributes.getRequest();
            Result<SsoUser> loginResult = this.userService.login(username, password, tel, sessionId, catpcha, request);
            if (loginResult.getCode() == 3003) {
                return Result.createNeedResetPassword((String)loginResult.getMessage());
            }
            if (!loginResult.isSuccess()) {
                return Result.createError((String)loginResult.getMessage());
            }
            SsoUser user = (SsoUser)loginResult.getData();
            String tgt = this.ticketGrantingTicketManager.generate((SsoUser)loginResult.getData());
            CodeContent codeContent = new CodeContent(tgt, false, null);
            authDto = new AccessTokenContent(codeContent, user, appId, null);
        }
        return Result.createSuccess(authDto);
    }

    private RpcAccessToken genereateRpcAccessToken(AccessTokenContent accessTokenContent, String accessToken) {
        String newAccessToken = accessToken;
        if (newAccessToken == null || !this.accessTokenManager.refresh(newAccessToken)) {
            newAccessToken = this.accessTokenManager.generate(accessTokenContent);
        }
        String refreshToken = this.refreshTokenManager.generate(accessTokenContent, newAccessToken);
        AccessTokenContent tokenContent = this.accessTokenManager.get(newAccessToken);
        tokenContent.setRefreshToken(refreshToken);
        this.accessTokenManager.create(newAccessToken, tokenContent);
        return new RpcAccessToken(newAccessToken, this.accessTokenManager.getExpiresIn(), refreshToken, accessTokenContent.getUser());
    }

    private RpcAccessToken genereateRpcAccessToken2(AccessTokenContent accessTokenContent) {
        String newAccessToken = this.accessTokenManager.generate(accessTokenContent);
        String refreshToken = this.refreshTokenManager.generate(accessTokenContent, newAccessToken);
        AccessTokenContent tokenContent = this.accessTokenManager.get(newAccessToken);
        tokenContent.setRefreshToken(refreshToken);
        this.accessTokenManager.create(newAccessToken, tokenContent);
        return new RpcAccessToken(newAccessToken, this.accessTokenManager.getExpiresIn(), refreshToken, accessTokenContent.getUser());
    }
}

