/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.biz.service.sys.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.design.base.support.query.MPJQueryMapperUtil;
import com.geoway.design.biz.constatn.AppNodeType;
import com.geoway.design.biz.constatn.AppType;
import com.geoway.design.biz.constatn.ManagerType;
import com.geoway.design.biz.entity.BizManagerRange;
import com.geoway.design.biz.entity.SysOrganization;
import com.geoway.design.biz.entity.SysPermission;
import com.geoway.design.biz.entity.SysPermissionGroup;
import com.geoway.design.biz.entity.SysRegion;
import com.geoway.design.biz.entity.SysRole;
import com.geoway.design.biz.entity.SysUser;
import com.geoway.design.biz.entity.SysUserApplication;
import com.geoway.design.biz.mapper.BizManagerRangeMapper;
import com.geoway.design.biz.mapper.SysOrganizationMapper;
import com.geoway.design.biz.mapper.SysUserMapper;
import com.geoway.design.biz.service.dev.IOrganizationService;
import com.geoway.design.biz.service.sys.BizManagerRangeService;
import com.geoway.design.biz.service.sys.IApplicationSysService;
import com.geoway.design.biz.service.sys.ISysPermissionGroupService;
import com.geoway.design.biz.service.sys.ISysPermissionService;
import com.geoway.design.biz.service.sys.ISysRegionService;
import com.geoway.design.biz.service.sys.ISysRoleService;
import com.geoway.design.biz.service.sys.ISysUserService;
import com.geoway.design.biz.service.sys.SysApplicationGroupService;
import com.geoway.design.biz.service.sys.SysUserApplicationService;
import com.geoway.design.biz.vo.BizManagerVO;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class BizManagerRangeServiceImpl
extends ServiceImpl<BizManagerRangeMapper, BizManagerRange>
implements BizManagerRangeService {
    @Autowired
    private SysUserMapper sysUserMapper;
    @Autowired
    private ISysUserService sysUserService;
    @Autowired
    private ISysRegionService sysRegionService;
    @Autowired
    private IOrganizationService organizationService;
    @Autowired
    private ISysRoleService sysRoleService;
    @Autowired
    private ISysPermissionService sysPermissionService;
    @Autowired
    private ISysPermissionGroupService sysPermissionGroupService;
    @Autowired
    private SysOrganizationMapper sysOrganizationMapper;
    @Autowired
    private SysUserApplicationService sysUserApplicationService;
    @Autowired
    private SysApplicationGroupService sysApplicationGroupService;
    @Autowired
    private IApplicationSysService applicationSysService;

    @Override
    public void addBizManager(String userids) {
        List sysUsers = this.sysUserMapper.selectBatchIds(Arrays.asList(userids.split(",")));
        sysUsers.forEach(user -> {
            if (user.getCatalog() != 1) {
                List<SysRole> roles;
                List<SysOrganization> orgs;
                user.setCatalog(2);
                this.sysUserMapper.updateById(user);
                List<SysRegion> regions = this.sysUserService.queryRelRegions(user.getId());
                if (regions.size() > 0) {
                    this.updateManage(user.getId(), ManagerType.region.getValue(), StrUtil.join((CharSequence)",", (Object[])new Object[]{regions.stream().map(SysRegion::getCode).collect(Collectors.toList())}));
                }
                if ((orgs = this.sysUserService.queryRelOrgs(user.getId())).size() > 0) {
                    this.updateManage(user.getId(), ManagerType.organization.getValue(), StrUtil.join((CharSequence)",", (Object[])new Object[]{orgs.stream().map(SysOrganization::getId).collect(Collectors.toList())}));
                }
                if ((roles = this.sysUserService.queryRelRoles(user.getId())).size() > 0) {
                    this.updateManage(user.getId(), ManagerType.role.getValue(), StrUtil.join((CharSequence)",", (Object[])new Object[]{roles.stream().map(SysRole::getId).collect(Collectors.toList())}));
                }
            }
        });
    }

    @Override
    public void delBizManager(String userids) {
        List sysUsers = this.sysUserMapper.selectBatchIds(Arrays.asList(userids.split(",")));
        sysUsers.forEach(f -> {
            f.setCatalog(3);
            this.sysUserMapper.updateById(f);
            this.remove((Wrapper)new LambdaQueryWrapper().eq(BizManagerRange::getUserid, (Object)f.getId()));
        });
    }

    @Override
    public IPage<BizManagerVO> queryBizManagerPage(String filterParam, Integer page, Integer size) throws Exception {
        Page resultPage = new Page();
        MPJQueryMapperUtil qmu = new MPJQueryMapperUtil();
        MPJLambdaWrapper queryWrapper = qmu.queryMapper(filterParam, SysUser.class);
        queryWrapper.orderByDesc(SysUser::getUpdatetime);
        Page pages = new Page((long)page.intValue(), (long)size.intValue());
        IPage pageUsers = this.sysUserMapper.selectPage((IPage)pages, (Wrapper)queryWrapper);
        List users = pageUsers.getRecords();
        if (users.size() == 0) {
            return resultPage;
        }
        List userIds = users.stream().map(SysUser::getId).collect(Collectors.toList());
        List ranges = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BizManagerRange::getUserid, userIds)).list();
        List bizManagerVOS = users.stream().map(user -> {
            List<BizManagerRange> userRanges = ranges.stream().filter(f -> user.getId().equals(f.getUserid())).collect(Collectors.toList());
            BizManagerVO bizManagerVO = BizManagerVO.builder().userid(user.getId()).accout(user.getAccout()).aname(user.getAname()).build();
            this.buildBizManagerRange(bizManagerVO, userRanges);
            return bizManagerVO;
        }).collect(Collectors.toList());
        resultPage.setRecords(bizManagerVOS);
        resultPage.setTotal(pageUsers.getTotal());
        return resultPage;
    }

    @Override
    public void updateManage(String userid, Integer type, String values) {
        List ranges;
        boolean isApplication = type.intValue() == ManagerType.appliaction.getValue();
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)lambdaQueryWrapper.eq(BizManagerRange::getUserid, (Object)userid)).eq(BizManagerRange::getManageType, (Object)type);
        List<Object> existsAppIds = new ArrayList();
        if (isApplication) {
            ranges = this.list((Wrapper)lambdaQueryWrapper);
            existsAppIds = ranges.stream().map(item -> item.getManageValue()).collect(Collectors.toList());
        }
        this.remove((Wrapper)lambdaQueryWrapper);
        if (StrUtil.isNotBlank((CharSequence)values)) {
            ranges = Arrays.asList(values.split(",")).stream().map(value -> BizManagerRange.builder().userid(userid).manageType(type).manageValue((String)value).build()).collect(Collectors.toList());
            this.saveBatch(ranges);
        }
        SysUser sysUser = (SysUser)this.sysUserMapper.selectById((Serializable)((Object)userid));
        sysUser.setUpdatetime(new Date());
        this.sysUserMapper.updateById(sysUser);
        if (isApplication) {
            if (existsAppIds.size() > 0) {
                LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
                queryWrapper.eq(SysUserApplication::getUserid, (Object)userid);
                queryWrapper.in(SysUserApplication::getAppid, existsAppIds);
                queryWrapper.eq(SysUserApplication::getType, (Object)AppType.application.getValue());
                this.sysUserApplicationService.remove((Wrapper)queryWrapper);
                List<String> existsGroupIds = this.sysApplicationGroupService.queryAppGroupIds(existsAppIds);
                Iterator<String> iterator = existsGroupIds.iterator();
                while (iterator.hasNext()) {
                    String groupId = iterator.next();
                    this.sysUserApplicationService.deleteGroupIsNoChild(userid, groupId, AppType.application.getValue());
                }
            }
            if (StrUtil.isBlank((CharSequence)values)) {
                return;
            }
            List<String> appIds = Arrays.asList(values.split(","));
            for (String appId : appIds) {
                this.sysUserApplicationService.updateUserApplication(userid, appId, AppType.application.getValue(), AppNodeType.node.getValue());
            }
            List<String> groupIds = this.sysApplicationGroupService.queryAppGroupIds(appIds);
            for (String groupId : groupIds) {
                this.sysUserApplicationService.updateUserApplication(userid, groupId, AppType.application.getValue(), AppNodeType.group.getValue());
            }
        }
    }

    @Override
    public List<BizManagerRange> queryManage(String userid, Integer type) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BizManagerRange::getUserid, (Object)userid)).eq(BizManagerRange::getManageType, (Object)type)).list();
    }

    @Override
    public List<String> queryAllManageOrgs(String userid) {
        List orgs = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BizManagerRange::getUserid, (Object)userid)).eq(BizManagerRange::getManageType, (Object)2)).list();
        if (orgs.size() == 0) {
            return new ArrayList<String>();
        }
        HashSet resultSet = new HashSet();
        orgs.forEach(org -> {
            List<SysOrganization> children = this.sysOrganizationMapper.getOrgListById(org.getManageValue());
            resultSet.addAll(children.stream().map(SysOrganization::getId).collect(Collectors.toList()));
        });
        return new ArrayList<String>(resultSet);
    }

    @Override
    public List<String> queryAllManageRegions(String userid) {
        List regions = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BizManagerRange::getUserid, (Object)userid)).eq(BizManagerRange::getManageType, (Object)1)).list();
        if (regions.size() == 0) {
            return new ArrayList<String>();
        }
        HashSet resultSet = new HashSet();
        regions.forEach(org -> {
            List<SysRegion> children = this.sysRegionService.queryRegionListByCode(org.getManageValue());
            resultSet.addAll(children.stream().map(SysRegion::getCode).collect(Collectors.toList()));
        });
        return new ArrayList<String>(resultSet);
    }

    @Override
    public List<SysOrganization> queryOrgTree(String userid) {
        List orgRanges = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BizManagerRange::getUserid, (Object)userid)).eq(BizManagerRange::getManageType, (Object)2)).list();
        if (orgRanges.size() == 0) {
            return new ArrayList<SysOrganization>();
        }
        ArrayList<SysOrganization> orgs = new ArrayList<SysOrganization>();
        for (BizManagerRange org : orgRanges) {
            List<SysOrganization> parents = this.sysOrganizationMapper.getAllParentOrg(org.getManageValue());
            parents.forEach(f -> {
                Optional<SysOrganization> opt = orgs.stream().filter(m -> m.getId().equals(f.getId())).findAny();
                if (!opt.isPresent()) {
                    f.setEditable(false);
                    orgs.add((SysOrganization)f);
                }
            });
            List<SysOrganization> children = this.sysOrganizationMapper.getOrgListById(org.getManageValue());
            children.forEach(f -> {
                boolean exist = false;
                for (SysOrganization m : orgs) {
                    if (!f.getId().equals(m.getId())) continue;
                    m.setEditable(true);
                    exist = true;
                    break;
                }
                if (!exist) {
                    f.setEditable(true);
                    orgs.add((SysOrganization)f);
                }
            });
        }
        List<SysOrganization> editableOrgs = orgs.stream().filter(f -> Boolean.TRUE.equals(f.getEditable())).collect(Collectors.toList());
        this.organizationService.bindUsersToOrg(editableOrgs);
        editableOrgs.forEach(f -> {
            for (SysOrganization org : orgs) {
                if (!org.getId().equals(f.getId())) continue;
                org.setBindUsers(f.getBindUsers());
                break;
            }
        });
        return this.organizationService.constructTree(orgs);
    }

    private void buildBizManagerRange(BizManagerVO bizManagerVO, List<BizManagerRange> ranges) {
        Map<Integer, List<BizManagerRange>> groups = ranges.stream().collect(Collectors.groupingBy(BizManagerRange::getManageType));
        groups.keySet().forEach(type -> {
            List<String> typeValues = ((List)groups.get(type)).stream().map(BizManagerRange::getManageValue).collect(Collectors.toList());
            switch (type) {
                case 1: {
                    bizManagerVO.setRegions(typeValues);
                    try {
                        List<SysRegion> regions = this.sysRegionService.queryList("regionCode_IN_" + StrUtil.join((CharSequence)",", (Object[])new Object[]{typeValues}), null);
                        regions.forEach(m -> m.setAllname(StrUtil.join((CharSequence)"/", (Object[])new Object[]{this.sysRegionService.queryAllParentRegion(m.getRegionCode()).stream().map(SysRegion::getName).collect(Collectors.toList())})));
                        bizManagerVO.setRegionNames(regions.stream().map(SysRegion::getAllname).collect(Collectors.toList()));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case 2: {
                    bizManagerVO.setOrgs(typeValues);
                    bizManagerVO.setOrgNames(typeValues.stream().map(orgId -> {
                        List<SysOrganization> orgs = this.organizationService.queryAllParentOrg((String)orgId);
                        if (orgs.size() == 0) {
                            return "";
                        }
                        return StrUtil.join((CharSequence)"/", (Object[])new Object[]{orgs.stream().map(SysOrganization::getName).collect(Collectors.toList())});
                    }).collect(Collectors.toList()));
                    break;
                }
                case 3: {
                    bizManagerVO.setRoles(typeValues);
                    bizManagerVO.setRoleNames(typeValues.stream().map(roleId -> {
                        List<SysRole> roles = this.sysRoleService.queryAllParentRole((String)roleId);
                        if (roles.size() == 0) {
                            return "";
                        }
                        return StrUtil.join((CharSequence)"/", (Object[])new Object[]{roles.stream().map(SysRole::getName).collect(Collectors.toList())});
                    }).collect(Collectors.toList()));
                    break;
                }
                case 4: {
                    bizManagerVO.setPermissions(typeValues);
                    List permissions = this.sysPermissionService.listByIds(typeValues);
                    List groupIds = permissions.stream().map(SysPermission::getGroupid).filter(Objects::nonNull).collect(Collectors.toList());
                    List permissionGroups = this.sysPermissionGroupService.listByIds(groupIds);
                    bizManagerVO.setPermissionNames(permissions.stream().map(permission -> {
                        Optional<SysPermissionGroup> groupOptional;
                        String str = permission.getName();
                        if (permission.getGroupid() != null && (groupOptional = permissionGroups.stream().filter(f -> permission.getGroupid().equals(f.getId())).findAny()).isPresent()) {
                            str = groupOptional.get().getName() + "/" + str;
                        }
                        return str;
                    }).collect(Collectors.toList()));
                    break;
                }
                case 5: {
                    bizManagerVO.setAppIds(typeValues);
                    List apps = this.applicationSysService.listByIds(typeValues);
                    List<String> appNames = apps.stream().map(item -> item.getName()).collect(Collectors.toList());
                    bizManagerVO.setAppNames(appNames);
                    break;
                }
            }
        });
    }
}

