/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.biz.service.sys.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.tree.TreeNodeConfig;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.geoway.design.base.support.BaseTreeUtil;
import com.geoway.design.base.support.StringUtils;
import com.geoway.design.base.support.query.MyBatisQueryMapperUtils;
import com.geoway.design.biz.dto.AppMenuDTO;
import com.geoway.design.biz.dto.FunctionDTO;
import com.geoway.design.biz.entity.SysApplication;
import com.geoway.design.biz.entity.SysFunction;
import com.geoway.design.biz.entity.SysGroup;
import com.geoway.design.biz.entity.SysPermissionFunction;
import com.geoway.design.biz.entity.SysRoleMenu;
import com.geoway.design.biz.entity.SysRolePermission;
import com.geoway.design.biz.entity.SysUserRole;
import com.geoway.design.biz.mapper.FunctionSysMapper;
import com.geoway.design.biz.service.sys.IApplicationSysService;
import com.geoway.design.biz.service.sys.IFunctionSysService;
import com.github.yulichang.base.MPJBaseServiceImpl;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FunctionSysServiceImpl
extends MPJBaseServiceImpl<FunctionSysMapper, SysFunction>
implements IFunctionSysService {
    final String rootPid = "1";
    private final TreeNodeConfig treeNodeConfig = new TreeNodeConfig().setParentIdKey("pid").setWeightKey("sort").setIdKey("id");
    @Autowired
    private FunctionSysMapper functionSysMapper;
    @Autowired
    private IApplicationSysService applicationSysService;

    @Override
    public void saveOrUp(SysFunction sysFunction) throws Exception {
        if (StringUtils.isEmpty((String)sysFunction.getName())) {
            throw new Exception("\u529f\u80fd\u540d\u79f0\u4e3a\u7a7a\uff01");
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        if (StringUtils.isNotEmpty((String)sysFunction.getId())) {
            wrapper.ne(SysFunction::getId, (Object)sysFunction.getId());
        }
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(SysFunction::getPid, (Object)sysFunction.getPid())).eq(SysFunction::getAppId, (Object)sysFunction.getAppId())).eq(SysFunction::getName, (Object)sysFunction.getName());
        SysFunction one = (SysFunction)this.getOne((Wrapper)wrapper);
        if (one != null) {
            throw new Exception("\u529f\u80fd\u540d\u79f0\u3010" + one.getName() + "\u3011\u5df2\u5b58\u5728\uff01");
        }
        if (StringUtils.isEmpty((String)sysFunction.getId())) {
            LambdaQueryWrapper wrappers = Wrappers.lambdaQuery();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrappers.eq(SysFunction::getPid, (Object)sysFunction.getPid())).eq(SysFunction::getAppId, (Object)sysFunction.getAppId())).orderByAsc(true, (Object[])new SFunction[]{SysFunction::getSort});
            List list = this.list((Wrapper)wrappers);
            int curSort = 1;
            if (list != null && list.size() > 0) {
                curSort = ((SysFunction)list.stream().reduce((prev, curr) -> prev.getSort() > curr.getSort() ? prev : curr).get()).getSort();
                ++curSort;
            }
            sysFunction.setSort(curSort);
            sysFunction.setNoLogin(0);
            sysFunction.setLinkOneMap(0);
        }
        this.saveOrUpdate(sysFunction);
    }

    @Override
    public void deleteFunctionSys(String id, Integer sort, String pid, String appId) throws Exception {
        int iCount;
        if (StringUtils.isEmpty((String)id)) {
            throw new Exception("\u4f20\u9012\u7684id\u4e3a\u7a7a\uff01");
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(SysFunction::getId, (Object)id)).or()).eq(SysFunction::getPid, (Object)id);
        List sysFunctions = this.functionSysMapper.selectList((Wrapper)wrapper);
        List<String> funIds = sysFunctions.stream().map(i -> i.getId()).collect(Collectors.toList());
        if (funIds.size() > 0 && (iCount = this.functionSysMapper.queryRelateMenesCount(funIds)) > 0) {
            throw new Exception("\u8be5\u529f\u80fd\u5df2\u7ecf\u88ab\u6302\u63a5\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        this.functionSysMapper.delete((Wrapper)wrapper);
        this.upSortDelete(sort, pid, appId);
    }

    @Override
    public IPage<SysFunction> queryFunctionSys(String params, Integer page, Integer size, String uid, String userId) throws Exception {
        if (StringUtils.isEmpty((String)params) && page == null) {
            Page pages = new Page();
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            wrapper.orderByAsc(SysFunction::getSort);
            return this.page((IPage)pages, (Wrapper)wrapper);
        }
        MyBatisQueryMapperUtils qmu = new MyBatisQueryMapperUtils();
        QueryWrapper queryWrapper = qmu.queryMapper(params, SysFunction.class);
        Page pages = new Page((long)page.intValue(), (long)size.intValue());
        IPage pageInfo = this.page((IPage)pages, (Wrapper)queryWrapper);
        return pageInfo;
    }

    @Override
    public IPage<SysFunction> queryTree(String params, Integer page, Integer size) throws Exception {
        MyBatisQueryMapperUtils qmu = new MyBatisQueryMapperUtils();
        QueryWrapper queryWrapper = null;
        Page pages = new Page((long)page.intValue(), (long)size.intValue());
        if (params.indexOf("_LIKE_") > -1) {
            queryWrapper = qmu.queryMapper(params, SysFunction.class);
            queryWrapper.orderByAsc((Object)"f_sort");
            Page infos = (Page)this.page((IPage)pages, (Wrapper)queryWrapper);
            List records = infos.getRecords();
            pages.setRecords(this.getSearchTree(records, params));
        } else {
            String filterParam = "pid_EQ_1;" + params;
            queryWrapper = qmu.queryMapper(filterParam, SysFunction.class);
            queryWrapper.orderByAsc((Object)"f_sort");
            Page infos = (Page)this.page((IPage)pages, (Wrapper)queryWrapper);
            List records = infos.getRecords();
            pages.setRecords(this.getTree(records, params));
        }
        return pages;
    }

    @Override
    public void upSort(String appId, String id, String pid, Integer sort, Integer flag) throws Exception {
        String errMsg = "\u6392\u5e8f\u5931\u8d25!";
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        SysFunction funSys = (SysFunction)this.getById((Serializable)((Object)id));
        if (funSys == null) {
            return;
        }
        sort = funSys.getSort();
        switch (flag) {
            case 1: {
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(SysFunction::getPid, (Object)pid)).eq(SysFunction::getAppId, (Object)appId)).lt(SysFunction::getSort, (Object)sort)).orderByDesc(SysFunction::getSort);
                errMsg = "\u8be5\u529f\u80fd\u5df2\u7ecf\u7f6e\u9876\u4e86!";
                break;
            }
            case 2: {
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(SysFunction::getPid, (Object)pid)).eq(SysFunction::getAppId, (Object)appId)).gt(SysFunction::getSort, (Object)sort)).orderByAsc(SysFunction::getSort);
                errMsg = "\u8be5\u6761\u8bb0\u5f55\u5df2\u7ecf\u7f6e\u5e95\u4e86\uff01";
            }
        }
        SysFunction preInfo = this.list((Wrapper)wrapper).stream().findFirst().orElse(null);
        if (preInfo != null && !preInfo.getSort().equals(sort)) {
            this.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(SysFunction.class).eq(SysFunction::getId, (Object)id)).set(SysFunction::getSort, (Object)preInfo.getSort()));
            this.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(SysFunction.class).eq(SysFunction::getId, (Object)preInfo.getId())).set(SysFunction::getSort, (Object)sort));
        } else {
            wrapper.clear();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(SysFunction::getAppId, (Object)appId)).eq(SysFunction::getPid, (Object)pid)).eq(SysFunction::getSort, (Object)sort)).ne(SysFunction::getId, (Object)id);
            int iCount = this.count((Wrapper)wrapper);
            if (iCount > 0) {
                wrapper.clear();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(SysFunction::getAppId, (Object)appId)).eq(SysFunction::getPid, (Object)pid)).ne(SysFunction::getId, (Object)id);
                if (flag == 1) {
                    wrapper.ge(SysFunction::getSort, (Object)sort);
                } else if (flag == 2) {
                    wrapper.le(SysFunction::getSort, (Object)sort);
                } else {
                    throw new Exception(errMsg);
                }
                wrapper.orderByAsc(SysFunction::getSort);
                List functions = this.list((Wrapper)wrapper);
                LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
                int iSort = sort;
                if (flag == 2) {
                    iSort = 0;
                    sort = functions.size() + 1;
                    funSys.setSort(sort);
                    ((LambdaUpdateWrapper)updateWrapper.set(SysFunction::getSort, (Object)sort)).eq(SysFunction::getId, (Object)funSys.getId());
                    this.update((Wrapper)updateWrapper);
                }
                for (SysFunction function : functions) {
                    updateWrapper.clear();
                    ((LambdaUpdateWrapper)updateWrapper.set(SysFunction::getSort, (Object)(++iSort))).eq(SysFunction::getId, (Object)function.getId());
                    this.update((Wrapper)updateWrapper);
                }
            }
        }
    }

    @Override
    public List<SysApplication> queryFunctionTree() {
        List list = this.applicationSysService.list();
        for (SysApplication application : list) {
            List<FunctionDTO> functionDTOS = this.functionSysMapper.queryFunctionTree("1", application.getId());
            application.setChildren(this.getFunctionTree(functionDTOS));
        }
        return list;
    }

    @Override
    public List<SysGroup> queryFunctionTreeByGroup() throws Exception {
        List<SysGroup> groups = this.applicationSysService.queryAppGroups();
        for (SysGroup group : groups) {
            List<SysApplication> list = group.getApplications();
            for (SysApplication application : list) {
                List<FunctionDTO> functionDTOS = this.functionSysMapper.queryFunctionTree("1", application.getId());
                application.setChildren(this.getFunctionTree(functionDTOS));
            }
        }
        return groups;
    }

    @Override
    public void updateInfo(SysFunction sysFunction) {
        this.updateById(sysFunction);
    }

    @Override
    public FunctionDTO queryInfo(String id) {
        return this.functionSysMapper.queryInfo(id);
    }

    @Override
    public List<AppMenuDTO> queryAppMenus(String userId, String appId) {
        LambdaQueryWrapper appQuery = Wrappers.lambdaQuery();
        appQuery.eq(SysApplication::getAppId, (Object)appId);
        appQuery.last(" limit 1");
        SysApplication app = (SysApplication)this.applicationSysService.getOne((Wrapper)appQuery);
        if (app == null) {
            ArrayList<AppMenuDTO> appMenuDTOS = new ArrayList<AppMenuDTO>();
            return appMenuDTOS;
        }
        List<SysFunction> allFunctions = this.queryUserSysFunctions(userId, app);
        return this.convertToAppMenuTree(allFunctions);
    }

    @Override
    public List<SysFunction> queryUserSysFunctions(String userId, SysApplication app) {
        MPJLambdaWrapper queryWrapper = new MPJLambdaWrapper();
        queryWrapper.eq(SysFunction::getAppId, (Object)app.getId());
        queryWrapper.eq(SysFunction::getNoLogin, (Object)1);
        queryWrapper.orderByAsc(SysFunction::getSort);
        List noLoginFunctions = this.list((Wrapper)queryWrapper);
        HashSet<SysFunction> allFunctionSets = new HashSet<SysFunction>();
        allFunctionSets.addAll(noLoginFunctions);
        List validFunctions = null;
        if (StrUtil.isNotBlank((CharSequence)userId)) {
            queryWrapper.clear();
            queryWrapper.eq(SysFunction::getAppId, (Object)app.getId());
            queryWrapper.leftJoin(SysPermissionFunction.class, SysPermissionFunction::getFuncid, SysFunction::getId);
            queryWrapper.leftJoin(SysRolePermission.class, SysRolePermission::getPermissionid, SysPermissionFunction::getPermissionid);
            queryWrapper.leftJoin(SysUserRole.class, SysUserRole::getRoleid, SysRolePermission::getRoleid);
            queryWrapper.eq(SysUserRole::getUserid, (Object)userId);
            queryWrapper.orderByAsc(SysFunction::getSort);
            validFunctions = this.list((Wrapper)queryWrapper);
            if (validFunctions != null) {
                allFunctionSets.addAll(validFunctions);
            }
        }
        if (StrUtil.isNotBlank((CharSequence)userId)) {
            queryWrapper.clear();
            queryWrapper.eq(SysFunction::getAppId, (Object)app.getId());
            queryWrapper.leftJoin(SysRoleMenu.class, SysRoleMenu::getMenuid, SysFunction::getId);
            queryWrapper.leftJoin(SysUserRole.class, SysUserRole::getRoleid, SysRoleMenu::getRoleid);
            queryWrapper.eq(SysUserRole::getUserid, (Object)userId);
            queryWrapper.orderByAsc(SysFunction::getSort);
            validFunctions = this.list((Wrapper)queryWrapper);
            if (validFunctions != null) {
                allFunctionSets.addAll(validFunctions);
            }
        }
        ArrayList<String> allPids = new ArrayList<String>();
        this.queryAllPidsNoContains(allFunctionSets, allPids);
        if (allPids.size() > 0) {
            List pFunctions = this.listByIds(allPids);
            allFunctionSets.addAll(pFunctions);
        }
        ArrayList allFunctions = CollectionUtil.newArrayList(allFunctionSets);
        return allFunctions;
    }

    private void queryAllPidsNoContains(Set<SysFunction> functions, List<String> pids) {
        ArrayList<String> newPids = new ArrayList<String>();
        for (SysFunction function : functions) {
            boolean exists = StrUtil.isNotBlank((CharSequence)function.getPid()) && !function.getPid().equals("1");
            if (!exists || pids.contains(function.getPid())) continue;
            newPids.add(function.getPid());
        }
        pids.addAll(newPids);
        if (newPids.size() > 0) {
            List pFunctions = this.listByIds(newPids);
            HashSet<SysFunction> pFunctionSets = new HashSet<SysFunction>();
            pFunctionSets.addAll(pFunctions);
            this.queryAllPidsNoContains(pFunctionSets, pids);
        }
    }

    private List<AppMenuDTO> convertToAppMenuTree(List<SysFunction> functions) {
        ArrayList<AppMenuDTO> appMenuDTOS = new ArrayList<AppMenuDTO>();
        for (SysFunction function : functions) {
            AppMenuDTO appMenuDTO = new AppMenuDTO();
            appMenuDTO.setName(function.getName());
            appMenuDTO.setId(function.getId());
            appMenuDTO.setKey(function.getKey());
            appMenuDTO.setKey(UUID.randomUUID().toString());
            appMenuDTO.setRoutename(function.getKey());
            appMenuDTO.setPid(function.getPid());
            appMenuDTO.setNoLogin(function.getNoLogin());
            int linkType = function.getUrlType() == 2 ? 0 : 1;
            appMenuDTO.setLink(linkType);
            appMenuDTO.setNewPage(function.getOpen());
            appMenuDTO.setParams(function.getParams());
            appMenuDTO.setSort(function.getSort());
            appMenuDTO.setPath(function.getUrl());
            appMenuDTOS.add(appMenuDTO);
        }
        List menuTrees = BaseTreeUtil.listToTree(appMenuDTOS, (TreeNodeConfig)this.treeNodeConfig, (String)"1");
        this.buildTreeLevel(menuTrees, 1);
        return menuTrees;
    }

    private void buildTreeLevel(List<AppMenuDTO> menuTrees, int level) {
        for (AppMenuDTO menu : menuTrees) {
            menu.setLevel(level);
            if (menu.getChildren() != null && menu.getChildren().size() > 0) {
                menu.setIsLeaf(0);
                this.buildTreeLevel(menu.getChildren(), level + 1);
                continue;
            }
            menu.setIsLeaf(1);
        }
    }

    private List<FunctionDTO> getFunctionTree(List<FunctionDTO> list) {
        for (FunctionDTO function : list) {
            List<FunctionDTO> functionDTOS = this.functionSysMapper.queryFunctionTree(function.getId(), function.getAppId());
            if (functionDTOS.size() > 0) {
                function.setChildren(this.getFunctionTree(functionDTOS));
                continue;
            }
            function.setIsLeaf(1);
        }
        return list;
    }

    private List<SysFunction> getTree(List<SysFunction> records, String filterParam) throws Exception {
        MyBatisQueryMapperUtils qmu = new MyBatisQueryMapperUtils();
        for (SysFunction record : records) {
            String myFilterParam = filterParam + ";pid_EQ_" + record.getId();
            QueryWrapper wrapper = qmu.queryMapper(myFilterParam, SysFunction.class);
            wrapper.orderByAsc((Object)"f_sort");
            List list = this.list((Wrapper)wrapper);
            if (list.size() <= 0) continue;
            record.setChildren(this.getTree(list, filterParam));
        }
        return records;
    }

    private List<SysFunction> getSearchTree(List<SysFunction> records, String filterParam) throws Exception {
        MyBatisQueryMapperUtils qmu = new MyBatisQueryMapperUtils();
        Map<Boolean, List<SysFunction>> recordMap = records.stream().collect(Collectors.partitioningBy(v -> "1".equals(v.getPid())));
        List<SysFunction> parents = this.getTree(recordMap.get(true), filterParam);
        List<SysFunction> childs = recordMap.get(false);
        return Stream.of(parents, childs).flatMap(x -> x.stream()).collect(Collectors.toList());
    }

    private void upSort(String appId, Integer sort, String id, String pid) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(SysFunction::getSort, (Object)sort)).eq(SysFunction::getAppId, (Object)appId)).eq(SysFunction::getPid, (Object)pid);
        SysFunction one = (SysFunction)this.getOne((Wrapper)wrapper);
        if (one != null && !one.getId().equals(id)) {
            Integer maxSort = this.functionSysMapper.findMaxSort(pid);
            for (int i = maxSort.intValue(); i >= sort; --i) {
                UpdateWrapper updateWrapper = Wrappers.update();
                ((UpdateWrapper)((UpdateWrapper)updateWrapper.eq((Object)"f_sort", (Object)i)).eq((Object)"f_pid", (Object)pid)).set((Object)"f_sort", (Object)(i + 1));
                this.update((Wrapper)updateWrapper);
            }
        }
    }

    private void upSortDelete(Integer sort, String pid, String appId) {
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)wrapper.eq((Object)"f_pid", (Object)pid)).eq((Object)"f_appid", (Object)appId);
        List list = this.list((Wrapper)wrapper);
        if (list.size() > 0 && sort < ((SysFunction)list.get(0)).getSort()) {
            for (int i = sort + 1; i <= ((SysFunction)list.get(0)).getSort(); ++i) {
                UpdateWrapper updateWrapper = Wrappers.update();
                ((UpdateWrapper)((UpdateWrapper)updateWrapper.eq((Object)"f_sort", (Object)i)).eq((Object)"f_pid", (Object)pid)).set((Object)"f_sort", (Object)(i - 1));
                this.update((Wrapper)updateWrapper);
            }
        }
    }
}

