/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.biz.service.sys.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.design.base.config.SsoConfigProp;
import com.geoway.design.base.enums.UserSysEnum;
import com.geoway.design.base.support.StringUtils;
import com.geoway.design.biz.config.ProjectConfig;
import com.geoway.design.biz.constatn.AppNodeType;
import com.geoway.design.biz.constatn.AppType;
import com.geoway.design.biz.constatn.RoleLevel;
import com.geoway.design.biz.dto.UserSysDTO;
import com.geoway.design.biz.entity.NsSystemStyle;
import com.geoway.design.biz.entity.SysGroup;
import com.geoway.design.biz.entity.SysImage;
import com.geoway.design.biz.entity.SysMenu;
import com.geoway.design.biz.entity.SysNsSystem;
import com.geoway.design.biz.entity.SysPermissonSystem;
import com.geoway.design.biz.entity.SysRoleApplication;
import com.geoway.design.biz.entity.SysUser;
import com.geoway.design.biz.entity.SysUserApplication;
import com.geoway.design.biz.entity.SysUserRole;
import com.geoway.design.biz.mapper.NsSystemMapper;
import com.geoway.design.biz.mapper.SysGroupMapper;
import com.geoway.design.biz.mapper.SysMenuMapper;
import com.geoway.design.biz.mapper.SysPermissionSystemMapper;
import com.geoway.design.biz.mapper.SysRoleApplicationMapper;
import com.geoway.design.biz.mapper.SysUserMapper;
import com.geoway.design.biz.service.oauth2.IOauth2Service;
import com.geoway.design.biz.service.sys.IApplicationSysService;
import com.geoway.design.biz.service.sys.INsSystemService;
import com.geoway.design.biz.service.sys.SysUserApplicationService;
import com.geoway.design.biz.service.sys.impl.NsMenuServiceImpl;
import com.geoway.design.biz.service.sys.impl.NsSystemStyleServiceImpl;
import com.geoway.sso.client.util.HttpServletUtil;
import com.github.yulichang.interfaces.MPJBaseJoin;
import com.github.yulichang.toolkit.MPJWrappers;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class NsSystemServiceImpl
extends ServiceImpl<NsSystemMapper, SysNsSystem>
implements INsSystemService {
    @Autowired
    private NsSystemMapper systemMapper;
    @Autowired
    private SysMenuMapper menuMapper;
    @Autowired
    private NsMenuServiceImpl menuService;
    @Autowired
    private ProjectConfig config;
    @Autowired
    private NsSystemStyleServiceImpl styleService;
    @Autowired
    IApplicationSysService.ISysImageService sysImageService;
    @Autowired
    SysGroupMapper sysGroupMapper;
    @Autowired
    SysUserMapper sysUserMapper;
    @Autowired
    SysPermissionSystemMapper sysPermissionSystemMapper;
    @Autowired
    IOauth2Service auth2Service;
    @Autowired
    SysUserApplicationService sysUserApplicationService;
    @Autowired
    SysRoleApplicationMapper sysRoleApplicationMapper;
    @Autowired
    private SsoConfigProp ssoConfig;

    @Override
    public void saveOrUp(SysNsSystem sysNsSystem, MultipartFile logofile, MultipartFile bgfile) throws Exception {
        boolean isBizAdmin;
        LambdaUpdateWrapper updateWrapper;
        SysImage sysImage;
        SysNsSystem one;
        if (StringUtils.isEmpty((String)sysNsSystem.getName())) {
            throw new Exception("\u3010\u540d\u79f0\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysNsSystem::getName, (Object)sysNsSystem.getName());
        if (StringUtils.isNotEmpty((String)sysNsSystem.getId())) {
            wrapper.ne(SysNsSystem::getId, (Object)sysNsSystem.getId());
        }
        if ((one = (SysNsSystem)this.getOne((Wrapper)wrapper)) != null) {
            throw new Exception("\u540d\u79f0\u3010" + one.getName() + "\u3011\u5df2\u5b58\u5728\uff01");
        }
        if (StringUtils.isEmpty((String)sysNsSystem.getStyleId())) {
            throw new Exception("\u3010\u4e3b\u9898\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((String)sysNsSystem.getKey())) {
            throw new Exception("\u3010\u5173\u952e\u5b57\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysNsSystem::getKey, (Object)sysNsSystem.getKey());
        if (StringUtils.isNotEmpty((String)sysNsSystem.getId())) {
            wrapper.ne(SysNsSystem::getId, (Object)sysNsSystem.getId());
        }
        if ((one = (SysNsSystem)this.getOne((Wrapper)wrapper)) != null) {
            throw new Exception("\u5173\u952e\u5b57\u3010" + one.getKey() + "\u3011\u5df2\u5b58\u5728\uff01");
        }
        if (StringUtils.isEmpty((String)sysNsSystem.getId())) {
            int cur = this.count();
            sysNsSystem.setSort(++cur);
            sysNsSystem.setUpDateTime(new Date());
        } else {
            sysNsSystem.setSort(sysNsSystem.getSort());
            sysNsSystem.setUpDateTime(sysNsSystem.getUpDateTime());
        }
        SysNsSystem exsitSystem = (SysNsSystem)this.getById((Serializable)((Object)sysNsSystem.getId()));
        this.saveOrUpdate(sysNsSystem);
        if (logofile != null && !logofile.isEmpty()) {
            sysImage = (SysImage)this.sysImageService.getById((Serializable)((Object)sysNsSystem.getLogoid()));
            if (sysImage == null) {
                sysImage = new SysImage();
                sysImage.setObjectid(sysNsSystem.getId());
                sysImage.setType(1);
            }
            sysImage.setImage(logofile.getBytes());
            this.sysImageService.saveOrUpdate(sysImage);
            if (StrUtil.isBlank((CharSequence)sysNsSystem.getLogoid())) {
                updateWrapper = Wrappers.lambdaUpdate();
                updateWrapper.set(SysNsSystem::getLogoid, (Object)sysImage.getId());
                updateWrapper.eq(SysNsSystem::getId, (Object)sysNsSystem.getId());
                this.update((Wrapper)updateWrapper);
            }
        } else if (StrUtil.isBlankIfStr((Object)sysNsSystem.getLogoid()) && exsitSystem != null && StrUtil.isNotBlank((CharSequence)exsitSystem.getLogoid())) {
            this.sysImageService.removeById((Serializable)((Object)exsitSystem.getLogoid()));
        }
        if (bgfile != null && !bgfile.isEmpty()) {
            sysImage = (SysImage)this.sysImageService.getById((Serializable)((Object)sysNsSystem.getBgid()));
            if (sysImage == null) {
                sysImage = new SysImage();
                sysImage.setObjectid(sysNsSystem.getId());
                sysImage.setType(1);
            }
            sysImage.setImage(bgfile.getBytes());
            this.sysImageService.saveOrUpdate(sysImage);
            if (StrUtil.isBlank((CharSequence)sysNsSystem.getBgid())) {
                updateWrapper = Wrappers.lambdaUpdate();
                updateWrapper.set(SysNsSystem::getBgid, (Object)sysImage.getId());
                updateWrapper.eq(SysNsSystem::getId, (Object)sysNsSystem.getId());
                this.update((Wrapper)updateWrapper);
            }
        } else if (StrUtil.isBlankIfStr((Object)sysNsSystem.getBgid()) && exsitSystem != null && StrUtil.isNotBlank((CharSequence)exsitSystem.getBgid())) {
            this.sysImageService.removeById((Serializable)((Object)exsitSystem.getBgid()));
        }
        String userId = this.getCurrentUserId();
        SysUser user = (SysUser)this.sysUserMapper.selectById((Serializable)((Object)userId));
        if (user == null || user.getCatalog() == null) {
            throw new Exception("\u7528\u6237\u65e0\u6743\u9650");
        }
        boolean bl = isBizAdmin = user.getCatalog().intValue() == RoleLevel.bizAdmin.getValue();
        if (isBizAdmin) {
            this.sysUserApplicationService.updateUserApplication(userId, sysNsSystem.getId(), AppType.system.getValue(), AppNodeType.node.getValue());
        }
    }

    @Override
    public void deleteSystem(String id) throws Exception {
        boolean isBizAdmin;
        SysNsSystem sysNsSystem = (SysNsSystem)this.getById((Serializable)((Object)id));
        if (sysNsSystem != null && StrUtil.isNotBlank((CharSequence)sysNsSystem.getLogoid())) {
            this.sysImageService.removeById((Serializable)((Object)sysNsSystem.getLogoid()));
        }
        if (sysNsSystem != null && StrUtil.isNotBlank((CharSequence)sysNsSystem.getBgid())) {
            this.sysImageService.removeById((Serializable)((Object)sysNsSystem.getBgid()));
        }
        this.removeById((Serializable)((Object)id));
        LambdaQueryWrapper menuWrapper = Wrappers.lambdaQuery();
        menuWrapper.eq(SysMenu::getSystemId, (Object)sysNsSystem.getId());
        this.menuMapper.delete((Wrapper)menuWrapper);
        LambdaQueryWrapper queryWrapper2 = Wrappers.lambdaQuery();
        queryWrapper2.eq(SysPermissonSystem::getSystemid, (Object)sysNsSystem.getId());
        this.sysPermissionSystemMapper.delete((Wrapper)queryWrapper2);
        String userId = this.getCurrentUserId();
        SysUser user = (SysUser)this.sysUserMapper.selectById((Serializable)((Object)userId));
        if (user == null || user.getCatalog() == null) {
            throw new Exception("\u7528\u6237\u65e0\u6743\u9650");
        }
        boolean bl = isBizAdmin = user.getCatalog().intValue() == RoleLevel.bizAdmin.getValue();
        if (isBizAdmin) {
            this.sysUserApplicationService.deleteExistApplication(userId, sysNsSystem.getId(), AppType.system.getValue());
        }
    }

    @Override
    public void deleteSystems(String ids) throws Exception {
        String[] idArr;
        if (StrUtil.isBlank((CharSequence)ids)) {
            return;
        }
        for (String id : idArr = ids.split(",")) {
            this.deleteSystem(id);
        }
    }

    @Override
    public HashMap<String, Object> queryInfo(String key) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotEmpty((String)key)) {
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            ((LambdaQueryWrapper)wrapper.eq(SysNsSystem::getKey, (Object)key)).eq(SysNsSystem::getState, (Object)1);
            SysNsSystem sysNsSystem = (SysNsSystem)this.getOne((Wrapper)wrapper);
            if (sysNsSystem != null) {
                List<SysMenu> sysMenus = this.menuService.queryTree(sysNsSystem.getId(), 1, 0);
                List<SysMenu> uCenterMenu = this.menuService.queryTree(sysNsSystem.getId(), 1, 1);
                map.put("system", sysNsSystem);
                map.put("menu", sysMenus);
                map.put("uCenterMenu", uCenterMenu);
            } else {
                map = null;
            }
        }
        return map;
    }

    @Override
    public List<SysNsSystem> queryList() throws Exception {
        MPJLambdaWrapper<SysNsSystem> queryWrapper = this.buildSysNsSystemMPJLambdaWrapper();
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<SysNsSystem> queryListNotInPermission(String permissonId) throws Exception {
        MPJLambdaWrapper<SysNsSystem> queryWrapper = this.buildSysNsSystemMPJLambdaWrapper();
        if (StrUtil.isNotBlank((CharSequence)permissonId)) {
            LambdaQueryWrapper queryWrapper2 = Wrappers.lambdaQuery();
            queryWrapper2.eq(SysPermissonSystem::getPermissionid, (Object)permissonId);
            List sysPermissonSystems = this.sysPermissionSystemMapper.selectList((Wrapper)queryWrapper2);
            if (sysPermissonSystems != null && sysPermissonSystems.size() > 0) {
                List systemIds = sysPermissonSystems.stream().map(item -> item.getSystemid()).collect(Collectors.toList());
                queryWrapper.notIn(SysNsSystem::getId, systemIds);
            }
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<SysNsSystem> queryListNotInRole(String roleId) throws Exception {
        MPJLambdaWrapper<SysNsSystem> queryWrapper = this.buildSysNsSystemMPJLambdaWrapper();
        if (StrUtil.isNotBlank((CharSequence)roleId)) {
            LambdaQueryWrapper queryWrapper2 = Wrappers.lambdaQuery();
            queryWrapper2.eq(SysRoleApplication::getRoleid, (Object)roleId);
            List sysRoleApplications = this.sysRoleApplicationMapper.selectList((Wrapper)queryWrapper2);
            if (sysRoleApplications != null && sysRoleApplications.size() > 0) {
                List systemIds = sysRoleApplications.stream().map(item -> item.getAppid()).collect(Collectors.toList());
                queryWrapper.notIn(SysNsSystem::getId, systemIds);
            }
        }
        return this.list((Wrapper)queryWrapper);
    }

    private MPJLambdaWrapper<SysNsSystem> buildSysNsSystemMPJLambdaWrapper() throws Exception {
        String userId = this.getCurrentUserId();
        SysUser user = (SysUser)this.sysUserMapper.selectById((Serializable)((Object)userId));
        if (user == null || user.getCatalog() == null || user.getCatalog().intValue() == RoleLevel.commonUser.getValue()) {
            throw new Exception("\u7528\u6237\u65e0\u8bbf\u95ee\u6743\u9650");
        }
        boolean isBizAdmin = user.getCatalog().intValue() == RoleLevel.bizAdmin.getValue();
        MPJLambdaWrapper queryWrapper = MPJWrappers.lambdaJoin();
        if (isBizAdmin) {
            queryWrapper.leftJoin(SysUserApplication.class, SysUserApplication::getAppid, SysNsSystem::getId);
            queryWrapper.eq(SysUserApplication::getApptype, (Object)AppType.system.getValue());
            queryWrapper.eq(SysUserApplication::getUserid, (Object)userId);
        }
        queryWrapper.orderByDesc(SysNsSystem::getSort);
        return queryWrapper;
    }

    @Override
    public List<SysNsSystem> queryAll() {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.orderByDesc(SysNsSystem::getSort);
        List list = this.list((Wrapper)wrapper);
        for (SysNsSystem sysNsSystem : list) {
            List<SysMenu> sysMenus = this.menuService.queryTree(sysNsSystem.getId(), 0, 0);
            List<SysMenu> userMenus = this.menuService.queryTree(sysNsSystem.getId(), 0, 1);
            sysNsSystem.setSysMenu(sysMenus);
            sysNsSystem.setUCenterMenu(userMenus);
        }
        return list;
    }

    @Override
    public void stateUp(String id, Integer state) {
        LambdaUpdateWrapper update = Wrappers.lambdaUpdate();
        ((LambdaUpdateWrapper)update.eq(SysNsSystem::getId, (Object)id)).set(SysNsSystem::getState, (Object)state);
        this.update((Wrapper)update);
    }

    @Override
    public HashMap<String, Object> querySystemInfoByUser(String userId, String key) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotEmpty((String)key)) {
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            ((LambdaQueryWrapper)wrapper.eq(SysNsSystem::getKey, (Object)key)).eq(SysNsSystem::getState, (Object)1);
            wrapper.last(" limit 1");
            SysNsSystem sysNsSystem = (SysNsSystem)this.getOne((Wrapper)wrapper);
            if (sysNsSystem != null) {
                NsSystemStyle systemStyle = this.styleService.findOne(sysNsSystem.getStyleId());
                List<SysMenu> sysMenus = this.menuService.queryUserMenuTree(userId, sysNsSystem.getId(), 1, 0);
                List<SysMenu> uCenterMenu = this.menuService.queryUserMenuTree(userId, sysNsSystem.getId(), 1, 1);
                map.put("system", sysNsSystem);
                map.put("systemStyle", systemStyle);
                map.put("menu", sysMenus);
                map.put("uCenterMenu", uCenterMenu);
            } else {
                map = null;
            }
        }
        return map;
    }

    @Override
    public HashMap<String, Object> querySystemBaseInfoByKey(String key) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotEmpty((String)key)) {
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            ((LambdaQueryWrapper)wrapper.eq(SysNsSystem::getKey, (Object)key)).eq(SysNsSystem::getState, (Object)1);
            wrapper.last(" limit 1");
            SysNsSystem sysNsSystem = (SysNsSystem)this.getOne((Wrapper)wrapper);
            if (sysNsSystem != null) {
                NsSystemStyle systemStyle = this.styleService.findOne(sysNsSystem.getStyleId());
                map.put("system", sysNsSystem);
                map.put("systemStyle", systemStyle);
            } else {
                map = null;
            }
        }
        return map;
    }

    @Override
    public List<SysNsSystem> querySystemListByUser(String userId) {
        if (StrUtil.isBlank((CharSequence)userId)) {
            return null;
        }
        List<SysNsSystem> sysNsSystems = new ArrayList();
        List<String> sysIds = this.menuMapper.queryUserMenuSystemId(userId);
        if (sysIds.size() > 0) {
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            ((LambdaQueryWrapper)wrapper.in(SysNsSystem::getId, sysIds)).orderBy(true, true, (Object[])new SFunction[]{SysNsSystem::getSort});
            sysNsSystems = this.systemMapper.selectList((Wrapper)wrapper);
        }
        MPJLambdaWrapper joinWrapper = MPJWrappers.lambdaJoin();
        joinWrapper.leftJoin(SysRoleApplication.class, SysRoleApplication::getAppid, SysNsSystem::getId);
        joinWrapper.leftJoin(SysUserRole.class, SysUserRole::getRoleid, SysRoleApplication::getRoleid);
        joinWrapper.eq(SysUserRole::getUserid, (Object)userId);
        List roleSystems = this.systemMapper.selectJoinList(SysNsSystem.class, (MPJBaseJoin)joinWrapper);
        sysNsSystems.addAll(roleSystems);
        return sysNsSystems;
    }

    @Override
    public void saveGroup(SysGroup group) throws Exception {
        boolean isBizAdmin;
        int icount;
        group.setType(1);
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysGroup::getType, (Object)1);
        queryWrapper.eq(SysGroup::getName, (Object)group.getName());
        if (StrUtil.isBlank((CharSequence)group.getId())) {
            icount = this.sysGroupMapper.selectCount((Wrapper)queryWrapper);
            if (icount > 0) {
                throw new Exception("\u5206\u7ec4\u540d\u79f0: \u3010" + group.getName() + "\u3011 \u5df2\u5b58\u5728");
            }
            this.sysGroupMapper.insert(group);
        } else {
            queryWrapper.ne(SysGroup::getId, (Object)group.getId());
            icount = this.sysGroupMapper.selectCount((Wrapper)queryWrapper);
            if (icount > 0) {
                throw new Exception("\u5206\u7ec4\u540d\u79f0: \u3010" + group.getName() + "\u3011 \u5df2\u5b58\u5728");
            }
            this.sysGroupMapper.updateById(group);
        }
        String userId = this.getCurrentUserId();
        SysUser user = (SysUser)this.sysUserMapper.selectById((Serializable)((Object)userId));
        if (user == null || user.getCatalog() == null) {
            throw new Exception("\u7528\u6237\u65e0\u6743\u9650");
        }
        boolean bl = isBizAdmin = user.getCatalog().intValue() == RoleLevel.bizAdmin.getValue();
        if (isBizAdmin) {
            this.sysUserApplicationService.updateUserApplication(userId, group.getId(), AppType.system.getValue(), AppNodeType.node.getValue());
        }
    }

    @Override
    public List<SysGroup> querySystemGroups(String userId) throws Exception {
        List<SysNsSystem> unGroupSystems;
        List groups;
        List groupIds;
        SysUser user = (SysUser)this.sysUserMapper.selectById((Serializable)((Object)userId));
        if (user == null || user.getCatalog() == null || user.getCatalog().intValue() == RoleLevel.commonUser.getValue()) {
            throw new Exception("\u7528\u6237\u65e0\u8bbf\u95ee\u6743\u9650");
        }
        boolean isBizAdmin = user.getCatalog().intValue() == RoleLevel.bizAdmin.getValue();
        MPJLambdaWrapper queryWrapper = MPJWrappers.lambdaJoin();
        queryWrapper.eq(SysGroup::getType, (Object)1);
        if (isBizAdmin) {
            queryWrapper.leftJoin(SysUserApplication.class, SysUserApplication::getAppid, SysGroup::getId);
            queryWrapper.eq(SysUserApplication::getApptype, (Object)AppType.system.getValue());
            queryWrapper.eq(SysUserApplication::getUserid, (Object)userId);
        }
        if ((groupIds = (groups = this.sysGroupMapper.selectList((Wrapper)queryWrapper)).stream().map(item -> item.getId()).collect(Collectors.toList())).size() > 0) {
            MPJLambdaWrapper queryWrapper2 = MPJWrappers.lambdaJoin();
            queryWrapper2.in(SysNsSystem::getGroupId, groupIds);
            if (isBizAdmin) {
                queryWrapper2.leftJoin(SysUserApplication.class, SysUserApplication::getAppid, SysNsSystem::getId);
                queryWrapper2.eq(SysUserApplication::getApptype, (Object)AppType.system.getValue());
                queryWrapper2.eq(SysUserApplication::getUserid, (Object)userId);
            }
            List systems = this.list((Wrapper)queryWrapper2);
            for (SysGroup group : groups) {
                List<SysNsSystem> subSystem = systems.stream().filter(item -> group.getId().equals(item.getGroupId())).collect(Collectors.toList());
                group.setSystems(subSystem);
            }
        }
        if ((unGroupSystems = this.querySystemNoGroup(userId)).size() > 0) {
            SysGroup group = new SysGroup();
            group.setId("weifenzu");
            group.setName("\u672a\u5206\u7ec4");
            group.setType(1);
            group.setSystems(unGroupSystems);
            groups.add(group);
        }
        return groups;
    }

    @Override
    public void deleteGroup(String groupId) throws Exception {
        boolean isBizAdmin;
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysNsSystem::getGroupId, (Object)groupId);
        int icount = this.count((Wrapper)queryWrapper);
        if (icount > 0) {
            throw new Exception("\u5e94\u7528\u5206\u7ec4\u4e0b\u6709\u5173\u8054\u7cfb\u7edf\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        this.sysGroupMapper.deleteById((Serializable)((Object)groupId));
        String userId = this.getCurrentUserId();
        SysUser user = (SysUser)this.sysUserMapper.selectById((Serializable)((Object)userId));
        if (user == null || user.getCatalog() == null) {
            throw new Exception("\u7528\u6237\u65e0\u6743\u9650");
        }
        boolean bl = isBizAdmin = user.getCatalog().intValue() == RoleLevel.bizAdmin.getValue();
        if (isBizAdmin) {
            this.sysUserApplicationService.deleteGroupIsNoChild(userId, groupId, AppType.system.getValue());
        }
    }

    @Override
    public List<SysNsSystem> querySystemNoGroup(String userId) throws Exception {
        SysUser user = (SysUser)this.sysUserMapper.selectById((Serializable)((Object)userId));
        if (user == null || user.getCatalog() == null || user.getCatalog().intValue() == RoleLevel.commonUser.getValue()) {
            throw new Exception("\u7528\u6237\u65e0\u8bbf\u95ee\u6743\u9650");
        }
        boolean isBizAdmin = user.getCatalog().intValue() == RoleLevel.bizAdmin.getValue();
        MPJLambdaWrapper queryWrapper = MPJWrappers.lambdaJoin();
        queryWrapper.isNull(SysNsSystem::getGroupId);
        if (isBizAdmin) {
            queryWrapper.leftJoin(SysUserApplication.class, SysUserApplication::getAppid, SysNsSystem::getId);
            queryWrapper.eq(SysUserApplication::getType, (Object)AppType.system.getValue());
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<UserSysDTO> getUserSys() {
        List<String> types = Arrays.asList(this.ssoConfig.getLoginType().split(","));
        List<String> syncTypes = Arrays.asList(this.ssoConfig.getSyncType().split(","));
        ArrayList<UserSysDTO> userSysDTOS = new ArrayList<UserSysDTO>();
        for (UserSysEnum value : UserSysEnum.values()) {
            if (!types.contains(value.value)) continue;
            UserSysDTO userSysDTO = UserSysDTO.builder().value(value.value).name(value.name).type(value.type).sync(false).build();
            if (syncTypes.contains(value.value)) {
                userSysDTO.setSync(true);
            }
            userSysDTOS.add(userSysDTO);
        }
        return userSysDTOS;
    }

    private String getCurrentUserId() {
        HttpServletRequest request = HttpServletUtil.getRequest();
        return this.auth2Service.queryCurrentUserId(request);
    }
}

