/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.biz.service.sys.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.design.biz.entity.SysApplicationGroup;
import com.geoway.design.biz.mapper.SysApplicationGroupMapper;
import com.geoway.design.biz.service.sys.SysApplicationGroupService;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class SysApplicationGroupServiceImpl
extends ServiceImpl<SysApplicationGroupMapper, SysApplicationGroup>
implements SysApplicationGroupService {
    @Override
    public void saveApplicationGroup(String appId, String groupId) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysApplicationGroup::getAppid, (Object)appId);
        queryWrapper.eq(SysApplicationGroup::getGroupid, (Object)groupId);
        int iCount = this.count((Wrapper)queryWrapper);
        if (iCount == 0) {
            SysApplicationGroup applicationGroup = new SysApplicationGroup();
            applicationGroup.setAppid(appId);
            applicationGroup.setGroupid(groupId);
            this.saveOrUpdate(applicationGroup);
        }
    }

    @Override
    public void removeApplicationInGroup(String appId) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysApplicationGroup::getAppid, (Object)appId);
        this.remove((Wrapper)queryWrapper);
    }

    @Override
    public void removeApplicationGroup(String appId, String groupId) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysApplicationGroup::getAppid, (Object)appId);
        queryWrapper.eq(SysApplicationGroup::getGroupid, (Object)groupId);
        this.remove((Wrapper)queryWrapper);
    }

    @Override
    public List<String> queryGroupAppIds(String groupId) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysApplicationGroup::getGroupid, (Object)groupId);
        List sysAppGroups = this.list((Wrapper)queryWrapper);
        List<String> appIds = sysAppGroups.stream().map(i -> i.getAppid()).collect(Collectors.toList());
        return appIds;
    }

    @Override
    public int queryCount(String groupId) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysApplicationGroup::getGroupid, (Object)groupId);
        int count = this.count((Wrapper)queryWrapper);
        return count;
    }

    @Override
    public List<String> queryAppGroupIds(List<String> appIds) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.in(SysApplicationGroup::getAppid, appIds);
        List appGroups = this.list((Wrapper)queryWrapper);
        List<String> groupIds = appGroups.stream().map(item -> item.getGroupid()).collect(Collectors.toList());
        return groupIds;
    }
}

