/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.biz.service.sys.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.design.base.support.ExcelUtil;
import com.geoway.design.base.support.query.MyBatisQueryMapperUtils;
import com.geoway.design.biz.entity.SysOplog;
import com.geoway.design.biz.entity.SysOplogBackup;
import com.geoway.design.biz.mapper.SysOplogBackupMapper;
import com.geoway.design.biz.service.sys.SysOplogBackupService;
import com.geoway.design.biz.service.sys.SysOplogService;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysOplogBackupServiceImpl
extends ServiceImpl<SysOplogBackupMapper, SysOplogBackup>
implements SysOplogBackupService {
    private static final Logger log = LoggerFactory.getLogger(SysOplogBackupServiceImpl.class);
    @Autowired
    private SysOplogService sysOplogService;

    @Override
    public void backup(String startDate) throws Exception {
        LocalDate currentDate;
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate inputDate = LocalDate.parse(startDate, formatter);
        long daysBetween = ChronoUnit.DAYS.between(inputDate, currentDate = LocalDate.now().minusDays(1L));
        if (daysBetween < 0L) {
            throw new RuntimeException("\u53ea\u80fd\u5907\u4efd\u6628\u5929\u53ca\u4e4b\u524d\u7684\u65e5\u5fd7\uff01");
        }
        if (daysBetween > 365L) {
            inputDate = currentDate.minusYears(1L);
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        while (!inputDate.isAfter(currentDate)) {
            String dateStr = inputDate.format(formatter);
            SysOplogBackup sysOplogBackup = (SysOplogBackup)this.getOne((Wrapper)Wrappers.lambdaQuery(SysOplogBackup.class).eq(SysOplogBackup::getDate, (Object)inputDate));
            inputDate = inputDate.plusDays(1L);
            if (sysOplogBackup != null) continue;
            sysOplogBackup = SysOplogBackup.builder().name(dateStr).date(simpleDateFormat.parse(dateStr)).build();
            try {
                String[] dateStrArr = dateStr.split("-");
                String folder = "data/logBackup/" + dateStrArr[0] + dateStrArr[1];
                Path folderPath = Paths.get(folder, new String[0]);
                if (!Files.exists(folderPath, new LinkOption[0])) {
                    Files.createDirectories(folderPath, new FileAttribute[0]);
                }
                String oplogFilter = String.format("Q_createtime_S_GE=%s 00:00:00;Q_createtime_S_LE=%s 23:59:59", dateStr, dateStr);
                List<SysOplog> logs = this.sysOplogService.findByFilterParam(oplogFilter);
                String filePath = folder + File.separator + dateStr + ".xlsx";
                ExcelUtil.exportExcel(logs, null, (String)"sheet1", SysOplog.class, (String)dateStr, (boolean)true, (String)filePath);
                sysOplogBackup.setPath(filePath);
            }
            catch (Exception ex) {
                log.error("\u5907\u4efd\u65e5\u5fd7\u51fa\u9519", (Throwable)ex);
            }
            this.save(sysOplogBackup);
        }
    }

    @Override
    public IPage<SysOplogBackup> queryPage(String filterParam, int page, int size) throws Exception {
        MyBatisQueryMapperUtils qum = new MyBatisQueryMapperUtils();
        QueryWrapper queryWrapper = qum.queryMapper(filterParam, SysOplogBackup.class);
        queryWrapper.orderByDesc((Object)"f_createtime");
        Page pages = new Page((long)page, (long)size);
        return this.page((IPage)pages, (Wrapper)queryWrapper);
    }
}

