/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.biz.service.sys.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.design.base.support.query.MyBatisQueryMapperUtils;
import com.geoway.design.biz.entity.SysPermission;
import com.geoway.design.biz.entity.SysPermissionGroup;
import com.geoway.design.biz.mapper.SysPermissionGroupMapper;
import com.geoway.design.biz.service.sys.ISysPermissionGroupService;
import com.geoway.design.biz.service.sys.ISysPermissionService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysPermissionGroupServiceImpl
extends ServiceImpl<SysPermissionGroupMapper, SysPermissionGroup>
implements ISysPermissionGroupService {
    @Autowired
    ISysPermissionService sysPermissionService;

    @Override
    public List<SysPermissionGroup> listByFilter(String filterParam, boolean hasChildren) throws Exception {
        if (filterParam == null) {
            filterParam = "";
        }
        List allGroups = this.list();
        MyBatisQueryMapperUtils qmu = new MyBatisQueryMapperUtils();
        QueryWrapper queryWrapper = qmu.queryMapper(filterParam, SysPermissionGroup.class);
        List<SysPermissionGroup> groups = this.list((Wrapper)queryWrapper);
        List<String> filterGroupIds = groups.stream().map(x -> x.getId()).collect(Collectors.toList());
        if (hasChildren) {
            MyBatisQueryMapperUtils qmuChild = new MyBatisQueryMapperUtils();
            QueryWrapper queryWrapperChild = qmuChild.queryMapper(filterParam, SysPermission.class);
            List childrens = this.sysPermissionService.list((Wrapper)queryWrapperChild);
            groups = this.buildTree(filterGroupIds, allGroups, childrens);
        }
        return groups;
    }

    @Override
    public void batchDelete(String ids) {
        if (StrUtil.isBlank((CharSequence)ids)) {
            return;
        }
        List<String> idList = Arrays.asList(ids.split(","));
        this.removeByIds(idList);
    }

    private void insertChildNodes(List<SysPermissionGroup> groups, List<SysPermission> childrens) {
        for (SysPermissionGroup group : groups) {
            List<SysPermission> filterList = childrens.stream().filter(u -> u.getGroupid().equals(group.getId())).collect(Collectors.toList());
            group.setChildren(filterList);
        }
    }

    private List<SysPermissionGroup> buildTree(List<String> filterGroupIds, List<SysPermissionGroup> allGroups, List<SysPermission> childrens) {
        ArrayList<SysPermissionGroup> results = new ArrayList<SysPermissionGroup>();
        boolean flag = false;
        for (SysPermissionGroup group : allGroups) {
            List<SysPermission> filterList = childrens.stream().filter(u -> u.getGroupid().equals(group.getId())).collect(Collectors.toList());
            group.setChildren(filterList);
            flag = filterList.size() > 0 || filterGroupIds.contains(group.getId());
            if (!flag) continue;
            results.add(group);
        }
        return results;
    }
}

