/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.biz.service.sys.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.design.base.support.StringUtils;
import com.geoway.design.base.support.query.MyBatisQueryMapperUtils;
import com.geoway.design.biz.entity.SysFunction;
import com.geoway.design.biz.entity.SysMenu;
import com.geoway.design.biz.entity.SysPermission;
import com.geoway.design.biz.entity.SysPermissionFunction;
import com.geoway.design.biz.entity.SysPermissionMenu;
import com.geoway.design.biz.entity.SysPermissonSystem;
import com.geoway.design.biz.entity.SysRolePermission;
import com.geoway.design.biz.mapper.SysPermissionMapper;
import com.geoway.design.biz.mapper.SysRolePermissionMapper;
import com.geoway.design.biz.service.sys.IFunctionSysService;
import com.geoway.design.biz.service.sys.INsMenuService;
import com.geoway.design.biz.service.sys.INsSystemService;
import com.geoway.design.biz.service.sys.ISysPermissionFunctionService;
import com.geoway.design.biz.service.sys.ISysPermissionMenuService;
import com.geoway.design.biz.service.sys.ISysPermissionService;
import com.geoway.design.biz.service.sys.ISysPermissionSystemService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysPermissionServiceImpl
extends ServiceImpl<SysPermissionMapper, SysPermission>
implements ISysPermissionService {
    @Autowired
    ISysPermissionMenuService sysPermissionMenuService;
    @Autowired
    INsMenuService menuService;
    @Autowired
    ISysPermissionSystemService sysPermissionSystemService;
    @Autowired
    SysRolePermissionMapper sysRolePermissionMapper;
    @Autowired
    INsSystemService nsSystemService;
    @Autowired
    IFunctionSysService functionSysService;
    @Autowired
    ISysPermissionFunctionService sysPermissionFunctionService;

    @Override
    public void saveOrUp(SysPermission permission) throws Exception {
        int iCount;
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysPermission::getGroupid, (Object)permission.getGroupid());
        wrapper.eq(SysPermission::getName, (Object)permission.getName());
        if (StrUtil.isNotBlank((CharSequence)permission.getId())) {
            wrapper.ne(SysPermission::getId, (Object)permission.getId());
        }
        if ((iCount = this.count((Wrapper)wrapper)) > 0) {
            throw new Exception("\u6743\u9650\u540d\u79f0: " + permission.getName() + "  \u5df2\u5b58\u5728\uff01");
        }
        this.saveOrUpdate(permission);
    }

    @Override
    public void saveRelateSystems(String permissonId, List<String> systemIds, boolean isClear) {
        this.sysPermissionSystemService.batchSave(permissonId, systemIds, isClear);
    }

    @Override
    public IPage<SysPermission> queryByFilter(String params, Integer page, Integer size) throws Exception {
        if (StringUtils.isBlank((CharSequence)params)) {
            Page pages = new Page();
            return this.page((IPage)pages);
        }
        MyBatisQueryMapperUtils qmu = new MyBatisQueryMapperUtils();
        QueryWrapper queryWrapper = qmu.queryMapper(params, SysPermission.class);
        Page pages = new Page((long)page.intValue(), (long)size.intValue());
        return this.page((IPage)pages, (Wrapper)queryWrapper);
    }

    @Override
    public List<SysMenu> queryRelateMenus(String id, String systemId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysPermissionMenu::getPermissionid, (Object)id);
        List permissionMenus = this.sysPermissionMenuService.list((Wrapper)wrapper);
        List menuIds = permissionMenus.stream().map(x -> x.getMenuid()).collect(Collectors.toList());
        if (menuIds.size() == 0) {
            return new ArrayList<SysMenu>();
        }
        LambdaQueryWrapper sysMenuWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)sysMenuWrapper.eq(SysMenu::getSystemId, (Object)systemId)).in(SysMenu::getId, menuIds);
        return this.menuService.list((Wrapper)sysMenuWrapper);
    }

    @Override
    public void saveRelateMenus(String permissonId, String systemId, List<String> menuIds) {
        LambdaQueryWrapper sysMenuWrapper = Wrappers.lambdaQuery();
        sysMenuWrapper.eq(SysMenu::getSystemId, (Object)systemId);
        List wholeMenus = this.menuService.list((Wrapper)sysMenuWrapper);
        LambdaQueryWrapper permissionMenuWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)permissionMenuWrapper.eq(SysPermissionMenu::getPermissionid, (Object)permissonId)).in(SysPermissionMenu::getMenuid, (Collection)wholeMenus.stream().map(f -> f.getId()).collect(Collectors.toList()));
        this.sysPermissionMenuService.remove((Wrapper)permissionMenuWrapper);
        SysPermissionMenu permissionMenu = null;
        for (String menuId : menuIds) {
            permissionMenu = new SysPermissionMenu();
            permissionMenu.setPermissionid(permissonId);
            permissionMenu.setMenuid(menuId);
            this.sysPermissionMenuService.save(permissionMenu);
        }
    }

    @Override
    public void saveRelateFunctions(String permissonId, String applicationId, List<String> functionIds) {
        LambdaQueryWrapper sysFuncWrapper = Wrappers.lambdaQuery();
        sysFuncWrapper.eq(SysFunction::getAppId, (Object)applicationId);
        List wholeFuncs = this.functionSysService.list((Wrapper)sysFuncWrapper);
        LambdaQueryWrapper permissionFuncWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)permissionFuncWrapper.eq(SysPermissionFunction::getPermissionid, (Object)permissonId)).in(SysPermissionFunction::getFuncid, (Collection)wholeFuncs.stream().map(f -> f.getId()).collect(Collectors.toList()));
        this.sysPermissionFunctionService.remove((Wrapper)permissionFuncWrapper);
        SysPermissionFunction permissionFunc = null;
        for (String FuncId : functionIds) {
            permissionFunc = new SysPermissionFunction();
            permissionFunc.setPermissionid(permissonId);
            permissionFunc.setFuncid(FuncId);
            this.sysPermissionFunctionService.save(permissionFunc);
        }
    }

    @Override
    public List<SysFunction> queryRelateFunctions(String id, String applicationId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysPermissionFunction::getPermissionid, (Object)id);
        List permissionMenus = this.sysPermissionFunctionService.list((Wrapper)wrapper);
        List funcIds = permissionMenus.stream().map(x -> x.getFuncid()).collect(Collectors.toList());
        if (funcIds.size() == 0) {
            return new ArrayList<SysFunction>();
        }
        LambdaQueryWrapper sysMenuWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)sysMenuWrapper.eq(SysFunction::getAppId, (Object)applicationId)).in(SysFunction::getId, funcIds);
        return this.functionSysService.list((Wrapper)sysMenuWrapper);
    }

    @Override
    public void delete(String id) throws Exception {
        LambdaQueryWrapper queryWrapper1 = Wrappers.lambdaQuery();
        queryWrapper1.eq(SysRolePermission::getPermissionid, (Object)id);
        int iCount = this.sysRolePermissionMapper.selectCount((Wrapper)queryWrapper1);
        if (iCount > 0) {
            throw new Exception("\u89d2\u8272\u4e0b\u5b58\u5728\u8be5\u6743\u9650\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        LambdaQueryWrapper queryWrapper2 = Wrappers.lambdaQuery();
        queryWrapper2.eq(SysPermissionMenu::getPermissionid, (Object)id);
        this.sysPermissionMenuService.remove((Wrapper)queryWrapper2);
        LambdaQueryWrapper queryWrapper3 = Wrappers.lambdaQuery();
        queryWrapper3.eq(SysPermissonSystem::getPermissionid, (Object)id);
        this.sysPermissionSystemService.remove((Wrapper)queryWrapper3);
        this.removeById((Serializable)((Object)id));
    }

    @Override
    public void batchDelete(String ids) throws Exception {
        if (StrUtil.isBlank((CharSequence)ids)) {
            return;
        }
        List<String> idList = Arrays.asList(ids.split(","));
        for (String id : idList) {
            this.delete(id);
        }
    }

    @Override
    public List<SysPermission> queryRolePermissons(String roleIds) {
        List<String> roleIdList = new ArrayList<String>();
        if (StrUtil.isNotBlank((CharSequence)roleIds)) {
            roleIdList = Arrays.asList(roleIds.split(","));
        }
        return ((SysPermissionMapper)this.baseMapper).queryRolePermissons(roleIdList);
    }

    @Override
    public List<SysPermission> queryRolePermissons(List<String> roleIds) {
        return ((SysPermissionMapper)this.baseMapper).queryRolePermissons(roleIds);
    }

    public boolean saveBatch(Collection<SysPermission> entityList) {
        return super.saveBatch(entityList);
    }
}

