/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.biz.service.sys.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.design.biz.entity.SysPermissionSubfunction;
import com.geoway.design.biz.entity.SysSubFunction;
import com.geoway.design.biz.entity.SysSubFunctionGroup;
import com.geoway.design.biz.mapper.SysPermissionSubfunctionMapper;
import com.geoway.design.biz.service.sys.ISysPermissionSubfunctionService;
import com.geoway.design.biz.service.sys.ISysSubFuncitonGroupService;
import com.geoway.design.biz.service.sys.ISysSubFunctionService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysPermissionSubfunctionServiceImpl
extends ServiceImpl<SysPermissionSubfunctionMapper, SysPermissionSubfunction>
implements ISysPermissionSubfunctionService {
    @Autowired
    private ISysSubFunctionService sysSubFunctionService;
    @Autowired
    private ISysSubFuncitonGroupService sysSubFuncitonGroupService;

    @Override
    public void batchSave(String permissionId, String menuId, List<String> funIds) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.eq(SysPermissionSubfunction::getPermissionid, (Object)permissionId)).eq(SysPermissionSubfunction::getMenuid, (Object)menuId);
        this.remove((Wrapper)wrapper);
        ArrayList funs = new ArrayList();
        funIds.forEach(f -> {
            SysPermissionSubfunction fun = new SysPermissionSubfunction();
            fun.setPermissionid(permissionId);
            fun.setMenuid(menuId);
            fun.setFunid((String)f);
            funs.add(fun);
        });
        this.saveBatch(funs);
    }

    @Override
    public List<SysSubFunctionGroup> queryByPermissionId(String permissionId, String menuId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.eq(SysPermissionSubfunction::getPermissionid, (Object)permissionId)).eq(SysPermissionSubfunction::getMenuid, (Object)menuId);
        List permissionSubfunctions = this.list((Wrapper)wrapper);
        if (permissionSubfunctions == null || permissionSubfunctions.size() == 0) {
            return new ArrayList<SysSubFunctionGroup>();
        }
        List<String> ids = permissionSubfunctions.stream().map(f -> f.getFunid()).collect(Collectors.toList());
        return this.sysSubFuncitonGroupService.listBySubFunctionIds(ids);
    }

    @Override
    public List<SysSubFunction> querySubFunctionByPermissionIdList(List<String> permissionIds, String menuId) {
        if (permissionIds == null || permissionIds.size() == 0) {
            return new ArrayList<SysSubFunction>();
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.in(SysPermissionSubfunction::getPermissionid, permissionIds);
        wrapper.eq(SysPermissionSubfunction::getMenuid, (Object)menuId);
        List permissionSubfunctions = this.list((Wrapper)wrapper);
        if (permissionSubfunctions == null || permissionSubfunctions.size() == 0) {
            return new ArrayList<SysSubFunction>();
        }
        List<String> ids = permissionSubfunctions.stream().map(f -> f.getFunid()).collect(Collectors.toList());
        ids = ids.stream().distinct().collect(Collectors.toList());
        return this.sysSubFunctionService.listSubFunctionByIds(ids);
    }
}

