/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.biz.service.sys.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.design.biz.entity.SysMenu;
import com.geoway.design.biz.entity.SysNsSystem;
import com.geoway.design.biz.entity.SysPermissionMenu;
import com.geoway.design.biz.entity.SysPermissonSystem;
import com.geoway.design.biz.mapper.SysMenuMapper;
import com.geoway.design.biz.mapper.SysPermissionMenuMapper;
import com.geoway.design.biz.mapper.SysPermissionSystemMapper;
import com.geoway.design.biz.service.sys.INsSystemService;
import com.geoway.design.biz.service.sys.ISysPermissionSystemService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysPermissionSystemServiceImpl
extends ServiceImpl<SysPermissionSystemMapper, SysPermissonSystem>
implements ISysPermissionSystemService {
    @Autowired
    INsSystemService systemService;
    @Autowired
    SysMenuMapper sysMenuMapper;
    @Autowired
    SysPermissionMenuMapper sysPermissionMenuMapper;

    @Override
    public List<SysNsSystem> queryByPermissionId(String permissionId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysPermissonSystem::getPermissionid, (Object)permissionId);
        List roleSystems = this.list((Wrapper)wrapper);
        List systemIds = roleSystems.stream().map(f -> f.getSystemid()).collect(Collectors.toList());
        if (systemIds.size() == 0) {
            return new ArrayList<SysNsSystem>();
        }
        return this.systemService.listByIds(systemIds);
    }

    @Override
    public void delete(String permissionId, String systemId) {
        LambdaQueryWrapper queryWrapper2 = Wrappers.lambdaQuery();
        queryWrapper2.eq(SysMenu::getSystemId, (Object)systemId);
        List sysMenus = this.sysMenuMapper.selectList((Wrapper)queryWrapper2);
        List menuIds = sysMenus.stream().map(i -> i.getId()).collect(Collectors.toList());
        if (menuIds.size() > 0) {
            LambdaQueryWrapper queryWrapper3 = Wrappers.lambdaQuery();
            queryWrapper3.eq(SysPermissionMenu::getPermissionid, (Object)permissionId);
            queryWrapper3.in(SysPermissionMenu::getMenuid, menuIds);
            this.sysPermissionMenuMapper.delete((Wrapper)queryWrapper3);
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.eq(SysPermissonSystem::getPermissionid, (Object)permissionId)).eq(SysPermissonSystem::getSystemid, (Object)systemId);
        this.remove((Wrapper)wrapper);
    }

    @Override
    public void batchDelete(String permissionId, List<String> systemIds) {
        for (String systemId : systemIds) {
            this.delete(permissionId, systemId);
        }
    }

    @Override
    public void batchSave(String permissionId, List<String> systemIds, boolean isClear) {
        if (isClear) {
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            wrapper.eq(SysPermissonSystem::getPermissionid, (Object)permissionId);
            this.remove((Wrapper)wrapper);
        }
        ArrayList systems = new ArrayList();
        systemIds.forEach(f -> {
            SysPermissonSystem sys = new SysPermissonSystem();
            sys.setPermissionid(permissionId);
            sys.setSystemid((String)f);
            systems.add(sys);
        });
        this.saveBatch(systems);
    }
}

