/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.biz.service.sys.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.design.biz.constatn.AppType;
import com.geoway.design.biz.dto.RoleAppsDTO;
import com.geoway.design.biz.entity.SysApplication;
import com.geoway.design.biz.entity.SysNsSystem;
import com.geoway.design.biz.entity.SysRoleApplication;
import com.geoway.design.biz.mapper.ApplicationSysMapper;
import com.geoway.design.biz.mapper.NsSystemMapper;
import com.geoway.design.biz.mapper.SysRoleApplicationMapper;
import com.geoway.design.biz.service.sys.SysRoleApplicationService;
import com.github.yulichang.interfaces.MPJBaseJoin;
import com.github.yulichang.toolkit.MPJWrappers;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SysRoleApplicationServiceImpl
extends ServiceImpl<SysRoleApplicationMapper, SysRoleApplication>
implements SysRoleApplicationService {
    @Autowired
    ApplicationSysMapper applicationSysMapper;
    @Autowired
    NsSystemMapper nsSystemMapper;

    @Override
    public void saveRoleApplications(String roleId, List<String> appIds, int appType, boolean isClear) {
        if (appIds == null || appIds.size() == 0) {
            return;
        }
        if (isClear) {
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            wrapper.eq(SysRoleApplication::getRoleid, (Object)roleId);
            wrapper.eq(SysRoleApplication::getApptype, (Object)appType);
            this.remove((Wrapper)wrapper);
        }
        ArrayList roleApps = new ArrayList();
        appIds.forEach(appId -> {
            SysRoleApplication roleApp = new SysRoleApplication();
            roleApp.setAppid((String)appId);
            roleApp.setRoleid(roleId);
            roleApp.setApptype(appType);
            roleApps.add(roleApp);
        });
        this.saveBatch(roleApps);
    }

    @Override
    public void saveRoleAppsAndSysems(String roleId, List<String> appIds, List<String> systemIds, boolean isClear) {
        this.saveRoleApplications(roleId, appIds, AppType.application.getValue(), isClear);
        this.saveRoleApplications(roleId, systemIds, AppType.system.getValue(), isClear);
    }

    @Override
    public List<SysApplication> queryRoleApplications(String roleId) {
        MPJLambdaWrapper queryWrapper = MPJWrappers.lambdaJoin();
        queryWrapper.leftJoin(SysRoleApplication.class, SysRoleApplication::getAppid, SysApplication::getId);
        queryWrapper.eq(SysRoleApplication::getApptype, (Object)AppType.application.getValue());
        queryWrapper.eq(SysRoleApplication::getRoleid, (Object)roleId);
        return this.applicationSysMapper.selectJoinList(SysApplication.class, (MPJBaseJoin)queryWrapper);
    }

    @Override
    public List<SysNsSystem> queryRoleSystems(String roleId) {
        MPJLambdaWrapper queryWrapper = MPJWrappers.lambdaJoin();
        queryWrapper.leftJoin(SysRoleApplication.class, SysRoleApplication::getAppid, SysNsSystem::getId);
        queryWrapper.eq(SysRoleApplication::getApptype, (Object)AppType.system.getValue());
        queryWrapper.eq(SysRoleApplication::getRoleid, (Object)roleId);
        return this.nsSystemMapper.selectJoinList(SysNsSystem.class, (MPJBaseJoin)queryWrapper);
    }

    @Override
    public RoleAppsDTO queryRoleAppsAndSystems(String roleId) {
        List<SysApplication> apps = this.queryRoleApplications(roleId);
        List<SysNsSystem> systems = this.queryRoleSystems(roleId);
        RoleAppsDTO roleAppsDTO = new RoleAppsDTO();
        roleAppsDTO.setRoleId(roleId);
        roleAppsDTO.setApps(apps);
        roleAppsDTO.setSystems(systems);
        return roleAppsDTO;
    }

    @Override
    public void removeRoleAppsAndSysems(String roleId, List<String> appIds, List<String> systemIds) {
        LambdaQueryWrapper wrapper;
        if (appIds != null && appIds.size() > 0) {
            wrapper = Wrappers.lambdaQuery();
            wrapper.eq(SysRoleApplication::getRoleid, (Object)roleId);
            wrapper.eq(SysRoleApplication::getApptype, (Object)AppType.application.getValue());
            wrapper.in(SysRoleApplication::getAppid, appIds);
            this.remove((Wrapper)wrapper);
        }
        if (systemIds != null && systemIds.size() > 0) {
            wrapper = Wrappers.lambdaQuery();
            wrapper.eq(SysRoleApplication::getRoleid, (Object)roleId);
            wrapper.eq(SysRoleApplication::getApptype, (Object)AppType.system.getValue());
            wrapper.in(SysRoleApplication::getAppid, systemIds);
            this.remove((Wrapper)wrapper);
        }
    }
}

