/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.biz.service.sys.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.design.biz.constatn.AppType;
import com.geoway.design.biz.entity.SysFunction;
import com.geoway.design.biz.entity.SysMenu;
import com.geoway.design.biz.entity.SysRoleMenu;
import com.geoway.design.biz.mapper.FunctionSysMapper;
import com.geoway.design.biz.mapper.SysMenuMapper;
import com.geoway.design.biz.mapper.SysRoleMenuMapper;
import com.geoway.design.biz.service.sys.SysRoleMenuService;
import com.github.yulichang.interfaces.MPJBaseJoin;
import com.github.yulichang.toolkit.MPJWrappers;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysRoleMenuServiceImpl
extends ServiceImpl<SysRoleMenuMapper, SysRoleMenu>
implements SysRoleMenuService {
    @Autowired
    SysMenuMapper sysMenuMapper;
    @Autowired
    FunctionSysMapper functionSysMapper;

    @Override
    public List<SysMenu> queryRelateMenus(String roleId, String appId) {
        MPJLambdaWrapper wrapper = MPJWrappers.lambdaJoin();
        wrapper.leftJoin(SysRoleMenu.class, SysRoleMenu::getMenuid, SysMenu::getId);
        wrapper.eq(SysRoleMenu::getRoleid, (Object)roleId);
        wrapper.eq(SysRoleMenu::getAppid, (Object)appId);
        wrapper.eq(SysRoleMenu::getApptype, (Object)AppType.system.getValue());
        return this.sysMenuMapper.selectJoinList(SysMenu.class, (MPJBaseJoin)wrapper);
    }

    @Override
    public List<SysFunction> queryRelateFunctions(String roleId, String appId) {
        MPJLambdaWrapper wrapper = MPJWrappers.lambdaJoin();
        wrapper.leftJoin(SysRoleMenu.class, SysRoleMenu::getMenuid, SysFunction::getId);
        wrapper.eq(SysRoleMenu::getRoleid, (Object)roleId);
        wrapper.eq(SysRoleMenu::getAppid, (Object)appId);
        wrapper.eq(SysRoleMenu::getApptype, (Object)AppType.application.getValue());
        return this.functionSysMapper.selectJoinList(SysFunction.class, (MPJBaseJoin)wrapper);
    }

    @Override
    public void saveRoleMenus(String roleId, String appId, int appType, List<String> menuIds) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysRoleMenu::getRoleid, (Object)roleId);
        wrapper.eq(SysRoleMenu::getAppid, (Object)appId);
        wrapper.eq(SysRoleMenu::getApptype, (Object)appType);
        this.remove((Wrapper)wrapper);
        if (menuIds.size() > 0) {
            ArrayList<SysRoleMenu> roleMenus = new ArrayList<SysRoleMenu>();
            for (String menuId : menuIds) {
                SysRoleMenu roleMenu = new SysRoleMenu();
                roleMenu.setMenuid(menuId);
                roleMenu.setAppid(appId);
                roleMenu.setApptype(appType);
                roleMenu.setRoleid(roleId);
                roleMenus.add(roleMenu);
            }
            this.saveBatch(roleMenus);
        }
    }
}

