/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.biz.service.sys.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.design.base.support.StringUtils;
import com.geoway.design.base.support.query.MPJQueryMapperUtil;
import com.geoway.design.base.support.query.MyBatisQueryMapperUtils;
import com.geoway.design.biz.constatn.ManagerType;
import com.geoway.design.biz.constatn.RoleLevel;
import com.geoway.design.biz.entity.BizManagerRange;
import com.geoway.design.biz.entity.SysOrganization;
import com.geoway.design.biz.entity.SysPermission;
import com.geoway.design.biz.entity.SysRegion;
import com.geoway.design.biz.entity.SysRole;
import com.geoway.design.biz.entity.SysRolePermission;
import com.geoway.design.biz.entity.SysUser;
import com.geoway.design.biz.entity.SysUserRole;
import com.geoway.design.biz.mapper.BizManagerRangeMapper;
import com.geoway.design.biz.mapper.SysOrganizationMapper;
import com.geoway.design.biz.mapper.SysRegionMapper;
import com.geoway.design.biz.mapper.SysRoleMapper;
import com.geoway.design.biz.mapper.SysUserMapper;
import com.geoway.design.biz.service.dev.IUserService;
import com.geoway.design.biz.service.oauth2.IOauth2Service;
import com.geoway.design.biz.service.sys.ISysPermissionService;
import com.geoway.design.biz.service.sys.ISysRolePermissionService;
import com.geoway.design.biz.service.sys.ISysRoleService;
import com.geoway.design.biz.service.sys.ISysUserRoleService;
import com.geoway.sso.client.util.HttpServletUtil;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class SysRoleServiceImpl
extends ServiceImpl<SysRoleMapper, SysRole>
implements ISysRoleService {
    @Autowired
    ISysRolePermissionService sysRolePermissionService;
    @Autowired
    ISysPermissionService sysPermissionService;
    @Autowired
    @Qualifier(value="localUserServiceImpl")
    private IUserService userService;
    @Autowired
    SysUserMapper sysUserMapper;
    @Autowired
    SysOrganizationMapper sysOrganizationMapper;
    @Autowired
    ISysUserRoleService sysUserRoleService;
    @Autowired
    IOauth2Service auth2Service;
    @Autowired
    BizManagerRangeMapper bizManagerRangeMapper;
    @Autowired
    SysRegionMapper sysRegionMapper;

    @Override
    public void saveOrUp(SysRole role) throws Exception {
        String userId = this.getCurrentUserId();
        SysUser user = (SysUser)this.sysUserMapper.selectById((Serializable)((Object)userId));
        if (user == null || user.getCatalog() == null) {
            throw new Exception("\u7528\u6237\u65e0\u6743\u9650");
        }
        boolean isBizAdmin = user.getCatalog().intValue() == RoleLevel.bizAdmin.getValue();
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysRole::getName, (Object)role.getName());
        wrapper.eq(SysRole::getPid, (Object)role.getPid());
        if (StrUtil.isNotBlank((CharSequence)role.getId())) {
            wrapper.ne(SysRole::getId, (Object)role.getId());
            SysRole oldRole = (SysRole)this.getById((Serializable)((Object)role.getId()));
            if (oldRole != null) {
                role.setCreateTime(oldRole.getCreateTime());
                role.setParents(oldRole.getParents());
                role.setLevel(oldRole.getLevel());
                role.setSort(oldRole.getSort());
                role.setCreatorid(oldRole.getCreatorid());
            }
            if (!oldRole.getName().equals(role.getName())) {
                this.buildChildALlName(role);
            }
        } else {
            SysRole pRole = (SysRole)this.getById((Serializable)((Object)role.getPid()));
            int level = pRole == null ? 1 : pRole.getLevel() + 1;
            role.setLevel(level);
            LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
            queryWrapper.eq(SysRole::getPid, (Object)role.getPid());
            queryWrapper.orderByDesc(SysRole::getSort);
            queryWrapper.last(" limit 1");
            SysRole lastRole = (SysRole)this.getOne((Wrapper)queryWrapper);
            if (lastRole == null) {
                role.setSort(1);
            } else {
                role.setSort(lastRole.getSort() + 1);
            }
            String parents = "";
            if (pRole != null) {
                parents = StrUtil.isNotBlank((CharSequence)pRole.getParents()) ? pRole.getId() : pRole.getParents() + "/" + pRole.getId();
            }
            role.setParents(parents);
            if (isBizAdmin) {
                role.setCreatorid(userId);
            }
        }
        int iCount = this.count((Wrapper)wrapper);
        if (iCount > 0) {
            throw new Exception("\u89d2\u8272\u3010" + role.getName() + "\u3011\u5df2\u5b58\u5728\uff01");
        }
        this.buildAllName(role);
        this.saveOrUpdate(role);
    }

    @Override
    public List<SysRole> queryTree(String filterParam) throws Exception {
        String userId = this.getCurrentUserId();
        SysUser user = (SysUser)this.sysUserMapper.selectById((Serializable)((Object)userId));
        if (user == null || user.getCatalog() == null) {
            throw new Exception("\u7528\u6237\u65e0\u6743\u9650");
        }
        boolean isBizAdmin = user.getCatalog().intValue() == RoleLevel.bizAdmin.getValue();
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysRole::getType, (Object)0);
        wrapper.orderByAsc(SysRole::getSort);
        List list = this.list((Wrapper)wrapper);
        if (filterParam == null) {
            filterParam = "";
        }
        MPJQueryMapperUtil qmu = new MPJQueryMapperUtil();
        MPJLambdaWrapper queryWrapper = qmu.queryMapper(filterParam, SysRole.class);
        queryWrapper.eq(SysRole::getType, (Object)1);
        queryWrapper.orderByAsc(SysRole::getSort);
        if (isBizAdmin) {
            List<String> roleIds = this.queryBizRoleIds(userId);
            if (roleIds.size() == 0) {
                roleIds.add("0");
            }
            queryWrapper.in(SysRole::getId, roleIds);
        }
        List roleList = this.list((Wrapper)queryWrapper);
        if (isBizAdmin) {
            LambdaQueryWrapper subQueryWrapper = Wrappers.lambdaQuery();
            subQueryWrapper.eq(SysRole::getCreatorid, (Object)userId);
            subQueryWrapper.eq(SysRole::getType, (Object)1);
            List selfRoleList = this.list((Wrapper)subQueryWrapper);
            roleList.addAll(selfRoleList);
        }
        if (isBizAdmin) {
            List pids = roleList.stream().map(i -> i.getPid()).collect(Collectors.toList());
            list = list.stream().filter(i -> pids.contains(i.getId())).collect(Collectors.toList());
        }
        list.addAll(roleList);
        return this.constructTree(list);
    }

    private List<String> queryBizRoleIds(String userId) {
        LambdaQueryWrapper subQueryWrapper = Wrappers.lambdaQuery();
        subQueryWrapper.eq(BizManagerRange::getUserid, (Object)userId);
        subQueryWrapper.eq(BizManagerRange::getManageType, (Object)ManagerType.role.getValue());
        List bizRanges = this.bizManagerRangeMapper.selectList((Wrapper)subQueryWrapper);
        if (bizRanges == null || bizRanges.size() == 0) {
            return new ArrayList<String>();
        }
        List<String> roleIds = bizRanges.stream().map(item -> item.getManageValue()).collect(Collectors.toList());
        return roleIds;
    }

    @Override
    public List<SysRole> queryList(String filterParam) throws Exception {
        MyBatisQueryMapperUtils qmu = new MyBatisQueryMapperUtils();
        QueryWrapper queryWrapper = qmu.queryMapper(filterParam, SysRole.class);
        queryWrapper.orderByAsc((Object)"f_sort");
        List roleList = this.list((Wrapper)queryWrapper);
        return roleList;
    }

    @Override
    public List<SysRole> queryAllParentRole(String id) {
        List<SysRole> roles = ((SysRoleMapper)this.baseMapper).getAllParentRole(id);
        Collections.reverse(roles);
        return roles;
    }

    @Override
    public IPage<SysRole> queryPage(String filterParam, int page, int size) throws Exception {
        MyBatisQueryMapperUtils qmu = new MyBatisQueryMapperUtils();
        QueryWrapper queryWrapper = qmu.queryMapper(filterParam, SysRole.class);
        queryWrapper.orderByAsc((Object)"f_sort");
        Page pages = new Page((long)page, (long)size);
        return this.page((IPage)pages, (Wrapper)queryWrapper);
    }

    @Override
    public List<SysPermission> queryPermissionByRoleId(String roleId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysRolePermission::getRoleid, (Object)roleId);
        List relObjs = this.sysRolePermissionService.list((Wrapper)wrapper);
        List relIds = relObjs.stream().map(x -> x.getPermissionid()).collect(Collectors.toList());
        if (relIds.size() == 0) {
            return new ArrayList<SysPermission>();
        }
        List permissions = this.sysPermissionService.listByIds(relIds);
        return permissions;
    }

    @Override
    public void saveRolePermissions(String roleId, String permissionIds) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysRolePermission::getRoleid, (Object)roleId);
        this.sysRolePermissionService.remove((Wrapper)wrapper);
        if (StrUtil.isBlank((CharSequence)permissionIds)) {
            return;
        }
        String[] permissionIdArr = permissionIds.split(",");
        ArrayList<SysRolePermission> rolePermissions = new ArrayList<SysRolePermission>();
        ArrayList<String> permissionIdList = new ArrayList<String>();
        for (String permissionId : permissionIdArr) {
            if (permissionIdList.contains(permissionId)) continue;
            SysRolePermission rolePermission = new SysRolePermission();
            rolePermission.setPermissionid(permissionId);
            rolePermission.setRoleid(roleId);
            rolePermissions.add(rolePermission);
            permissionIdList.add(permissionId);
        }
        this.sysRolePermissionService.saveBatch(rolePermissions);
    }

    @Override
    public SysRole findOne(String id, String filterParam) throws Exception {
        SysRole role = (SysRole)this.getById((Serializable)((Object)id));
        if (filterParam == null) {
            filterParam = "";
        }
        if (role.getType() == 0) {
            boolean isBizAdmin;
            MPJQueryMapperUtil qmu = new MPJQueryMapperUtil();
            MPJLambdaWrapper queryWrapper = qmu.queryMapper(filterParam, SysRole.class);
            queryWrapper.eq(SysRole::getPid, (Object)id);
            queryWrapper.orderByAsc(SysRole::getSort);
            String userId = this.getCurrentUserId();
            SysUser user = (SysUser)this.sysUserMapper.selectById((Serializable)((Object)userId));
            if (user == null || user.getCatalog() == null) {
                return role;
            }
            boolean bl = isBizAdmin = user.getCatalog().intValue() == RoleLevel.bizAdmin.getValue();
            if (isBizAdmin) {
                List<String> roleIds = this.queryBizRoleIds(userId);
                if (roleIds.size() == 0) {
                    return role;
                }
                queryWrapper.in(SysRole::getId, roleIds);
            }
            List childRoles = this.list((Wrapper)queryWrapper);
            if (isBizAdmin) {
                LambdaQueryWrapper subQueryWrapper = Wrappers.lambdaQuery();
                subQueryWrapper.eq(SysRole::getCreatorid, (Object)userId);
                subQueryWrapper.eq(SysRole::getPid, (Object)id);
                List selfRoleList = this.list((Wrapper)subQueryWrapper);
                childRoles.addAll(selfRoleList);
            }
            if (role != null) {
                role.setChildren(childRoles);
            }
        }
        return role;
    }

    @Override
    public void batchDelete(String ids) throws Exception {
        if (StrUtil.isBlank((CharSequence)ids)) {
            return;
        }
        List<String> idList = Arrays.asList(ids.split(","));
        for (String id : idList) {
            this.deleteById(id);
        }
    }

    @Override
    public List<SysUser> queryRelUsers(String roleId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysUserRole::getRoleid, (Object)roleId);
        List userRoles = this.sysUserRoleService.list((Wrapper)wrapper);
        if (userRoles == null || userRoles.size() == 0) {
            return null;
        }
        List<SysUser> users = this.userService.query(userRoles.stream().map(f -> f.getUserid()).collect(Collectors.toList()));
        this.wrapperOrgAllNames(users);
        this.wrapperRegionAllNames(users);
        return users;
    }

    @Override
    public List<SysRole> queryUserRoles(String userId) {
        return ((SysRoleMapper)this.baseMapper).queryUserRoles(userId);
    }

    @Override
    public void sortRoles(String id, String pid, int flag) {
        List<SysRole> roles = this.initSort(pid);
        int iCount = roles.size();
        if (iCount < 2) {
            return;
        }
        int index = roles.stream().map(i -> i.getId()).collect(Collectors.toList()).indexOf(id);
        if (index < 0) {
            return;
        }
        SysRole curRole = roles.get(index);
        List otherRoles = roles.stream().filter(item -> !item.getId().equals(id)).collect(Collectors.toList());
        switch (flag) {
            case 1: {
                int start = 2;
                curRole.setSort(1);
                for (SysRole role : otherRoles) {
                    role.setSort(start);
                    ++start;
                }
                otherRoles.add(curRole);
                this.updateBatchById(roles);
                break;
            }
            case 2: {
                if (index <= 0) break;
                SysRole changRole = roles.get(index - 1);
                int iSort = changRole.getSort();
                changRole.setSort(curRole.getSort());
                curRole.setSort(iSort);
                this.updateById(curRole);
                this.updateById(changRole);
                break;
            }
            case 3: {
                if (index >= iCount - 1) break;
                SysRole changRole = roles.get(index + 1);
                int iSort = changRole.getSort();
                changRole.setSort(curRole.getSort());
                curRole.setSort(iSort);
                this.updateById(curRole);
                this.updateById(changRole);
                break;
            }
            case 4: {
                int start2 = 1;
                for (SysRole role : otherRoles) {
                    role.setSort(start2);
                    ++start2;
                }
                curRole.setSort(start2);
                otherRoles.add(curRole);
                this.updateBatchById(roles);
                break;
            }
        }
    }

    @Override
    public List<SysRole> initSort(String pid) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        if (pid == null) {
            queryWrapper.isNull(SysRole::getPid);
        } else {
            queryWrapper.eq(SysRole::getPid, (Object)pid);
        }
        queryWrapper.orderByAsc(SysRole::getSort);
        List roles = this.list((Wrapper)queryWrapper);
        int iCount = roles.size();
        if (iCount < 2) {
            return roles;
        }
        LambdaQueryWrapper queryWrapper2 = Wrappers.lambdaQuery();
        if (pid == null) {
            queryWrapper2.isNull(SysRole::getPid);
        } else {
            queryWrapper2.eq(SysRole::getPid, (Object)pid);
        }
        queryWrapper2.groupBy(SysRole::getSort);
        queryWrapper2.select(new SFunction[]{SysRole::getSort});
        List list2 = this.listMaps((Wrapper)queryWrapper2);
        int iCount2 = list2.size();
        if (iCount > iCount2) {
            for (int i = 0; i < roles.size(); ++i) {
                SysRole role = (SysRole)roles.get(i);
                role.setSort(i + 1);
            }
            this.updateBatchById(roles);
        }
        return roles;
    }

    @Override
    public void dragRoleNode(String id, String refId, String type) throws Exception {
        SysRole role = (SysRole)this.getById((Serializable)((Object)id));
        SysRole refRole = (SysRole)this.getById((Serializable)((Object)refId));
        String pid = refRole.getPid();
        int sort = refRole.getSort();
        role.setLevel(refRole.getLevel());
        role.setParents(refRole.getParents());
        if (type.equals("inner")) {
            pid = refRole.getId();
            role.setLevel(refRole.getLevel() + 1);
            role.setParents(refRole.getParents() + "/" + refRole.getId());
        }
        role.setPid(pid);
        role.setSort(sort);
        this.buildAllName(role);
        this.saveOrUpdate(role);
        this.initSort(pid);
        int sortType = 2;
        if (type.equals("after")) {
            sortType = 3;
        } else if (type.equals("inner")) {
            sortType = 4;
        }
        this.sortRoles(id, pid, sortType);
    }

    @Override
    public int queryCount(String filterParam) throws Exception {
        int count = 0;
        MyBatisQueryMapperUtils qmu = new MyBatisQueryMapperUtils();
        QueryWrapper queryWrapper = qmu.queryMapper(filterParam, SysRole.class);
        count = this.count((Wrapper)queryWrapper);
        return count;
    }

    private void deleteById(String id) throws Exception {
        SysRole role = (SysRole)this.getById((Serializable)((Object)id));
        if (role.getType() == 1) {
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            wrapper.eq(SysUserRole::getRoleid, (Object)id);
            int iCount = this.sysUserRoleService.count((Wrapper)wrapper);
            if (iCount > 0) {
                throw new Exception("\u8be5\u89d2\u8272\u4e0b\u5df2\u5173\u8054\u7528\u6237\uff0c\u4e0d\u80fd\u5220\u9664!");
            }
            LambdaQueryWrapper wrapper2 = Wrappers.lambdaQuery();
            wrapper2.eq(SysRolePermission::getRoleid, (Object)id);
            this.sysRolePermissionService.remove((Wrapper)wrapper2);
        } else {
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            wrapper.eq(SysRole::getPid, (Object)id);
            List subRoles = this.list((Wrapper)wrapper);
            for (SysRole subRole : subRoles) {
                this.deleteById(subRole.getId());
            }
        }
        this.removeById((Serializable)((Object)id));
    }

    private List<SysRole> constructTree(List<SysRole> list) {
        int minLevel = 99;
        HashMap mapParam = new HashMap();
        for (SysRole role : list) {
            String key = role.getPid();
            if (!StringUtils.isEmpty((String)key) && !key.equals("-1")) {
                if (mapParam.containsKey(key)) {
                    ((List)mapParam.get(key)).add(role);
                } else {
                    ArrayList<SysRole> childList = new ArrayList<SysRole>();
                    childList.add(role);
                    mapParam.put(key, childList);
                }
            }
            if (role.getLevel() >= minLevel) continue;
            minLevel = role.getLevel();
        }
        ArrayList<SysRole> results = new ArrayList<SysRole>();
        for (SysRole role : list) {
            String key = role.getId();
            if (StringUtils.isNotBlank((CharSequence)key) && mapParam.containsKey(key)) {
                role.setChildren((List)mapParam.get(key));
            }
            if (role.getLevel() != minLevel) continue;
            results.add(role);
        }
        return results;
    }

    private void buildChildALlName(SysRole role) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.like(SysRole::getParents, (Object)role.getId());
        List roles = this.list((Wrapper)wrapper);
        for (SysRole subRole : roles) {
            this.buildAllName(subRole);
        }
    }

    private void buildAllName(SysRole role) {
        String parents = role.getParents();
        if (StrUtil.isBlank((CharSequence)parents)) {
            role.setAllname(role.getName());
        } else {
            List<String> pRoleIds = Arrays.asList(parents.split("/"));
            List pRoles = ((SysRoleMapper)this.baseMapper).selectBatchIds(pRoleIds);
            String allName = "";
            for (SysRole pRole : pRoles) {
                allName = allName + pRole.getName() + "/";
            }
            allName = allName + role.getName();
            role.setAllname(allName);
        }
    }

    private void wrapperOrgAllNames(List<SysUser> users) {
        HashMap allNameCache = new HashMap();
        for (SysUser user : users) {
            List<SysOrganization> orgs = this.sysOrganizationMapper.queryUserOrgs(user.getId());
            List<String> orgAllNames = orgs.stream().map(x -> x.getName()).collect(Collectors.toList());
            user.setOrgNames(orgAllNames);
        }
    }

    private void wrapperRegionAllNames(List<SysUser> users) {
        for (SysUser user : users) {
            ArrayList<String> allRegionNames = new ArrayList<String>();
            List<SysRegion> regions = this.sysRegionMapper.queryUserRegions(user.getId());
            for (SysRegion region : regions) {
                List<SysRegion> parentRegion = this.sysRegionMapper.getAllParentRegion(region.getCode());
                Collections.reverse(parentRegion);
                allRegionNames.add(StrUtil.join((CharSequence)"/", (Object[])new Object[]{parentRegion.stream().map(SysRegion::getName).collect(Collectors.toList())}));
            }
            user.setRegionNames(allRegionNames);
        }
    }

    private String getCurrentUserId() {
        HttpServletRequest request = HttpServletUtil.getRequest();
        return this.auth2Service.queryCurrentUserId(request);
    }
}

