/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.biz.service.sys.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.design.base.support.query.MyBatisQueryMapperUtils;
import com.geoway.design.biz.entity.SysSubFunction;
import com.geoway.design.biz.entity.SysSubFunctionGroup;
import com.geoway.design.biz.mapper.SysSubFunctionGroupMapper;
import com.geoway.design.biz.service.sys.ISysSubFuncitonGroupService;
import com.geoway.design.biz.service.sys.ISysSubFunctionService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysSubFuncitonGroupServiceImpl
extends ServiceImpl<SysSubFunctionGroupMapper, SysSubFunctionGroup>
implements ISysSubFuncitonGroupService {
    @Autowired
    private ISysSubFunctionService privilegeService;

    @Override
    public List<SysSubFunctionGroup> listByFilter(String filterParam) throws Exception {
        if (filterParam == null) {
            filterParam = "";
        }
        List allGroups = this.list();
        MyBatisQueryMapperUtils qmu = new MyBatisQueryMapperUtils();
        QueryWrapper queryWrapper = qmu.queryMapper(filterParam, SysSubFunctionGroup.class);
        List<SysSubFunctionGroup> groups = this.list((Wrapper)queryWrapper);
        List<String> filterGroupIds = groups.stream().map(x -> x.getId()).collect(Collectors.toList());
        MyBatisQueryMapperUtils qmuChild = new MyBatisQueryMapperUtils();
        QueryWrapper queryWrapperChild = qmuChild.queryMapper(filterParam, SysSubFunction.class);
        List childrens = this.privilegeService.list((Wrapper)queryWrapperChild);
        groups = this.buildTree(filterGroupIds, allGroups, childrens);
        return groups;
    }

    @Override
    public List<SysSubFunctionGroup> listBySubFunctionIds(List<String> subFunctionIds) {
        List subFunctions = this.privilegeService.listByIds(subFunctionIds);
        List<String> groupIds = subFunctions.stream().map(f -> f.getGroupid()).distinct().collect(Collectors.toList());
        List<SysSubFunctionGroup> groups = this.listByIds(groupIds);
        groups = this.buildTree(groupIds, groups, subFunctions);
        return groups;
    }

    @Override
    public void saveOrUp(SysSubFunctionGroup group) throws Exception {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysSubFunctionGroup::getName, (Object)group.getName());
        if (StrUtil.isNotBlank((CharSequence)group.getId())) {
            wrapper.ne(SysSubFunctionGroup::getId, (Object)group.getId());
            group.setUpdateTime(new Date());
        } else {
            group.setSort(this.getNextOrder());
            group.setCreateTime(new Date());
            group.setUpdateTime(new Date());
        }
        int iCount = this.count((Wrapper)wrapper);
        if (iCount > 0) {
            throw new Exception("\u7ec4\u540d: " + group.getName() + "  \u5df2\u5b58\u5728\uff01");
        }
        this.saveOrUpdate(group);
    }

    private int getNextOrder() {
        SysSubFunctionGroup group = (SysSubFunctionGroup)this.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().orderByDesc(SysSubFunctionGroup::getSort)).last("limit 1"));
        if (group == null) {
            return 1;
        }
        return group.getSort() + 1;
    }

    private List<SysSubFunctionGroup> buildTree(List<String> filterGroupIds, List<SysSubFunctionGroup> allGroups, List<SysSubFunction> childrens) {
        ArrayList<SysSubFunctionGroup> results = new ArrayList<SysSubFunctionGroup>();
        boolean flag = false;
        for (SysSubFunctionGroup group : allGroups) {
            List<SysSubFunction> filterList = childrens.stream().filter(u -> u.getGroupid().equals(group.getId())).collect(Collectors.toList());
            group.setChildren(filterList);
            flag = filterList.size() > 0 || filterGroupIds.contains(group.getId());
            if (!flag) continue;
            results.add(group);
        }
        return results;
    }
}

