/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.biz.service.sys.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.design.biz.entity.SysUserApplication;
import com.geoway.design.biz.mapper.SysUserApplicationMapper;
import com.geoway.design.biz.service.sys.SysApplicationGroupService;
import com.geoway.design.biz.service.sys.SysUserApplicationService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysUserApplicationServiceImpl
extends ServiceImpl<SysUserApplicationMapper, SysUserApplication>
implements SysUserApplicationService {
    @Autowired
    SysApplicationGroupService sysApplicationGroupService;

    @Override
    public void updateUserApplication(String userId, String appId, int appType, int nodeType) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysUserApplication::getUserid, (Object)userId);
        queryWrapper.eq(SysUserApplication::getAppid, (Object)appId);
        queryWrapper.eq(SysUserApplication::getApptype, (Object)appType);
        int icount = this.count((Wrapper)queryWrapper);
        if (icount == 0) {
            SysUserApplication sysUserApplication = new SysUserApplication();
            sysUserApplication.setUserid(userId);
            sysUserApplication.setAppid(appId);
            sysUserApplication.setApptype(appType);
            sysUserApplication.setType(nodeType);
            this.save(sysUserApplication);
        }
    }

    @Override
    public void deleteExistApplication(String userId, String appId, int appType) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysUserApplication::getUserid, (Object)userId);
        queryWrapper.eq(SysUserApplication::getAppid, (Object)appId);
        queryWrapper.eq(SysUserApplication::getApptype, (Object)appType);
        this.remove((Wrapper)queryWrapper);
    }

    @Override
    public void deleteGroupIsNoChild(String userId, String groupId, int appType) {
        List<String> subAppIds = this.sysApplicationGroupService.queryGroupAppIds(groupId);
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysUserApplication::getUserid, (Object)userId);
        queryWrapper.in(SysUserApplication::getAppid, subAppIds);
        queryWrapper.eq(SysUserApplication::getApptype, (Object)appType);
        int icount = this.count((Wrapper)queryWrapper);
        if (icount == 0) {
            this.deleteExistApplication(userId, groupId, appType);
        }
    }
}

