/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.biz.service.sys.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.geoway.design.base.support.query.MPJQueryMapperUtil;
import com.geoway.design.biz.entity.SysUser;
import com.geoway.design.biz.entity.SysUserLimit;
import com.geoway.design.biz.mapper.SysUserLimitMapper;
import com.geoway.design.biz.service.sys.SysUserLimitService;
import com.github.yulichang.base.MPJBaseServiceImpl;
import com.github.yulichang.interfaces.MPJBaseJoin;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class SysUserLimitServiceImpl
extends MPJBaseServiceImpl<SysUserLimitMapper, SysUserLimit>
implements SysUserLimitService {
    private final int const_blacklist = 1;
    private final int const_whitelist = 2;

    @Override
    public void saveOneLimit(SysUserLimit userLimit) {
        boolean isNew = true;
        if (StrUtil.isNotBlank((CharSequence)userLimit.getId())) {
            boolean bl = isNew = this.getById((Serializable)((Object)userLimit.getId())) == null;
        }
        if (isNew) {
            LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
            queryWrapper.eq(SysUserLimit::getUserid, (Object)userLimit.getUserid());
            queryWrapper.eq(SysUserLimit::getAppid, (Object)userLimit.getAppid());
            queryWrapper.last(" limit 1");
            SysUserLimit existLimit = (SysUserLimit)this.getOne((Wrapper)queryWrapper);
            if (existLimit != null) {
                userLimit.setId(existLimit.getId());
            } else {
                userLimit.setCreatetime(new Date());
            }
        }
        this.saveOrUpdate(userLimit);
    }

    @Override
    public void bactchSaveWithJSON(String jsonArrayStr) {
        List userLimits = JSONArray.parseArray((String)jsonArrayStr, SysUserLimit.class);
        if (userLimits != null) {
            for (SysUserLimit userLimit : userLimits) {
                this.saveOneLimit(userLimit);
            }
        }
    }

    @Override
    public boolean isValid(String appId, String userId) {
        boolean isValid = true;
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysUserLimit::getUserid, (Object)userId);
        List userLimits = this.list((Wrapper)queryWrapper);
        for (SysUserLimit userLimit : userLimits) {
            boolean timeValid;
            boolean appIdValid = userLimit.getAppid().equals("-1") || userLimit.getAppid().equals(appId);
            boolean bl = timeValid = userLimit.getExpiretime() == null || userLimit.getExpiretime().getTime() > System.currentTimeMillis();
            if (userLimit.getLimittype() != 1 || !appIdValid || !timeValid) continue;
            isValid = false;
            break;
        }
        return isValid;
    }

    @Override
    public IPage<SysUserLimit> queryPage(String filterParam, String sortParam, String username, String tel, int page, int size) throws Exception {
        MPJQueryMapperUtil qmu = new MPJQueryMapperUtil();
        MPJLambdaWrapper queryWrapper = qmu.queryMapper(filterParam, sortParam, SysUserLimit.class);
        queryWrapper.selectAll(SysUserLimit.class);
        queryWrapper.selectAs("su", SysUser::getName, SysUserLimit::getUsername);
        queryWrapper.selectAs("su", SysUser::getTel, SysUserLimit::getTel);
        queryWrapper.selectAs("su", SysUser::getEmail, SysUserLimit::getEmail);
        queryWrapper.leftJoin(SysUser.class, "su", SysUser::getId, SysUserLimit::getUserid);
        if (StrUtil.isNotBlank((CharSequence)username)) {
            queryWrapper.like(SysUser::getName, (Object)username);
        }
        if (StrUtil.isNotBlank((CharSequence)tel)) {
            queryWrapper.like(SysUser::getTel, (Object)tel);
        }
        Page pageT = new Page((long)page, (long)size);
        IPage pageResults = this.selectJoinListPage((IPage)pageT, SysUserLimit.class, (MPJBaseJoin)queryWrapper);
        return pageResults;
    }
}

