/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.biz.service.sys.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.design.base.exception.ServiceException;
import com.geoway.design.base.support.encryption.AESUtils;
import com.geoway.design.base.support.query.MyBatisQueryMapperUtils;
import com.geoway.design.biz.dto.UserRelParams;
import com.geoway.design.biz.entity.SysOrganization;
import com.geoway.design.biz.entity.SysRegion;
import com.geoway.design.biz.entity.SysUser;
import com.geoway.design.biz.entity.SysUserRegister;
import com.geoway.design.biz.mapper.SysUserRegisterMapper;
import com.geoway.design.biz.service.dev.IOrganizationService;
import com.geoway.design.biz.service.sys.BizManagerRangeService;
import com.geoway.design.biz.service.sys.ISysRegionService;
import com.geoway.design.biz.service.sys.ISysUserRegisterService;
import com.geoway.design.biz.service.sys.ISysUserRoleService;
import com.geoway.design.biz.service.sys.ISysUserService;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SysUserRegisterServiceImpl
extends ServiceImpl<SysUserRegisterMapper, SysUserRegister>
implements ISysUserRegisterService {
    @Autowired
    ISysUserService sysUserService;
    @Autowired
    IOrganizationService organizationService;
    @Autowired
    BizManagerRangeService bizManagerRangeService;
    @Autowired
    ISysRegionService sysRegionService;
    @Autowired
    ISysUserRoleService sysUserRoleService;
    @Value(value="${userTel.encrypt:true}")
    private boolean userTelEncrypt;
    @Value(value="${userRegister.auditMode:2}")
    private int auditMode;

    @Override
    public Boolean checkAccoutRepeat(String accout) throws Exception {
        List<SysUser> users = this.sysUserService.queryList("accout_EQ_" + accout);
        List<SysUserRegister> usersRegister = this.queryList("accout_EQ_" + accout + ";auditState_NE_2");
        return users.size() > 0 || usersRegister.size() > 0;
    }

    @Override
    public Boolean checkTelRepeat(String tel) throws Exception {
        if (this.userTelEncrypt) {
            String telEncrypt = AESUtils.encrypt((String)tel, (String)"FWAijk4A2Dwt2MKw");
            List<SysUser> users = this.sysUserService.queryList("telEncrypt_EQ_" + telEncrypt);
            List<SysUserRegister> usersRegister = this.queryList("telEncrypt_EQ_" + telEncrypt + ";auditState_NE_2");
            return users.size() > 0 || usersRegister.size() > 0;
        }
        List<SysUser> users = this.sysUserService.queryList("tel_EQ_" + tel);
        List<SysUserRegister> usersRegister = this.queryList("tel_EQ_" + tel + ";auditState_NE_2");
        return users.size() > 0 || usersRegister.size() > 0;
    }

    @Override
    public Boolean registerUser(SysUserRegister sysUserRegister) {
        String tel = sysUserRegister.getTel();
        if (StringUtils.isBlank((CharSequence)tel)) {
            throw new ServiceException("\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (tel.length() != 11) {
            throw new RuntimeException("\u624b\u673a\u53f7\u683c\u5f0f\u9519\u8bef");
        }
        try {
            sysUserRegister.setTelEncrypt(AESUtils.encrypt((String)tel, (String)"FWAijk4A2Dwt2MKw"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        sysUserRegister.setTel(tel.substring(0, 3) + "****" + tel.substring(7, 11));
        this.save(sysUserRegister);
        return true;
    }

    @Override
    public IPage<SysUserRegister> queryPage(String filterParam, int page, int size, String userid, Integer userCatalog) throws Exception {
        Page pages = new Page((long)page, (long)size);
        if (userCatalog == null || userCatalog == 3) {
            return pages;
        }
        if (userCatalog == 2) {
            String orgFilter = "";
            List<String> manageOrgs = this.bizManagerRangeService.queryAllManageOrgs(userid);
            if (manageOrgs.size() > 0) {
                orgFilter = "QOR_organization_S_IN=" + StrUtil.join((CharSequence)",", (Object[])new Object[]{manageOrgs}) + ";";
            }
            String regionFilter = "";
            List<String> manageRegions = this.bizManagerRangeService.queryAllManageRegions(userid);
            if (manageRegions.size() > 0) {
                regionFilter = "QOR_region_S_IN=" + StrUtil.join((CharSequence)",", (Object[])new Object[]{manageRegions}) + ";";
            }
            if (manageOrgs.size() == 0 && manageRegions.size() == 0) {
                return pages;
            }
            String filter = String.format(";(%s);", this.auditMode == 1 ? regionFilter : (this.auditMode == 2 ? orgFilter : orgFilter + regionFilter));
            filterParam = filter + filterParam;
        }
        MyBatisQueryMapperUtils qmu = new MyBatisQueryMapperUtils();
        QueryWrapper queryWrapper = qmu.queryMapper(filterParam, SysUserRegister.class);
        queryWrapper.orderByAsc((Object)"f_createtime");
        IPage pageUsers = ((SysUserRegisterMapper)this.baseMapper).selectPage((IPage)pages, (Wrapper)queryWrapper);
        for (SysUserRegister register : pageUsers.getRecords()) {
            if (StringUtils.isNotBlank((CharSequence)register.getOrganization())) {
                List<SysOrganization> organizations = this.organizationService.queryList("id_IN_" + register.getOrganization());
                register.setOrgNames(StringUtils.join((Iterable)organizations.stream().map(SysOrganization::getAllname).collect(Collectors.toList()), (String)","));
            }
            if (StringUtils.isNotBlank((CharSequence)register.getRegion())) {
                List<SysRegion> regions = this.sysRegionService.queryList("regionCode_IN_" + register.getRegion(), null);
                regions.forEach(m -> m.setAllname(StrUtil.join((CharSequence)"/", (Object[])new Object[]{this.sysRegionService.queryAllParentRegion(m.getRegionCode()).stream().map(SysRegion::getName).collect(Collectors.toList())})));
                register.setRegionNames(StringUtils.join((Iterable)regions.stream().map(SysRegion::getAllname).collect(Collectors.toList()), (String)","));
            }
            if (!StringUtils.isNotBlank((CharSequence)register.getAuditUser())) continue;
            register.setAuditUserName(this.sysUserService.queryOne(register.getAuditUser()).getName());
        }
        return pageUsers;
    }

    @Override
    public List<SysUserRegister> queryList(String filterParam) throws Exception {
        MyBatisQueryMapperUtils qmu = new MyBatisQueryMapperUtils();
        QueryWrapper queryWrapper = qmu.queryMapper(filterParam, SysUserRegister.class);
        queryWrapper.orderByAsc((Object)"f_createtime");
        List users = ((SysUserRegisterMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        return users;
    }

    @Override
    public Boolean audit(String userId, String id, Boolean passed, String auditOpinion, String roleIds) throws Exception {
        if (StringUtils.isBlank((CharSequence)userId)) {
            return false;
        }
        SysUserRegister entity = (SysUserRegister)this.getById((Serializable)((Object)id));
        if (entity == null) {
            return false;
        }
        entity.setAuditState(Boolean.TRUE.equals(passed) ? "1" : "2");
        entity.setAuditOpinion(auditOpinion);
        entity.setAuditTime(new Date());
        entity.setAuditUser(userId);
        this.updateById(entity);
        if ("1".equals(entity.getAuditState())) {
            SysUser sysUser = new SysUser();
            BeanUtil.copyProperties((Object)entity, (Object)sysUser, (boolean)true);
            sysUser.setId(null);
            sysUser.setCatalog(3);
            if (entity.getKind() == 1) {
                UserRelParams userRelParams = new UserRelParams();
                if (StrUtil.isNotBlank((CharSequence)entity.getOrganization())) {
                    userRelParams.setOrganizations(Arrays.asList(entity.getOrganization().split(",")));
                }
                userRelParams.setRegions(Arrays.asList(entity.getRegion()));
                sysUser.setOtherParams(JSON.toJSONString((Object)userRelParams));
            }
            this.sysUserService.saveOrUp(sysUser, null, false);
            if (StrUtil.isNotBlank((CharSequence)roleIds)) {
                this.sysUserRoleService.updateUserRole(sysUser.getId(), Arrays.asList(roleIds.split(",")));
            }
        }
        return true;
    }
}

