/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.biz.service.sys.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.design.base.enums.UserStatus;
import com.geoway.design.base.enums.register.EnumUserType;
import com.geoway.design.base.exception.ServiceException;
import com.geoway.design.base.support.StringUtils;
import com.geoway.design.base.support.encryption.AESUtils;
import com.geoway.design.biz.dto.UserRegistDTO;
import com.geoway.design.biz.dto.UserRelParams;
import com.geoway.design.biz.entity.SysOrganization;
import com.geoway.design.biz.entity.SysRegion;
import com.geoway.design.biz.entity.SysRole;
import com.geoway.design.biz.entity.SysUser;
import com.geoway.design.biz.entity.SysUserRegion;
import com.geoway.design.biz.mapper.SysRoleMapper;
import com.geoway.design.biz.mapper.SysUserMapper;
import com.geoway.design.biz.mapper.SysUserSecurityMapper;
import com.geoway.design.biz.service.dev.IOrganizationService;
import com.geoway.design.biz.service.dev.IUserOrganizationService;
import com.geoway.design.biz.service.dev.impl.UserSysFactory;
import com.geoway.design.biz.service.login.ICaptchaService;
import com.geoway.design.biz.service.sys.IApplicationSysService;
import com.geoway.design.biz.service.sys.IFunctionSysService;
import com.geoway.design.biz.service.sys.INsMenuService;
import com.geoway.design.biz.service.sys.ISysRegionService;
import com.geoway.design.biz.service.sys.ISysRoleService;
import com.geoway.design.biz.service.sys.ISysUserRegionService;
import com.geoway.design.biz.service.sys.ISysUserRoleService;
import com.geoway.design.biz.service.sys.ISysUserService;
import com.geoway.design.biz.vo.SysOrganizationVO;
import com.geoway.design.biz.vo.SysRoleVO;
import com.geoway.design.biz.vo.SysUserVO;
import com.geoway.sso.server.session.AccessTokenManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional
public class SysUserServiceImpl
extends ServiceImpl<SysUserMapper, SysUser>
implements ISysUserService {
    @Autowired
    private SysUserMapper sysUserMapper;
    private static final String REGIST_DEFAULT_ORG_NAME = "\u65e0\u7ec4\u7ec7\u673a\u6784\u7528\u6237";
    private static final String REGIST_DEFAULT_ROLE_PARENT = "\u6ce8\u518c\u7528\u6237\u9ed8\u8ba4\u89d2\u8272";
    private static final String REGIST_DEFAULT_ROLE_NAME = "\u6ce8\u518c\u7528\u6237";
    @Autowired
    ISysUserRoleService sysUserRoleService;
    @Autowired
    IUserOrganizationService sysUserOrganizationService;
    @Autowired
    ISysUserRegionService sysUserRegionService;
    @Autowired
    private ISysRoleService sysRoleService;
    @Autowired
    private IOrganizationService sysOrganizationService;
    @Autowired
    ISysRegionService sysRegionService;
    @Autowired
    IFunctionSysService.ISysUserSecurityService sysUserSecurityService;
    @Autowired
    private INsMenuService iNsMenuService;
    @Autowired
    IApplicationSysService.ISysImageService sysImageService;
    @Autowired
    SysRoleMapper sysRoleMapper;
    @Autowired
    SysUserSecurityMapper sysUserSecurityMapper;
    @Autowired
    private ICaptchaService commonService;
    @Autowired
    private UserSysFactory userSysFactory;
    @Autowired
    private AccessTokenManager accessTokenManager;

    @Override
    public void saveOrUp(SysUser user, MultipartFile file, boolean deletePhoto) throws Exception {
        this.userSysFactory.getService().saveOrUp(user, file, deletePhoto);
    }

    @Override
    public void batchSave(List<SysUser> users) throws Exception {
        this.userSysFactory.getService().batchSave(users);
    }

    @Override
    public List<SysUser> queryList(String filterParam) throws Exception {
        return this.userSysFactory.getService().queryList(filterParam);
    }

    @Override
    public List<SysUser> queryList(String filterParam, boolean withRoleOrg) {
        return this.userSysFactory.getService().queryList(filterParam);
    }

    @Override
    public SysUser queryOne(String id) {
        return this.userSysFactory.getService().query(id);
    }

    @Override
    public List<SysUser> queryByIds(List<String> ids) {
        return this.userSysFactory.getService().query(ids);
    }

    @Override
    public IPage<SysUser> queryPage(String filterParam, int page, int size) throws Exception {
        return this.userSysFactory.getService().queryPage(filterParam, page, size);
    }

    @Override
    public void deleteOne(String id) throws Exception {
        this.userSysFactory.getService().delete(id);
    }

    @Override
    public void batchDelete(String ids) throws Exception {
        this.userSysFactory.getService().batchDelete(ids);
    }

    @Override
    public List<SysRole> queryRelRoles(String userId) {
        List<SysRole> roles = this.sysRoleService.queryUserRoles(userId);
        return roles;
    }

    @Override
    public List<SysOrganization> queryRelOrgs(String userId) {
        List<SysOrganization> orgs = this.sysOrganizationService.queryUserOrgs(userId);
        return orgs;
    }

    @Override
    public List<SysRegion> queryRelRegions(String userId) {
        List<SysRegion> regions = this.sysRegionService.queryUserRegions(userId);
        return regions;
    }

    @Override
    public void changeUserPassword(String userId, String password) {
        this.userSysFactory.getService().changePassword(userId, password);
    }

    @Override
    public String resetUserPassword(String userId) {
        return this.userSysFactory.getService().resetUserPassword(userId);
    }

    @Override
    public Boolean modifyPassword(String phoneNum, String verifyCode, String verifyCodeUid, String password) throws Exception {
        String verifyStr = this.commonService.queryCaptcha(verifyCodeUid);
        if (StrUtil.isBlank((CharSequence)verifyStr)) {
            throw new ServiceException("\u65e0\u6548\u7684\u9a8c\u8bc1\u7801");
        }
        JSONObject jsonObject = JSON.parseObject((String)verifyStr);
        if (!verifyCode.equals(jsonObject.getString("verifyCode"))) {
            throw new ServiceException("\u65e0\u6548\u7684\u9a8c\u8bc1\u7801");
        }
        List<SysUser> users = this.queryList("telEncrypt_EQ_" + AESUtils.encrypt((String)phoneNum, (String)"FWAijk4A2Dwt2MKw"));
        if (users == null || users.size() == 0) {
            throw new ServiceException("\u6b64\u624b\u673a\u53f7\u7801\u672a\u6ce8\u518c");
        }
        this.userSysFactory.getService().changePassword(users.get(0).getId(), password);
        return true;
    }

    @Override
    public SysUserVO getUserInfoByUserId(String userId) {
        SysUser sysUser = this.userSysFactory.getService().query(userId);
        if (ObjectUtil.isNull((Object)sysUser)) {
            throw new RuntimeException("\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
        }
        SysUserVO sysUserVO = new SysUserVO();
        sysUserVO.setAccount(sysUser.getAccout());
        sysUserVO.setAddress(sysUser.getAddress());
        sysUserVO.setAlisName(sysUser.getAname());
        sysUserVO.setBh(sysUser.getBh());
        sysUserVO.setId(sysUser.getId());
        sysUserVO.setName(sysUser.getName());
        sysUserVO.setTel(sysUser.getTel());
        List<SysRoleVO> roleVOS = this.sysRoleMapper.getSysRoleVO(userId);
        sysUserVO.setRoleVOList(roleVOS);
        List<SysOrganization> orgs = this.sysOrganizationService.queryUserOrgs(userId);
        ArrayList<SysOrganizationVO> orgVOS = new ArrayList<SysOrganizationVO>();
        for (SysOrganization org : orgs) {
            SysOrganizationVO orgVO = new SysOrganizationVO();
            orgVO.setId(org.getId());
            orgVO.setName(org.getName());
            orgVO.setDesc(org.getDesc());
            orgVOS.add(orgVO);
        }
        sysUserVO.setOrganizationVOList(orgVOS);
        List sysUserRegionList = this.sysUserRegionService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserRegion::getUserid, (Object)userId)).orderByAsc(SysUserRegion::getRegioncode));
        if (ObjectUtil.isNotEmpty((Object)sysUserRegionList)) {
            sysUserVO.setRegionCode(((SysUserRegion)sysUserRegionList.get(0)).getRegioncode());
        }
        if (ObjectUtil.isNotEmpty(sysUserVO.getRoleVOList())) {
            sysUserVO.setMenuTreeList(this.iNsMenuService.getSysMenuVoTree(sysUserVO.getRoleVOList().stream().map(SysRoleVO::getId).collect(Collectors.toList())));
        }
        return sysUserVO;
    }

    @Override
    public Boolean userRegistrer(UserRegistDTO userDTO) throws Exception {
        SysUser sysUser = this.userDto2SysUser(userDTO);
        this.isUserRepeat(sysUser);
        if (StrUtil.isBlank((CharSequence)sysUser.getId())) {
            this.sysUserMapper.insert(sysUser);
        } else {
            this.sysUserMapper.updateById(sysUser);
        }
        this.saveRegisterUserOrg(userDTO, sysUser);
        if (StrUtil.isNotEmpty((CharSequence)userDTO.getRegionCodes())) {
            this.sysUserRegionService.updateUserRegions(sysUser.getId(), Arrays.asList(userDTO.getRegionCodes().split(",")));
        }
        this.saveRegisterUserRole(sysUser);
        this.changeUserPassword(sysUser.getId(), "e10adc3949ba59abbe56e057f20f883e");
        return true;
    }

    private boolean isUserRepeat(SysUser user) throws Exception {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysUser::getAccout, (Object)user.getAccout());
        int iCount = this.sysUserMapper.selectCount((Wrapper)wrapper);
        if (iCount > 0) {
            throw new Exception("\u8d26\u6237:" + user.getAccout() + "  \u5df2\u5b58\u5728\uff01");
        }
        return true;
    }

    private SysUser userDto2SysUser(UserRegistDTO userDTO) {
        SysUser sysUser = new SysUser();
        BeanUtils.copyProperties((Object)userDTO, (Object)sysUser);
        sysUser.setAccout(userDTO.getAccount());
        sysUser.setName(userDTO.getAname());
        sysUser.setSource(REGIST_DEFAULT_ROLE_NAME);
        sysUser.setType((ObjectUtil.isNotNull((Object)userDTO.getType()) ? userDTO.getType() : EnumUserType.DEFAULT.value).shortValue());
        sysUser.setStatus(StrUtil.isNotEmpty((CharSequence)userDTO.getOrgIds()) ? UserStatus.DISABLE.getCode() : UserStatus.OK.getCode());
        return sysUser;
    }

    private boolean saveRegisterUserOrg(UserRegistDTO userDTO, SysUser sysUser) throws Exception {
        if (StrUtil.isNotEmpty((CharSequence)userDTO.getOrgIds())) {
            this.sysUserOrganizationService.updateUserOrg(sysUser.getId(), Arrays.asList(userDTO.getOrgIds().split(",")));
        } else {
            SysOrganization defaultOrg = this.sysOrganizationService.findOneByName(REGIST_DEFAULT_ORG_NAME, "");
            if (ObjectUtil.isNull((Object)defaultOrg)) {
                defaultOrg = new SysOrganization();
                defaultOrg.setName(REGIST_DEFAULT_ORG_NAME);
                defaultOrg.setAllname(REGIST_DEFAULT_ORG_NAME);
                defaultOrg.setDesc("\u6ce8\u518c\u65f6\u6ca1\u9009\u62e9\u673a\u6784\u7684\u7528\u6237\u4f1a\u5728\u8fd9\u4e0b\u9762\u663e\u793a");
                defaultOrg.setLevel(1);
                defaultOrg.setPid("0");
                defaultOrg.setOrder(999);
                this.sysOrganizationService.saveOrUp(defaultOrg);
            }
            this.sysUserOrganizationService.updateUserOrg(sysUser.getId(), Arrays.asList(defaultOrg.getId()));
        }
        return true;
    }

    private boolean saveRegisterUserRole(SysUser sysUser) throws Exception {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysRole::getName, (Object)REGIST_DEFAULT_ROLE_NAME);
        SysRole defaultRole = (SysRole)this.sysRoleService.getOne((Wrapper)wrapper);
        if (ObjectUtil.isNull((Object)defaultRole)) {
            SysRole parenDefault = new SysRole();
            parenDefault.setName(REGIST_DEFAULT_ROLE_PARENT);
            parenDefault.setAllname(REGIST_DEFAULT_ROLE_PARENT);
            parenDefault.setLevel(1);
            parenDefault.setType(0);
            parenDefault.setBz("\u6ce8\u518c\u7528\u6237\u9ed8\u8ba4\u89d2\u8272\uff0c\u521d\u6b21\u7528\u6237\u6ce8\u518c\u65f6\u7cfb\u7edf\u4f1a\u81ea\u52a8\u521b\u5efa");
            this.sysRoleService.saveOrUp(parenDefault);
            defaultRole = new SysRole();
            defaultRole.setName(REGIST_DEFAULT_ROLE_NAME);
            defaultRole.setAllname(parenDefault.getName() + "/" + REGIST_DEFAULT_ROLE_NAME);
            defaultRole.setLevel(2);
            defaultRole.setType(1);
            defaultRole.setPid(parenDefault.getId());
            defaultRole.setParents(parenDefault.getId());
            defaultRole.setBz("\u6ce8\u518c\u7528\u6237\u4f1a\u9ed8\u8ba4\u6302\u63a5\u5230\u6b64\u89d2\u8272\u4e0b\u9762\uff0c\u7cfb\u7edf\u4f1a\u81ea\u52a8\u521b\u5efa");
            this.sysRoleService.saveOrUp(defaultRole);
        }
        this.sysUserRoleService.updateUserRole(sysUser.getId(), Arrays.asList(defaultRole.getId()));
        return true;
    }

    @Override
    public void exportUsers(String filterParam, Boolean isTemplate, HttpServletResponse response) throws Exception {
        this.userSysFactory.getService().exportUsers(filterParam, isTemplate, response);
    }

    @Override
    public String importUsers(List<SysUser> userList, Boolean isUpdateSupport) {
        return this.userSysFactory.getService().importUsers(userList, isUpdateSupport);
    }

    @Override
    public void updateRoles(SysUser user) {
        String otherParams = user.getOtherParams();
        if (StringUtils.isNotBlank((CharSequence)otherParams)) {
            try {
                UserRelParams userParams = (UserRelParams)JSON.parseObject((String)otherParams, UserRelParams.class);
                this.sysUserRoleService.updateUserRole(user.getId(), userParams.getRoles());
            }
            catch (Exception ex) {
                throw new ServiceException("\u9519\u8bef:" + ex.getMessage());
            }
        }
    }

    @Override
    public Map<String, Object> queryCount(String filterParam) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        int all = 0;
        int online = 0;
        int offline = 0;
        all = this.userSysFactory.getService().queryCount(filterParam);
        List users = this.accessTokenManager.getOnlineUsers();
        online = users.size();
        offline = all - online;
        result.put("users", users);
        result.put("all", all);
        result.put("online", online);
        result.put("offline", offline);
        return result;
    }

    @Override
    public void changePasswordByUserId(String userId, String oldPwd, String newPwd) throws Exception {
        this.userSysFactory.getService().changePassword(userId, oldPwd, newPwd);
    }

    @Override
    public void changePasswordByAccount(String account, String oldPwd, String newPwd) throws Exception {
        SysUser sysUser = (SysUser)this.sysUserMapper.selectOne((Wrapper)Wrappers.lambdaQuery(SysUser.class).eq(SysUser::getAccout, (Object)account));
        if (sysUser == null) {
            throw new Exception("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        this.userSysFactory.getService().changePassword(sysUser.getId(), oldPwd, newPwd);
    }

    @Override
    public List<SysUser> queryRolerUsers(String roleId) {
        return null;
    }

    @Override
    public List<SysUser> queryOrgUsers(String roleId) {
        return null;
    }

    @Override
    public List<SysUser> queryAllNonOrgUsers() {
        return null;
    }

    @Override
    public void encryptPhone(String phone) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.isNull(SysUser::getTelEncrypt);
        if (StrUtil.isNotBlank((CharSequence)phone)) {
            queryWrapper.eq(SysUser::getTel, (Object)phone);
        }
        int count = this.sysUserMapper.selectCount((Wrapper)queryWrapper);
        int pages = count / 100 + 1;
        for (int i = 1; i <= pages; ++i) {
            ArrayList<SysUser> toUpdate = new ArrayList<SysUser>();
            IPage records = this.sysUserMapper.selectPage((IPage)new Page((long)i, 100L), (Wrapper)queryWrapper);
            for (SysUser user : records.getRecords()) {
                if (user.getTel().contains("****")) continue;
                try {
                    user.setTelEncrypt(AESUtils.encrypt((String)user.getTel(), (String)"FWAijk4A2Dwt2MKw"));
                    user.setTel(user.getTel().substring(0, 3) + "****" + user.getTel().substring(7, 11));
                    toUpdate.add(user);
                }
                catch (Exception ex) {
                    this.log.error(ex.getMessage(), (Throwable)ex);
                }
            }
            this.updateBatchById(toUpdate);
        }
    }

    @Override
    public void decryptPhone(String encryptPhone) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.isNotNull(SysUser::getTelEncrypt);
        if (StrUtil.isNotBlank((CharSequence)encryptPhone)) {
            queryWrapper.eq(SysUser::getTelEncrypt, (Object)encryptPhone);
        }
        int count = this.sysUserMapper.selectCount((Wrapper)queryWrapper);
        int pages = count / 100 + 1;
        for (int i = 1; i <= pages; ++i) {
            ArrayList toUpdate = new ArrayList();
            IPage records = this.sysUserMapper.selectPage((IPage)new Page((long)i, 100L), (Wrapper)queryWrapper);
            for (SysUser user : records.getRecords()) {
                if (!StrUtil.isNotBlank((CharSequence)user.getTelEncrypt())) continue;
                try {
                    String tel = AESUtils.decrypt((String)user.getTelEncrypt(), (String)"FWAijk4A2Dwt2MKw");
                    LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
                    wrapper.set(SysUser::getTelEncrypt, null);
                    wrapper.set(SysUser::getTel, (Object)tel);
                    wrapper.eq(SysUser::getId, (Object)user.getId());
                    this.update((Wrapper)wrapper);
                }
                catch (Exception ex) {
                    this.log.error(ex.getMessage(), (Throwable)ex);
                }
            }
        }
    }

    @Override
    public SysUser queryOneByTel(String tel) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysUser::getTel, (Object)tel);
        queryWrapper.last(" limit 1");
        return (SysUser)this.getOne((Wrapper)queryWrapper);
    }
}

