/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.biz.service.uis.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.geoway.design.biz.dto.uis.SimpleUserDTO;
import com.geoway.design.biz.entity.SysOrganization;
import com.geoway.design.biz.entity.SysPermission;
import com.geoway.design.biz.entity.SysRegion;
import com.geoway.design.biz.entity.SysRole;
import com.geoway.design.biz.entity.SysUser;
import com.geoway.design.biz.service.dev.IOrganizationService;
import com.geoway.design.biz.service.sys.ISysPermissionService;
import com.geoway.design.biz.service.sys.ISysRoleService;
import com.geoway.design.biz.service.sys.ISysUserService;
import com.geoway.design.biz.service.uis.IUISService;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.RpcAccessToken;
import com.geoway.sso.client.util.Oauth2Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.junit.platform.commons.util.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UISServiceImpl
implements IUISService {
    @Value(value="${sso.server.url}")
    private String serverUrl;
    @Autowired
    private ISysUserService sysUserService;
    @Autowired
    private IOrganizationService sysOrganizationService;
    @Autowired
    private ISysRoleService sysRoleService;
    @Autowired
    private ISysPermissionService sysPermissionService;

    @Override
    public List<SimpleUserDTO> getUserInfo(Map<String, String> map) {
        ArrayList<SimpleUserDTO> arrayList = new ArrayList<SimpleUserDTO>();
        SysUser sysUser = null;
        String token = map.get("token");
        String userId = map.get("userId");
        if (StringUtils.isBlank((String)token)) {
            throw new RuntimeException("\u65e0\u6548token\u6216token\u5df2\u8fc7\u671f");
        }
        if (StringUtils.isBlank((String)userId)) {
            Result userResult = Oauth2Utils.queryAccessToken((String)this.serverUrl, (String)token);
            if (userResult != null && userResult.isSuccess() && userResult.getData() != null) {
                userId = ((RpcAccessToken)userResult.getData()).getUser().getId();
            } else {
                throw new RuntimeException("\u67e5\u8be2\u7528\u6237\u5931\u8d25:" + userResult.getMessage());
            }
        }
        if (ObjectUtil.isNull((Object)(sysUser = this.sysUserService.queryOne(userId)))) {
            throw new RuntimeException("\u6b64\u7528\u6237\u4e0d\u5b58\u5728,\u6216\u5f53\u524d\u767b\u5f55token\u4e0e\u7528\u6237\u4fe1\u606f\u4e0d\u4e00\u81f4");
        }
        List<SysRole> roles = this.sysUserService.queryRelRoles(userId);
        List<SysOrganization> orgs = this.sysUserService.queryRelOrgs(userId);
        List<SysRegion> regions = this.sysUserService.queryRelRegions(userId);
        SimpleUserDTO simpleUser = new SimpleUserDTO().sysUser2simpleUser(sysUser, orgs, roles, regions);
        arrayList.add(simpleUser);
        return arrayList;
    }

    @Override
    public void modifyUserInfo(Map<String, String> map) {
        String userId = map.get("id");
        String userPwd = map.get("password");
        if (StringUtils.isBlank((String)userId) || StringUtils.isBlank((String)userPwd)) {
            throw new RuntimeException("\u7528\u6237id\u548c\u5bc6\u7801\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.sysUserService.queryOne(userId) == null) {
            throw new RuntimeException("\u6b64\u7528\u6237\u4e0d\u5b58\u5728!");
        }
        this.sysUserService.changeUserPassword(userId, userPwd);
    }

    @Override
    public List<SimpleUserDTO> getUserList(String filterParam) {
        try {
            List<SysUser> userList = this.sysUserService.queryList(filterParam, false);
            ArrayList<SimpleUserDTO> simpleUserList = new ArrayList<SimpleUserDTO>();
            for (SysUser sysUser : userList) {
                SimpleUserDTO simpleUserDTO = new SimpleUserDTO().sysUser2simpleUser(sysUser);
                simpleUserList.add(simpleUserDTO);
            }
            return simpleUserList;
        }
        catch (Exception exceptions) {
            throw new RuntimeException(exceptions);
        }
    }

    @Override
    public List<SysOrganization> getOrgTree(Map<String, String> paramMap) {
        String pid = paramMap.get("pid");
        String myFilterParam = "";
        if (StringUtils.isNotBlank((String)pid)) {
            myFilterParam = "pid_EQ_" + pid;
        }
        try {
            List<SysOrganization> organizationList = this.sysOrganizationService.queryTree(myFilterParam);
            return organizationList;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<SysOrganization> getOrgInfo(Map<String, String> paramMap) {
        String pid = paramMap.get("pid");
        String myFilterParam = "";
        if (StringUtils.isNotBlank((String)pid)) {
            myFilterParam = "pid_EQ_" + pid;
        }
        try {
            List<SysOrganization> orgList = this.sysOrganizationService.queryList(myFilterParam);
            return orgList;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<SysRole> queryRoleTree(String filterParam) {
        try {
            List<SysRole> roleTree = this.sysRoleService.queryTree(filterParam);
            return roleTree;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<SysPermission> queryRolePermissions(Map<String, String> paramMap) {
        try {
            List<SysPermission> permissions = this.sysPermissionService.queryRolePermissons(paramMap.get("roleIds"));
            return permissions;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<SysRole> queryRoleList(String filterParam) {
        try {
            if (StrUtil.isEmpty((CharSequence)filterParam)) {
                filterParam = "";
            }
            filterParam = filterParam + ";type_EQ_1";
            List<SysRole> roles = this.sysRoleService.queryList(filterParam);
            return roles;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<SysUser> queryRoleUsers(String roleId) {
        try {
            List<SysUser> users = this.sysRoleService.queryRelUsers(roleId);
            return users;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

