/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.biz.util;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.geoway.design.base.support.encryption.AESUtils;
import com.geoway.design.base.support.spring.SpringUtils;
import com.geoway.design.biz.entity.SysRegion;
import com.geoway.design.biz.entity.SysUser;
import com.geoway.design.biz.service.dev.impl.LocalUserServiceImpl;
import com.geoway.sso.client.rpc.RpcAccessToken;
import com.geoway.sso.client.rpc.SsoUser;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class GuestUtil {
    public static String getGuestToken() {
        String token = "Geoway";
        try {
            String formattedDate = DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd");
            String encryptedPart = AESUtils.encrypt((String)formattedDate, (String)"FWAijk4A2Dwt2MKw");
            token = token + encryptedPart;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return token;
    }

    public static boolean validateGuestToken(String token) {
        if (StrUtil.isBlank((CharSequence)token)) {
            return false;
        }
        String tokenPrefix = "Geoway";
        if (!token.startsWith(tokenPrefix)) {
            return false;
        }
        String encryptedPart = token.substring(tokenPrefix.length());
        try {
            String decryptedStr = AESUtils.decrypt((String)encryptedPart, (String)"FWAijk4A2Dwt2MKw");
            String formattedDate = DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd");
            return formattedDate.equalsIgnoreCase(decryptedStr);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static RpcAccessToken getGuestRpcAccessToken(String token) {
        LocalUserServiceImpl localUserService = (LocalUserServiceImpl)SpringUtils.getBean(LocalUserServiceImpl.class);
        SysUser sysUser = localUserService.query("guest");
        List<SysRegion> regions = sysUser.getRegions();
        String regionCode = regions.stream().map(i -> i.getCode()).collect(Collectors.joining(","));
        String regionName = regions.stream().map(i -> i.getName()).collect(Collectors.joining(","));
        SsoUser ssoUser = new SsoUser();
        ssoUser.setId(sysUser.getId());
        ssoUser.setUserid(sysUser.getId());
        ssoUser.setUserName(sysUser.getAname());
        ssoUser.setLoginName(sysUser.getName());
        ssoUser.setRegionCode(regionCode);
        ssoUser.setRegionName(regionName);
        ssoUser.setUserCatalog(sysUser.getCatalog());
        ssoUser.setSource(sysUser.getSource());
        ssoUser.setToken(token);
        ssoUser.setUserCatalog(Integer.valueOf(3));
        RpcAccessToken rpcAccessToken = new RpcAccessToken(ssoUser.getToken(), 60, ssoUser.getToken(), ssoUser);
        return rpcAccessToken;
    }
}

