-- sys_tenant definition

-- Drop table

-- DROP TABLE sys_bizmanage;

CREATE TABLE if not  EXISTS sys_bizmanage (
	f_id varchar(50) NOT NULL,
	f_userid varchar(50) NULL, -- 业务管理员的用户id
	f_createtime timestamp NULL, -- 创建时间
	CONSTRAINT pk_sys_bizmanage PRIMARY KEY (f_id)
);
COMMENT ON TABLE sys_bizmanage IS '业务管理员表';

-- Column comments

COMMENT ON COLUMN sys_bizmanage.f_id IS '主键';
COMMENT ON COLUMN sys_bizmanage.f_userid IS '业务管理员的用户id';
COMMENT ON COLUMN sys_bizmanage.f_createtime IS '创建时间';


CREATE TABLE if not  EXISTS sys_bizmanage_organization (
	f_id varchar(50) NOT NULL,
	f_bizmanageid varchar(50) NULL, -- 业务管理员id
	f_orgid varchar(255)  NULL, -- 组织机构id
	CONSTRAINT pk_sys_bizmanage_organization PRIMARY KEY (f_id)
);
COMMENT ON TABLE sys_bizmanage_organization IS '业务管理员表的组织机构表';

-- Column comments

COMMENT ON COLUMN sys_bizmanage_organization.f_id IS '主键';
COMMENT ON COLUMN sys_bizmanage_organization.f_bizmanageid IS '业务管理员id';
COMMENT ON COLUMN sys_bizmanage_organization.f_orgid IS '组织机构id';


CREATE TABLE if not  EXISTS sys_bizmanage_region (
	f_id varchar(50) NOT NULL,
	f_bizmanageid varchar(50) NULL, -- 业务管理员id
	f_regionid varchar(255)  NULL, -- 行政区划id
	CONSTRAINT pk_sys_bizmanage_region PRIMARY KEY (f_id)
);
COMMENT ON TABLE sys_bizmanage_region IS '业务管理员表的组织机构表';

-- Column comments

COMMENT ON COLUMN sys_bizmanage_region.f_id IS '主键';
COMMENT ON COLUMN sys_bizmanage_region.f_bizmanageid IS '业务管理员id';
COMMENT ON COLUMN sys_bizmanage_region.f_regionid IS '行政区划id';


CREATE TABLE if not  EXISTS sys_bizmanage_role (
	f_id varchar(50) NOT NULL,
	f_bizmanageid varchar(50) NULL, -- 业务管理员id
	f_roleid varchar(255)  NULL, -- 角色id
	CONSTRAINT pk_sys_bizmanage_role PRIMARY KEY (f_id)
);
COMMENT ON TABLE sys_bizmanage_role IS '业务管理员表的组织机构表';

-- Column comments

COMMENT ON COLUMN sys_bizmanage_role.f_id IS '主键';
COMMENT ON COLUMN sys_bizmanage_role.f_bizmanageid IS '业务管理员id';
COMMENT ON COLUMN sys_bizmanage_role.f_roleid IS '角色id';