/**
 * jQuery Validate 2.0
 * 
 * Author Joe
 */
var smart = smart ? smart : {};
(function(sm, $) {
	sm.validate = {
		// 外部可选传递参数
		options  : {
			/**
			 * form参数：     
			 * <form 
			 * 		需要验证Form,默认false
			 * 		validate="true"
			 * 
			 * 		是否显示验证消息
			 * 		vmessage="true"
			 * 
			 *      必填项是否加*,默认false
			 * 		vstar="true"
			 * 
			 * 		存在验证消息时，定位到元素位置,默认false
			 * 		vanimate="true"/>
			 * 
			 * 
			 * input参数:     
			 * <input 
			 * 		必填
			 * 		required="true"
			 * 
			 * 		最小数值
			 * 		min="1"
			 * 
			 * 		最大数值
			 * 		max="100"
			 * 
			 * 		最小长度
			 * 		minlength="1"
			 * 
			 * 		最大长度
			 * 		maxlength="100"
			 * 
			 * 		类型(可选)：email, integer, double, english, chinese, phone, mobile, qq, postcode, idcard
			 * 		支持"|"和"+"操作(可选)：mobile|phone, integer&english
			 * 		vtype="mobile"
			 * 
			 * 		属性名称
			 * 		vmessage="用户名"
			 * 
			 * 		强制错误信息
			 * 		verrorMessage="必须输入正确的手机号码或电话号码"
			 * 
			 * 		强制必填信息
			 * 		vnullMessage="请填写信息"
			 * 
			 * 		与id="_password"比较，当内容不一致显示"两次输入的密码不一致"
			 * 		equalsTo="_password:两次输入的密码不一致"/>
			 * 
			 *      ajax请求验证
			 *      dataId为html标签ID，支持form和element两种ID
			 *      ajax="{url : '${_path}/admin/user!validateAccount.shtml', dataId : '_editForm'}"
			 * */

			// 显示消息
			messages : {
				required 	: "required",
				select	 	: "selected",
				blank		: "not blank",
				maxlength 	: "Please enter no more than {0} characters",
				minlength 	: "Please enter at least {0} characters",
				bothlength 	: "Please enter a value between {0} and {1} characters long",
				equallength : "length {0} characters",
				max 	    : "Please enter a value less than or equal to {0}",
				min     	: "Please enter a value greater than or equal to {0}",
				bothvalue   : "Please enter a value between {0} and {1}",
				equalvalue  : "value equal to {0}",
				email 		: "Please enter a valid email address",
				integer 	: "Please enter a valid integer",
				double 		: "Please enter a valid double",
				english 	: "Please enter a valid english",
				chinese 	: "Please enter a valid chinese",
				phone 		: "Please enter a valid phone",
				mobile 		: "Please enter a valid mobile",
				qq 			: "Please enter a valid qq",
				postcode 	: "Please enter a valid postcode",
				idcard 	    : "Please enter a valid idcard"
			},
			vstarHtml : "<span style='color : red; float : left;'>*</span>"
		},
		// 内部使用
		settings : {
			// 是否显示验证消息
			vmessage : true,
			// 必填项是否加*,默认false
			vstar : false,
			// 有验证消息，定位到元素位置
			vanimate : false,
			// 临时变量
			vtemp : null,
			// 验证后第一条不通过对象
			vobject : null,
			// 验证后第一条不通过对象的消息内容
			vmessageContent : null
		},
		reg : function(val, reg, required, message) {
			if (!reg.test(val)) {
				sm.validate.settings.vtemp = message;
				return false;
			}
			return true;
		},
		compare : function(type, firstStr, secondStr, errorMessage) {
			var bool = true;
			if (secondStr && ('text' == type || 'password' == type || 'textarea' == type)) {
				if (Number(firstStr) < Number(secondStr)) {
					sm.validate.settings.vtemp = errorMessage;
					bool = false;
				} 
			}
			return bool;
		},
		orRule : function($o, val, vtypes, required){
			var bool = true;
			for(var i = 0,len = vtypes.length; i < len; i++){
				if(sm.validate.rule($o, val, $.trim(vtypes[i]), required)){
					bool = true;
					break;
				}
				else{
					bool = false;
				}
			}
			return bool;
		},
		specialRule : function(type, val, min, max, required) {
			var bool = true;
			
			var msg = null;
			if(min && max){
				if(min == max){
					msg = sm.validate.options.messages.equalvalue.replace("{0}", min);
				}
				else{
					msg = sm.validate.options.messages.bothvalue.replace("{0}", min).replace("{1}", max);
				}
			}
			
			if(!sm.validate.compare(type, val, min, msg ? msg : sm.validate.options.messages.min.replace("{0}", min))
					|| !sm.validate.compare(type, max, val, msg ? msg : sm.validate.options.messages.max.replace("{0}", max))){
				bool = false;
			}
			return bool;
		},
		rule : function($o, val, vtype, required) {
			switch (vtype.toLowerCase()) {
				case 'email':
					return sm.validate.reg(val, /^\w{3,}@\w+(\.\w+)+$/, required, sm.validate.options.messages.email);
					break;
				case 'integer':
					if(sm.validate.reg(val, /^[-\+]?\d+$/, required, sm.validate.options.messages.integer)){
						return sm.validate.specialRule($o.attr('type'), val, $o.attr('min'), $o.attr('max'), required);
					}
					return false;
					break;
				case 'double':
					if(sm.validate.reg(val, /^[-\+]?\d+(\.\d+)?$/, required, sm.validate.options.messages.double)){
						return sm.validate.specialRule($o.attr('type'), val, $o.attr('min'), $o.attr('max'), required);
					}
					return false;
					break;
				case 'english':
					return sm.validate.reg(val, /^(([a-z]+\s*)|(\s+[a-z]+))[a-z\s]*$/i, required, sm.validate.options.messages.english);
					break;
				case 'chinese':
					return sm.validate.reg(val, /^[\u0391-\uFFE5]+$/, required, sm.validate.options.messages.chinese);
					break;
				case 'phone':
					return sm.validate.reg(val, /^((\(\d{3}\))|(\d{3}\-))?(\(0\d{2,3}\)|0\d{2,3}-)?[1-9]\d{6,7}$/, required, sm.validate.options.messages.phone);
					break;
				case 'mobile':
					return sm.validate.reg(val, /^((\(\d{3}\))|(\d{3}\-))?1[34578]\d{9}$/, required, sm.validate.options.messages.mobile);
					break;
				case 'qq':
					return sm.validate.reg(val, /^[1-9]\d{4,9}$/, required, sm.validate.options.messages.qq);
					break;
				case 'postcode':
					return sm.validate.reg(val, /^[1-9]\d{5}$/, required, sm.validate.options.messages.postcode);
					break;
				case 'idcard':
					return sm.validate.reg(val, /(^\d{15}$)|(^\d{18}$)|(^\d{17}(\d|X|x)$)/, required, sm.validate.options.messages.idcard);
					break;
				default:
					return false;
			}
		},
		vblur : function($o) {
			$o.blur(function() {
				sm.validate.detailValidate($o);
			});
		},
		initParam: function($form){
			var vmessage = $form.attr('vmessage');
			if(vmessage && vmessage == 'false'){
				sm.validate.settings.vmessage = false;
			}
			
			var vstar = $form.attr('vstar');
			if(vstar && vstar == 'true'){
				sm.validate.settings.vstar = true;
			}
			
			var vanimate = $form.attr('vanimate');
			if(vanimate && vanimate == 'true'){
				sm.validate.settings.vanimate = true;
			}
		},
		init : function() {
			$("form").each(function(i, o) {
				if(!$(this).attr('validate'))
					return; // 实现continue功能
				
				// 初始化form验证参数
				sm.validate.initParam($(this));
				
				var els = o.elements;
				var $o, required;
				for ( var i = 0; i < els.length; i++) {
					$o = $(els[i]);
					
					if ($o.focus) {
						sm.validate.vblur($o);
					}
				}
				
				if(sm.validate.settings.vstar){
					for ( var i = 0; i < els.length; i++) {
						$o = $(els[i]);
						
						if ($o.attr('required')) {
							$o.parent().append(sm.validate.options.vstarHtml);
						}
					}
				}
			});
		},
		error : function($o, errorMessage) {
			// 赋值验证对象
			sm.validate.settings.vobject = $o;
			
			if(sm.validate.settings.vmessage){
				// 强制为空消息
				var vnullMessage = $o.attr('vnullMessage');
				if(vnullMessage == undefined || vnullMessage == null){
					if('checkbox' == $o.attr('type') || $o.is('select')){
						vnullMessage = sm.validate.options.messages.select;
					}
					else{
						vnullMessage = sm.validate.options.messages.required;
					}
				}
				
				// 强制错误消息
				if(errorMessage != null && errorMessage != undefined){
					var verrorMessage = $o.attr('verrorMessage');
					if(verrorMessage != null && verrorMessage != undefined){
						errorMessage = verrorMessage;
					}
				}
				
				// 填充验证消息
				sm.validate.settings.vmessageContent =  errorMessage ? errorMessage : vnullMessage;
				var vmessage = $o.attr('vmessage');
				if(vmessage != null && vmessage != undefined){
					sm.validate.settings.vmessageContent = vmessage + "(" + sm.validate.settings.vmessageContent + ")";
				}
			}
			
			sm.validate.highlight($o, sm.validate.settings.vmessageContent);
		},
		detailValidate : function($o) {
			var _type = $o.attr('type');
			if(!('text' == _type || 'hidden' == _type || 'password' == _type || 'textarea' == _type || 'checkbox' == _type || $o.is('select')))
				return true;
			var required = $o.attr('required');
			sm.validate.unhighlight($o);
			
			//如果没有值或者值为空
			if(!$o.val() || $o.val().length <= 0){
				if(required){
					sm.validate.error($o);
					return false;
				}
				else{
					return true;
				}
			}
			
			var bool = true;
			
			// 如果是复选框
			if(bool && 'checkbox' == $o.attr('type')){
				if(required){
					if($("input:checkbox[name="+$o.attr('name')+"]:checked").length <= 0){
						sm.validate.error($o);
						bool = false;
					}
					else{
						sm.validate.unhighlight($o);
						bool = true;
					}
				}
				return bool;
			}
			
			var minlen = $o.attr('minlength');
			var maxlen = $o.attr('maxlength');
			var msg = null;
			if(bool && minlen && maxlen){
				if(minlen == maxlen){
					msg = sm.validate.options.messages.equallength.replace("{0}", minlen);
				}
				else{
					msg = sm.validate.options.messages.bothlength.replace("{0}", minlen).replace("{1}", maxlen);
				}
			}
			
			if(bool && (!sm.validate.compare($o.attr('type'), maxlen, $o.val().length, msg ? msg : sm.validate.options.messages.maxlength.replace("{0}", maxlen))
					|| !sm.validate.compare($o.attr('type'), $o.val().length, minlen, msg ? msg : sm.validate.options.messages.minlength.replace("{0}", minlen)))){
				sm.validate.error($o, sm.validate.settings.vtemp);
				bool = false;
			}

			var vtype = $o.attr('vtype');
			if (bool && vtype) {
				var vtypes = vtype.split("|");
				var vtypess = vtype.split("&");
				if (vtypes.length > 1) {
					bool = sm.validate.orRule($o, $o.val(), vtypes, required);
				} 
				else if (vtypess.length > 1) {
					// 存在空格
					if(!/^[\S]*$/.test($o.val())){
						sm.validate.settings.vtemp = sm.validate.options.messages.blank;
						bool = false;
					}
					else{
						var vtype, vals, con;
						for ( var i = 0, length = vtypess.length; i < length; i++) {
							vtype = $.trim(vtypess[i]);
							vals = $o.val().match(/./g);
							con = false;
							for ( var j = 0, len = vals.length; j < len; j++) {
								if (sm.validate.rule($o, vals[j], vtype, required)) {
									con = true;
									break;
								}
							}
							if (!con) {
								bool = false;
								break;
							}
						}
					}
				} 
				else {
					bool = sm.validate.rule($o, $o.val(), vtype, required);
				}

				if (bool) {
					sm.validate.unhighlight($o);
				} 
				else {
					sm.validate.error($o, sm.validate.settings.vtemp);
				}
			}
			
			var equalsTo = $o.attr('equalsTo');
			if(bool && equalsTo){
				var vs = equalsTo.split(":");
				if(vs.length == 2){
					if(!vs[0] || $o.val() != $("#" + vs[0]).val()){
						sm.validate.error($o, vs[1]);
						bool = false;
					}
				}
			}
			
			var ajax = $o.attr('ajax');
			if(bool && ajax){
				var json = eval("(" + ajax + ")");
				var ajaxData = null;
				if(json.dataId){
					var $obj = $("#" + json.dataId);
					if($obj.is('form')){
						ajaxData = $.formJson($obj);
					}
					else{
						ajaxData = eval("({'" + $obj.attr("name") + "':'" + $obj.val() + "'})");
					}
				}
				
				$.ajax({ 
					type : json.type ? json.type : "post", 
		            url : json.url,
		            async : false,
		            cache : false,
		            data : ajaxData,
		            dataType : "json",
		          	success : function(d){
	          			if(d){
	          				if(d.code == 1){
			          			sm.validate.unhighlight($o);
			          		}
			          		else{
			          			bool = false;
								sm.validate.highlight($o, d.message);
			          		}
						}
		          	}
			    });
			}
			return bool;
		},
		destory: function(){
			if(sm.validate.settings.vanimate && sm.validate.settings.vobject){
				$('html,body').animate({scrollTop : sm.validate.settings.vobject.offset().top}, 800);
				if (sm.validate.settings.vobject.focus){
					sm.validate.settings.vobject.focus();
				}
			}
			if(sm.validate.settings.vobject){
				sm.validate.settings.vobject = null;
			}
		},
		validate : function(c) {
			var els = c.obj[0].elements;
			var bool = true;
			for ( var i = els.length - 1; i >= 0; i--) {
				var $o = $(els[i]);
				try {
					$o.val($.trim($o[0].value));
				} catch (e) {
				}
				if (!sm.validate.detailValidate($o)) {
					bool = false;
				}
			}
			// 销毁还原form验证参数
			sm.validate.destory();
			return bool;
		},
		highlight : function($o, message) {
			if(message != undefined && message != null){
				alert(message);
			}
		},
		unhighlight : function($o) {
		}
	};
})(smart, jQuery);

(function($) {
	// form验证函数
	$.validate = function(c) {
		if(!c.obj){
			c = $.extend({}, {}, {obj : c});
		}
		
		if(c.obj.is('form')){
			return smart.validate.validate(c);
		}
		else{
			return smart.validate.detailValidate(c.obj);
		}
	};
	
	$.fn.validate = function(c) {
		c = $.extend({}, c, {obj : $(this)});
		return $.validate(c);
	};
})(jQuery);

jQuery(function($) {
	smart.validate.init();
});