/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.api.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.geoway.jckj.base.base.dto.ResponseDataBase;
import com.geoway.jckj.base.exception.ServiceException;
import com.geoway.jckj.base.support.ExcelUtil;
import com.geoway.jckj.base.support.StringUtils;
import com.geoway.jckj.base.support.encryption.AESUtils;
import com.geoway.jckj.biz.config.UserSystemConfig;
import com.geoway.jckj.biz.dto.UserOnlineStatDTO;
import com.geoway.jckj.biz.dto.UserRelParams;
import com.geoway.jckj.biz.entity.SysUser;
import com.geoway.jckj.biz.service.dev.unity.IUnityOrganizationService;
import com.geoway.jckj.biz.service.dev.unity.IUnityUserService;
import com.geoway.jckj.biz.service.dev.unity.IUnityUserTelService;
import com.geoway.jckj.biz.service.sys.SysRegionService;
import com.geoway.jckj.biz.service.sys.SysRoleService;
import com.geoway.jckj.biz.service.sys.SysUserOnlineService;
import com.geoway.jckj.biz.service.sys.SysUserRoleService;
import com.geoway.sso.client.annotation.OpLog;
import com.geoway.sso.client.annotation.RequireAuth;
import com.geoway.sso.client.enums.OpTypeEnum;
import com.geoway.sso.client.enums.RoleLevelEnum;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.client.util.CommonLoginUserUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u7528\u6237\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/user"})
@RequireAuth(roleLevel=RoleLevelEnum.bizAdmin)
public class SysUserController {
    private static final Logger log = LoggerFactory.getLogger(SysUserController.class);
    @Autowired
    private IUnityUserService sysUserService;
    @Autowired
    SysUserRoleService sysUserRoleService;
    @Autowired
    SysRegionService sysRegionService;
    @Autowired
    private SysRoleService sysRoleService;
    @Autowired
    private IUnityOrganizationService sysOrganizationService;
    @Autowired
    private SysUserOnlineService sysUserOnlineService;
    @Autowired
    private IUnityUserTelService sysUserTelService;
    @Autowired
    private UserSystemConfig userSystemConfig;

    @ApiOperation(value="\u6839\u636e\u624b\u673a\u53f7\u67e5\u8be2\u7528\u6237")
    @RequestMapping(value={"/queryByTel"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryByTel(@RequestParam String tel) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        responseDataBase.put((Object)"data", (Object)this.sysUserTelService.query(tel));
        return responseDataBase;
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u4f53\u7cfb")
    @RequireAuth(roleLevel=RoleLevelEnum.None)
    @RequestMapping(value={"/getUserSystems"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase getUserSystems() throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        responseDataBase.put((Object)"data", (Object)this.userSystemConfig.getUserSystem());
        return responseDataBase;
    }

    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u4fe1\u606f")
    @RequestMapping(value={"/queryUserInfo"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @RequireAuth(roleLevel=RoleLevelEnum.guest)
    public ResponseDataBase queryUserInfo() throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        String userId = CommonLoginUserUtil.getUserId();
        responseDataBase.put((Object)"data", (Object)this.sysUserService.query(userId));
        return responseDataBase;
    }

    @ApiOperation(value="\u4fee\u6539\u7528\u6237\u5bc6\u7801")
    @OpLog(name="\u4fee\u6539\u7528\u6237\u5bc6\u7801", opType=OpTypeEnum.update)
    @RequestMapping(value={"/setPassword"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase setPassword(@RequestParam(value="userId", required=true) String userId, @RequestParam(value="password", required=true) String password) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        this.sysUserService.changePassword(userId, password);
        return responseDataBase;
    }

    @ApiOperation(value="\u91cd\u7f6e\u7528\u6237\u5bc6\u7801")
    @OpLog(name="\u91cd\u7f6e\u7528\u6237\u5bc6\u7801", opType=OpTypeEnum.update)
    @RequestMapping(value={"/resetPassword"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase resetPassword(@RequestParam(value="userId", required=true) String userId) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        responseDataBase.put((Object)"data", (Object)this.sysUserService.resetPassword(userId));
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u7528\u6237\u771f\u5b9e\u624b\u673a\u53f7")
    @RequestMapping(value={"/getCurUserRealTel"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase getCurUserRealTel() throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        String userId = CommonLoginUserUtil.getUserId();
        SysUser user = this.sysUserService.query(userId);
        String reaTel = user.getTelEncrypt() == null ? null : AESUtils.decrypt((String)user.getTelEncrypt(), (String)"FWAijk4A2Dwt2MKw");
        responseDataBase.put((Object)"data", (Object)reaTel);
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u8be2\u771f\u5b9e\u624b\u673a\u53f7")
    @RequestMapping(value={"/getRealTel"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase getRealTel(String userId, String userSys) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        SysUser user = this.sysUserService.query(userId);
        String reaTel = user.getTelEncrypt() == null ? null : AESUtils.decrypt((String)user.getTelEncrypt(), (String)"FWAijk4A2Dwt2MKw");
        responseDataBase.put((Object)"data", (Object)reaTel);
        return responseDataBase;
    }

    @RequireAuth(roleLevel=RoleLevelEnum.None)
    @ApiOperation(value="\u9a8c\u8bc1\u662f\u5426\u9700\u8981\u91cd\u7f6e\u5bc6\u7801")
    @RequestMapping(value={"/validSecure"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ResponseDataBase validSecure(HttpServletRequest request) {
        ResponseDataBase responseData = new ResponseDataBase();
        SsoUser ssoUser = CommonLoginUserUtil.getUser();
        boolean isNeedReset = this.sysUserService.checkIsResetPassword(ssoUser.getUserid());
        if (isNeedReset) {
            responseData = ResponseDataBase.resetPassword((String)"\u9700\u8981\u91cd\u7f6e\u5bc6\u7801");
        }
        return responseData;
    }

    @ApiOperation(value="\u4fee\u6539\u7528\u6237\u5bc6\u7801")
    @OpLog(name="\u4fee\u6539\u7528\u6237\u5bc6\u7801", opType=OpTypeEnum.update)
    @RequestMapping(value={"/modifyPassword"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase modifyPassword(@RequestParam String phoneNum, @RequestParam String verifyCode, @RequestParam String verifyCodeUid, @RequestParam String password, String userSys) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        this.sysUserService.changePassword(phoneNum, verifyCode, verifyCodeUid, password);
        return responseDataBase;
    }

    @ApiOperation(value="\u4fee\u6539\u7528\u6237\u57fa\u672c\u4fe1\u606f")
    @OpLog(name="\u4fee\u6539\u7528\u6237\u57fa\u672c\u4fe1\u606f", opType=OpTypeEnum.update)
    @RequestMapping(value={"/update"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @RequireAuth(roleLevel=RoleLevelEnum.commonUser)
    public ResponseDataBase update(SysUser user) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        user.setId(CommonLoginUserUtil.getUserId());
        user.setOtherParams("");
        this.sysUserService.saveOrUp(user, null, false);
        return responseDataBase;
    }

    @ApiOperation(value="\u65b0\u589e\u6216\u4fee\u6539")
    @OpLog(name="\u65b0\u589e\u6216\u4fee\u6539\u7528\u6237", opType=OpTypeEnum.update)
    @RequestMapping(value={"/save"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase saveOrUp(SysUser user, @RequestParam(value="deletePhoto", required=false) Integer deletePhoto, @RequestParam(value="file", required=false) MultipartFile file) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        boolean isDeletePhoto = deletePhoto == 1;
        this.sysUserService.saveOrUp(user, file, isDeletePhoto);
        return responseDataBase;
    }

    @ApiOperation(value="\u6279\u91cf\u4fee\u6539\u7528\u6237")
    @OpLog(name="\u6279\u91cf\u4fee\u6539\u7528\u6237", opType=OpTypeEnum.update)
    @RequestMapping(value={"/batchSave"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase batchSave(String usersJson) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        List users = JSONArray.parseArray((String)usersJson, SysUser.class);
        this.sysUserService.batchSave(users);
        return responseDataBase;
    }

    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryList(String filterParam, String userSys) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        List users = this.sysUserService.queryList(filterParam);
        responseDataBase.put((Object)"data", (Object)users);
        return responseDataBase;
    }

    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryPage"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryPage(@RequestParam(value="filterParam", required=false) String filterParam, @RequestParam(value="page", required=true) Integer page, @RequestParam(value="size", required=true) Integer size) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        IPage pages = this.sysUserService.queryPage(filterParam, page.intValue(), size.intValue());
        responseDataBase.put((Object)"data", (Object)pages);
        return responseDataBase;
    }

    @ApiOperation(value="\u6839\u636eID\u67e5\u8be2\u7528\u6237\u4fe1\u606f")
    @RequestMapping(value={"/findOne"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase findOne(@RequestParam(value="id", required=true) String id) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        SysUser user = this.sysUserService.query(id);
        responseDataBase.put((Object)"data", (Object)user);
        return responseDataBase;
    }

    @ApiOperation(value="\u6839\u636eID\u5220\u9664\u4e00\u6761\u7528\u6237\u8bb0\u5f55")
    @OpLog(name="\u5220\u9664\u7528\u6237", opType=OpTypeEnum.del)
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase delete(String id) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        this.sysUserService.delete(id);
        return responseDataBase;
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u7528\u6237")
    @OpLog(name="\u6279\u91cf\u5220\u9664\u7528\u6237", opType=OpTypeEnum.del)
    @RequestMapping(value={"/batchDelete"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase batchDelete(@RequestParam(value="ids", required=true) String ids) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        this.sysUserService.batchDelete(ids);
        return responseDataBase;
    }

    @ApiOperation(value="\u7528\u6237\u5173\u8054\u7684\u89d2\u8272")
    @RequestMapping(value={"/roles"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @RequireAuth(roleLevel=RoleLevelEnum.commonUser)
    public ResponseDataBase queryRelRoles(@RequestParam(value="id", required=true) String id) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        List roles = this.sysRoleService.queryUserRoles(id);
        responseDataBase.put((Object)"data", (Object)roles);
        return responseDataBase;
    }

    @ApiOperation(value="\u7528\u6237\u5173\u8054\u7ec4\u7ec7\u673a\u6784")
    @RequestMapping(value={"/orgs"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryRelOrgs(@RequestParam(value="id", required=true) String id) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        List orgs = this.sysOrganizationService.queryUserOrgs(id);
        responseDataBase.put((Object)"data", (Object)orgs);
        return responseDataBase;
    }

    @ApiOperation(value="\u7528\u6237\u5173\u8054\u8f96\u533a")
    @RequestMapping(value={"/regions"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryRelRegions(@RequestParam(value="id", required=true) String id) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        List regions = this.sysRegionService.queryUserRegions(id);
        responseDataBase.put((Object)"data", (Object)regions);
        return responseDataBase;
    }

    @ApiOperation(value="Excel \u7528\u6237\u6279\u91cf\u5bfc\u5165", notes="\u9700\u8981\u4e0a\u4f20\u7528\u6237\u4fe1\u606f\u6a21\u677f\u7684Excel\u6570\u636e")
    @OpLog(name="\u7528\u6237\u6279\u91cf\u5bfc\u5165", opType=OpTypeEnum.update)
    @ApiImplicitParams(value={@ApiImplicitParam(name="file", value="Excel\u6587\u4ef6", dataType="File"), @ApiImplicitParam(name="updateSupport", value="\u662f\u5426\u8986\u76d6\u66f4\u65b0", dataType="Boolean", defaultValue="false")})
    @PostMapping(value={"/import"})
    public ResponseDataBase importExcel(MultipartFile file, boolean updateSupport, String orgId) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        List excelUserList = ExcelUtil.importExcel((MultipartFile)file, (Integer)0, (Integer)1, SysUser.class);
        String message = this.sysUserService.importUsers(excelUserList, Boolean.valueOf(updateSupport), orgId);
        responseDataBase.put((Object)"data", (Object)message);
        return responseDataBase;
    }

    @ApiOperation(value="Excel \u7528\u6237\u6279\u91cf\u5bfc\u51fa")
    @OpLog(name="Excel \u7528\u6237\u6279\u91cf\u5bfc\u51fa", opType=OpTypeEnum.update)
    @GetMapping(value={"/export"})
    public void exportExcel(@RequestParam(value="filterParam", required=false) String filterParam, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.sysUserService.exportUsers(filterParam, Boolean.valueOf(false), response);
    }

    @ApiOperation(value="Excel \u5bfc\u51fa\u7528\u6237Excel\u6a21\u677f")
    @GetMapping(value={"/exportTemplate"})
    public void exportTemplate(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.sysUserService.exportUsers("", Boolean.valueOf(true), response);
    }

    @ApiOperation(value="\u6743\u9650\u4e0e\u6743\u9650\u7ec4\u4fee\u6539")
    @RequestMapping(value={"/upRoles"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase upRoles(SysUser user) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        String otherParams = user.getOtherParams();
        if (StringUtils.isNotBlank((CharSequence)otherParams)) {
            try {
                UserRelParams userParams = (UserRelParams)JSON.parseObject((String)otherParams, UserRelParams.class);
                this.sysUserRoleService.updateUserRole(user.getId(), userParams.getRoles());
            }
            catch (Exception ex) {
                throw new ServiceException("\u9519\u8bef:" + ex.getMessage());
            }
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u7528\u6236\u6570\u91cf")
    @RequestMapping(value={"/queryCount"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @RequireAuth(roleLevel=RoleLevelEnum.guest)
    public ResponseDataBase queryCount(String filterParam) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        UserOnlineStatDTO map = this.sysUserOnlineService.getStatInfo();
        responseDataBase.put((Object)"data", (Object)map);
        return responseDataBase;
    }

    @RequireAuth(roleLevel=RoleLevelEnum.commonUser)
    @ApiOperation(value="\u4fee\u6539\u7528\u6237\u5bc6\u7801")
    @RequestMapping(value={"/changePwd"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase changePwd(HttpServletRequest request, @RequestParam(value="oldPwd") String oldPwd, @RequestParam(value="newPwd") String newPwd) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        String userId = CommonLoginUserUtil.getUserId();
        this.sysUserService.changePassword(userId, oldPwd, newPwd);
        return responseDataBase;
    }

    @ApiOperation(value="\u5e93\u8868\u7ef4\u62a4-\u52a0\u5bc6\u624b\u673a\u53f7")
    @RequestMapping(value={"/encryptPhone"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase encryptPhone(HttpServletRequest request, String phone) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        this.sysUserTelService.encrypt(phone);
        return responseDataBase;
    }

    @ApiOperation(value="\u5e93\u8868\u7ef4\u62a4-\u89e3\u5bc6\u624b\u673a\u53f7")
    @RequestMapping(value={"/decryptPhone"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase decryptPhone(HttpServletRequest request, String encryptPhone) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        this.sysUserTelService.decrypt(encryptPhone);
        return responseDataBase;
    }
}

