/**
 * jQuery Table 1.0
 * 
 * Author Joe
 */
var smart = smart ? smart : {};
(function(sm, $) {
	sm.table = {
		// 外部可选传递参数
		options  : {
			checkbox : {hide : false},
			index : {hide : true, title : "序号", align: 'center'},
			
			url : '',
			formId : null,
			// 搜索过滤json参数
			data : {},
			tools : [],
			columns : [],
			operate : [],
			pagination : {hide : false, pageSize : 20, pageSizes : [10, 20, 50, 100]},
			after : function(){}
		},
		// 内部使用
		settings : {
			// 当前表格对象
			obj : {},
			
			// ajax请求获取后台数据
			firstResult : 0,
			list : [],
			offsetSize : 0,
			pageCount : 0,
			pageNo : 1,
			rowCount : 0,
			pageSize : 20
		},
		toolsHandler: function(){
			// 默认
			var def = {text : '', clazz : '', icon : '', show : function(d){ return true; },handler : function(d){}};
			$(sm.table.options.tools).each(function(i,d) {
				d = $.extend({}, def, d);
				var $t = $("#_tr"+ i);
				if(d.show()){
					$t.click(function(){ d.handler(); });
				}
				else{
					$t.hide();
				}
			});
		},
		createTools :function () {
			var tableId = sm.table.settings.obj.attr('id');
			var html = '';
			html += '<div class="row">';
			html += '	<div class="col-xs-12">';
			html += '		<div id="' + tableId + '_length" class="dataTables_length">';
			var button;
			var permission;
			for ( var i = 0, len = sm.table.options.tools.length; i < len; i++) {
				button = sm.table.options.tools[i];
				permission = (button.permission ? 'permission="' + button.permission + '"' : '');
				html += '			<button  id="_tr'+ i +'" class="btn btn-sm btn-white ' + button.clazz + ' btn-bold" '+ permission+'>';
				html += '				<i class="ace-icon ' + button.icon + ' bigger-120"></i>';
				html += '					' + button.text;
				html += '			</button>';
			}
			html += '		</div>';
			html += '	</div>';
			html += '</div>';
			sm.table.settings.obj.before(html);
			
			// 为过滤条件添加事件
			sm.table.toolsHandler();
		},
		createHeader :function () {
			var thead = $('<thead/>').appendTo(sm.table.settings.obj);
			var row = $('<tr/>').appendTo( thead );
			var cell, column;
			
			// 添加checkbox
			if(!sm.table.options.checkbox.hide){
				cell = $('<th/>').html('<label class="pos-rel"><input type="checkbox" class="ace" /><span class="lbl"></span></label>').addClass('center');;
				cell.appendTo(row);
			}
			
			// 添加序列号
			if(!sm.table.options.index.hide){
				cell = $('<th/>').html(sm.table.options.index.title);
				if(sm.table.options.index.align){
					cell.addClass('text-' + sm.table.options.index.align);
				}
				cell.appendTo(row);
			}
			
			//行默认参数
			var def = {align:'center', mobileHide : false, hide : false};
			// 添加动态列
			for ( var i = 0, len = sm.table.options.columns.length; i < len; i++) {
				column = (sm.table.options.columns[i] = $.extend({}, def, sm.table.options.columns[i]));;
				if(column.hide){
					continue;
				}
				cell = $('<th/>').html(column.title);
				if(column.align){
					cell.addClass('text-' + column.align);
				}
				if(column.mobileHide){
					cell.addClass("hidden-480");
				}
				cell.appendTo(row);
			}
			
			// 添加操作列
			if(sm.table.options.operate.length > 0){
				cell = $('<th/>');
				cell.appendTo(row);
			}
		},
		operationHandler: function(c, i){
			// 默认
			var def = {text : '', clazz : '', icon : '', show : function(d){ return true; },handler : function(d){}};
			$(sm.table.options.operate).each(function(j,d) {
				d = $.extend({}, def, d);
				var $m = $("#_mr"+ i +"c"+ j);
				var $d = $("#_dr"+ i +"c"+ j);
				if(d.show(c, i)){
					$m.click(function(){
						$('th input[type=checkbox], td input[type=checkbox]').prop('checked', false);
						$(this).closest('tr').find('td input[type=checkbox]').prop('checked', true);
						d.handler(c, i);
					});
					$d.click(function(){ 
						$('th input[type=checkbox], td input[type=checkbox]').prop('checked', false);
						$(this).closest('tr').find('td input[type=checkbox]').prop('checked', true);
						d.handler(c, i);
					});
				}
				else{
					$m.hide();
					$d.hide();
				}
			});
			
		},
		operation : function(cell, index){
			var button;
			var html = '';
			var buttonm = '';
			buttonm += '<div class="hidden-sm hidden-xs action-buttons">';
			
			var md = '';
			md += '<div class="hidden-md hidden-lg">';
			md += '	<div class="inline pos-rel">';
			md += '		<button class="btn btn-minier btn-yellow dropdown-toggle" data-toggle="dropdown" data-position="auto">';
			md += '			<i class="ace-icon fa fa-caret-down icon-only bigger-120"></i>';
			md += '		</button>';
			md += '		<ul class="dropdown-menu dropdown-only-icon dropdown-yellow dropdown-menu-right dropdown-caret dropdown-close">';
			var permission;
			for ( var i = 0, len = sm.table.options.operate.length; i < len; i++) {
				button = sm.table.options.operate[i];
				permission = (button.permission ? 'permission="' + button.permission + '"' : '');
				buttonm += '	<a id="_mr'+ index +'c'+ i +'" class="' + button.clazz + '" href="javascript:void(0)" title="' + button.text + '" '+ permission+'>';
				buttonm += '		<i class="ace-icon ' + button.icon + ' bigger-110"></i>';
				buttonm += '	</a>';
				
				md += '			<li>';
				md += '				<a id="_dr'+ index +'c'+ i +'" href="javascript:void(0)" title="' + button.text + '" class="tooltip-info" data-rel="tooltip" title="View" '+ permission+'>';
				md += '					<span class="' + button.clazz + '">';
				md += '						<i class="ace-icon ' + button.icon + ' bigger-110"></i>';
				md += '					</span>';
				md += '				</a>';
				md += '			</li>';
			}
			buttonm += '</div>';
			
			md += '		</ul>';
			md += '	</div>';
			md += '</div>';
			html = buttonm + md;
			cell.html(html);
		},
		bodyHandler: function(){
			var tableId = sm.table.settings.obj.attr('id');
			
			//表格复选框初始化
			$('th input[type=checkbox], td input[type=checkbox]').prop('checked', false);
			
			//表格选中一行
			/**
			$('#' + tableId + ' tbody').on( 'click', 'tr', function () {
		        $(this).find('td input[type=checkbox]').each(function () {  
		            this.checked = !this.checked;  
		        });
		    });
		     **/
			
			//全选、反选
			$('#' + tableId + ' > thead > tr > th input[type=checkbox]').eq(0).on('click', function(){
				var th_checked = this.checked;
				$(this).closest('table').find('tbody > tr > td input[type=checkbox]').each(function(){
					this.checked = th_checked;
				});
			});
		},
		createBody :function () {
			var thead = $('<tbody/>').appendTo(sm.table.settings.obj);
			var cell, row, column, data;
			
			if(sm.table.settings.list.length > 0){
				for ( var i = 0, len = sm.table.settings.list.length; i < len; i++) {
					
					data = sm.table.settings.list[i];
					row = $('<tr/>').appendTo(thead);
					
					// 添加checkbox
					if(!sm.table.options.checkbox.hide){
						cell = $('<td/>').html('<label class="pos-rel"><input type="checkbox" class="ace" index="' + i + '"/><span class="lbl"></span></label>').addClass('center');
						cell.appendTo(row);
					}
					
					// 添加序列号
					if(!sm.table.options.index.hide){
						cell = $('<td/>').html(i+1+sm.table.settings.pageSize*(sm.table.settings.pageNo-1));
						if(sm.table.options.index.align){
							cell.addClass('text-' + sm.table.options.index.align);
						}
						cell.appendTo(row);
					}
					
					// 添加动态列
					for ( var j = 0, length = sm.table.options.columns.length; j < length; j++) {
						column = sm.table.options.columns[j];
						if(column.hide){
							continue;
						}
						if(column.replace){
							cell = $('<td/>').html(column.replace(data, i, j));
						}
						else{
							cell = $('<td/>').html((data[column.field] == null ? '' : data[column.field]) + '');
						}
						if(column.align){
							cell.addClass('text-' + column.align);
						}
						if(column.clazz){
							cell.addClass(column.clazz);
						}
						if(column.mobileHide){
							cell.addClass("hidden-480");
						}
						cell.appendTo(row);
					}
					
					// 添加操作列
					if(sm.table.options.operate.length > 0){
						cell = $('<td/>');
						cell.appendTo(row);
						// 添加操作按钮
						sm.table.operation(cell, i);
						// 为操作按钮注册事件
						sm.table.operationHandler(data, i);
					}
				}
			}
			else{
				row = $('<tr/>').appendTo(thead).addClass('odd');
				row.html('<td valign="top" colspan="' + (sm.table.options.columns.length + 2) + '" class="dataTables_empty">暂无记录</td>');
			}
			
			// 加载body为checkbox添加事件
			sm.table.bodyHandler();
		},
		ajaxData :function () {
			var bool = false;
			if(sm.table.options.formId != null){
				sm.table.options.data = $.extend({}, sm.table.options.data, $.formJson(sm.table.options.formId));
			}
			$.ajax({ 
				type : "get", 
	            url : sm.table.options.url, 
	            data : $.extend({}, sm.table.options.data, {pageNo : sm.table.settings.pageNo, pageSize : sm.table.settings.pageSize}), 
	            async : false, 
	            cache : false,
	            dataType : "json",
	          	success : function(d){
	          		var data = d.data;
	          		if(data){
	          			// 树结构
	          			if(data.length != undefined){
	          				sm.table.settings.list = data;
	          				sm.table.settings.rowCount = data.length;
	          			}
	          			else{
	          				sm.table.settings = $.extend({}, sm.table.settings, data);
	          			}
	          		}
	          		bool = true;
	          	}
		    });
			return bool;
		},
		paginationHandler: function(){
			var tableId = sm.table.settings.obj.attr('id');
			if(sm.table.settings.pageNo > 1){
				$('#' + tableId + '_first > a').click(function(){
					sm.table.settings.pageNo = 1;
					sm.table.reload();
				});
				
				$('#' + tableId + '_previous > a').click(function(){
					sm.table.settings.pageNo = sm.table.settings.pageNo - 1;
					sm.table.reload();
				});
			}
			
			if(sm.table.settings.pageNo < sm.table.settings.pageCount){
				$('#' + tableId + '_next > a').click(function(){
					sm.table.settings.pageNo = sm.table.settings.pageNo + 1;
					sm.table.reload();
				});
				
				$('#' + tableId + '_last > a').click(function(){
					sm.table.settings.pageNo = sm.table.settings.pageCount;
					sm.table.reload();
				});
			}
			
			$('.paginate_number_button').click(function(){
				sm.table.settings.pageNo = $(this).find('a').html();
				sm.table.reload();
			});
			
			//切换分页
			$('#' + tableId + '_info > label > select').change(function(){
				sm.table.settings.pageNo = 1;
				sm.table.settings.pageSize = $(this).val();
				sm.table.reload();
			});
		},
		createPagination :function () {
			var tableId = sm.table.settings.obj.attr('id');
			var html = '';
			html += '<div class="row">';
			html += '	<div class="col-xs-6">';
			html += '		<div id="' + tableId + '_info" class="dataTables_info" role="status" aria-live="polite">';
			html += '			<label>每页显示';
			html += '				 <select name="' + tableId + '_length" aria-controls="' + tableId + '" class="form-control input-sm">';
			var size;
			for( var i = 0, len = sm.table.options.pagination.pageSizes.length; i < len; i++){
				size = sm.table.options.pagination.pageSizes[i];
				html += '					<option	value="'+ size +'" '+ (size == sm.table.settings.pageSize ? 'selected="selected"' : '')+ ' >'+ size +'</option>';
			}
			html += '			</select> 条记录，</label>';
			html += '			<label>共&nbsp;' + sm.table.settings.rowCount + '&nbsp;条记录</label>';
			html += '		</div>';
			html += '	</div>';
			html += '	<div class="col-xs-6">';
			html += '		<div id="' + tableId + '_paginate" class="dataTables_paginate paging_full_numbers">';
			html += '			<ul class="pagination">';
			html += '				<li id="' + tableId + '_first" class="paginate_button first ' + (sm.table.settings.pageNo > 1 ? '' : 'disabled') + '" aria-controls="' + tableId + '" tabindex="0">';
			html += '					<a href="javascript:void(0)">首页</a>';
			html += '				</li>';
			html += '				<li id="' + tableId + '_previous" class="paginate_button previous ' + (sm.table.settings.pageNo > 1 ? '' : 'disabled') + '" aria-controls="' + tableId + '" tabindex="0">';
			html += '					<a href="javascript:void(0)">上一页</a>';
			html += '				</li>';
			
			var i = (sm.table.settings.pageNo - sm.table.settings.offsetSize < 1 ? 1 : sm.table.settings.pageNo - sm.table.settings.offsetSize);
			for(; i < sm.table.settings.pageNo; i++){
				if(i > 0){
					html += '				<li class="paginate_button paginate_number_button" aria-controls="' + tableId + '" tabindex="0">';
					html += '					<a href="javascript:void(0)">' + i + '</a>';
					html += '				</li>';
				}
			}
			
			if(sm.table.settings.pageNo <= sm.table.settings.pageCount){
				html += '				<li class="paginate_button active" aria-controls="' + tableId + '" tabindex="0">';
				html += '					<a href="javascript:void(0)">' + sm.table.settings.pageNo + '</a>';
				html += '				</li>';
			}
			
			for(var i = sm.table.settings.pageNo + 1 ; i <= sm.table.settings.pageNo + sm.table.settings.offsetSize; i++){
				if(i <= sm.table.settings.pageCount){
					html += '				<li class="paginate_button paginate_number_button" aria-controls="' + tableId + '" tabindex="0">';
					html += '					<a href="javascript:void(0)">' + i + '</a>';
					html += '				</li>';
				}
			}
			
			html += '				<li id="' + tableId + '_next" class="paginate_button next ' + (sm.table.settings.pageNo < sm.table.settings.pageCount ? '' : 'disabled') + '" aria-controls="' + tableId + '" tabindex="0">';
			html += '					<a href="javascript:void(0)">下一页</a>';
			html += '				</li>';
			html += '				<li id="' + tableId + '_last" class="paginate_button last ' + (sm.table.settings.pageNo < sm.table.settings.pageCount ? '' : 'disabled') + '" aria-controls="' + tableId + '" tabindex="0">';
			html += '					<a href="javascript:void(0)">末页</a>';
			html += '				</li>';
			html += '			</ul>';
			html += '		</div>';
			html += '	</div>';
			html += '</div>';
			sm.table.settings.obj.after(html);
			
			// 为分页注册事件
			sm.table.paginationHandler();
		},
		clear :function () {
			if(sm.table.options.tools.length > 0){
				sm.table.settings.obj.prev().remove();
			}
			sm.table.settings.obj.html('');
			if(!sm.table.options.pagination.hide){
				sm.table.settings.obj.next().remove();
			}
		},
		reload :function () {
			sm.table.clear();
			sm.table.load();
		},
		load :function () {
			if(sm.table.options.tools.length > 0){
				sm.table.createTools();
			}
			sm.table.createHeader();
			if(sm.table.ajaxData()){
				sm.table.createBody();
			}
			if(!sm.table.options.pagination.hide){
				sm.table.createPagination();
			}
			if(sm.table.options.after){
				sm.table.options.after();
			}
		},
		search :function (d) {
			sm.table.settings.pageNo = 1;
			if(d){
				sm.table.options.data = d;
			}
			sm.table.reload();
		},
		generate :function (c) {
			sm.table.options = $.extend({}, sm.table.options, c);
			
			if(sm.table.options.columns.length > 0 && sm.table.options.url){
				sm.table.load();
			}
			return sm.table;
		},
		getSelectedItems :function () {
			var array = [];
			sm.table.settings.obj.find('tbody > tr > td input[type=checkbox]:checked').each(function(){
				array.push($(this));
	        });
			return $(array);
		},
		getSelectedItemKeys :function (key) {
			var temp = '';
			sm.table.getSelectedItems().each(function (i, d) {
				if(i > 0){
					temp += ",";
				}
				temp += sm.table.settings.list[this.attr("index")][key];
			});
			return temp;
		},
		validateSelected :function (selectOne) {
			var bool = true;
			if(sm.table.getSelectedItems().length < 1){
				$.gritter.add({text: '至少选择一行'});
				bool = false;
			}
			else if(selectOne && sm.table.getSelectedItems().length != 1){
				$.gritter.add({text: '只能操作单行'});
				bool = false;
			}
			return bool;
		},
		ajaxRequest :function (d) {
			$.ajax({
				type : d.type, 
	            url : d.url, 
	            data : $.extend({}, {ids : sm.table.getSelectedItemKeys("id")}, d.data), 
	            async : d.async, 
	            cache : false,
	            dataType : d.dataType,
	          	success : function(data){ 
	          		if(d.success){
	          			d.success(data);
	          		}
	          	},
	          	error : function(){
	          		d.error();
	          	},
	          	complete : function(){
	          		d.after();
	          	}
		    });
		},
		ajax :function (d) {
			var def = {
				// 是否只能操作单行
				selectOne : false,
				
				type : "post", 
				url : "", 
				data : {}, 
				async : true,
				dataType : "json",
				// 确认框内容
				confirm : null,
				success : function(data){
					if(data && data.message){
						$.gritter.add({text: data.message});
					}
					else{
						$.gritter.add({text: '操作成功！'});
					}
				},
				error : function(data){
					if(data && data.message){
						$.gritter.add({text: data.message});
					}
					else{
						$.gritter.add({text: '操作失败！'});
					}
				},
				after : function(){
					sm.table.reload();
				}
			};
			
			d = $.extend({}, def, d);
			
			if(sm.table.validateSelected(d.selectOne)){
				if(d.confirm != null){
					bootbox.confirm(d.confirm, function(result) {
						if(result) {
							sm.table.ajaxRequest(d);
						}
					});
				}
				else{
					sm.table.ajaxRequest(d);
				}
			}
		},
		ajaxDelete :function (d) {
			sm.table.ajax($.extend({}, {
				confirm : "确认删除?",
				success : function(data){
					if(data && data.message){
						$.gritter.add({text: data.message});
					}
					else{
						$.gritter.add({text: '删除成功！'});
					}
				},
				error : function(data){
					if(data && data.message){
						$.gritter.add({text: data.message});
					}
					else{
						$.gritter.add({text: '删除失败！'});
					}
				}
			}, d));
		},
		ajaxEnable :function (d, enable) {
			sm.table.ajax($.extend({}, {
				data : {isEnable : enable}
			}, d));
		}
	};
})(smart, jQuery);

jQuery(function($) {
	$.table = function(c) {
		return smart.table.generate(c);
	};
	
	$.fn.table = function(c) {
		smart.table.settings.obj = $(this);
		return $.table(c);
	};
});