/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.api.controller.login;

import cn.hutool.core.util.ObjectUtil;
import com.geoway.jckj.base.base.dto.ResponseDataBase;
import com.geoway.jckj.biz.service.login.IQrLoginService;
import com.geoway.jckj.biz.service.oauth2.IOauth2Service;
import com.geoway.sso.client.annotation.OpLog;
import com.geoway.sso.client.enums.OpTypeEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4e8c\u7ef4\u7801\u626b\u7801\u767b\u5f55"})
@RestController
@RequestMapping(value={"/qrlogin"})
public class QrLoginController {
    @Autowired
    private IQrLoginService qrLoginService;
    @Autowired
    private IOauth2Service ssoOauth2Service;

    @ApiOperation(value="\u751f\u6210\u767b\u5f55\u4e8c\u7ef4\u7801")
    @RequestMapping(value={"/_getdata"}, method={RequestMethod.GET})
    public ResponseDataBase _getdata(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        responseDataBase.put((Object)"data", (Object)this.qrLoginService.generateQrCode());
        return responseDataBase;
    }

    @ApiOperation(value="\u68c0\u67e5\u626b\u7801\u540e\u624b\u673a\u7aef\u662f\u5426\u767b\u5f55\u6388\u6743")
    @OpLog(name="\u68c0\u67e5\u626b\u7801\u540e\u624b\u673a\u7aef\u662f\u5426\u767b\u5f55\u6388\u6743", opType=OpTypeEnum.login)
    @ApiImplicitParam(name="key", value="\u767b\u5f55\u4e8c\u7ef4\u7801\u5bf9\u5e94\u7684key", required=true, dataType="String")
    @RequestMapping(value={"/_check"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase _check(String key) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        responseDataBase.put((Object)"data", (Object)this.qrLoginService.getLoginInfo(key));
        return responseDataBase;
    }

    @ApiOperation(value="\u83b7\u53d6\u4e8c\u7ef4\u7801\u72b6\u6001")
    @ApiImplicitParam(name="key", value="\u767b\u5f55\u4e8c\u7ef4\u7801\u5bf9\u5e94\u7684key", required=true, dataType="String")
    @RequestMapping(value={"/_status"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase _status(String key) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        responseDataBase.put((Object)"data", (Object)this.qrLoginService.getQrStatus(key));
        return responseDataBase;
    }

    @ApiOperation(value="\u5237\u65b0token")
    @ApiImplicitParam(name="token", value="\u65e7token", required=true, dataType="String")
    @RequestMapping(value={"/_refresh"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase _refresh(@RequestParam(value="refreshToken", required=true) String refreshToken, @RequestParam(value="appId", required=true) String appId) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        responseDataBase.put((Object)"data", (Object)this.ssoOauth2Service.refreshToken(appId, refreshToken));
        return responseDataBase;
    }

    @ApiOperation(value="\u624b\u673a\u7aef\u786e\u8ba4\u767b\u5f55")
    @OpLog(name="\u624b\u673a\u7aef\u786e\u8ba4\u767b\u5f55", opType=OpTypeEnum.login)
    @ApiImplicitParams(value={@ApiImplicitParam(name="token", value="\u767b\u5f55\u8fc7\u7684\u7528\u6237token", required=true, dataType="String"), @ApiImplicitParam(name="state", value="\u4e8c\u7ef4\u7801\u72b6\u6001\uff1aready-\u5f85\u4f7f\u7528\uff0cscanned-\u5df2\u626b\u63cf\uff0cconfirm-\u5df2\u786e\u8ba4\uff0ccancel-\u5df2\u53d6\u6d88 invalid-\u4e0d\u5408\u6cd5\uff0c\u8be5\u63a5\u53e3\u53ea\u5141\u8bb8\u4f20scanned/confirm/cancel", required=true, dataType="String"), @ApiImplicitParam(name="key", value="\u767b\u5f55\u4e8c\u7ef4\u7801\u5bf9\u5e94\u7684key", required=true, dataType="String")})
    @RequestMapping(value={"/_autologin"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase _autologin(String token, String key, String state) {
        if (ObjectUtil.isEmpty((Object)state)) {
            state = "confirm";
        }
        if (!ObjectUtil.contains(Arrays.asList("scanned", "confirm", "cancel"), (Object)state)) {
            return ResponseDataBase.error((String)"state\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        ResponseDataBase responseDataBase = new ResponseDataBase();
        if (!this.qrLoginService.autoLogin(token, key, state).booleanValue()) {
            return ResponseDataBase.error((String)"\u79fb\u52a8\u7aef\u767b\u5f55\u5931\u6548!");
        }
        return responseDataBase;
    }
}

