ALTER TABLE sys_organization ALTER COLUMN f_pid TYPE varchar(256);
ALTER TABLE sys_user_organization ALTER COLUMN f_id TYPE varchar(255) ;
ALTER TABLE sys_user_organization ALTER COLUMN f_userid TYPE varchar(255) ;
ALTER TABLE sys_user_organization ALTER COLUMN f_orgid TYPE varchar(255) ;
CREATE  INDEX IF NOT EXISTS sys_user_region_f_userid_idx ON sys_user_region (f_userid);
CREATE  INDEX  IF NOT EXISTS sys_user_region_f_regionid_idx ON sys_user_region (f_regionid);

DO
$do$
BEGIN    IF NOT EXISTS (
        SELECT *
        FROM information_schema.constraint_column_usage
        WHERE table_name = 'sys_group' AND constraint_name = 'sys_group_pk'
    ) THEN        ALTER TABLE sys_group
        ADD CONSTRAINT sys_group_pk PRIMARY KEY (f_id);
    END IF;
END;
$do$;

CREATE INDEX IF NOT exists sys_organization_f_id_path_idx ON sys_organization USING btree (f_id_path);;
CREATE INDEX IF NOT exists sys_organization_f_pid_idx ON sys_organization (f_pid);
CREATE INDEX IF NOT exists sys_region_f_id_path_idx ON sys_region (f_id_path);
CREATE INDEX IF NOT exists sys_region_f_pid_idx ON sys_region (f_pid);
CREATE INDEX IF NOT exists sys_region_f_code_idx ON sys_region (f_code);
CREATE INDEX IF NOT exists sys_region_f_pcode_idx ON sys_region (f_pcode);
CREATE INDEX IF NOT exists sys_role_menu_f_roleid_idx ON sys_role_menu (f_roleid);
CREATE INDEX IF NOT exists sys_role_menu_f_menuid_idx ON sys_role_menu (f_menuid);
CREATE INDEX IF NOT exists sys_role_subfunction_f_roleid_idx ON sys_role_subfunction (f_roleid);
CREATE INDEX IF NOT exists sys_role_subfunction_f_subfunctionid_idx ON sys_role_subfunction (f_subfunctionid);
CREATE INDEX IF NOT exists sys_role_system_f_roleid_idx ON sys_role_system (f_roleid);
CREATE INDEX IF NOT exists sys_role_system_f_systemid_idx ON sys_role_system (f_systemid);
CREATE INDEX IF NOT exists sys_subfunction_f_menuid_idx ON sys_subfunction USING btree (f_menuid);
CREATE INDEX IF NOT exists sys_subfunction_f_pid_idx ON sys_subfunction USING btree (f_pid);
CREATE INDEX IF NOT exists sys_subfunction_f_systemid_idx ON sys_subfunction USING btree (f_systemid);
CREATE INDEX IF NOT exists sys_tenant_menu_f_tenantid_idx ON sys_tenant_menu (f_tenantid);
CREATE INDEX IF NOT exists sys_tenant_menu_f_systemid_idx ON sys_tenant_menu (f_systemid);
CREATE INDEX IF NOT exists sys_tenant_menu_f_menuid_idx ON sys_tenant_menu (f_menuid);
CREATE INDEX IF NOT exists sys_tenant_menu_f_isolate_idx ON sys_tenant_menu (f_isolate);
CREATE INDEX IF NOT exists sys_tenant_organization_f_orgid_idx ON sys_tenant_organization (f_orgid);
CREATE INDEX IF NOT exists sys_tenant_organization_f_tenantid_idx ON sys_tenant_organization (f_tenantid);
CREATE INDEX IF NOT exists sys_tenant_space_f_tenantid_idx ON sys_tenant_space (f_tenantid);
CREATE INDEX IF NOT exists sys_tenant_space_f_systemid_idx ON sys_tenant_space (f_systemid);
CREATE INDEX IF NOT exists sys_tenant_space_f_solate_idx ON sys_tenant_space (f_solate);
CREATE INDEX IF NOT exists sys_tenant_system_f_tenantid_idx ON sys_tenant_system (f_tenantid);
CREATE INDEX IF NOT exists sys_tenant_system_f_systemid_idx ON sys_tenant_system (f_systemid);
CREATE INDEX IF NOT exists sys_tenant_user_f_userid_idx ON sys_tenant_user (f_userid);
CREATE INDEX IF NOT exists sys_tenant_user_f_tenantid_idx ON sys_tenant_user (f_tenantid);
CREATE INDEX IF NOT exists sys_user_catalog_f_userid_idx ON sys_user_catalog (f_userid);
CREATE INDEX IF NOT exists sys_user_catalog_f_usercatalog_idx ON sys_user_catalog (f_usercatalog);
CREATE INDEX IF NOT exists sys_user_limit_f_userid_idx ON sys_user_limit (f_userid);
CREATE INDEX IF NOT exists sys_user_limit_f_limittype_idx ON sys_user_limit (f_limittype);
CREATE INDEX IF NOT exists sys_user_limit_f_appid_idx ON sys_user_limit (f_appid);
CREATE INDEX IF NOT exists sys_user_organization_f_orgid_idx ON sys_user_organization (f_orgid);
CREATE INDEX IF NOT exists sys_user_region_f_regionid_idx ON sys_user_region USING btree (f_regionid);
CREATE INDEX IF NOT exists sys_user_region_f_userid_idx ON sys_user_region USING btree (f_userid);
CREATE INDEX IF NOT exists sys_user_organization_f_userid_idx ON sys_user_organization USING btree (f_userid);
CREATE INDEX IF NOT exists sys_user_organization_f_orgid_idx ON sys_user_organization USING btree (f_orgid);
CREATE INDEX IF NOT exists sys_user_role_f_userid_idx ON sys_user_role (f_userid);
CREATE INDEX IF NOT exists sys_user_role_f_roleid_idx ON sys_user_role (f_roleid);