-- ----------------------------
--2025年5月22日，wangqiang，组织机构表增加f_idpath字段
-- ----------------------------
ALTER TABLE sys_organization ADD if not exists f_id_path text NULL;
COMMENT ON COLUMN sys_organization.f_id_path IS '用于存储所有的父id和自己的id';

WITH RECURSIVE org AS (
            SELECT sys_organization.*,
            sys_organization.f_id::text  AS f_id_path_v,
            sys_organization.f_id::text as f_id_v
            FROM   sys_organization
            UNION ALL
            SELECT d.*,
            (d.f_id || '->' || org.f_id_path_v)::text as f_id_path_v,
            org.f_id_v
            FROM   sys_organization d
                       JOIN   org ON org.f_pid = d.f_id
        ),
org_path_id as  (SELECT *
FROM (
    SELECT
        f_id_path_v,
        f_id_v,
        RANK()  OVER (PARTITION BY f_id_v ORDER BY LENGTH(f_id_path_v) DESC) AS rank
    FROM
        org
) ranked
WHERE rank <= 1)

update sys_organization set f_id_path =org_path_id.f_id_path_v from org_path_id where org_path_id.f_id_v=f_id
