package com.geoway.jckj.base.base.dto;

import java.util.HashMap;

/**
 * @author ALMJ
 */

public enum ResponseErrorCode {
    //用户输入错误
	UserInputError(401,"用户输入错误"),
	//数据错误
	DataError(402,"数据错误"),
	//系统处理出错
	ServerError(505,"系统处理出错");

	private static final HashMap<Integer, ResponseErrorCode> MAP;
	static{
		MAP = new HashMap<>();
		ResponseErrorCode[] values = ResponseErrorCode.values();
		for (ResponseErrorCode value : values) {
			MAP.put(value.code, value);
		}
	}

	private int code;
	private String desc;
	ResponseErrorCode(int code,String desc){
		this.code = code;
		this.desc = desc;
	}

	public static ResponseErrorCode of(Integer code){
		if(MAP.containsKey(code)){
			return MAP.get(code);
		}else{
			throw new IllegalArgumentException("code");
		}
	}

	public int getCode() {
		return code;
	}

	public void setCode(int code) {
		this.code = code;
	}

	public String getDesc() {
		return desc;
	}

	public void setDesc(String desc) {
		this.desc = desc;
	}
}
