package com.geoway.jckj.base.config;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.map.HashedMap;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;
import springfox.documentation.builders.ApiListingBuilder;
import springfox.documentation.schema.ModelKey;
import springfox.documentation.schema.ModelSpecification;
import springfox.documentation.schema.QualifiedModelName;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.ApiListingBuilderPlugin;
import springfox.documentation.spi.service.contexts.ApiListingContext;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;

@Order(value = Ordered.LOWEST_PRECEDENCE)
@Component
@Slf4j
public class ModelRetriveApiListingPugin implements ApiListingBuilderPlugin {


    private Map<String, QualifiedModelName> apiModels = new HashedMap();

    @Override
    public void apply(ApiListingContext apiListingContext) {
        Field filed = ReflectionUtils.findField(ApiListingBuilder.class, "modelSpecifications");
        filed.setAccessible(true);
        Map<String, ModelSpecification> specsMap = (Map<String, ModelSpecification>) ReflectionUtils.getField(filed, apiListingContext.apiListingBuilder());

        retriveApiModels(specsMap.values());
    }

    private void retriveApiModels(Collection<ModelSpecification> specs) {
        specs.forEach(spec -> {
            ModelKey modelKey = spec.getCompound().get().getModelKey();
            QualifiedModelName modelName = modelKey.getQualifiedModelName();
            apiModels.put(modelName.getName(), modelName);
            log.info(modelName.toString());
        });
    }

    public Map<String, QualifiedModelName> getApiModels() {
        return apiModels;
    }

    @Override
    public boolean supports(DocumentationType delimiter) {
        return true;
    }
}

