package com.geoway.jckj.base.support;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author 李海江
 * @date 2020/2/17
 * @version 1.0
 */
public class DbUtil {
	private DbUtil(){}
	public static String getFilterByList(List<String> sqhList, int splitNum,String columnName) {
		if(sqhList == null || sqhList.size() == 0) {
			return " 1=1 ";
		}
		//ORA-01795: 列表中的最大表达式数为 1000。因为数据库的列表sql限制，不能超过1000.
		if(sqhList.size() < splitNum) {
			return columnName + " in (" + String.join(",", sqhList) + ")";
		}
		StringBuilder sql = new StringBuilder("");
		sql.append(" ").append(columnName).append (" IN ( ");
		for (int i = 0; i < sqhList.size(); i++) {
			sql.append(sqhList.get(i) + ",");
			if ((i + 1) % splitNum == 0 && (i + 1) < sqhList.size()) {
				sql.deleteCharAt(sql.length() - 1);
				sql.append(" ) OR ").append(columnName).append (" IN (");
			}
		}
		sql.deleteCharAt(sql.length() - 1);
		sql.append(" )");
		return sql.toString();
	}

	public static boolean isTableExist(JdbcTemplate jdbcTemplate, String tableName) {
		
		String dbTypeName = queryDbType(jdbcTemplate);
		//去除表空间前缀
		String checkTableName = tableName;
		int index = checkTableName.lastIndexOf(".");
		if (index > -1) {
			checkTableName = checkTableName.substring(index + 1);
		}
		String sql = String.format("select count(1) from user_tables where table_name ='%s'", checkTableName.toUpperCase());
		if (dbTypeName.trim().toLowerCase().equals("postgresql")) {
			sql = String.format("select count(1) from pg_class where lower(relname) ='%s'", checkTableName.toLowerCase());
		}
		Long exist = jdbcTemplate.queryForObject(sql, Long.class);
		return exist > 0;
	}

	public static boolean hasData(JdbcTemplate jdbcTemplate, String tableName) {
		String sql = "select count(*) from " + tableName;
		List<Integer> result = jdbcTemplate.query(sql, new RowMapper<Integer>() {
			@Override
			public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
				return Integer.parseInt(rs.getString(1));
			}
		});
		return result.get(0) > 0;
	}
	
	public static String queryDbType(JdbcTemplate jdbcTemplate) {
		String dbTypeName = null;
		Connection myConn = null;
		try {
		    myConn = jdbcTemplate.getDataSource().getConnection();
		    dbTypeName = myConn.getMetaData().getDatabaseProductName();
		} catch (SQLException e) {
			e.printStackTrace();
		} finally {
			if (myConn != null) {
				try {
					myConn.close();
				} catch (SQLException e) {
					e.printStackTrace();
				}
			}
		}
		
		return dbTypeName;
	}

	public static List<HashMap<String, Object>> listArrayToListMap(List<Object> list, String[] keys) {
		if (list == null || list.size() <= 0) {
			return null;
		}
		List<HashMap<String, Object>> mapList = new ArrayList<HashMap<String, Object>>();
		for (int i = 0; i < list.size(); i++) {
			if (!(list.get(i) instanceof Map)) {
				HashMap<String, Object> map = new HashMap<String, Object>();
				Object[] m = (Object[]) list.get(i);
				for (int j = 0; j < keys.length; j++) {
					map.put(keys[j], m[j]);
				}
				mapList.add(map);
			}
		}
		return mapList;
	}
}
