package com.geoway.jckj.base.support;

import lombok.extern.slf4j.Slf4j;

import java.io.*;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

/***
 * zip压缩包操作类
 *
 * @author Walt Chiang
 *
 */
@Slf4j
public class ZipUtils {

  private ZipEntry zipEntry;

  private static int bufSize; // size of bytes

  private byte[] buf;

  private int readedBytes;
  private String rootDir;

  public ZipUtils() {
    this(512);
  }

  public ZipUtils(int bufSize) {
    ZipUtils.bufSize = bufSize;
    this.buf = new byte[ZipUtils.bufSize];
  }

  // -------------------------解压指定zip文件
  public void unZip(String unZipfileName) { // unZipfileName需要解压的zip文件名
    if (unZipfileName.endsWith(".zip")) {
      FileOutputStream fileOut;
      File file;
      String f = unZipfileName.substring(0, unZipfileName.length() - 4);
      String rootName = "";
      f = f.replaceAll("\\\\", "/");
      rootName = f.substring(f.lastIndexOf("/") + 1);
      File ff = new File(f); // f为减压后的存放目标文件夹
      try {
        File zipFile = new File(unZipfileName);
        if (zipFile.exists()) {
          // start----------------------------------------核心语句---------------------------------------
          ZipInputStream zipIn =
              new ZipInputStream(new BufferedInputStream(new FileInputStream(unZipfileName)));
          // end----------------------------------------核心语句---------------------------------------
          while ((this.zipEntry = zipIn.getNextEntry()) != null) {
            String path = this.zipEntry.getName();
            path = path.replaceAll("\\\\", "/");
            if (path.lastIndexOf("/") > -1) {
              path = path.substring(0, path.lastIndexOf("/"));
            } else {
              path = "";
            }
            path = path.replaceFirst(rootName, "");
            file = new File(this.zipEntry.getName()); // zipEntry.getName()是文件在zip包中的全路径
            if (this.zipEntry.isDirectory()) {
              file.mkdirs();
            } else { // 如果指定文件的目录不存在,则创建之.
              File parent = file.getParentFile();
              if (parent != null && !parent.exists()) {
                parent.mkdirs();
              }
              if (!ff.exists()) {
                ff.mkdir();
              }
              File dir = null;
              if (StringUtils.isBlank(path)) {
                dir = new File(f);
              } else {
                dir = new File(f + "/" + path);
              }
              if (!dir.exists()) {
                dir.mkdirs();
              }
              if (StringUtils.isEmpty(path)) {
                fileOut = new FileOutputStream(f + "/" + file.getName());
              } else {
                fileOut = new FileOutputStream(f + "/" + path + "/" + file.getName());
              }
              while ((this.readedBytes = zipIn.read(this.buf)) > 0) {
                fileOut.write(this.buf, 0, this.readedBytes);
              }
              fileOut.close();
            }
            zipIn.closeEntry();
          }
          System.out.println("解压完成！");
        } else {
          System.err.println("zip文件不存在！");
        }
      } catch (Exception ioe) {
        ioe.printStackTrace();
      }

    } else {
      System.err.println("您选择的文件不是zip文件！");
    }
  }

  // -----------------压缩文件夹内的文件
  public void doZip(String zipDirectory) { // zipDirectoryPath:需要压缩的文件夹名
    File zipDir;
    zipDir = new File(zipDirectory);
    if (zipDir.exists()) {
      this.rootDir = zipDir.getName();
      String zipFileName = zipDirectory + ".zip";
      ; // 压缩后生成的zip文件名
      if (zipDir.isFile()) {
        zipFileName = zipDirectory.substring(0, zipDirectory.indexOf(".")) + ".zip";
      }
      try { // 压缩zip的核心
        ZipOutputStream zipOut =
            new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFileName)));
        handleDir(zipDir, zipOut);
        zipOut.close();
        System.out.println("完成！");
      } catch (IOException e) {
        e.printStackTrace();
        System.out.println(" 请输入正确的文件路径！");
      }
    } else {
      System.err.println("您输入的文件路径不存在！");
    }
  }

  public void doZip(String zipDirectory, String zipFileName) {
    File zipDir;
    zipDir = new File(zipDirectory);
    if (zipDir.exists()) {
      try { // 压缩zip的核心
        this.rootDir = zipDir.getName();
        ZipOutputStream zipOut =
            new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFileName)));
        handleDir(zipDir, zipOut);
        zipOut.close();
        System.out.println("完成！");
      } catch (IOException e) {
        log.error("", e);
        System.out.println(" 请输入正确的文件路径！");
      }
    } else {
      System.err.println("您输入的文件路径不存在！");
    }
  }

  // -----------------------由doZip调用,递归完成目录文件读取
  private void handleDir(File dir, ZipOutputStream zipOut) throws IOException {
    FileInputStream fileIn;
    File[] files = null;
    if (dir.isDirectory()) { // 为文件夹
      files = dir.listFiles(); // 子文件
      if (null != files && files.length == 0) { // 如果目录为空,则单独创建之.
        // ZipEntry的isDirectory()方法中,目录以"/"结尾. 注意文件夹的创建形式
        zipOut.putNextEntry(new ZipEntry(dir.toString() + "/"));
        zipOut.closeEntry();
      } else { // 如果目录不为空,则分别处理目录和文件.
        for (File fileName : files) {

          if (fileName.isDirectory()) { // 是文件夹
            handleDir(fileName, zipOut);
          } else { // 是文件
            fileIn = new FileInputStream(fileName);
            String name = dir.getName();
            String path = dir.getPath();
            path = path.substring(path.indexOf(this.rootDir));

            zipOut.putNextEntry(
                new ZipEntry(
                    path + "/" + fileName.getName().toString())); // 生成的压缩包存放在原目录下//ZipEntry类
            // 文件夹
            // +文件的名字
            while ((this.readedBytes = fileIn.read(this.buf)) > 0) {
              zipOut.write(this.buf, 0, this.readedBytes);
            }
            zipOut.closeEntry();
          }
        }
      }

    } else if (dir.isFile()) { // 为文件
      fileIn = new FileInputStream(dir);
      String name = dir.getName();
      String path = dir.getPath();
      zipOut.putNextEntry(new ZipEntry(dir.getName().toString())); // 生成的压缩包存放在原目录下//ZipEntry类
      // 文件夹
      // +文件的名字
      while ((this.readedBytes = fileIn.read(this.buf)) > 0) {
        zipOut.write(this.buf, 0, this.readedBytes);
      }
      zipOut.closeEntry();
    }
  }
}
