package com.geoway.jckj.base.annotation;

import java.lang.annotation.*;

/**
 * swagger schema模型中，
 * 1. 在作为body入参的场景下，忽略某些字段
 * 2. 在作为出参的场景下，不必忽略某些字段
 *
 * 比如：
 *     @ApiOperation("获取用户列表, UserEntity作为出参")
 *     @GetMapping("/list")
 *     public R<List<UserEntity>> userList();
 *
 *     @ApiOperation("更新用户，UserEntity作为入参")
 *     @PutMapping("/update")
 *     public R<String> update(@RequestBody UserEntity user)
 */
@Target({ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface SwaggerInputFieldIgnore {
}
