package com.geoway.jckj.base.support.query;

import com.geoway.jckj.base.support.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;


/**
 * @author geoway
 */
public class QueryParamParseUtil {
	
	public static final String complexFindKey = "#";

     /**
      * 带括号表达式
      * @param matchParam
      * @return
      */
	public static boolean isComplexExpession(String matchParam){
		String regex = "\\([^\\(\\)]+\\)";
		Pattern pattern = Pattern.compile(regex);
		Matcher matcher = pattern.matcher(matchParam);

        return matcher.find();
	}
	

	/**
	 * 解析嵌套表达式
	 * @param matchParam
	 * @param cacheMap
	 * @return
	 */
	public static QueryFilterParam parseComplexMatchParam(String matchParam, Map<String,String> cacheMap,boolean oldMode){
		if(!cacheMap.containsKey(matchParam)){
			return null;
		}
		String filterParam = cacheMap.get(matchParam);
		QueryFilterParam queryFilterParam = new QueryFilterParam();
		queryFilterParam.setExpression(matchParam);
	
		String[] paramPairs = filterParam.split(";");
		List<QueryFilterParam>  childrens = new ArrayList<QueryFilterParam>();
		QueryFilterParam subQueryParam = null;
		for (int i = 0; i < paramPairs.length; i++) {
			String subMatchParam = paramPairs[i];
			if (StringUtils.isBlank(subMatchParam) ) {
				continue;
			}
			
            if(subMatchParam.contains(QueryParamParseUtil.complexFindKey)){
            	//递归处理参数
            	 subQueryParam = parseComplexMatchParam(subMatchParam,cacheMap,oldMode);
			}else{
				 subQueryParam = parseMatchParam(subMatchParam,oldMode);
			}
            
            childrens.add(subQueryParam);
		}
		
		queryFilterParam.setChildrens(childrens);
		queryFilterParam.setNest(true);
		
		if(childrens.size() > 0){
			queryFilterParam.setJoinModel(childrens.get(0).getJoinModel());
		}
		
		
		return queryFilterParam;
	}
	
	public static List<QueryFilterParam> parse4QueryParams(String filterParam,boolean oldMode) {

		List<QueryFilterParam> queryParams = new ArrayList<QueryFilterParam>();
		if (StringUtils.isBlank(filterParam) ) {
			return queryParams;
		}

		String[] paramPairs = filterParam.split(";");
		for (int i = 0; i < paramPairs.length; i++) {
			if (StringUtils.isBlank(paramPairs[i]) ) {
				continue;
			}

			queryParams.add(parseMatchParam(paramPairs[i],oldMode));
		}

		return queryParams;
	}
	
	public static QueryFilterParam parseMatchParam(String matchParam,boolean oldMode){
		
		QueryFilterParam queryParam = new QueryFilterParam();
		queryParam.setExpression(matchParam);

		//如果仅仅是连接表达式
		if(matchParam.equalsIgnoreCase("and")){
			queryParam.setOnlyJoinModel(true);
			queryParam.setJoinModel(QueryFilterParam.JoinModel.AND);

			return  queryParam;
		}

		if(matchParam.equalsIgnoreCase("or")){
			queryParam.setOnlyJoinModel(true);
			queryParam.setJoinModel(QueryFilterParam.JoinModel.OR);

			return  queryParam;
		}

		String operation = "EQ";
		if(oldMode){
			String[] paramValPair = matchParam.split("=");
			String parseParam = paramValPair[0].trim();

			String[] fieldInfo = parseParam.split("_");

			// 设置连接条件
			String joinParam = fieldInfo[0];
			if (joinParam.toUpperCase().equals("Q") || joinParam.toUpperCase().equals("QA")) {
				queryParam.setJoinModel(QueryFilterParam.JoinModel.AND);
			} else if (joinParam.toUpperCase().equals("QOR")) {
				queryParam.setJoinModel(QueryFilterParam.JoinModel.OR);
			}

			// 设置字段名称
			queryParam.setParamName(fieldInfo[1].trim());
			queryParam.setParamValue(paramValPair[1].trim());

			// 设置字段类型
			String fieldType = fieldInfo[2];
			if (fieldType.toUpperCase().equals("N")) {
				queryParam.setFieldType(QueryFilterParam.DataFieldType.NumberField);
			} else if (fieldType.toUpperCase().equals("S")) {
				queryParam.setFieldType(QueryFilterParam.DataFieldType.StringField);
			} else if (fieldType.toUpperCase().equals("D")) {
				queryParam.setFieldType(QueryFilterParam.DataFieldType.DateField);
			}
			operation = fieldInfo[3];
		}else{
			queryParam.setJoinModel(QueryFilterParam.JoinModel.AND);
			String[] filters = matchParam.split("_");
			if (filters.length < 3) {
				return queryParam;
			}
			// 设置字段名称
			queryParam.setParamName(filters[0]);
			operation = filters[1];
			queryParam.setParamValue(filters[2]);
		}

		setOperation(queryParam, operation);

		return queryParam;
	}

	private static void setOperation(QueryFilterParam queryParam, String operation1) {
		// 设置操作符
		String operation = operation1.toUpperCase();
		queryParam.setOperation(operation);
		switch (operation) {
			case "EQ":
				queryParam.setOperationMode(OperationModel.EQ);
				break;
			case "NE":
				queryParam.setOperationMode(OperationModel.NE);
				break;
			case "LK":
				queryParam.setOperationMode(OperationModel.LK);
				break;
			case "LFK":
				queryParam.setOperationMode(OperationModel.LFK);
				break;
			case "RHK":
				queryParam.setOperationMode(OperationModel.RHK);
				break;
			case "BTW":
				queryParam.setOperationMode(OperationModel.BTW);
				break;
			case "LT":
				queryParam.setOperationMode(OperationModel.LT);
				break;
			case "GT":
				queryParam.setOperationMode(OperationModel.GT);
				break;
			case "LE":
				queryParam.setOperationMode(OperationModel.LE);
				break;
			case "GE":
				queryParam.setOperationMode(OperationModel.GE);
				break;
			case "IN":
				queryParam.setOperationMode(OperationModel.IN);
				break;
			case "NOTIN":
				queryParam.setOperationMode(OperationModel.NOTIN);
				break;
			default:
				queryParam.setOperationMode(OperationModel.EQ);
				break;
		}
	}

}
