/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.base.support;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;

public class EncodingDetect {
    public static void main(String[] args) {
        System.out.println(EncodingDetect.detect("C:\\Users\\tanzhiliang\\Desktop\\test.txt"));
    }

    public static String detect(String path) {
        BytesEncodingDetect s = new BytesEncodingDetect();
        String fileCode = BytesEncodingDetect.javaname[s.detectEncoding(new File(path))];
        return fileCode;
    }

    public static String detect(File file) {
        BytesEncodingDetect s = new BytesEncodingDetect();
        String fileCode = BytesEncodingDetect.javaname[s.detectEncoding(file)];
        return fileCode;
    }

    public static String detect(byte[] contents) {
        BytesEncodingDetect s = new BytesEncodingDetect();
        String fileCode = BytesEncodingDetect.javaname[s.detectEncoding(contents)];
        return fileCode;
    }

    public static String detect(URL url) {
        BytesEncodingDetect s = new BytesEncodingDetect();
        String fileCode = BytesEncodingDetect.javaname[s.detectEncoding(url)];
        return fileCode;
    }

    static class Encoding {
        public static final int SIMP = 0;
        public static final int TRAD = 1;
        public static int GB2312 = 0;
        public static int GBK = 1;
        public static int GB18030 = 2;
        public static int HZ = 3;
        public static int BIG5 = 4;
        public static int CNS11643 = 5;
        public static int UTF8 = 6;
        public static int UTF8T = 7;
        public static int UTF8S = 8;
        public static int UNICODE = 9;
        public static int UNICODET = 10;
        public static int UNICODES = 11;
        public static int ISO2022CN = 12;
        public static int ISO2022CN_CNS = 13;
        public static int ISO2022CN_GB = 14;
        public static int EUC_KR = 15;
        public static int CP949 = 16;
        public static int ISO2022KR = 17;
        public static int JOHAB = 18;
        public static int SJIS = 19;
        public static int EUC_JP = 20;
        public static int ISO2022JP = 21;
        public static int ASCII = 22;
        public static int OTHER = 23;
        public static int TOTALTYPES = 24;
        public static String[] javaname;
        public static String[] nicename;
        public static String[] htmlname;

        public Encoding() {
            javaname = new String[TOTALTYPES];
            nicename = new String[TOTALTYPES];
            htmlname = new String[TOTALTYPES];
            Encoding.javaname[Encoding.GB2312] = "GB2312";
            Encoding.javaname[Encoding.GBK] = "GBK";
            Encoding.javaname[Encoding.GB18030] = "GB18030";
            Encoding.javaname[Encoding.HZ] = "ASCII";
            Encoding.javaname[Encoding.ISO2022CN_GB] = "ISO2022CN_GB";
            Encoding.javaname[Encoding.BIG5] = "BIG5";
            Encoding.javaname[Encoding.CNS11643] = "EUC-TW";
            Encoding.javaname[Encoding.ISO2022CN_CNS] = "ISO2022CN_CNS";
            Encoding.javaname[Encoding.ISO2022CN] = "ISO2022CN";
            Encoding.javaname[Encoding.UTF8] = "UTF-8";
            Encoding.javaname[Encoding.UTF8T] = "UTF-8";
            Encoding.javaname[Encoding.UTF8S] = "UTF-8";
            Encoding.javaname[Encoding.UNICODE] = "Unicode";
            Encoding.javaname[Encoding.UNICODET] = "Unicode";
            Encoding.javaname[Encoding.UNICODES] = "Unicode";
            Encoding.javaname[Encoding.EUC_KR] = "EUC_KR";
            Encoding.javaname[Encoding.CP949] = "MS949";
            Encoding.javaname[Encoding.ISO2022KR] = "ISO2022KR";
            Encoding.javaname[Encoding.JOHAB] = "Johab";
            Encoding.javaname[Encoding.SJIS] = "SJIS";
            Encoding.javaname[Encoding.EUC_JP] = "EUC_JP";
            Encoding.javaname[Encoding.ISO2022JP] = "ISO2022JP";
            Encoding.javaname[Encoding.ASCII] = "ASCII";
            Encoding.javaname[Encoding.OTHER] = "ISO8859_1";
            Encoding.htmlname[Encoding.GB2312] = "GB2312";
            Encoding.htmlname[Encoding.GBK] = "GBK";
            Encoding.htmlname[Encoding.GB18030] = "GB18030";
            Encoding.htmlname[Encoding.HZ] = "HZ-GB-2312";
            Encoding.htmlname[Encoding.ISO2022CN_GB] = "ISO-2022-CN-EXT";
            Encoding.htmlname[Encoding.BIG5] = "BIG5";
            Encoding.htmlname[Encoding.CNS11643] = "EUC-TW";
            Encoding.htmlname[Encoding.ISO2022CN_CNS] = "ISO-2022-CN-EXT";
            Encoding.htmlname[Encoding.ISO2022CN] = "ISO-2022-CN";
            Encoding.htmlname[Encoding.UTF8] = "UTF-8";
            Encoding.htmlname[Encoding.UTF8T] = "UTF-8";
            Encoding.htmlname[Encoding.UTF8S] = "UTF-8";
            Encoding.htmlname[Encoding.UNICODE] = "UTF-16";
            Encoding.htmlname[Encoding.UNICODET] = "UTF-16";
            Encoding.htmlname[Encoding.UNICODES] = "UTF-16";
            Encoding.htmlname[Encoding.EUC_KR] = "EUC-KR";
            Encoding.htmlname[Encoding.CP949] = "x-windows-949";
            Encoding.htmlname[Encoding.ISO2022KR] = "ISO-2022-KR";
            Encoding.htmlname[Encoding.JOHAB] = "x-Johab";
            Encoding.htmlname[Encoding.SJIS] = "Shift_JIS";
            Encoding.htmlname[Encoding.EUC_JP] = "EUC-JP";
            Encoding.htmlname[Encoding.ISO2022JP] = "ISO-2022-JP";
            Encoding.htmlname[Encoding.ASCII] = "ASCII";
            Encoding.htmlname[Encoding.OTHER] = "ISO8859-1";
            Encoding.nicename[Encoding.GB2312] = "GB-2312";
            Encoding.nicename[Encoding.GBK] = "GBK";
            Encoding.nicename[Encoding.GB18030] = "GB18030";
            Encoding.nicename[Encoding.HZ] = "HZ";
            Encoding.nicename[Encoding.ISO2022CN_GB] = "ISO2022CN-GB";
            Encoding.nicename[Encoding.BIG5] = "Big5";
            Encoding.nicename[Encoding.CNS11643] = "CNS11643";
            Encoding.nicename[Encoding.ISO2022CN_CNS] = "ISO2022CN-CNS";
            Encoding.nicename[Encoding.ISO2022CN] = "ISO2022 CN";
            Encoding.nicename[Encoding.UTF8] = "UTF-8";
            Encoding.nicename[Encoding.UTF8T] = "UTF-8 (Trad)";
            Encoding.nicename[Encoding.UTF8S] = "UTF-8 (Simp)";
            Encoding.nicename[Encoding.UNICODE] = "Unicode";
            Encoding.nicename[Encoding.UNICODET] = "Unicode (Trad)";
            Encoding.nicename[Encoding.UNICODES] = "Unicode (Simp)";
            Encoding.nicename[Encoding.EUC_KR] = "EUC-KR";
            Encoding.nicename[Encoding.CP949] = "CP949";
            Encoding.nicename[Encoding.ISO2022KR] = "ISO 2022 KR";
            Encoding.nicename[Encoding.JOHAB] = "Johab";
            Encoding.nicename[Encoding.SJIS] = "Shift-JIS";
            Encoding.nicename[Encoding.EUC_JP] = "EUC-JP";
            Encoding.nicename[Encoding.ISO2022JP] = "ISO 2022 JP";
            Encoding.nicename[Encoding.ASCII] = "ASCII";
            Encoding.nicename[Encoding.OTHER] = "OTHER";
        }
    }

    static class BytesEncodingDetect
    extends Encoding {
        public boolean debug = false;
        int[][] GBFreq = new int[94][94];
        int[][] GBKFreq = new int[126][191];
        int[][] Big5Freq = new int[94][158];
        int[][] Big5PFreq = new int[126][191];
        int[][] EUC_TWFreq = new int[94][94];
        int[][] KRFreq = new int[94][94];
        int[][] JPFreq = new int[94][94];

        public BytesEncodingDetect() {
            this.initialize_frequencies();
        }

        public int detectEncoding(URL testurl) {
            byte[] rawtext = new byte[10000];
            int bytesread = 0;
            int byteoffset = 0;
            int guess = OTHER;
            try {
                InputStream is = testurl.openStream();
                while ((bytesread = is.read(rawtext, byteoffset, rawtext.length - byteoffset)) > 0) {
                    byteoffset += bytesread;
                }
                is.close();
                guess = this.detectEncoding(rawtext);
            }
            catch (Exception e) {
                System.err.println("Error loading or using URL " + e.toString());
                guess = -1;
            }
            return guess;
        }

        public int detectEncoding(File testfile) {
            byte[] rawtext = new byte[(int)testfile.length()];
            try {
                FileInputStream fileis = new FileInputStream(testfile);
                fileis.read(rawtext);
                fileis.close();
            }
            catch (Exception e) {
                System.err.println("Error: " + e);
                System.err.println();
            }
            return this.detectEncoding(rawtext);
        }

        public int detectEncoding(byte[] rawtext) {
            int maxscore = 0;
            int encoding_guess = OTHER;
            int[] scores = new int[TOTALTYPES];
            scores[BytesEncodingDetect.GB2312] = this.gb2312_probability(rawtext);
            scores[BytesEncodingDetect.GBK] = this.gbk_probability(rawtext);
            scores[BytesEncodingDetect.GB18030] = this.gb18030_probability(rawtext);
            scores[BytesEncodingDetect.HZ] = this.hz_probability(rawtext);
            scores[BytesEncodingDetect.BIG5] = this.big5_probability(rawtext);
            scores[BytesEncodingDetect.CNS11643] = this.euc_tw_probability(rawtext);
            scores[BytesEncodingDetect.ISO2022CN] = this.iso_2022_cn_probability(rawtext);
            scores[BytesEncodingDetect.UTF8] = this.utf8_probability(rawtext);
            scores[BytesEncodingDetect.UNICODE] = this.utf16_probability(rawtext);
            scores[BytesEncodingDetect.EUC_KR] = this.euc_kr_probability(rawtext);
            scores[BytesEncodingDetect.CP949] = this.cp949_probability(rawtext);
            scores[BytesEncodingDetect.JOHAB] = 0;
            scores[BytesEncodingDetect.ISO2022KR] = this.iso_2022_kr_probability(rawtext);
            scores[BytesEncodingDetect.ASCII] = this.ascii_probability(rawtext);
            scores[BytesEncodingDetect.SJIS] = this.sjis_probability(rawtext);
            scores[BytesEncodingDetect.EUC_JP] = this.euc_jp_probability(rawtext);
            scores[BytesEncodingDetect.ISO2022JP] = this.iso_2022_jp_probability(rawtext);
            scores[BytesEncodingDetect.UNICODET] = 0;
            scores[BytesEncodingDetect.UNICODES] = 0;
            scores[BytesEncodingDetect.ISO2022CN_GB] = 0;
            scores[BytesEncodingDetect.ISO2022CN_CNS] = 0;
            scores[BytesEncodingDetect.OTHER] = 0;
            for (int index = 0; index < TOTALTYPES; ++index) {
                if (this.debug) {
                    System.err.println("Encoding " + nicename[index] + " score " + scores[index]);
                }
                if (scores[index] <= maxscore) continue;
                encoding_guess = index;
                maxscore = scores[index];
            }
            if (maxscore <= 50) {
                encoding_guess = OTHER;
            }
            return encoding_guess;
        }

        int gb2312_probability(byte[] rawtext) {
            int rawtextlen = 0;
            int dbchars = 1;
            int gbchars = 1;
            long gbfreq = 0L;
            long totalfreq = 1L;
            float rangeval = 0.0f;
            float freqval = 0.0f;
            rawtextlen = rawtext.length;
            for (int i = 0; i < rawtextlen - 1; ++i) {
                if (rawtext[i] >= 0) continue;
                ++dbchars;
                if (-95 <= rawtext[i] && rawtext[i] <= -9 && -95 <= rawtext[i + 1] && rawtext[i + 1] <= -2) {
                    ++gbchars;
                    totalfreq += 500L;
                    int row = rawtext[i] + 256 - 161;
                    int column = rawtext[i + 1] + 256 - 161;
                    if (this.GBFreq[row][column] != 0) {
                        gbfreq += (long)this.GBFreq[row][column];
                    } else if (15 <= row && row < 55) {
                        gbfreq += 200L;
                    }
                }
                ++i;
            }
            rangeval = 50.0f * ((float)gbchars / (float)dbchars);
            freqval = 50.0f * ((float)gbfreq / (float)totalfreq);
            return (int)(rangeval + freqval);
        }

        int gbk_probability(byte[] rawtext) {
            int rawtextlen = 0;
            int dbchars = 1;
            int gbchars = 1;
            long gbfreq = 0L;
            long totalfreq = 1L;
            float rangeval = 0.0f;
            float freqval = 0.0f;
            rawtextlen = rawtext.length;
            for (int i = 0; i < rawtextlen - 1; ++i) {
                int column;
                int row;
                if (rawtext[i] >= 0) continue;
                ++dbchars;
                if (-95 <= rawtext[i] && rawtext[i] <= -9 && -95 <= rawtext[i + 1] && rawtext[i + 1] <= -2) {
                    ++gbchars;
                    totalfreq += 500L;
                    row = rawtext[i] + 256 - 161;
                    column = rawtext[i + 1] + 256 - 161;
                    if (this.GBFreq[row][column] != 0) {
                        gbfreq += (long)this.GBFreq[row][column];
                    } else if (15 <= row && row < 55) {
                        gbfreq += 200L;
                    }
                } else if (-127 <= rawtext[i] && rawtext[i] <= -2 && (-128 <= rawtext[i + 1] && rawtext[i + 1] <= -2 || 64 <= rawtext[i + 1] && rawtext[i + 1] <= 126)) {
                    ++gbchars;
                    totalfreq += 500L;
                    row = rawtext[i] + 256 - 129;
                    column = 64 <= rawtext[i + 1] && rawtext[i + 1] <= 126 ? rawtext[i + 1] - 64 : rawtext[i + 1] + 256 - 64;
                    if (this.GBKFreq[row][column] != 0) {
                        gbfreq += (long)this.GBKFreq[row][column];
                    }
                }
                ++i;
            }
            rangeval = 50.0f * ((float)gbchars / (float)dbchars);
            freqval = 50.0f * ((float)gbfreq / (float)totalfreq);
            return (int)(rangeval + freqval) - 1;
        }

        int gb18030_probability(byte[] rawtext) {
            int rawtextlen = 0;
            int dbchars = 1;
            int gbchars = 1;
            long gbfreq = 0L;
            long totalfreq = 1L;
            float rangeval = 0.0f;
            float freqval = 0.0f;
            rawtextlen = rawtext.length;
            for (int i = 0; i < rawtextlen - 1; ++i) {
                int column;
                int row;
                if (rawtext[i] >= 0) continue;
                ++dbchars;
                if (-95 <= rawtext[i] && rawtext[i] <= -9 && i + 1 < rawtextlen && -95 <= rawtext[i + 1] && rawtext[i + 1] <= -2) {
                    ++gbchars;
                    totalfreq += 500L;
                    row = rawtext[i] + 256 - 161;
                    column = rawtext[i + 1] + 256 - 161;
                    if (this.GBFreq[row][column] != 0) {
                        gbfreq += (long)this.GBFreq[row][column];
                    } else if (15 <= row && row < 55) {
                        gbfreq += 200L;
                    }
                } else if (-127 <= rawtext[i] && rawtext[i] <= -2 && i + 1 < rawtextlen && (-128 <= rawtext[i + 1] && rawtext[i + 1] <= -2 || 64 <= rawtext[i + 1] && rawtext[i + 1] <= 126)) {
                    ++gbchars;
                    totalfreq += 500L;
                    row = rawtext[i] + 256 - 129;
                    column = 64 <= rawtext[i + 1] && rawtext[i + 1] <= 126 ? rawtext[i + 1] - 64 : rawtext[i + 1] + 256 - 64;
                    if (this.GBKFreq[row][column] != 0) {
                        gbfreq += (long)this.GBKFreq[row][column];
                    }
                } else if (-127 <= rawtext[i] && rawtext[i] <= -2 && i + 3 < rawtextlen && 48 <= rawtext[i + 1] && rawtext[i + 1] <= 57 && -127 <= rawtext[i + 2] && rawtext[i + 2] <= -2 && 48 <= rawtext[i + 3] && rawtext[i + 3] <= 57) {
                    ++gbchars;
                }
                ++i;
            }
            rangeval = 50.0f * ((float)gbchars / (float)dbchars);
            freqval = 50.0f * ((float)gbfreq / (float)totalfreq);
            return (int)(rangeval + freqval) - 1;
        }

        int hz_probability(byte[] rawtext) {
            int hzchars = 0;
            int dbchars = 1;
            long hzfreq = 0L;
            long totalfreq = 1L;
            float rangeval = 0.0f;
            float freqval = 0.0f;
            int hzstart = 0;
            int hzend = 0;
            int rawtextlen = rawtext.length;
            block0: for (int i = 0; i < rawtextlen; ++i) {
                if (rawtext[i] != 126) continue;
                if (rawtext[i + 1] == 123) {
                    ++hzstart;
                    i += 2;
                    while (i < rawtextlen - 1 && rawtext[i] != 10 && rawtext[i] != 13) {
                        int column;
                        int row;
                        if (rawtext[i] == 126 && rawtext[i + 1] == 125) {
                            ++hzend;
                            ++i;
                            continue block0;
                        }
                        if (33 <= rawtext[i] && rawtext[i] <= 119 && 33 <= rawtext[i + 1] && rawtext[i + 1] <= 119) {
                            hzchars += 2;
                            row = rawtext[i] - 33;
                            column = rawtext[i + 1] - 33;
                            totalfreq += 500L;
                            if (this.GBFreq[row][column] != 0) {
                                hzfreq += (long)this.GBFreq[row][column];
                            } else if (15 <= row && row < 55) {
                                hzfreq += 200L;
                            }
                        } else if (161 <= rawtext[i] && rawtext[i] <= 247 && 161 <= rawtext[i + 1] && rawtext[i + 1] <= 247) {
                            hzchars += 2;
                            row = rawtext[i] + 256 - 161;
                            column = rawtext[i + 1] + 256 - 161;
                            totalfreq += 500L;
                            if (this.GBFreq[row][column] != 0) {
                                hzfreq += (long)this.GBFreq[row][column];
                            } else if (15 <= row && row < 55) {
                                hzfreq += 200L;
                            }
                        }
                        dbchars += 2;
                        i += 2;
                    }
                    continue;
                }
                if (rawtext[i + 1] == 125) {
                    ++hzend;
                    ++i;
                    continue;
                }
                if (rawtext[i + 1] != 126) continue;
                ++i;
            }
            rangeval = hzstart > 4 ? 50.0f : (hzstart > 1 ? 41.0f : (hzstart > 0 ? 39.0f : 0.0f));
            freqval = 50.0f * ((float)hzfreq / (float)totalfreq);
            return (int)(rangeval + freqval);
        }

        int big5_probability(byte[] rawtext) {
            int rawtextlen = 0;
            int dbchars = 1;
            int bfchars = 1;
            float rangeval = 0.0f;
            float freqval = 0.0f;
            long bffreq = 0L;
            long totalfreq = 1L;
            rawtextlen = rawtext.length;
            for (int i = 0; i < rawtextlen - 1; ++i) {
                if (rawtext[i] >= 0) continue;
                ++dbchars;
                if (-95 <= rawtext[i] && rawtext[i] <= -7 && (64 <= rawtext[i + 1] && rawtext[i + 1] <= 126 || -95 <= rawtext[i + 1] && rawtext[i + 1] <= -2)) {
                    ++bfchars;
                    totalfreq += 500L;
                    int row = rawtext[i] + 256 - 161;
                    int column = 64 <= rawtext[i + 1] && rawtext[i + 1] <= 126 ? rawtext[i + 1] - 64 : rawtext[i + 1] + 256 - 97;
                    if (this.Big5Freq[row][column] != 0) {
                        bffreq += (long)this.Big5Freq[row][column];
                    } else if (3 <= row && row <= 37) {
                        bffreq += 200L;
                    }
                }
                ++i;
            }
            rangeval = 50.0f * ((float)bfchars / (float)dbchars);
            freqval = 50.0f * ((float)bffreq / (float)totalfreq);
            return (int)(rangeval + freqval);
        }

        int big5plus_probability(byte[] rawtext) {
            int rawtextlen = 0;
            int dbchars = 1;
            int bfchars = 1;
            long bffreq = 0L;
            long totalfreq = 1L;
            float rangeval = 0.0f;
            float freqval = 0.0f;
            rawtextlen = rawtext.length;
            for (int i = 0; i < rawtextlen - 1; ++i) {
                int column;
                int row;
                if (rawtext[i] >= 128) continue;
                ++dbchars;
                if (161 <= rawtext[i] && rawtext[i] <= 249 && (64 <= rawtext[i + 1] && rawtext[i + 1] <= 126 || 161 <= rawtext[i + 1] && rawtext[i + 1] <= 254)) {
                    ++bfchars;
                    totalfreq += 500L;
                    row = rawtext[i] - 161;
                    column = 64 <= rawtext[i + 1] && rawtext[i + 1] <= 126 ? rawtext[i + 1] - 64 : rawtext[i + 1] - 97;
                    if (this.Big5Freq[row][column] != 0) {
                        bffreq += (long)this.Big5Freq[row][column];
                    } else if (3 <= row && row < 37) {
                        bffreq += 200L;
                    }
                } else if (129 <= rawtext[i] && rawtext[i] <= 254 && (64 <= rawtext[i + 1] && rawtext[i + 1] <= 126 || 128 <= rawtext[i + 1] && rawtext[i + 1] <= 254)) {
                    ++bfchars;
                    totalfreq += 500L;
                    row = rawtext[i] - 129;
                    column = 64 <= rawtext[i + 1] && rawtext[i + 1] <= 126 ? rawtext[i + 1] - 64 : rawtext[i + 1] - 64;
                    if (this.Big5PFreq[row][column] != 0) {
                        bffreq += (long)this.Big5PFreq[row][column];
                    }
                }
                ++i;
            }
            rangeval = 50.0f * ((float)bfchars / (float)dbchars);
            freqval = 50.0f * ((float)bffreq / (float)totalfreq);
            return (int)(rangeval + freqval) - 1;
        }

        int euc_tw_probability(byte[] rawtext) {
            int rawtextlen = 0;
            int dbchars = 1;
            int cnschars = 1;
            long cnsfreq = 0L;
            long totalfreq = 1L;
            float rangeval = 0.0f;
            float freqval = 0.0f;
            rawtextlen = rawtext.length;
            for (int i = 0; i < rawtextlen - 1; ++i) {
                if (rawtext[i] >= 0) continue;
                ++dbchars;
                if (i + 3 < rawtextlen && -114 == rawtext[i] && -95 <= rawtext[i + 1] && rawtext[i + 1] <= -80 && -95 <= rawtext[i + 2] && rawtext[i + 2] <= -2 && -95 <= rawtext[i + 3] && rawtext[i + 3] <= -2) {
                    ++cnschars;
                    i += 3;
                    continue;
                }
                if (-95 > rawtext[i] || rawtext[i] > -2 || -95 > rawtext[i + 1] || rawtext[i + 1] > -2) continue;
                ++cnschars;
                totalfreq += 500L;
                int row = rawtext[i] + 256 - 161;
                int column = rawtext[i + 1] + 256 - 161;
                if (this.EUC_TWFreq[row][column] != 0) {
                    cnsfreq += (long)this.EUC_TWFreq[row][column];
                } else if (35 <= row && row <= 92) {
                    cnsfreq += 150L;
                }
                ++i;
            }
            rangeval = 50.0f * ((float)cnschars / (float)dbchars);
            freqval = 50.0f * ((float)cnsfreq / (float)totalfreq);
            return (int)(rangeval + freqval);
        }

        int iso_2022_cn_probability(byte[] rawtext) {
            int rawtextlen = 0;
            int dbchars = 1;
            int isochars = 1;
            long isofreq = 0L;
            long totalfreq = 1L;
            float rangeval = 0.0f;
            float freqval = 0.0f;
            rawtextlen = rawtext.length;
            for (int i = 0; i < rawtextlen - 1; ++i) {
                int column;
                int row;
                if (rawtext[i] != 27 || i + 3 >= rawtextlen) continue;
                if (rawtext[i + 1] == 36 && rawtext[i + 2] == 41 && rawtext[i + 3] == 65) {
                    i += 4;
                    while (rawtext[i] != 27) {
                        ++dbchars;
                        if (33 <= rawtext[i] && rawtext[i] <= 119 && 33 <= rawtext[i + 1] && rawtext[i + 1] <= 119) {
                            ++isochars;
                            row = rawtext[i] - 33;
                            column = rawtext[i + 1] - 33;
                            totalfreq += 500L;
                            if (this.GBFreq[row][column] != 0) {
                                isofreq += (long)this.GBFreq[row][column];
                            } else if (15 <= row && row < 55) {
                                isofreq += 200L;
                            }
                            ++i;
                        }
                        ++i;
                    }
                } else if (i + 3 < rawtextlen && rawtext[i + 1] == 36 && rawtext[i + 2] == 41 && rawtext[i + 3] == 71) {
                    i += 4;
                    while (rawtext[i] != 27) {
                        ++dbchars;
                        if (33 <= rawtext[i] && rawtext[i] <= 126 && 33 <= rawtext[i + 1] && rawtext[i + 1] <= 126) {
                            ++isochars;
                            totalfreq += 500L;
                            row = rawtext[i] - 33;
                            column = rawtext[i + 1] - 33;
                            if (this.EUC_TWFreq[row][column] != 0) {
                                isofreq += (long)this.EUC_TWFreq[row][column];
                            } else if (35 <= row && row <= 92) {
                                isofreq += 150L;
                            }
                            ++i;
                        }
                        ++i;
                    }
                }
                if (rawtext[i] != 27 || i + 2 >= rawtextlen || rawtext[i + 1] != 40 || rawtext[i + 2] != 66) continue;
                i += 2;
            }
            rangeval = 50.0f * ((float)isochars / (float)dbchars);
            freqval = 50.0f * ((float)isofreq / (float)totalfreq);
            return (int)(rangeval + freqval);
        }

        int utf8_probability(byte[] rawtext) {
            int score = 0;
            int rawtextlen = 0;
            int goodbytes = 0;
            int asciibytes = 0;
            rawtextlen = rawtext.length;
            for (int i = 0; i < rawtextlen; ++i) {
                if ((rawtext[i] & 0x7F) == rawtext[i]) {
                    ++asciibytes;
                    continue;
                }
                if (-64 <= rawtext[i] && rawtext[i] <= -33 && i + 1 < rawtextlen && -128 <= rawtext[i + 1] && rawtext[i + 1] <= -65) {
                    goodbytes += 2;
                    ++i;
                    continue;
                }
                if (-32 > rawtext[i] || rawtext[i] > -17 || i + 2 >= rawtextlen || -128 > rawtext[i + 1] || rawtext[i + 1] > -65 || -128 > rawtext[i + 2] || rawtext[i + 2] > -65) continue;
                goodbytes += 3;
                i += 2;
            }
            if (asciibytes == rawtextlen) {
                return 0;
            }
            score = (int)(100.0f * ((float)goodbytes / (float)(rawtextlen - asciibytes)));
            if (score > 98) {
                return score;
            }
            if (score > 95 && goodbytes > 30) {
                return score;
            }
            return 0;
        }

        int utf16_probability(byte[] rawtext) {
            if (rawtext.length > 1 && -2 == rawtext[0] && -1 == rawtext[1] || -1 == rawtext[0] && -2 == rawtext[1]) {
                return 100;
            }
            return 0;
        }

        int ascii_probability(byte[] rawtext) {
            int score = 75;
            int rawtextlen = rawtext.length;
            for (int i = 0; i < rawtextlen; ++i) {
                if (rawtext[i] < 0) {
                    score -= 5;
                } else if (rawtext[i] == 27) {
                    score -= 5;
                }
                if (score > 0) continue;
                return 0;
            }
            return score;
        }

        int euc_kr_probability(byte[] rawtext) {
            int rawtextlen = 0;
            int dbchars = 1;
            int krchars = 1;
            long krfreq = 0L;
            long totalfreq = 1L;
            float rangeval = 0.0f;
            float freqval = 0.0f;
            rawtextlen = rawtext.length;
            for (int i = 0; i < rawtextlen - 1; ++i) {
                if (rawtext[i] >= 0) continue;
                ++dbchars;
                if (-95 <= rawtext[i] && rawtext[i] <= -2 && -95 <= rawtext[i + 1] && rawtext[i + 1] <= -2) {
                    ++krchars;
                    totalfreq += 500L;
                    int row = rawtext[i] + 256 - 161;
                    int column = rawtext[i + 1] + 256 - 161;
                    if (this.KRFreq[row][column] != 0) {
                        krfreq += (long)this.KRFreq[row][column];
                    } else if (15 <= row && row < 55) {
                        krfreq += 0L;
                    }
                }
                ++i;
            }
            rangeval = 50.0f * ((float)krchars / (float)dbchars);
            freqval = 50.0f * ((float)krfreq / (float)totalfreq);
            return (int)(rangeval + freqval);
        }

        int cp949_probability(byte[] rawtext) {
            int rawtextlen = 0;
            int dbchars = 1;
            int krchars = 1;
            long krfreq = 0L;
            long totalfreq = 1L;
            float rangeval = 0.0f;
            float freqval = 0.0f;
            rawtextlen = rawtext.length;
            for (int i = 0; i < rawtextlen - 1; ++i) {
                if (rawtext[i] >= 0) continue;
                ++dbchars;
                if (-127 <= rawtext[i] && rawtext[i] <= -2 && (65 <= rawtext[i + 1] && rawtext[i + 1] <= 90 || 97 <= rawtext[i + 1] && rawtext[i + 1] <= 122 || -127 <= rawtext[i + 1] && rawtext[i + 1] <= -2)) {
                    int column;
                    int row;
                    ++krchars;
                    totalfreq += 500L;
                    if (-95 <= rawtext[i] && rawtext[i] <= -2 && -95 <= rawtext[i + 1] && rawtext[i + 1] <= -2 && this.KRFreq[row = rawtext[i] + 256 - 161][column = rawtext[i + 1] + 256 - 161] != 0) {
                        krfreq += (long)this.KRFreq[row][column];
                    }
                }
                ++i;
            }
            rangeval = 50.0f * ((float)krchars / (float)dbchars);
            freqval = 50.0f * ((float)krfreq / (float)totalfreq);
            return (int)(rangeval + freqval);
        }

        int iso_2022_kr_probability(byte[] rawtext) {
            for (int i = 0; i < rawtext.length; ++i) {
                if (i + 3 >= rawtext.length || rawtext[i] != 27 || (char)rawtext[i + 1] != '$' || (char)rawtext[i + 2] != ')' || (char)rawtext[i + 3] != 'C') continue;
                return 100;
            }
            return 0;
        }

        int euc_jp_probability(byte[] rawtext) {
            int rawtextlen = 0;
            int dbchars = 1;
            int jpchars = 1;
            long jpfreq = 0L;
            long totalfreq = 1L;
            float rangeval = 0.0f;
            float freqval = 0.0f;
            rawtextlen = rawtext.length;
            for (int i = 0; i < rawtextlen - 1; ++i) {
                if (rawtext[i] >= 0) continue;
                ++dbchars;
                if (-95 <= rawtext[i] && rawtext[i] <= -2 && -95 <= rawtext[i + 1] && rawtext[i + 1] <= -2) {
                    ++jpchars;
                    totalfreq += 500L;
                    int row = rawtext[i] + 256 - 161;
                    int column = rawtext[i + 1] + 256 - 161;
                    if (this.JPFreq[row][column] != 0) {
                        jpfreq += (long)this.JPFreq[row][column];
                    } else if (15 <= row && row < 55) {
                        jpfreq += 0L;
                    }
                }
                ++i;
            }
            rangeval = 50.0f * ((float)jpchars / (float)dbchars);
            freqval = 50.0f * ((float)jpfreq / (float)totalfreq);
            return (int)(rangeval + freqval);
        }

        int iso_2022_jp_probability(byte[] rawtext) {
            for (int i = 0; i < rawtext.length; ++i) {
                if (i + 2 >= rawtext.length || rawtext[i] != 27 || (char)rawtext[i + 1] != '$' || (char)rawtext[i + 2] != 'B') continue;
                return 100;
            }
            return 0;
        }

        int sjis_probability(byte[] rawtext) {
            int rawtextlen = 0;
            int dbchars = 1;
            int jpchars = 1;
            long jpfreq = 0L;
            long totalfreq = 1L;
            float rangeval = 0.0f;
            float freqval = 0.0f;
            rawtextlen = rawtext.length;
            for (int i = 0; i < rawtextlen - 1; ++i) {
                if (rawtext[i] >= 0) continue;
                ++dbchars;
                if (i + 1 < rawtext.length && (-127 <= rawtext[i] && rawtext[i] <= -97 || -32 <= rawtext[i] && rawtext[i] <= -17) && (64 <= rawtext[i + 1] && rawtext[i + 1] <= 126 || -128 <= rawtext[i + 1] && rawtext[i + 1] <= -4)) {
                    int adjust;
                    ++jpchars;
                    totalfreq += 500L;
                    int row = rawtext[i] + 256;
                    int column = rawtext[i + 1] + 256;
                    if (column < 159) {
                        adjust = 1;
                        column = column > 127 ? (column -= 32) : (column -= 25);
                    } else {
                        adjust = 0;
                        column -= 126;
                    }
                    row = row < 160 ? (row - 112 << 1) - adjust : (row - 176 << 1) - adjust;
                    column = 32;
                    if ((row -= 32) < this.JPFreq.length && column < this.JPFreq[row].length && this.JPFreq[row][column] != 0) {
                        jpfreq += (long)this.JPFreq[row][column];
                    }
                    ++i;
                    continue;
                }
                if (-95 <= rawtext[i] && rawtext[i] > -33) continue;
            }
            rangeval = 50.0f * ((float)jpchars / (float)dbchars);
            freqval = 50.0f * ((float)jpfreq / (float)totalfreq);
            return (int)(rangeval + freqval) - 1;
        }

        /*
         * Opcode count of 23256 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
         */
        void initialize_frequencies() {
            int j;
            int i;
            for (i = 0; i < 94; ++i) {
                for (j = 0; j < 94; ++j) {
                    this.GBFreq[i][j] = 0;
                }
            }
            for (i = 0; i < 126; ++i) {
                for (j = 0; j < 191; ++j) {
                    this.GBKFreq[i][j] = 0;
                }
            }
            for (i = 0; i < 94; ++i) {
                for (j = 0; j < 158; ++j) {
                    this.Big5Freq[i][j] = 0;
                }
            }
            for (i = 0; i < 126; ++i) {
                for (j = 0; j < 191; ++j) {
                    this.Big5PFreq[i][j] = 0;
                }
            }
            for (i = 0; i < 94; ++i) {
                for (j = 0; j < 94; ++j) {
                    this.EUC_TWFreq[i][j] = 0;
                }
            }
            for (i = 0; i < 94; ++i) {
                for (j = 0; j < 94; ++j) {
                    this.JPFreq[i][j] = 0;
                }
            }
            this.GBFreq[20][35] = 599;
            this.GBFreq[49][26] = 598;
            this.GBFreq[41][38] = 597;
            this.GBFreq[17][26] = 596;
            this.GBFreq[32][42] = 595;
            this.GBFreq[39][42] = 594;
            this.GBFreq[45][49] = 593;
            this.GBFreq[51][57] = 592;
            this.GBFreq[50][47] = 591;
            this.GBFreq[42][90] = 590;
            this.GBFreq[52][65] = 589;
            this.GBFreq[53][47] = 588;
            this.GBFreq[19][82] = 587;
            this.GBFreq[31][19] = 586;
            this.GBFreq[40][46] = 585;
            this.GBFreq[24][89] = 584;
            this.GBFreq[23][85] = 583;
            this.GBFreq[20][28] = 582;
            this.GBFreq[42][20] = 581;
            this.GBFreq[34][38] = 580;
            this.GBFreq[45][9] = 579;
            this.GBFreq[54][50] = 578;
            this.GBFreq[25][44] = 577;
            this.GBFreq[35][66] = 576;
            this.GBFreq[20][55] = 575;
            this.GBFreq[18][85] = 574;
            this.GBFreq[20][31] = 573;
            this.GBFreq[49][17] = 572;
            this.GBFreq[41][16] = 571;
            this.GBFreq[35][73] = 570;
            this.GBFreq[20][34] = 569;
            this.GBFreq[29][44] = 568;
            this.GBFreq[35][38] = 567;
            this.GBFreq[49][9] = 566;
            this.GBFreq[46][33] = 565;
            this.GBFreq[49][51] = 564;
            this.GBFreq[40][89] = 563;
            this.GBFreq[26][64] = 562;
            this.GBFreq[54][51] = 561;
            this.GBFreq[54][36] = 560;
            this.GBFreq[39][4] = 559;
            this.GBFreq[53][13] = 558;
            this.GBFreq[24][92] = 557;
            this.GBFreq[27][49] = 556;
            this.GBFreq[48][6] = 555;
            this.GBFreq[21][51] = 554;
            this.GBFreq[30][40] = 553;
            this.GBFreq[42][92] = 552;
            this.GBFreq[31][78] = 551;
            this.GBFreq[25][82] = 550;
            this.GBFreq[47][0] = 549;
            this.GBFreq[34][19] = 548;
            this.GBFreq[47][35] = 547;
            this.GBFreq[21][63] = 546;
            this.GBFreq[43][75] = 545;
            this.GBFreq[21][87] = 544;
            this.GBFreq[35][59] = 543;
            this.GBFreq[25][34] = 542;
            this.GBFreq[21][27] = 541;
            this.GBFreq[39][26] = 540;
            this.GBFreq[34][26] = 539;
            this.GBFreq[39][52] = 538;
            this.GBFreq[50][57] = 537;
            this.GBFreq[37][79] = 536;
            this.GBFreq[26][24] = 535;
            this.GBFreq[22][1] = 534;
            this.GBFreq[18][40] = 533;
            this.GBFreq[41][33] = 532;
            this.GBFreq[53][26] = 531;
            this.GBFreq[54][86] = 530;
            this.GBFreq[20][16] = 529;
            this.GBFreq[46][74] = 528;
            this.GBFreq[30][19] = 527;
            this.GBFreq[45][35] = 526;
            this.GBFreq[45][61] = 525;
            this.GBFreq[30][9] = 524;
            this.GBFreq[41][53] = 523;
            this.GBFreq[41][13] = 522;
            this.GBFreq[50][34] = 521;
            this.GBFreq[53][86] = 520;
            this.GBFreq[47][47] = 519;
            this.GBFreq[22][28] = 518;
            this.GBFreq[50][53] = 517;
            this.GBFreq[39][70] = 516;
            this.GBFreq[38][15] = 515;
            this.GBFreq[42][88] = 514;
            this.GBFreq[16][29] = 513;
            this.GBFreq[27][90] = 512;
            this.GBFreq[29][12] = 511;
            this.GBFreq[44][22] = 510;
            this.GBFreq[34][69] = 509;
            this.GBFreq[24][10] = 508;
            this.GBFreq[44][11] = 507;
            this.GBFreq[39][92] = 506;
            this.GBFreq[49][48] = 505;
            this.GBFreq[31][46] = 504;
            this.GBFreq[19][50] = 503;
            this.GBFreq[21][14] = 502;
            this.GBFreq[32][28] = 501;
            this.GBFreq[18][3] = 500;
            this.GBFreq[53][9] = 499;
            this.GBFreq[34][80] = 498;
            this.GBFreq[48][88] = 497;
            this.GBFreq[46][53] = 496;
            this.GBFreq[22][53] = 495;
            this.GBFreq[28][10] = 494;
            this.GBFreq[44][65] = 493;
            this.GBFreq[20][10] = 492;
            this.GBFreq[40][76] = 491;
            this.GBFreq[47][8] = 490;
            this.GBFreq[50][74] = 489;
            this.GBFreq[23][62] = 488;
            this.GBFreq[49][65] = 487;
            this.GBFreq[28][87] = 486;
            this.GBFreq[15][48] = 485;
            this.GBFreq[22][7] = 484;
            this.GBFreq[19][42] = 483;
            this.GBFreq[41][20] = 482;
            this.GBFreq[26][55] = 481;
            this.GBFreq[21][93] = 480;
            this.GBFreq[31][76] = 479;
            this.GBFreq[34][31] = 478;
            this.GBFreq[20][66] = 477;
            this.GBFreq[51][33] = 476;
            this.GBFreq[34][86] = 475;
            this.GBFreq[37][67] = 474;
            this.GBFreq[53][53] = 473;
            this.GBFreq[40][88] = 472;
            this.GBFreq[39][10] = 471;
            this.GBFreq[24][3] = 470;
            this.GBFreq[27][25] = 469;
            this.GBFreq[26][15] = 468;
            this.GBFreq[21][88] = 467;
            this.GBFreq[52][62] = 466;
            this.GBFreq[46][81] = 465;
            this.GBFreq[38][72] = 464;
            this.GBFreq[17][30] = 463;
            this.GBFreq[52][92] = 462;
            this.GBFreq[34][90] = 461;
            this.GBFreq[21][7] = 460;
            this.GBFreq[36][13] = 459;
            this.GBFreq[45][41] = 458;
            this.GBFreq[32][5] = 457;
            this.GBFreq[26][89] = 456;
            this.GBFreq[23][87] = 455;
            this.GBFreq[20][39] = 454;
            this.GBFreq[27][23] = 453;
            this.GBFreq[25][59] = 452;
            this.GBFreq[49][20] = 451;
            this.GBFreq[54][77] = 450;
            this.GBFreq[27][67] = 449;
            this.GBFreq[47][33] = 448;
            this.GBFreq[41][17] = 447;
            this.GBFreq[19][81] = 446;
            this.GBFreq[16][66] = 445;
            this.GBFreq[45][26] = 444;
            this.GBFreq[49][81] = 443;
            this.GBFreq[53][55] = 442;
            this.GBFreq[16][26] = 441;
            this.GBFreq[54][62] = 440;
            this.GBFreq[20][70] = 439;
            this.GBFreq[42][35] = 438;
            this.GBFreq[20][57] = 437;
            this.GBFreq[34][36] = 436;
            this.GBFreq[46][63] = 435;
            this.GBFreq[19][45] = 434;
            this.GBFreq[21][10] = 433;
            this.GBFreq[52][93] = 432;
            this.GBFreq[25][2] = 431;
            this.GBFreq[30][57] = 430;
            this.GBFreq[41][24] = 429;
            this.GBFreq[28][43] = 428;
            this.GBFreq[45][86] = 427;
            this.GBFreq[51][56] = 426;
            this.GBFreq[37][28] = 425;
            this.GBFreq[52][69] = 424;
            this.GBFreq[43][92] = 423;
            this.GBFreq[41][31] = 422;
            this.GBFreq[37][87] = 421;
            this.GBFreq[47][36] = 420;
            this.GBFreq[16][16] = 419;
            this.GBFreq[40][56] = 418;
            this.GBFreq[24][55] = 417;
            this.GBFreq[17][1] = 416;
            this.GBFreq[35][57] = 415;
            this.GBFreq[27][50] = 414;
            this.GBFreq[26][14] = 413;
            this.GBFreq[50][40] = 412;
            this.GBFreq[39][19] = 411;
            this.GBFreq[19][89] = 410;
            this.GBFreq[29][91] = 409;
            this.GBFreq[17][89] = 408;
            this.GBFreq[39][74] = 407;
            this.GBFreq[46][39] = 406;
            this.GBFreq[40][28] = 405;
            this.GBFreq[45][68] = 404;
            this.GBFreq[43][10] = 403;
            this.GBFreq[42][13] = 402;
            this.GBFreq[44][81] = 401;
            this.GBFreq[41][47] = 400;
            this.GBFreq[48][58] = 399;
            this.GBFreq[43][68] = 398;
            this.GBFreq[16][79] = 397;
            this.GBFreq[19][5] = 396;
            this.GBFreq[54][59] = 395;
            this.GBFreq[17][36] = 394;
            this.GBFreq[18][0] = 393;
            this.GBFreq[41][5] = 392;
            this.GBFreq[41][72] = 391;
            this.GBFreq[16][39] = 390;
            this.GBFreq[54][0] = 389;
            this.GBFreq[51][16] = 388;
            this.GBFreq[29][36] = 387;
            this.GBFreq[47][5] = 386;
            this.GBFreq[47][51] = 385;
            this.GBFreq[44][7] = 384;
            this.GBFreq[35][30] = 383;
            this.GBFreq[26][9] = 382;
            this.GBFreq[16][7] = 381;
            this.GBFreq[32][1] = 380;
            this.GBFreq[33][76] = 379;
            this.GBFreq[34][91] = 378;
            this.GBFreq[52][36] = 377;
            this.GBFreq[26][77] = 376;
            this.GBFreq[35][48] = 375;
            this.GBFreq[40][80] = 374;
            this.GBFreq[41][92] = 373;
            this.GBFreq[27][93] = 372;
            this.GBFreq[15][17] = 371;
            this.GBFreq[16][76] = 370;
            this.GBFreq[51][12] = 369;
            this.GBFreq[18][20] = 368;
            this.GBFreq[15][54] = 367;
            this.GBFreq[50][5] = 366;
            this.GBFreq[33][22] = 365;
            this.GBFreq[37][57] = 364;
            this.GBFreq[28][47] = 363;
            this.GBFreq[42][31] = 362;
            this.GBFreq[18][2] = 361;
            this.GBFreq[43][64] = 360;
            this.GBFreq[23][47] = 359;
            this.GBFreq[28][79] = 358;
            this.GBFreq[25][45] = 357;
            this.GBFreq[23][91] = 356;
            this.GBFreq[22][19] = 355;
            this.GBFreq[25][46] = 354;
            this.GBFreq[22][36] = 353;
            this.GBFreq[54][85] = 352;
            this.GBFreq[46][20] = 351;
            this.GBFreq[27][37] = 350;
            this.GBFreq[26][81] = 349;
            this.GBFreq[42][29] = 348;
            this.GBFreq[31][90] = 347;
            this.GBFreq[41][59] = 346;
            this.GBFreq[24][65] = 345;
            this.GBFreq[44][84] = 344;
            this.GBFreq[24][90] = 343;
            this.GBFreq[38][54] = 342;
            this.GBFreq[28][70] = 341;
            this.GBFreq[27][15] = 340;
            this.GBFreq[28][80] = 339;
            this.GBFreq[29][8] = 338;
            this.GBFreq[45][80] = 337;
            this.GBFreq[53][37] = 336;
            this.GBFreq[28][65] = 335;
            this.GBFreq[23][86] = 334;
            this.GBFreq[39][45] = 333;
            this.GBFreq[53][32] = 332;
            this.GBFreq[38][68] = 331;
            this.GBFreq[45][78] = 330;
            this.GBFreq[43][7] = 329;
            this.GBFreq[46][82] = 328;
            this.GBFreq[27][38] = 327;
            this.GBFreq[16][62] = 326;
            this.GBFreq[24][17] = 325;
            this.GBFreq[22][70] = 324;
            this.GBFreq[52][28] = 323;
            this.GBFreq[23][40] = 322;
            this.GBFreq[28][50] = 321;
            this.GBFreq[42][91] = 320;
            this.GBFreq[47][76] = 319;
            this.GBFreq[15][42] = 318;
            this.GBFreq[43][55] = 317;
            this.GBFreq[29][84] = 316;
            this.GBFreq[44][90] = 315;
            this.GBFreq[53][16] = 314;
            this.GBFreq[22][93] = 313;
            this.GBFreq[34][10] = 312;
            this.GBFreq[32][53] = 311;
            this.GBFreq[43][65] = 310;
            this.GBFreq[28][7] = 309;
            this.GBFreq[35][46] = 308;
            this.GBFreq[21][39] = 307;
            this.GBFreq[44][18] = 306;
            this.GBFreq[40][10] = 305;
            this.GBFreq[54][53] = 304;
            this.GBFreq[38][74] = 303;
            this.GBFreq[28][26] = 302;
            this.GBFreq[15][13] = 301;
            this.GBFreq[39][34] = 300;
            this.GBFreq[39][46] = 299;
            this.GBFreq[42][66] = 298;
            this.GBFreq[33][58] = 297;
            this.GBFreq[15][56] = 296;
            this.GBFreq[18][51] = 295;
            this.GBFreq[49][68] = 294;
            this.GBFreq[30][37] = 293;
            this.GBFreq[51][84] = 292;
            this.GBFreq[51][9] = 291;
            this.GBFreq[40][70] = 290;
            this.GBFreq[41][84] = 289;
            this.GBFreq[28][64] = 288;
            this.GBFreq[32][88] = 287;
            this.GBFreq[24][5] = 286;
            this.GBFreq[53][23] = 285;
            this.GBFreq[42][27] = 284;
            this.GBFreq[22][38] = 283;
            this.GBFreq[32][86] = 282;
            this.GBFreq[34][30] = 281;
            this.GBFreq[38][63] = 280;
            this.GBFreq[24][59] = 279;
            this.GBFreq[22][81] = 278;
            this.GBFreq[32][11] = 277;
            this.GBFreq[51][21] = 276;
            this.GBFreq[54][41] = 275;
            this.GBFreq[21][50] = 274;
            this.GBFreq[23][89] = 273;
            this.GBFreq[19][87] = 272;
            this.GBFreq[26][7] = 271;
            this.GBFreq[30][75] = 270;
            this.GBFreq[43][84] = 269;
            this.GBFreq[51][25] = 268;
            this.GBFreq[16][67] = 267;
            this.GBFreq[32][9] = 266;
            this.GBFreq[48][51] = 265;
            this.GBFreq[39][7] = 264;
            this.GBFreq[44][88] = 263;
            this.GBFreq[52][24] = 262;
            this.GBFreq[23][34] = 261;
            this.GBFreq[32][75] = 260;
            this.GBFreq[19][10] = 259;
            this.GBFreq[28][91] = 258;
            this.GBFreq[32][83] = 257;
            this.GBFreq[25][75] = 256;
            this.GBFreq[53][45] = 255;
            this.GBFreq[29][85] = 254;
            this.GBFreq[53][59] = 253;
            this.GBFreq[16][2] = 252;
            this.GBFreq[19][78] = 251;
            this.GBFreq[15][75] = 250;
            this.GBFreq[51][42] = 249;
            this.GBFreq[45][67] = 248;
            this.GBFreq[15][74] = 247;
            this.GBFreq[25][81] = 246;
            this.GBFreq[37][62] = 245;
            this.GBFreq[16][55] = 244;
            this.GBFreq[18][38] = 243;
            this.GBFreq[23][23] = 242;
            this.GBFreq[38][30] = 241;
            this.GBFreq[17][28] = 240;
            this.GBFreq[44][73] = 239;
            this.GBFreq[23][78] = 238;
            this.GBFreq[40][77] = 237;
            this.GBFreq[38][87] = 236;
            this.GBFreq[27][19] = 235;
            this.GBFreq[38][82] = 234;
            this.GBFreq[37][22] = 233;
            this.GBFreq[41][30] = 232;
            this.GBFreq[54][9] = 231;
            this.GBFreq[32][30] = 230;
            this.GBFreq[30][52] = 229;
            this.GBFreq[40][84] = 228;
            this.GBFreq[53][57] = 227;
            this.GBFreq[27][27] = 226;
            this.GBFreq[38][64] = 225;
            this.GBFreq[18][43] = 224;
            this.GBFreq[23][69] = 223;
            this.GBFreq[28][12] = 222;
            this.GBFreq[50][78] = 221;
            this.GBFreq[50][1] = 220;
            this.GBFreq[26][88] = 219;
            this.GBFreq[36][40] = 218;
            this.GBFreq[33][89] = 217;
            this.GBFreq[41][28] = 216;
            this.GBFreq[31][77] = 215;
            this.GBFreq[46][1] = 214;
            this.GBFreq[47][19] = 213;
            this.GBFreq[35][55] = 212;
            this.GBFreq[41][21] = 211;
            this.GBFreq[27][10] = 210;
            this.GBFreq[32][77] = 209;
            this.GBFreq[26][37] = 208;
            this.GBFreq[20][33] = 207;
            this.GBFreq[41][52] = 206;
            this.GBFreq[32][18] = 205;
            this.GBFreq[38][13] = 204;
            this.GBFreq[20][18] = 203;
            this.GBFreq[20][24] = 202;
            this.GBFreq[45][19] = 201;
            this.GBFreq[18][53] = 200;
            this.Big5Freq[9][89] = 600;
            this.Big5Freq[11][15] = 599;
            this.Big5Freq[3][66] = 598;
            this.Big5Freq[6][121] = 597;
            this.Big5Freq[3][0] = 596;
            this.Big5Freq[5][82] = 595;
            this.Big5Freq[3][42] = 594;
            this.Big5Freq[5][34] = 593;
            this.Big5Freq[3][8] = 592;
            this.Big5Freq[3][6] = 591;
            this.Big5Freq[3][67] = 590;
            this.Big5Freq[7][139] = 589;
            this.Big5Freq[23][137] = 588;
            this.Big5Freq[12][46] = 587;
            this.Big5Freq[4][8] = 586;
            this.Big5Freq[4][41] = 585;
            this.Big5Freq[18][47] = 584;
            this.Big5Freq[12][114] = 583;
            this.Big5Freq[6][1] = 582;
            this.Big5Freq[22][60] = 581;
            this.Big5Freq[5][46] = 580;
            this.Big5Freq[11][79] = 579;
            this.Big5Freq[3][23] = 578;
            this.Big5Freq[7][114] = 577;
            this.Big5Freq[29][102] = 576;
            this.Big5Freq[19][14] = 575;
            this.Big5Freq[4][133] = 574;
            this.Big5Freq[3][29] = 573;
            this.Big5Freq[4][109] = 572;
            this.Big5Freq[14][127] = 571;
            this.Big5Freq[5][48] = 570;
            this.Big5Freq[13][104] = 569;
            this.Big5Freq[3][132] = 568;
            this.Big5Freq[26][64] = 567;
            this.Big5Freq[7][19] = 566;
            this.Big5Freq[4][12] = 565;
            this.Big5Freq[11][124] = 564;
            this.Big5Freq[7][89] = 563;
            this.Big5Freq[15][124] = 562;
            this.Big5Freq[4][108] = 561;
            this.Big5Freq[19][66] = 560;
            this.Big5Freq[3][21] = 559;
            this.Big5Freq[24][12] = 558;
            this.Big5Freq[28][111] = 557;
            this.Big5Freq[12][107] = 556;
            this.Big5Freq[3][112] = 555;
            this.Big5Freq[8][113] = 554;
            this.Big5Freq[5][40] = 553;
            this.Big5Freq[26][145] = 552;
            this.Big5Freq[3][48] = 551;
            this.Big5Freq[3][70] = 550;
            this.Big5Freq[22][17] = 549;
            this.Big5Freq[16][47] = 548;
            this.Big5Freq[3][53] = 547;
            this.Big5Freq[4][24] = 546;
            this.Big5Freq[32][120] = 545;
            this.Big5Freq[24][49] = 544;
            this.Big5Freq[24][142] = 543;
            this.Big5Freq[18][66] = 542;
            this.Big5Freq[29][150] = 541;
            this.Big5Freq[5][122] = 540;
            this.Big5Freq[5][114] = 539;
            this.Big5Freq[3][44] = 538;
            this.Big5Freq[10][128] = 537;
            this.Big5Freq[15][20] = 536;
            this.Big5Freq[13][33] = 535;
            this.Big5Freq[14][87] = 534;
            this.Big5Freq[3][126] = 533;
            this.Big5Freq[4][53] = 532;
            this.Big5Freq[4][40] = 531;
            this.Big5Freq[9][93] = 530;
            this.Big5Freq[15][137] = 529;
            this.Big5Freq[10][123] = 528;
            this.Big5Freq[4][56] = 527;
            this.Big5Freq[5][71] = 526;
            this.Big5Freq[10][8] = 525;
            this.Big5Freq[5][16] = 524;
            this.Big5Freq[5][146] = 523;
            this.Big5Freq[18][88] = 522;
            this.Big5Freq[24][4] = 521;
            this.Big5Freq[20][47] = 520;
            this.Big5Freq[5][33] = 519;
            this.Big5Freq[9][43] = 518;
            this.Big5Freq[20][12] = 517;
            this.Big5Freq[20][13] = 516;
            this.Big5Freq[5][156] = 515;
            this.Big5Freq[22][140] = 514;
            this.Big5Freq[8][146] = 513;
            this.Big5Freq[21][123] = 512;
            this.Big5Freq[4][90] = 511;
            this.Big5Freq[5][62] = 510;
            this.Big5Freq[17][59] = 509;
            this.Big5Freq[10][37] = 508;
            this.Big5Freq[18][107] = 507;
            this.Big5Freq[14][53] = 506;
            this.Big5Freq[22][51] = 505;
            this.Big5Freq[8][13] = 504;
            this.Big5Freq[5][29] = 503;
            this.Big5Freq[9][7] = 502;
            this.Big5Freq[22][14] = 501;
            this.Big5Freq[8][55] = 500;
            this.Big5Freq[33][9] = 499;
            this.Big5Freq[16][64] = 498;
            this.Big5Freq[7][131] = 497;
            this.Big5Freq[34][4] = 496;
            this.Big5Freq[7][101] = 495;
            this.Big5Freq[11][139] = 494;
            this.Big5Freq[3][135] = 493;
            this.Big5Freq[7][102] = 492;
            this.Big5Freq[17][13] = 491;
            this.Big5Freq[3][20] = 490;
            this.Big5Freq[27][106] = 489;
            this.Big5Freq[5][88] = 488;
            this.Big5Freq[6][33] = 487;
            this.Big5Freq[5][139] = 486;
            this.Big5Freq[6][0] = 485;
            this.Big5Freq[17][58] = 484;
            this.Big5Freq[5][133] = 483;
            this.Big5Freq[9][107] = 482;
            this.Big5Freq[23][39] = 481;
            this.Big5Freq[5][23] = 480;
            this.Big5Freq[3][79] = 479;
            this.Big5Freq[32][97] = 478;
            this.Big5Freq[3][136] = 477;
            this.Big5Freq[4][94] = 476;
            this.Big5Freq[21][61] = 475;
            this.Big5Freq[23][123] = 474;
            this.Big5Freq[26][16] = 473;
            this.Big5Freq[24][137] = 472;
            this.Big5Freq[22][18] = 471;
            this.Big5Freq[5][1] = 470;
            this.Big5Freq[20][119] = 469;
            this.Big5Freq[3][7] = 468;
            this.Big5Freq[10][79] = 467;
            this.Big5Freq[15][105] = 466;
            this.Big5Freq[3][144] = 465;
            this.Big5Freq[12][80] = 464;
            this.Big5Freq[15][73] = 463;
            this.Big5Freq[3][19] = 462;
            this.Big5Freq[8][109] = 461;
            this.Big5Freq[3][15] = 460;
            this.Big5Freq[31][82] = 459;
            this.Big5Freq[3][43] = 458;
            this.Big5Freq[25][119] = 457;
            this.Big5Freq[16][111] = 456;
            this.Big5Freq[7][77] = 455;
            this.Big5Freq[3][95] = 454;
            this.Big5Freq[24][82] = 453;
            this.Big5Freq[7][52] = 452;
            this.Big5Freq[9][151] = 451;
            this.Big5Freq[3][129] = 450;
            this.Big5Freq[5][87] = 449;
            this.Big5Freq[3][55] = 448;
            this.Big5Freq[8][153] = 447;
            this.Big5Freq[4][83] = 446;
            this.Big5Freq[3][114] = 445;
            this.Big5Freq[23][147] = 444;
            this.Big5Freq[15][31] = 443;
            this.Big5Freq[3][54] = 442;
            this.Big5Freq[11][122] = 441;
            this.Big5Freq[4][4] = 440;
            this.Big5Freq[34][149] = 439;
            this.Big5Freq[3][17] = 438;
            this.Big5Freq[21][64] = 437;
            this.Big5Freq[26][144] = 436;
            this.Big5Freq[4][62] = 435;
            this.Big5Freq[8][15] = 434;
            this.Big5Freq[35][80] = 433;
            this.Big5Freq[7][110] = 432;
            this.Big5Freq[23][114] = 431;
            this.Big5Freq[3][108] = 430;
            this.Big5Freq[3][62] = 429;
            this.Big5Freq[21][41] = 428;
            this.Big5Freq[15][99] = 427;
            this.Big5Freq[5][47] = 426;
            this.Big5Freq[4][96] = 425;
            this.Big5Freq[20][122] = 424;
            this.Big5Freq[5][21] = 423;
            this.Big5Freq[4][157] = 422;
            this.Big5Freq[16][14] = 421;
            this.Big5Freq[3][117] = 420;
            this.Big5Freq[7][129] = 419;
            this.Big5Freq[4][27] = 418;
            this.Big5Freq[5][30] = 417;
            this.Big5Freq[22][16] = 416;
            this.Big5Freq[5][64] = 415;
            this.Big5Freq[17][99] = 414;
            this.Big5Freq[17][57] = 413;
            this.Big5Freq[8][105] = 412;
            this.Big5Freq[5][112] = 411;
            this.Big5Freq[20][59] = 410;
            this.Big5Freq[6][129] = 409;
            this.Big5Freq[18][17] = 408;
            this.Big5Freq[3][92] = 407;
            this.Big5Freq[28][118] = 406;
            this.Big5Freq[3][109] = 405;
            this.Big5Freq[31][51] = 404;
            this.Big5Freq[13][116] = 403;
            this.Big5Freq[6][15] = 402;
            this.Big5Freq[36][136] = 401;
            this.Big5Freq[12][74] = 400;
            this.Big5Freq[20][88] = 399;
            this.Big5Freq[36][68] = 398;
            this.Big5Freq[3][147] = 397;
            this.Big5Freq[15][84] = 396;
            this.Big5Freq[16][32] = 395;
            this.Big5Freq[16][58] = 394;
            this.Big5Freq[7][66] = 393;
            this.Big5Freq[23][107] = 392;
            this.Big5Freq[9][6] = 391;
            this.Big5Freq[12][86] = 390;
            this.Big5Freq[23][112] = 389;
            this.Big5Freq[37][23] = 388;
            this.Big5Freq[3][138] = 387;
            this.Big5Freq[20][68] = 386;
            this.Big5Freq[15][116] = 385;
            this.Big5Freq[18][64] = 384;
            this.Big5Freq[12][139] = 383;
            this.Big5Freq[11][155] = 382;
            this.Big5Freq[4][156] = 381;
            this.Big5Freq[12][84] = 380;
            this.Big5Freq[18][49] = 379;
            this.Big5Freq[25][125] = 378;
            this.Big5Freq[25][147] = 377;
            this.Big5Freq[15][110] = 376;
            this.Big5Freq[19][96] = 375;
            this.Big5Freq[30][152] = 374;
            this.Big5Freq[6][31] = 373;
            this.Big5Freq[27][117] = 372;
            this.Big5Freq[3][10] = 371;
            this.Big5Freq[6][131] = 370;
            this.Big5Freq[13][112] = 369;
            this.Big5Freq[36][156] = 368;
            this.Big5Freq[4][60] = 367;
            this.Big5Freq[15][121] = 366;
            this.Big5Freq[4][112] = 365;
            this.Big5Freq[30][142] = 364;
            this.Big5Freq[23][154] = 363;
            this.Big5Freq[27][101] = 362;
            this.Big5Freq[9][140] = 361;
            this.Big5Freq[3][89] = 360;
            this.Big5Freq[18][148] = 359;
            this.Big5Freq[4][69] = 358;
            this.Big5Freq[16][49] = 357;
            this.Big5Freq[6][117] = 356;
            this.Big5Freq[36][55] = 355;
            this.Big5Freq[5][123] = 354;
            this.Big5Freq[4][126] = 353;
            this.Big5Freq[4][119] = 352;
            this.Big5Freq[9][95] = 351;
            this.Big5Freq[5][24] = 350;
            this.Big5Freq[16][133] = 349;
            this.Big5Freq[10][134] = 348;
            this.Big5Freq[26][59] = 347;
            this.Big5Freq[6][41] = 346;
            this.Big5Freq[6][146] = 345;
            this.Big5Freq[19][24] = 344;
            this.Big5Freq[5][113] = 343;
            this.Big5Freq[10][118] = 342;
            this.Big5Freq[34][151] = 341;
            this.Big5Freq[9][72] = 340;
            this.Big5Freq[31][25] = 339;
            this.Big5Freq[18][126] = 338;
            this.Big5Freq[18][28] = 337;
            this.Big5Freq[4][153] = 336;
            this.Big5Freq[3][84] = 335;
            this.Big5Freq[21][18] = 334;
            this.Big5Freq[25][129] = 333;
            this.Big5Freq[6][107] = 332;
            this.Big5Freq[12][25] = 331;
            this.Big5Freq[17][109] = 330;
            this.Big5Freq[7][76] = 329;
            this.Big5Freq[15][15] = 328;
            this.Big5Freq[4][14] = 327;
            this.Big5Freq[23][88] = 326;
            this.Big5Freq[18][2] = 325;
            this.Big5Freq[6][88] = 324;
            this.Big5Freq[16][84] = 323;
            this.Big5Freq[12][48] = 322;
            this.Big5Freq[7][68] = 321;
            this.Big5Freq[5][50] = 320;
            this.Big5Freq[13][54] = 319;
            this.Big5Freq[7][98] = 318;
            this.Big5Freq[11][6] = 317;
            this.Big5Freq[9][80] = 316;
            this.Big5Freq[16][41] = 315;
            this.Big5Freq[7][43] = 314;
            this.Big5Freq[28][117] = 313;
            this.Big5Freq[3][51] = 312;
            this.Big5Freq[7][3] = 311;
            this.Big5Freq[20][81] = 310;
            this.Big5Freq[4][2] = 309;
            this.Big5Freq[11][16] = 308;
            this.Big5Freq[10][4] = 307;
            this.Big5Freq[10][119] = 306;
            this.Big5Freq[6][142] = 305;
            this.Big5Freq[18][51] = 304;
            this.Big5Freq[8][144] = 303;
            this.Big5Freq[10][65] = 302;
            this.Big5Freq[11][64] = 301;
            this.Big5Freq[11][130] = 300;
            this.Big5Freq[9][92] = 299;
            this.Big5Freq[18][29] = 298;
            this.Big5Freq[18][78] = 297;
            this.Big5Freq[18][151] = 296;
            this.Big5Freq[33][127] = 295;
            this.Big5Freq[35][113] = 294;
            this.Big5Freq[10][155] = 293;
            this.Big5Freq[3][76] = 292;
            this.Big5Freq[36][123] = 291;
            this.Big5Freq[13][143] = 290;
            this.Big5Freq[5][135] = 289;
            this.Big5Freq[23][116] = 288;
            this.Big5Freq[6][101] = 287;
            this.Big5Freq[14][74] = 286;
            this.Big5Freq[7][153] = 285;
            this.Big5Freq[3][101] = 284;
            this.Big5Freq[9][74] = 283;
            this.Big5Freq[3][156] = 282;
            this.Big5Freq[4][147] = 281;
            this.Big5Freq[9][12] = 280;
            this.Big5Freq[18][133] = 279;
            this.Big5Freq[4][0] = 278;
            this.Big5Freq[7][155] = 277;
            this.Big5Freq[9][144] = 276;
            this.Big5Freq[23][49] = 275;
            this.Big5Freq[5][89] = 274;
            this.Big5Freq[10][11] = 273;
            this.Big5Freq[3][110] = 272;
            this.Big5Freq[3][40] = 271;
            this.Big5Freq[29][115] = 270;
            this.Big5Freq[9][100] = 269;
            this.Big5Freq[21][67] = 268;
            this.Big5Freq[23][145] = 267;
            this.Big5Freq[10][47] = 266;
            this.Big5Freq[4][31] = 265;
            this.Big5Freq[4][81] = 264;
            this.Big5Freq[22][62] = 263;
            this.Big5Freq[4][28] = 262;
            this.Big5Freq[27][39] = 261;
            this.Big5Freq[27][54] = 260;
            this.Big5Freq[32][46] = 259;
            this.Big5Freq[4][76] = 258;
            this.Big5Freq[26][15] = 257;
            this.Big5Freq[12][154] = 256;
            this.Big5Freq[9][150] = 255;
            this.Big5Freq[15][17] = 254;
            this.Big5Freq[5][129] = 253;
            this.Big5Freq[10][40] = 252;
            this.Big5Freq[13][37] = 251;
            this.Big5Freq[31][104] = 250;
            this.Big5Freq[3][152] = 249;
            this.Big5Freq[5][22] = 248;
            this.Big5Freq[8][48] = 247;
            this.Big5Freq[4][74] = 246;
            this.Big5Freq[6][17] = 245;
            this.Big5Freq[30][82] = 244;
            this.Big5Freq[4][116] = 243;
            this.Big5Freq[16][42] = 242;
            this.Big5Freq[5][55] = 241;
            this.Big5Freq[4][64] = 240;
            this.Big5Freq[14][19] = 239;
            this.Big5Freq[35][82] = 238;
            this.Big5Freq[30][139] = 237;
            this.Big5Freq[26][152] = 236;
            this.Big5Freq[32][32] = 235;
            this.Big5Freq[21][102] = 234;
            this.Big5Freq[10][131] = 233;
            this.Big5Freq[9][128] = 232;
            this.Big5Freq[3][87] = 231;
            this.Big5Freq[4][51] = 230;
            this.Big5Freq[10][15] = 229;
            this.Big5Freq[4][150] = 228;
            this.Big5Freq[7][4] = 227;
            this.Big5Freq[7][51] = 226;
            this.Big5Freq[7][157] = 225;
            this.Big5Freq[4][146] = 224;
            this.Big5Freq[4][91] = 223;
            this.Big5Freq[7][13] = 222;
            this.Big5Freq[17][116] = 221;
            this.Big5Freq[23][21] = 220;
            this.Big5Freq[5][106] = 219;
            this.Big5Freq[14][100] = 218;
            this.Big5Freq[10][152] = 217;
            this.Big5Freq[14][89] = 216;
            this.Big5Freq[6][138] = 215;
            this.Big5Freq[12][157] = 214;
            this.Big5Freq[10][102] = 213;
            this.Big5Freq[19][94] = 212;
            this.Big5Freq[7][74] = 211;
            this.Big5Freq[18][128] = 210;
            this.Big5Freq[27][111] = 209;
            this.Big5Freq[11][57] = 208;
            this.Big5Freq[3][131] = 207;
            this.Big5Freq[30][23] = 206;
            this.Big5Freq[30][126] = 205;
            this.Big5Freq[4][36] = 204;
            this.Big5Freq[26][124] = 203;
            this.Big5Freq[4][19] = 202;
            this.Big5Freq[9][152] = 201;
            this.Big5PFreq[41][122] = 600;
            this.Big5PFreq[35][0] = 599;
            this.Big5PFreq[43][15] = 598;
            this.Big5PFreq[35][99] = 597;
            this.Big5PFreq[35][6] = 596;
            this.Big5PFreq[35][8] = 595;
            this.Big5PFreq[38][154] = 594;
            this.Big5PFreq[37][34] = 593;
            this.Big5PFreq[37][115] = 592;
            this.Big5PFreq[36][12] = 591;
            this.Big5PFreq[18][77] = 590;
            this.Big5PFreq[35][100] = 589;
            this.Big5PFreq[35][42] = 588;
            this.Big5PFreq[120][75] = 587;
            this.Big5PFreq[35][23] = 586;
            this.Big5PFreq[13][72] = 585;
            this.Big5PFreq[0][67] = 584;
            this.Big5PFreq[39][172] = 583;
            this.Big5PFreq[22][182] = 582;
            this.Big5PFreq[15][186] = 581;
            this.Big5PFreq[15][165] = 580;
            this.Big5PFreq[35][44] = 579;
            this.Big5PFreq[40][13] = 578;
            this.Big5PFreq[38][1] = 577;
            this.Big5PFreq[37][33] = 576;
            this.Big5PFreq[36][24] = 575;
            this.Big5PFreq[56][4] = 574;
            this.Big5PFreq[35][29] = 573;
            this.Big5PFreq[9][96] = 572;
            this.Big5PFreq[37][62] = 571;
            this.Big5PFreq[48][47] = 570;
            this.Big5PFreq[51][14] = 569;
            this.Big5PFreq[39][122] = 568;
            this.Big5PFreq[44][46] = 567;
            this.Big5PFreq[35][21] = 566;
            this.Big5PFreq[36][8] = 565;
            this.Big5PFreq[36][141] = 564;
            this.Big5PFreq[3][81] = 563;
            this.Big5PFreq[37][155] = 562;
            this.Big5PFreq[42][84] = 561;
            this.Big5PFreq[36][40] = 560;
            this.Big5PFreq[35][103] = 559;
            this.Big5PFreq[11][84] = 558;
            this.Big5PFreq[45][33] = 557;
            this.Big5PFreq[121][79] = 556;
            this.Big5PFreq[2][77] = 555;
            this.Big5PFreq[36][41] = 554;
            this.Big5PFreq[37][47] = 553;
            this.Big5PFreq[39][125] = 552;
            this.Big5PFreq[37][26] = 551;
            this.Big5PFreq[35][48] = 550;
            this.Big5PFreq[35][28] = 549;
            this.Big5PFreq[35][159] = 548;
            this.Big5PFreq[37][40] = 547;
            this.Big5PFreq[35][145] = 546;
            this.Big5PFreq[37][147] = 545;
            this.Big5PFreq[46][160] = 544;
            this.Big5PFreq[37][46] = 543;
            this.Big5PFreq[50][99] = 542;
            this.Big5PFreq[52][13] = 541;
            this.Big5PFreq[10][82] = 540;
            this.Big5PFreq[35][169] = 539;
            this.Big5PFreq[35][31] = 538;
            this.Big5PFreq[47][31] = 537;
            this.Big5PFreq[18][79] = 536;
            this.Big5PFreq[16][113] = 535;
            this.Big5PFreq[37][104] = 534;
            this.Big5PFreq[39][134] = 533;
            this.Big5PFreq[36][53] = 532;
            this.Big5PFreq[38][0] = 531;
            this.Big5PFreq[4][86] = 530;
            this.Big5PFreq[54][17] = 529;
            this.Big5PFreq[43][157] = 528;
            this.Big5PFreq[35][165] = 527;
            this.Big5PFreq[69][147] = 526;
            this.Big5PFreq[117][95] = 525;
            this.Big5PFreq[35][162] = 524;
            this.Big5PFreq[35][17] = 523;
            this.Big5PFreq[36][142] = 522;
            this.Big5PFreq[36][4] = 521;
            this.Big5PFreq[37][166] = 520;
            this.Big5PFreq[35][168] = 519;
            this.Big5PFreq[35][19] = 518;
            this.Big5PFreq[37][48] = 517;
            this.Big5PFreq[42][37] = 516;
            this.Big5PFreq[40][146] = 515;
            this.Big5PFreq[36][123] = 514;
            this.Big5PFreq[22][41] = 513;
            this.Big5PFreq[20][119] = 512;
            this.Big5PFreq[2][74] = 511;
            this.Big5PFreq[44][113] = 510;
            this.Big5PFreq[35][125] = 509;
            this.Big5PFreq[37][16] = 508;
            this.Big5PFreq[35][20] = 507;
            this.Big5PFreq[35][55] = 506;
            this.Big5PFreq[37][145] = 505;
            this.Big5PFreq[0][88] = 504;
            this.Big5PFreq[3][94] = 503;
            this.Big5PFreq[6][65] = 502;
            this.Big5PFreq[26][15] = 501;
            this.Big5PFreq[41][126] = 500;
            this.Big5PFreq[36][129] = 499;
            this.Big5PFreq[31][75] = 498;
            this.Big5PFreq[19][61] = 497;
            this.Big5PFreq[35][128] = 496;
            this.Big5PFreq[29][79] = 495;
            this.Big5PFreq[36][62] = 494;
            this.Big5PFreq[37][189] = 493;
            this.Big5PFreq[39][109] = 492;
            this.Big5PFreq[39][135] = 491;
            this.Big5PFreq[72][15] = 490;
            this.Big5PFreq[47][106] = 489;
            this.Big5PFreq[54][14] = 488;
            this.Big5PFreq[24][52] = 487;
            this.Big5PFreq[38][162] = 486;
            this.Big5PFreq[41][43] = 485;
            this.Big5PFreq[37][121] = 484;
            this.Big5PFreq[14][66] = 483;
            this.Big5PFreq[37][30] = 482;
            this.Big5PFreq[35][7] = 481;
            this.Big5PFreq[49][58] = 480;
            this.Big5PFreq[43][188] = 479;
            this.Big5PFreq[24][66] = 478;
            this.Big5PFreq[35][171] = 477;
            this.Big5PFreq[40][186] = 476;
            this.Big5PFreq[39][164] = 475;
            this.Big5PFreq[78][186] = 474;
            this.Big5PFreq[8][72] = 473;
            this.Big5PFreq[36][190] = 472;
            this.Big5PFreq[35][53] = 471;
            this.Big5PFreq[35][54] = 470;
            this.Big5PFreq[22][159] = 469;
            this.Big5PFreq[35][9] = 468;
            this.Big5PFreq[41][140] = 467;
            this.Big5PFreq[37][22] = 466;
            this.Big5PFreq[48][97] = 465;
            this.Big5PFreq[50][97] = 464;
            this.Big5PFreq[36][127] = 463;
            this.Big5PFreq[37][23] = 462;
            this.Big5PFreq[40][55] = 461;
            this.Big5PFreq[35][43] = 460;
            this.Big5PFreq[26][22] = 459;
            this.Big5PFreq[35][15] = 458;
            this.Big5PFreq[72][179] = 457;
            this.Big5PFreq[20][129] = 456;
            this.Big5PFreq[52][101] = 455;
            this.Big5PFreq[35][12] = 454;
            this.Big5PFreq[42][156] = 453;
            this.Big5PFreq[15][157] = 452;
            this.Big5PFreq[50][140] = 451;
            this.Big5PFreq[26][28] = 450;
            this.Big5PFreq[54][51] = 449;
            this.Big5PFreq[35][112] = 448;
            this.Big5PFreq[36][116] = 447;
            this.Big5PFreq[42][11] = 446;
            this.Big5PFreq[37][172] = 445;
            this.Big5PFreq[37][29] = 444;
            this.Big5PFreq[44][107] = 443;
            this.Big5PFreq[50][17] = 442;
            this.Big5PFreq[39][107] = 441;
            this.Big5PFreq[19][109] = 440;
            this.Big5PFreq[36][60] = 439;
            this.Big5PFreq[49][132] = 438;
            this.Big5PFreq[26][16] = 437;
            this.Big5PFreq[43][155] = 436;
            this.Big5PFreq[37][120] = 435;
            this.Big5PFreq[15][159] = 434;
            this.Big5PFreq[43][6] = 433;
            this.Big5PFreq[45][188] = 432;
            this.Big5PFreq[35][38] = 431;
            this.Big5PFreq[39][143] = 430;
            this.Big5PFreq[48][144] = 429;
            this.Big5PFreq[37][168] = 428;
            this.Big5PFreq[37][1] = 427;
            this.Big5PFreq[36][109] = 426;
            this.Big5PFreq[46][53] = 425;
            this.Big5PFreq[38][54] = 424;
            this.Big5PFreq[36][0] = 423;
            this.Big5PFreq[72][33] = 422;
            this.Big5PFreq[42][8] = 421;
            this.Big5PFreq[36][31] = 420;
            this.Big5PFreq[35][150] = 419;
            this.Big5PFreq[118][93] = 418;
            this.Big5PFreq[37][61] = 417;
            this.Big5PFreq[0][85] = 416;
            this.Big5PFreq[36][27] = 415;
            this.Big5PFreq[35][134] = 414;
            this.Big5PFreq[36][145] = 413;
            this.Big5PFreq[6][96] = 412;
            this.Big5PFreq[36][14] = 411;
            this.Big5PFreq[16][36] = 410;
            this.Big5PFreq[15][175] = 409;
            this.Big5PFreq[35][10] = 408;
            this.Big5PFreq[36][189] = 407;
            this.Big5PFreq[35][51] = 406;
            this.Big5PFreq[35][109] = 405;
            this.Big5PFreq[35][147] = 404;
            this.Big5PFreq[35][180] = 403;
            this.Big5PFreq[72][5] = 402;
            this.Big5PFreq[36][107] = 401;
            this.Big5PFreq[49][116] = 400;
            this.Big5PFreq[73][30] = 399;
            this.Big5PFreq[6][90] = 398;
            this.Big5PFreq[2][70] = 397;
            this.Big5PFreq[17][141] = 396;
            this.Big5PFreq[35][62] = 395;
            this.Big5PFreq[16][180] = 394;
            this.Big5PFreq[4][91] = 393;
            this.Big5PFreq[15][171] = 392;
            this.Big5PFreq[35][177] = 391;
            this.Big5PFreq[37][173] = 390;
            this.Big5PFreq[16][121] = 389;
            this.Big5PFreq[35][5] = 388;
            this.Big5PFreq[46][122] = 387;
            this.Big5PFreq[40][138] = 386;
            this.Big5PFreq[50][49] = 385;
            this.Big5PFreq[36][152] = 384;
            this.Big5PFreq[13][43] = 383;
            this.Big5PFreq[9][88] = 382;
            this.Big5PFreq[36][159] = 381;
            this.Big5PFreq[27][62] = 380;
            this.Big5PFreq[40][18] = 379;
            this.Big5PFreq[17][129] = 378;
            this.Big5PFreq[43][97] = 377;
            this.Big5PFreq[13][131] = 376;
            this.Big5PFreq[46][107] = 375;
            this.Big5PFreq[60][64] = 374;
            this.Big5PFreq[36][179] = 373;
            this.Big5PFreq[37][55] = 372;
            this.Big5PFreq[41][173] = 371;
            this.Big5PFreq[44][172] = 370;
            this.Big5PFreq[23][187] = 369;
            this.Big5PFreq[36][149] = 368;
            this.Big5PFreq[17][125] = 367;
            this.Big5PFreq[55][180] = 366;
            this.Big5PFreq[51][129] = 365;
            this.Big5PFreq[36][51] = 364;
            this.Big5PFreq[37][122] = 363;
            this.Big5PFreq[48][32] = 362;
            this.Big5PFreq[51][99] = 361;
            this.Big5PFreq[54][16] = 360;
            this.Big5PFreq[41][183] = 359;
            this.Big5PFreq[37][179] = 358;
            this.Big5PFreq[38][179] = 357;
            this.Big5PFreq[35][143] = 356;
            this.Big5PFreq[37][24] = 355;
            this.Big5PFreq[40][177] = 354;
            this.Big5PFreq[47][117] = 353;
            this.Big5PFreq[39][52] = 352;
            this.Big5PFreq[22][99] = 351;
            this.Big5PFreq[40][142] = 350;
            this.Big5PFreq[36][49] = 349;
            this.Big5PFreq[38][17] = 348;
            this.Big5PFreq[39][188] = 347;
            this.Big5PFreq[36][186] = 346;
            this.Big5PFreq[35][189] = 345;
            this.Big5PFreq[41][7] = 344;
            this.Big5PFreq[18][91] = 343;
            this.Big5PFreq[43][137] = 342;
            this.Big5PFreq[35][142] = 341;
            this.Big5PFreq[35][117] = 340;
            this.Big5PFreq[39][138] = 339;
            this.Big5PFreq[16][59] = 338;
            this.Big5PFreq[39][174] = 337;
            this.Big5PFreq[55][145] = 336;
            this.Big5PFreq[37][21] = 335;
            this.Big5PFreq[36][180] = 334;
            this.Big5PFreq[37][156] = 333;
            this.Big5PFreq[49][13] = 332;
            this.Big5PFreq[41][107] = 331;
            this.Big5PFreq[36][56] = 330;
            this.Big5PFreq[53][8] = 329;
            this.Big5PFreq[22][114] = 328;
            this.Big5PFreq[5][95] = 327;
            this.Big5PFreq[37][0] = 326;
            this.Big5PFreq[26][183] = 325;
            this.Big5PFreq[22][66] = 324;
            this.Big5PFreq[35][58] = 323;
            this.Big5PFreq[48][117] = 322;
            this.Big5PFreq[36][102] = 321;
            this.Big5PFreq[22][122] = 320;
            this.Big5PFreq[35][11] = 319;
            this.Big5PFreq[46][19] = 318;
            this.Big5PFreq[22][49] = 317;
            this.Big5PFreq[48][166] = 316;
            this.Big5PFreq[41][125] = 315;
            this.Big5PFreq[41][1] = 314;
            this.Big5PFreq[35][178] = 313;
            this.Big5PFreq[41][12] = 312;
            this.Big5PFreq[26][167] = 311;
            this.Big5PFreq[42][152] = 310;
            this.Big5PFreq[42][46] = 309;
            this.Big5PFreq[42][151] = 308;
            this.Big5PFreq[20][135] = 307;
            this.Big5PFreq[37][162] = 306;
            this.Big5PFreq[37][50] = 305;
            this.Big5PFreq[22][185] = 304;
            this.Big5PFreq[36][166] = 303;
            this.Big5PFreq[19][40] = 302;
            this.Big5PFreq[22][107] = 301;
            this.Big5PFreq[22][102] = 300;
            this.Big5PFreq[57][162] = 299;
            this.Big5PFreq[22][124] = 298;
            this.Big5PFreq[37][138] = 297;
            this.Big5PFreq[37][25] = 296;
            this.Big5PFreq[0][69] = 295;
            this.Big5PFreq[43][172] = 294;
            this.Big5PFreq[42][167] = 293;
            this.Big5PFreq[35][120] = 292;
            this.Big5PFreq[41][128] = 291;
            this.Big5PFreq[2][88] = 290;
            this.Big5PFreq[20][123] = 289;
            this.Big5PFreq[35][123] = 288;
            this.Big5PFreq[36][28] = 287;
            this.Big5PFreq[42][188] = 286;
            this.Big5PFreq[42][164] = 285;
            this.Big5PFreq[42][4] = 284;
            this.Big5PFreq[43][57] = 283;
            this.Big5PFreq[39][3] = 282;
            this.Big5PFreq[42][3] = 281;
            this.Big5PFreq[57][158] = 280;
            this.Big5PFreq[35][146] = 279;
            this.Big5PFreq[24][54] = 278;
            this.Big5PFreq[13][110] = 277;
            this.Big5PFreq[23][132] = 276;
            this.Big5PFreq[26][102] = 275;
            this.Big5PFreq[55][178] = 274;
            this.Big5PFreq[17][117] = 273;
            this.Big5PFreq[41][161] = 272;
            this.Big5PFreq[38][150] = 271;
            this.Big5PFreq[10][71] = 270;
            this.Big5PFreq[47][60] = 269;
            this.Big5PFreq[16][114] = 268;
            this.Big5PFreq[21][47] = 267;
            this.Big5PFreq[39][101] = 266;
            this.Big5PFreq[18][45] = 265;
            this.Big5PFreq[40][121] = 264;
            this.Big5PFreq[45][41] = 263;
            this.Big5PFreq[22][167] = 262;
            this.Big5PFreq[26][149] = 261;
            this.Big5PFreq[15][189] = 260;
            this.Big5PFreq[41][177] = 259;
            this.Big5PFreq[46][36] = 258;
            this.Big5PFreq[20][40] = 257;
            this.Big5PFreq[41][54] = 256;
            this.Big5PFreq[3][87] = 255;
            this.Big5PFreq[40][16] = 254;
            this.Big5PFreq[42][15] = 253;
            this.Big5PFreq[11][83] = 252;
            this.Big5PFreq[0][94] = 251;
            this.Big5PFreq[122][81] = 250;
            this.Big5PFreq[41][26] = 249;
            this.Big5PFreq[36][34] = 248;
            this.Big5PFreq[44][148] = 247;
            this.Big5PFreq[35][3] = 246;
            this.Big5PFreq[36][114] = 245;
            this.Big5PFreq[42][112] = 244;
            this.Big5PFreq[35][183] = 243;
            this.Big5PFreq[49][73] = 242;
            this.Big5PFreq[39][2] = 241;
            this.Big5PFreq[38][121] = 240;
            this.Big5PFreq[44][114] = 239;
            this.Big5PFreq[49][32] = 238;
            this.Big5PFreq[1][65] = 237;
            this.Big5PFreq[38][25] = 236;
            this.Big5PFreq[39][4] = 235;
            this.Big5PFreq[42][62] = 234;
            this.Big5PFreq[35][40] = 233;
            this.Big5PFreq[24][2] = 232;
            this.Big5PFreq[53][49] = 231;
            this.Big5PFreq[41][133] = 230;
            this.Big5PFreq[43][134] = 229;
            this.Big5PFreq[3][83] = 228;
            this.Big5PFreq[38][158] = 227;
            this.Big5PFreq[24][17] = 226;
            this.Big5PFreq[52][59] = 225;
            this.Big5PFreq[38][41] = 224;
            this.Big5PFreq[37][127] = 223;
            this.Big5PFreq[22][175] = 222;
            this.Big5PFreq[44][30] = 221;
            this.Big5PFreq[47][178] = 220;
            this.Big5PFreq[43][99] = 219;
            this.Big5PFreq[19][4] = 218;
            this.Big5PFreq[37][97] = 217;
            this.Big5PFreq[38][181] = 216;
            this.Big5PFreq[45][103] = 215;
            this.Big5PFreq[1][86] = 214;
            this.Big5PFreq[40][15] = 213;
            this.Big5PFreq[22][136] = 212;
            this.Big5PFreq[75][165] = 211;
            this.Big5PFreq[36][15] = 210;
            this.Big5PFreq[46][80] = 209;
            this.Big5PFreq[59][55] = 208;
            this.Big5PFreq[37][108] = 207;
            this.Big5PFreq[21][109] = 206;
            this.Big5PFreq[24][165] = 205;
            this.Big5PFreq[79][158] = 204;
            this.Big5PFreq[44][139] = 203;
            this.Big5PFreq[36][124] = 202;
            this.Big5PFreq[42][185] = 201;
            this.Big5PFreq[39][186] = 200;
            this.Big5PFreq[22][128] = 199;
            this.Big5PFreq[40][44] = 198;
            this.Big5PFreq[41][105] = 197;
            this.Big5PFreq[1][70] = 196;
            this.Big5PFreq[1][68] = 195;
            this.Big5PFreq[53][22] = 194;
            this.Big5PFreq[36][54] = 193;
            this.Big5PFreq[47][147] = 192;
            this.Big5PFreq[35][36] = 191;
            this.Big5PFreq[35][185] = 190;
            this.Big5PFreq[45][37] = 189;
            this.Big5PFreq[43][163] = 188;
            this.Big5PFreq[56][115] = 187;
            this.Big5PFreq[38][164] = 186;
            this.Big5PFreq[35][141] = 185;
            this.Big5PFreq[42][132] = 184;
            this.Big5PFreq[46][120] = 183;
            this.Big5PFreq[69][142] = 182;
            this.Big5PFreq[38][175] = 181;
            this.Big5PFreq[22][112] = 180;
            this.Big5PFreq[38][142] = 179;
            this.Big5PFreq[40][37] = 178;
            this.Big5PFreq[37][109] = 177;
            this.Big5PFreq[40][144] = 176;
            this.Big5PFreq[44][117] = 175;
            this.Big5PFreq[35][181] = 174;
            this.Big5PFreq[26][105] = 173;
            this.Big5PFreq[16][48] = 172;
            this.Big5PFreq[44][122] = 171;
            this.Big5PFreq[12][86] = 170;
            this.Big5PFreq[84][53] = 169;
            this.Big5PFreq[17][44] = 168;
            this.Big5PFreq[59][54] = 167;
            this.Big5PFreq[36][98] = 166;
            this.Big5PFreq[45][115] = 165;
            this.Big5PFreq[73][9] = 164;
            this.Big5PFreq[44][123] = 163;
            this.Big5PFreq[37][188] = 162;
            this.Big5PFreq[51][117] = 161;
            this.Big5PFreq[15][156] = 160;
            this.Big5PFreq[36][155] = 159;
            this.Big5PFreq[44][25] = 158;
            this.Big5PFreq[38][12] = 157;
            this.Big5PFreq[38][140] = 156;
            this.Big5PFreq[23][4] = 155;
            this.Big5PFreq[45][149] = 154;
            this.Big5PFreq[22][189] = 153;
            this.Big5PFreq[38][147] = 152;
            this.Big5PFreq[27][5] = 151;
            this.Big5PFreq[22][42] = 150;
            this.Big5PFreq[3][68] = 149;
            this.Big5PFreq[39][51] = 148;
            this.Big5PFreq[36][29] = 147;
            this.Big5PFreq[20][108] = 146;
            this.Big5PFreq[50][57] = 145;
            this.Big5PFreq[55][104] = 144;
            this.Big5PFreq[22][46] = 143;
            this.Big5PFreq[18][164] = 142;
            this.Big5PFreq[50][159] = 141;
            this.Big5PFreq[85][131] = 140;
            this.Big5PFreq[26][79] = 139;
            this.Big5PFreq[38][100] = 138;
            this.Big5PFreq[53][112] = 137;
            this.Big5PFreq[20][190] = 136;
            this.Big5PFreq[14][69] = 135;
            this.Big5PFreq[23][11] = 134;
            this.Big5PFreq[40][114] = 133;
            this.Big5PFreq[40][148] = 132;
            this.Big5PFreq[53][130] = 131;
            this.Big5PFreq[36][2] = 130;
            this.Big5PFreq[66][82] = 129;
            this.Big5PFreq[45][166] = 128;
            this.Big5PFreq[4][88] = 127;
            this.Big5PFreq[16][57] = 126;
            this.Big5PFreq[22][116] = 125;
            this.Big5PFreq[36][108] = 124;
            this.Big5PFreq[13][48] = 123;
            this.Big5PFreq[54][12] = 122;
            this.Big5PFreq[40][136] = 121;
            this.Big5PFreq[36][128] = 120;
            this.Big5PFreq[23][6] = 119;
            this.Big5PFreq[38][125] = 118;
            this.Big5PFreq[45][154] = 117;
            this.Big5PFreq[51][127] = 116;
            this.Big5PFreq[44][163] = 115;
            this.Big5PFreq[16][173] = 114;
            this.Big5PFreq[43][49] = 113;
            this.Big5PFreq[20][112] = 112;
            this.Big5PFreq[15][168] = 111;
            this.Big5PFreq[35][129] = 110;
            this.Big5PFreq[20][45] = 109;
            this.Big5PFreq[38][10] = 108;
            this.Big5PFreq[57][171] = 107;
            this.Big5PFreq[44][190] = 106;
            this.Big5PFreq[40][56] = 105;
            this.Big5PFreq[36][156] = 104;
            this.Big5PFreq[3][88] = 103;
            this.Big5PFreq[50][122] = 102;
            this.Big5PFreq[36][7] = 101;
            this.Big5PFreq[39][43] = 100;
            this.Big5PFreq[15][166] = 99;
            this.Big5PFreq[42][136] = 98;
            this.Big5PFreq[22][131] = 97;
            this.Big5PFreq[44][23] = 96;
            this.Big5PFreq[54][147] = 95;
            this.Big5PFreq[41][32] = 94;
            this.Big5PFreq[23][121] = 93;
            this.Big5PFreq[39][108] = 92;
            this.Big5PFreq[2][78] = 91;
            this.Big5PFreq[40][155] = 90;
            this.Big5PFreq[55][51] = 89;
            this.Big5PFreq[19][34] = 88;
            this.Big5PFreq[48][128] = 87;
            this.Big5PFreq[48][159] = 86;
            this.Big5PFreq[20][70] = 85;
            this.Big5PFreq[34][71] = 84;
            this.Big5PFreq[16][31] = 83;
            this.Big5PFreq[42][157] = 82;
            this.Big5PFreq[20][44] = 81;
            this.Big5PFreq[11][92] = 80;
            this.Big5PFreq[44][180] = 79;
            this.Big5PFreq[84][33] = 78;
            this.Big5PFreq[16][116] = 77;
            this.Big5PFreq[61][163] = 76;
            this.Big5PFreq[35][164] = 75;
            this.Big5PFreq[36][42] = 74;
            this.Big5PFreq[13][40] = 73;
            this.Big5PFreq[43][176] = 72;
            this.Big5PFreq[2][66] = 71;
            this.Big5PFreq[20][133] = 70;
            this.Big5PFreq[36][65] = 69;
            this.Big5PFreq[38][33] = 68;
            this.Big5PFreq[12][91] = 67;
            this.Big5PFreq[36][26] = 66;
            this.Big5PFreq[15][174] = 65;
            this.Big5PFreq[77][32] = 64;
            this.Big5PFreq[16][1] = 63;
            this.Big5PFreq[25][86] = 62;
            this.Big5PFreq[17][13] = 61;
            this.Big5PFreq[5][75] = 60;
            this.Big5PFreq[36][52] = 59;
            this.Big5PFreq[51][164] = 58;
            this.Big5PFreq[12][85] = 57;
            this.Big5PFreq[39][168] = 56;
            this.Big5PFreq[43][16] = 55;
            this.Big5PFreq[40][69] = 54;
            this.Big5PFreq[26][108] = 53;
            this.Big5PFreq[51][56] = 52;
            this.Big5PFreq[16][37] = 51;
            this.Big5PFreq[40][29] = 50;
            this.Big5PFreq[46][171] = 49;
            this.Big5PFreq[40][128] = 48;
            this.Big5PFreq[72][114] = 47;
            this.Big5PFreq[21][103] = 46;
            this.Big5PFreq[22][44] = 45;
            this.Big5PFreq[40][115] = 44;
            this.Big5PFreq[43][7] = 43;
            this.Big5PFreq[43][153] = 42;
            this.Big5PFreq[17][20] = 41;
            this.Big5PFreq[16][49] = 40;
            this.Big5PFreq[36][57] = 39;
            this.Big5PFreq[18][38] = 38;
            this.Big5PFreq[45][184] = 37;
            this.Big5PFreq[37][167] = 36;
            this.Big5PFreq[26][106] = 35;
            this.Big5PFreq[61][121] = 34;
            this.Big5PFreq[89][140] = 33;
            this.Big5PFreq[46][61] = 32;
            this.Big5PFreq[39][163] = 31;
            this.Big5PFreq[40][62] = 30;
            this.Big5PFreq[38][165] = 29;
            this.Big5PFreq[47][37] = 28;
            this.Big5PFreq[18][155] = 27;
            this.Big5PFreq[20][33] = 26;
            this.Big5PFreq[29][90] = 25;
            this.Big5PFreq[20][103] = 24;
            this.Big5PFreq[37][51] = 23;
            this.Big5PFreq[57][0] = 22;
            this.Big5PFreq[40][31] = 21;
            this.Big5PFreq[45][32] = 20;
            this.Big5PFreq[59][23] = 19;
            this.Big5PFreq[18][47] = 18;
            this.Big5PFreq[45][134] = 17;
            this.Big5PFreq[37][59] = 16;
            this.Big5PFreq[21][128] = 15;
            this.Big5PFreq[36][106] = 14;
            this.Big5PFreq[31][39] = 13;
            this.Big5PFreq[40][182] = 12;
            this.Big5PFreq[52][155] = 11;
            this.Big5PFreq[42][166] = 10;
            this.Big5PFreq[35][27] = 9;
            this.Big5PFreq[38][3] = 8;
            this.Big5PFreq[13][44] = 7;
            this.Big5PFreq[58][157] = 6;
            this.Big5PFreq[47][51] = 5;
            this.Big5PFreq[41][37] = 4;
            this.Big5PFreq[41][172] = 3;
            this.Big5PFreq[51][165] = 2;
            this.Big5PFreq[15][161] = 1;
            this.Big5PFreq[24][181] = 0;
            this.EUC_TWFreq[48][49] = 599;
            this.EUC_TWFreq[35][65] = 598;
            this.EUC_TWFreq[41][27] = 597;
            this.EUC_TWFreq[35][0] = 596;
            this.EUC_TWFreq[39][19] = 595;
            this.EUC_TWFreq[35][42] = 594;
            this.EUC_TWFreq[38][66] = 593;
            this.EUC_TWFreq[35][8] = 592;
            this.EUC_TWFreq[35][6] = 591;
            this.EUC_TWFreq[35][66] = 590;
            this.EUC_TWFreq[43][14] = 589;
            this.EUC_TWFreq[69][80] = 588;
            this.EUC_TWFreq[50][48] = 587;
            this.EUC_TWFreq[36][71] = 586;
            this.EUC_TWFreq[37][10] = 585;
            this.EUC_TWFreq[60][52] = 584;
            this.EUC_TWFreq[51][21] = 583;
            this.EUC_TWFreq[40][2] = 582;
            this.EUC_TWFreq[67][35] = 581;
            this.EUC_TWFreq[38][78] = 580;
            this.EUC_TWFreq[49][18] = 579;
            this.EUC_TWFreq[35][23] = 578;
            this.EUC_TWFreq[42][83] = 577;
            this.EUC_TWFreq[79][47] = 576;
            this.EUC_TWFreq[61][82] = 575;
            this.EUC_TWFreq[38][7] = 574;
            this.EUC_TWFreq[35][29] = 573;
            this.EUC_TWFreq[37][77] = 572;
            this.EUC_TWFreq[54][67] = 571;
            this.EUC_TWFreq[38][80] = 570;
            this.EUC_TWFreq[52][74] = 569;
            this.EUC_TWFreq[36][37] = 568;
            this.EUC_TWFreq[74][8] = 567;
            this.EUC_TWFreq[41][83] = 566;
            this.EUC_TWFreq[36][75] = 565;
            this.EUC_TWFreq[49][63] = 564;
            this.EUC_TWFreq[42][58] = 563;
            this.EUC_TWFreq[56][33] = 562;
            this.EUC_TWFreq[37][76] = 561;
            this.EUC_TWFreq[62][39] = 560;
            this.EUC_TWFreq[35][21] = 559;
            this.EUC_TWFreq[70][19] = 558;
            this.EUC_TWFreq[77][88] = 557;
            this.EUC_TWFreq[51][14] = 556;
            this.EUC_TWFreq[36][17] = 555;
            this.EUC_TWFreq[44][51] = 554;
            this.EUC_TWFreq[38][72] = 553;
            this.EUC_TWFreq[74][90] = 552;
            this.EUC_TWFreq[35][48] = 551;
            this.EUC_TWFreq[35][69] = 550;
            this.EUC_TWFreq[66][86] = 549;
            this.EUC_TWFreq[57][20] = 548;
            this.EUC_TWFreq[35][53] = 547;
            this.EUC_TWFreq[36][87] = 546;
            this.EUC_TWFreq[84][67] = 545;
            this.EUC_TWFreq[70][56] = 544;
            this.EUC_TWFreq[71][54] = 543;
            this.EUC_TWFreq[60][70] = 542;
            this.EUC_TWFreq[80][1] = 541;
            this.EUC_TWFreq[39][59] = 540;
            this.EUC_TWFreq[39][51] = 539;
            this.EUC_TWFreq[35][44] = 538;
            this.EUC_TWFreq[48][4] = 537;
            this.EUC_TWFreq[55][24] = 536;
            this.EUC_TWFreq[52][4] = 535;
            this.EUC_TWFreq[54][26] = 534;
            this.EUC_TWFreq[36][31] = 533;
            this.EUC_TWFreq[37][22] = 532;
            this.EUC_TWFreq[37][9] = 531;
            this.EUC_TWFreq[46][0] = 530;
            this.EUC_TWFreq[56][46] = 529;
            this.EUC_TWFreq[47][93] = 528;
            this.EUC_TWFreq[37][25] = 527;
            this.EUC_TWFreq[39][8] = 526;
            this.EUC_TWFreq[46][73] = 525;
            this.EUC_TWFreq[38][48] = 524;
            this.EUC_TWFreq[39][83] = 523;
            this.EUC_TWFreq[60][92] = 522;
            this.EUC_TWFreq[70][11] = 521;
            this.EUC_TWFreq[63][84] = 520;
            this.EUC_TWFreq[38][65] = 519;
            this.EUC_TWFreq[45][45] = 518;
            this.EUC_TWFreq[63][49] = 517;
            this.EUC_TWFreq[63][50] = 516;
            this.EUC_TWFreq[39][93] = 515;
            this.EUC_TWFreq[68][20] = 514;
            this.EUC_TWFreq[44][84] = 513;
            this.EUC_TWFreq[66][34] = 512;
            this.EUC_TWFreq[37][58] = 511;
            this.EUC_TWFreq[39][0] = 510;
            this.EUC_TWFreq[59][1] = 509;
            this.EUC_TWFreq[47][8] = 508;
            this.EUC_TWFreq[61][17] = 507;
            this.EUC_TWFreq[53][87] = 506;
            this.EUC_TWFreq[67][26] = 505;
            this.EUC_TWFreq[43][46] = 504;
            this.EUC_TWFreq[38][61] = 503;
            this.EUC_TWFreq[45][9] = 502;
            this.EUC_TWFreq[66][83] = 501;
            this.EUC_TWFreq[43][88] = 500;
            this.EUC_TWFreq[85][20] = 499;
            this.EUC_TWFreq[57][36] = 498;
            this.EUC_TWFreq[43][6] = 497;
            this.EUC_TWFreq[86][77] = 496;
            this.EUC_TWFreq[42][70] = 495;
            this.EUC_TWFreq[49][78] = 494;
            this.EUC_TWFreq[36][40] = 493;
            this.EUC_TWFreq[42][71] = 492;
            this.EUC_TWFreq[58][49] = 491;
            this.EUC_TWFreq[35][20] = 490;
            this.EUC_TWFreq[76][20] = 489;
            this.EUC_TWFreq[39][25] = 488;
            this.EUC_TWFreq[40][34] = 487;
            this.EUC_TWFreq[39][76] = 486;
            this.EUC_TWFreq[40][1] = 485;
            this.EUC_TWFreq[59][0] = 484;
            this.EUC_TWFreq[39][70] = 483;
            this.EUC_TWFreq[46][14] = 482;
            this.EUC_TWFreq[68][77] = 481;
            this.EUC_TWFreq[38][55] = 480;
            this.EUC_TWFreq[35][78] = 479;
            this.EUC_TWFreq[84][44] = 478;
            this.EUC_TWFreq[36][41] = 477;
            this.EUC_TWFreq[37][62] = 476;
            this.EUC_TWFreq[65][67] = 475;
            this.EUC_TWFreq[69][66] = 474;
            this.EUC_TWFreq[73][55] = 473;
            this.EUC_TWFreq[71][49] = 472;
            this.EUC_TWFreq[66][87] = 471;
            this.EUC_TWFreq[38][33] = 470;
            this.EUC_TWFreq[64][61] = 469;
            this.EUC_TWFreq[35][7] = 468;
            this.EUC_TWFreq[47][49] = 467;
            this.EUC_TWFreq[56][14] = 466;
            this.EUC_TWFreq[36][49] = 465;
            this.EUC_TWFreq[50][81] = 464;
            this.EUC_TWFreq[55][76] = 463;
            this.EUC_TWFreq[35][19] = 462;
            this.EUC_TWFreq[44][47] = 461;
            this.EUC_TWFreq[35][15] = 460;
            this.EUC_TWFreq[82][59] = 459;
            this.EUC_TWFreq[35][43] = 458;
            this.EUC_TWFreq[73][0] = 457;
            this.EUC_TWFreq[57][83] = 456;
            this.EUC_TWFreq[42][46] = 455;
            this.EUC_TWFreq[36][0] = 454;
            this.EUC_TWFreq[70][88] = 453;
            this.EUC_TWFreq[42][22] = 452;
            this.EUC_TWFreq[46][58] = 451;
            this.EUC_TWFreq[36][34] = 450;
            this.EUC_TWFreq[39][24] = 449;
            this.EUC_TWFreq[35][55] = 448;
            this.EUC_TWFreq[44][91] = 447;
            this.EUC_TWFreq[37][51] = 446;
            this.EUC_TWFreq[36][19] = 445;
            this.EUC_TWFreq[69][90] = 444;
            this.EUC_TWFreq[55][35] = 443;
            this.EUC_TWFreq[35][54] = 442;
            this.EUC_TWFreq[49][61] = 441;
            this.EUC_TWFreq[36][67] = 440;
            this.EUC_TWFreq[88][34] = 439;
            this.EUC_TWFreq[35][17] = 438;
            this.EUC_TWFreq[65][69] = 437;
            this.EUC_TWFreq[74][89] = 436;
            this.EUC_TWFreq[37][31] = 435;
            this.EUC_TWFreq[43][48] = 434;
            this.EUC_TWFreq[89][27] = 433;
            this.EUC_TWFreq[42][79] = 432;
            this.EUC_TWFreq[69][57] = 431;
            this.EUC_TWFreq[36][13] = 430;
            this.EUC_TWFreq[35][62] = 429;
            this.EUC_TWFreq[65][47] = 428;
            this.EUC_TWFreq[56][8] = 427;
            this.EUC_TWFreq[38][79] = 426;
            this.EUC_TWFreq[37][64] = 425;
            this.EUC_TWFreq[64][64] = 424;
            this.EUC_TWFreq[38][53] = 423;
            this.EUC_TWFreq[38][31] = 422;
            this.EUC_TWFreq[56][81] = 421;
            this.EUC_TWFreq[36][22] = 420;
            this.EUC_TWFreq[43][4] = 419;
            this.EUC_TWFreq[36][90] = 418;
            this.EUC_TWFreq[38][62] = 417;
            this.EUC_TWFreq[66][85] = 416;
            this.EUC_TWFreq[39][1] = 415;
            this.EUC_TWFreq[59][40] = 414;
            this.EUC_TWFreq[58][93] = 413;
            this.EUC_TWFreq[44][43] = 412;
            this.EUC_TWFreq[39][49] = 411;
            this.EUC_TWFreq[64][2] = 410;
            this.EUC_TWFreq[41][35] = 409;
            this.EUC_TWFreq[60][22] = 408;
            this.EUC_TWFreq[35][91] = 407;
            this.EUC_TWFreq[78][1] = 406;
            this.EUC_TWFreq[36][14] = 405;
            this.EUC_TWFreq[82][29] = 404;
            this.EUC_TWFreq[52][86] = 403;
            this.EUC_TWFreq[40][16] = 402;
            this.EUC_TWFreq[91][52] = 401;
            this.EUC_TWFreq[50][75] = 400;
            this.EUC_TWFreq[64][30] = 399;
            this.EUC_TWFreq[90][78] = 398;
            this.EUC_TWFreq[36][52] = 397;
            this.EUC_TWFreq[55][87] = 396;
            this.EUC_TWFreq[57][5] = 395;
            this.EUC_TWFreq[57][31] = 394;
            this.EUC_TWFreq[42][35] = 393;
            this.EUC_TWFreq[69][50] = 392;
            this.EUC_TWFreq[45][8] = 391;
            this.EUC_TWFreq[50][87] = 390;
            this.EUC_TWFreq[69][55] = 389;
            this.EUC_TWFreq[92][3] = 388;
            this.EUC_TWFreq[36][43] = 387;
            this.EUC_TWFreq[64][10] = 386;
            this.EUC_TWFreq[56][25] = 385;
            this.EUC_TWFreq[60][68] = 384;
            this.EUC_TWFreq[51][46] = 383;
            this.EUC_TWFreq[50][0] = 382;
            this.EUC_TWFreq[38][30] = 381;
            this.EUC_TWFreq[50][85] = 380;
            this.EUC_TWFreq[60][54] = 379;
            this.EUC_TWFreq[73][6] = 378;
            this.EUC_TWFreq[73][28] = 377;
            this.EUC_TWFreq[56][19] = 376;
            this.EUC_TWFreq[62][69] = 375;
            this.EUC_TWFreq[81][66] = 374;
            this.EUC_TWFreq[40][32] = 373;
            this.EUC_TWFreq[76][31] = 372;
            this.EUC_TWFreq[35][10] = 371;
            this.EUC_TWFreq[41][37] = 370;
            this.EUC_TWFreq[52][82] = 369;
            this.EUC_TWFreq[91][72] = 368;
            this.EUC_TWFreq[37][29] = 367;
            this.EUC_TWFreq[56][30] = 366;
            this.EUC_TWFreq[37][80] = 365;
            this.EUC_TWFreq[81][56] = 364;
            this.EUC_TWFreq[70][3] = 363;
            this.EUC_TWFreq[76][15] = 362;
            this.EUC_TWFreq[46][47] = 361;
            this.EUC_TWFreq[35][88] = 360;
            this.EUC_TWFreq[61][58] = 359;
            this.EUC_TWFreq[37][37] = 358;
            this.EUC_TWFreq[57][22] = 357;
            this.EUC_TWFreq[41][23] = 356;
            this.EUC_TWFreq[90][66] = 355;
            this.EUC_TWFreq[39][60] = 354;
            this.EUC_TWFreq[38][0] = 353;
            this.EUC_TWFreq[37][87] = 352;
            this.EUC_TWFreq[46][2] = 351;
            this.EUC_TWFreq[38][56] = 350;
            this.EUC_TWFreq[58][11] = 349;
            this.EUC_TWFreq[48][10] = 348;
            this.EUC_TWFreq[74][4] = 347;
            this.EUC_TWFreq[40][42] = 346;
            this.EUC_TWFreq[41][52] = 345;
            this.EUC_TWFreq[61][92] = 344;
            this.EUC_TWFreq[39][50] = 343;
            this.EUC_TWFreq[47][88] = 342;
            this.EUC_TWFreq[88][36] = 341;
            this.EUC_TWFreq[45][73] = 340;
            this.EUC_TWFreq[82][3] = 339;
            this.EUC_TWFreq[61][36] = 338;
            this.EUC_TWFreq[60][33] = 337;
            this.EUC_TWFreq[38][27] = 336;
            this.EUC_TWFreq[35][83] = 335;
            this.EUC_TWFreq[65][24] = 334;
            this.EUC_TWFreq[73][10] = 333;
            this.EUC_TWFreq[41][13] = 332;
            this.EUC_TWFreq[50][27] = 331;
            this.EUC_TWFreq[59][50] = 330;
            this.EUC_TWFreq[42][45] = 329;
            this.EUC_TWFreq[55][19] = 328;
            this.EUC_TWFreq[36][77] = 327;
            this.EUC_TWFreq[69][31] = 326;
            this.EUC_TWFreq[60][7] = 325;
            this.EUC_TWFreq[40][88] = 324;
            this.EUC_TWFreq[57][56] = 323;
            this.EUC_TWFreq[50][50] = 322;
            this.EUC_TWFreq[42][37] = 321;
            this.EUC_TWFreq[38][82] = 320;
            this.EUC_TWFreq[52][25] = 319;
            this.EUC_TWFreq[42][67] = 318;
            this.EUC_TWFreq[48][40] = 317;
            this.EUC_TWFreq[45][81] = 316;
            this.EUC_TWFreq[57][14] = 315;
            this.EUC_TWFreq[42][13] = 314;
            this.EUC_TWFreq[78][0] = 313;
            this.EUC_TWFreq[35][51] = 312;
            this.EUC_TWFreq[41][67] = 311;
            this.EUC_TWFreq[64][23] = 310;
            this.EUC_TWFreq[36][65] = 309;
            this.EUC_TWFreq[48][50] = 308;
            this.EUC_TWFreq[46][69] = 307;
            this.EUC_TWFreq[47][89] = 306;
            this.EUC_TWFreq[41][48] = 305;
            this.EUC_TWFreq[60][56] = 304;
            this.EUC_TWFreq[44][82] = 303;
            this.EUC_TWFreq[47][35] = 302;
            this.EUC_TWFreq[49][3] = 301;
            this.EUC_TWFreq[49][69] = 300;
            this.EUC_TWFreq[45][93] = 299;
            this.EUC_TWFreq[60][34] = 298;
            this.EUC_TWFreq[60][82] = 297;
            this.EUC_TWFreq[61][61] = 296;
            this.EUC_TWFreq[86][42] = 295;
            this.EUC_TWFreq[89][60] = 294;
            this.EUC_TWFreq[48][31] = 293;
            this.EUC_TWFreq[35][75] = 292;
            this.EUC_TWFreq[91][39] = 291;
            this.EUC_TWFreq[53][19] = 290;
            this.EUC_TWFreq[39][72] = 289;
            this.EUC_TWFreq[69][59] = 288;
            this.EUC_TWFreq[41][7] = 287;
            this.EUC_TWFreq[54][13] = 286;
            this.EUC_TWFreq[43][28] = 285;
            this.EUC_TWFreq[36][6] = 284;
            this.EUC_TWFreq[45][75] = 283;
            this.EUC_TWFreq[36][61] = 282;
            this.EUC_TWFreq[38][21] = 281;
            this.EUC_TWFreq[45][14] = 280;
            this.EUC_TWFreq[61][43] = 279;
            this.EUC_TWFreq[36][63] = 278;
            this.EUC_TWFreq[43][30] = 277;
            this.EUC_TWFreq[46][51] = 276;
            this.EUC_TWFreq[68][87] = 275;
            this.EUC_TWFreq[39][26] = 274;
            this.EUC_TWFreq[46][76] = 273;
            this.EUC_TWFreq[36][15] = 272;
            this.EUC_TWFreq[35][40] = 271;
            this.EUC_TWFreq[79][60] = 270;
            this.EUC_TWFreq[46][7] = 269;
            this.EUC_TWFreq[65][72] = 268;
            this.EUC_TWFreq[69][88] = 267;
            this.EUC_TWFreq[47][18] = 266;
            this.EUC_TWFreq[37][0] = 265;
            this.EUC_TWFreq[37][49] = 264;
            this.EUC_TWFreq[67][37] = 263;
            this.EUC_TWFreq[36][91] = 262;
            this.EUC_TWFreq[75][48] = 261;
            this.EUC_TWFreq[75][63] = 260;
            this.EUC_TWFreq[83][87] = 259;
            this.EUC_TWFreq[37][44] = 258;
            this.EUC_TWFreq[73][54] = 257;
            this.EUC_TWFreq[51][61] = 256;
            this.EUC_TWFreq[46][57] = 255;
            this.EUC_TWFreq[55][21] = 254;
            this.EUC_TWFreq[39][66] = 253;
            this.EUC_TWFreq[47][11] = 252;
            this.EUC_TWFreq[52][8] = 251;
            this.EUC_TWFreq[82][81] = 250;
            this.EUC_TWFreq[36][57] = 249;
            this.EUC_TWFreq[38][54] = 248;
            this.EUC_TWFreq[43][81] = 247;
            this.EUC_TWFreq[37][42] = 246;
            this.EUC_TWFreq[40][18] = 245;
            this.EUC_TWFreq[80][90] = 244;
            this.EUC_TWFreq[37][84] = 243;
            this.EUC_TWFreq[57][15] = 242;
            this.EUC_TWFreq[38][87] = 241;
            this.EUC_TWFreq[37][32] = 240;
            this.EUC_TWFreq[53][53] = 239;
            this.EUC_TWFreq[89][29] = 238;
            this.EUC_TWFreq[81][53] = 237;
            this.EUC_TWFreq[75][3] = 236;
            this.EUC_TWFreq[83][73] = 235;
            this.EUC_TWFreq[66][13] = 234;
            this.EUC_TWFreq[48][7] = 233;
            this.EUC_TWFreq[46][35] = 232;
            this.EUC_TWFreq[35][86] = 231;
            this.EUC_TWFreq[37][20] = 230;
            this.EUC_TWFreq[46][80] = 229;
            this.EUC_TWFreq[38][24] = 228;
            this.EUC_TWFreq[41][68] = 227;
            this.EUC_TWFreq[42][21] = 226;
            this.EUC_TWFreq[43][32] = 225;
            this.EUC_TWFreq[38][20] = 224;
            this.EUC_TWFreq[37][59] = 223;
            this.EUC_TWFreq[41][77] = 222;
            this.EUC_TWFreq[59][57] = 221;
            this.EUC_TWFreq[68][59] = 220;
            this.EUC_TWFreq[39][43] = 219;
            this.EUC_TWFreq[54][39] = 218;
            this.EUC_TWFreq[48][28] = 217;
            this.EUC_TWFreq[54][28] = 216;
            this.EUC_TWFreq[41][44] = 215;
            this.EUC_TWFreq[51][64] = 214;
            this.EUC_TWFreq[47][72] = 213;
            this.EUC_TWFreq[62][67] = 212;
            this.EUC_TWFreq[42][43] = 211;
            this.EUC_TWFreq[61][38] = 210;
            this.EUC_TWFreq[76][25] = 209;
            this.EUC_TWFreq[48][91] = 208;
            this.EUC_TWFreq[36][36] = 207;
            this.EUC_TWFreq[80][32] = 206;
            this.EUC_TWFreq[81][40] = 205;
            this.EUC_TWFreq[37][5] = 204;
            this.EUC_TWFreq[74][69] = 203;
            this.EUC_TWFreq[36][82] = 202;
            this.EUC_TWFreq[46][59] = 201;
            this.GBKFreq[52][132] = 600;
            this.GBKFreq[73][135] = 599;
            this.GBKFreq[49][123] = 598;
            this.GBKFreq[77][146] = 597;
            this.GBKFreq[81][123] = 596;
            this.GBKFreq[82][144] = 595;
            this.GBKFreq[51][179] = 594;
            this.GBKFreq[83][154] = 593;
            this.GBKFreq[71][139] = 592;
            this.GBKFreq[64][139] = 591;
            this.GBKFreq[85][144] = 590;
            this.GBKFreq[52][125] = 589;
            this.GBKFreq[88][25] = 588;
            this.GBKFreq[81][106] = 587;
            this.GBKFreq[81][148] = 586;
            this.GBKFreq[62][137] = 585;
            this.GBKFreq[94][0] = 584;
            this.GBKFreq[1][64] = 583;
            this.GBKFreq[67][163] = 582;
            this.GBKFreq[20][190] = 581;
            this.GBKFreq[57][131] = 580;
            this.GBKFreq[29][169] = 579;
            this.GBKFreq[72][143] = 578;
            this.GBKFreq[0][173] = 577;
            this.GBKFreq[11][23] = 576;
            this.GBKFreq[61][141] = 575;
            this.GBKFreq[60][123] = 574;
            this.GBKFreq[81][114] = 573;
            this.GBKFreq[82][131] = 572;
            this.GBKFreq[67][156] = 571;
            this.GBKFreq[71][167] = 570;
            this.GBKFreq[20][50] = 569;
            this.GBKFreq[77][132] = 568;
            this.GBKFreq[84][38] = 567;
            this.GBKFreq[26][29] = 566;
            this.GBKFreq[74][187] = 565;
            this.GBKFreq[62][116] = 564;
            this.GBKFreq[67][135] = 563;
            this.GBKFreq[5][86] = 562;
            this.GBKFreq[72][186] = 561;
            this.GBKFreq[75][161] = 560;
            this.GBKFreq[78][130] = 559;
            this.GBKFreq[94][30] = 558;
            this.GBKFreq[84][72] = 557;
            this.GBKFreq[1][67] = 556;
            this.GBKFreq[75][172] = 555;
            this.GBKFreq[74][185] = 554;
            this.GBKFreq[53][160] = 553;
            this.GBKFreq[123][14] = 552;
            this.GBKFreq[79][97] = 551;
            this.GBKFreq[85][110] = 550;
            this.GBKFreq[78][171] = 549;
            this.GBKFreq[52][131] = 548;
            this.GBKFreq[56][100] = 547;
            this.GBKFreq[50][182] = 546;
            this.GBKFreq[94][64] = 545;
            this.GBKFreq[106][74] = 544;
            this.GBKFreq[11][102] = 543;
            this.GBKFreq[53][124] = 542;
            this.GBKFreq[24][3] = 541;
            this.GBKFreq[86][148] = 540;
            this.GBKFreq[53][184] = 539;
            this.GBKFreq[86][147] = 538;
            this.GBKFreq[96][161] = 537;
            this.GBKFreq[82][77] = 536;
            this.GBKFreq[59][146] = 535;
            this.GBKFreq[84][126] = 534;
            this.GBKFreq[79][132] = 533;
            this.GBKFreq[85][123] = 532;
            this.GBKFreq[71][101] = 531;
            this.GBKFreq[85][106] = 530;
            this.GBKFreq[6][184] = 529;
            this.GBKFreq[57][156] = 528;
            this.GBKFreq[75][104] = 527;
            this.GBKFreq[50][137] = 526;
            this.GBKFreq[79][133] = 525;
            this.GBKFreq[76][108] = 524;
            this.GBKFreq[57][142] = 523;
            this.GBKFreq[84][130] = 522;
            this.GBKFreq[52][128] = 521;
            this.GBKFreq[47][44] = 520;
            this.GBKFreq[52][152] = 519;
            this.GBKFreq[54][104] = 518;
            this.GBKFreq[30][47] = 517;
            this.GBKFreq[71][123] = 516;
            this.GBKFreq[52][107] = 515;
            this.GBKFreq[45][84] = 514;
            this.GBKFreq[107][118] = 513;
            this.GBKFreq[5][161] = 512;
            this.GBKFreq[48][126] = 511;
            this.GBKFreq[67][170] = 510;
            this.GBKFreq[43][6] = 509;
            this.GBKFreq[70][112] = 508;
            this.GBKFreq[86][174] = 507;
            this.GBKFreq[84][166] = 506;
            this.GBKFreq[79][130] = 505;
            this.GBKFreq[57][141] = 504;
            this.GBKFreq[81][178] = 503;
            this.GBKFreq[56][187] = 502;
            this.GBKFreq[81][162] = 501;
            this.GBKFreq[53][104] = 500;
            this.GBKFreq[123][35] = 499;
            this.GBKFreq[70][169] = 498;
            this.GBKFreq[69][164] = 497;
            this.GBKFreq[109][61] = 496;
            this.GBKFreq[73][130] = 495;
            this.GBKFreq[62][134] = 494;
            this.GBKFreq[54][125] = 493;
            this.GBKFreq[79][105] = 492;
            this.GBKFreq[70][165] = 491;
            this.GBKFreq[71][189] = 490;
            this.GBKFreq[23][147] = 489;
            this.GBKFreq[51][139] = 488;
            this.GBKFreq[47][137] = 487;
            this.GBKFreq[77][123] = 486;
            this.GBKFreq[86][183] = 485;
            this.GBKFreq[63][173] = 484;
            this.GBKFreq[79][144] = 483;
            this.GBKFreq[84][159] = 482;
            this.GBKFreq[60][91] = 481;
            this.GBKFreq[66][187] = 480;
            this.GBKFreq[73][114] = 479;
            this.GBKFreq[85][56] = 478;
            this.GBKFreq[71][149] = 477;
            this.GBKFreq[84][189] = 476;
            this.GBKFreq[104][31] = 475;
            this.GBKFreq[83][82] = 474;
            this.GBKFreq[68][35] = 473;
            this.GBKFreq[11][77] = 472;
            this.GBKFreq[15][155] = 471;
            this.GBKFreq[83][153] = 470;
            this.GBKFreq[71][1] = 469;
            this.GBKFreq[53][190] = 468;
            this.GBKFreq[50][135] = 467;
            this.GBKFreq[3][147] = 466;
            this.GBKFreq[48][136] = 465;
            this.GBKFreq[66][166] = 464;
            this.GBKFreq[55][159] = 463;
            this.GBKFreq[82][150] = 462;
            this.GBKFreq[58][178] = 461;
            this.GBKFreq[64][102] = 460;
            this.GBKFreq[16][106] = 459;
            this.GBKFreq[68][110] = 458;
            this.GBKFreq[54][14] = 457;
            this.GBKFreq[60][140] = 456;
            this.GBKFreq[91][71] = 455;
            this.GBKFreq[54][150] = 454;
            this.GBKFreq[78][177] = 453;
            this.GBKFreq[78][117] = 452;
            this.GBKFreq[104][12] = 451;
            this.GBKFreq[73][150] = 450;
            this.GBKFreq[51][142] = 449;
            this.GBKFreq[81][145] = 448;
            this.GBKFreq[66][183] = 447;
            this.GBKFreq[51][178] = 446;
            this.GBKFreq[75][107] = 445;
            this.GBKFreq[65][119] = 444;
            this.GBKFreq[69][176] = 443;
            this.GBKFreq[59][122] = 442;
            this.GBKFreq[78][160] = 441;
            this.GBKFreq[85][183] = 440;
            this.GBKFreq[105][16] = 439;
            this.GBKFreq[73][110] = 438;
            this.GBKFreq[104][39] = 437;
            this.GBKFreq[119][16] = 436;
            this.GBKFreq[76][162] = 435;
            this.GBKFreq[67][152] = 434;
            this.GBKFreq[82][24] = 433;
            this.GBKFreq[73][121] = 432;
            this.GBKFreq[83][83] = 431;
            this.GBKFreq[82][145] = 430;
            this.GBKFreq[49][133] = 429;
            this.GBKFreq[94][13] = 428;
            this.GBKFreq[58][139] = 427;
            this.GBKFreq[74][189] = 426;
            this.GBKFreq[66][177] = 425;
            this.GBKFreq[85][184] = 424;
            this.GBKFreq[55][183] = 423;
            this.GBKFreq[71][107] = 422;
            this.GBKFreq[11][98] = 421;
            this.GBKFreq[72][153] = 420;
            this.GBKFreq[2][137] = 419;
            this.GBKFreq[59][147] = 418;
            this.GBKFreq[58][152] = 417;
            this.GBKFreq[55][144] = 416;
            this.GBKFreq[73][125] = 415;
            this.GBKFreq[52][154] = 414;
            this.GBKFreq[70][178] = 413;
            this.GBKFreq[79][148] = 412;
            this.GBKFreq[63][143] = 411;
            this.GBKFreq[50][140] = 410;
            this.GBKFreq[47][145] = 409;
            this.GBKFreq[48][123] = 408;
            this.GBKFreq[56][107] = 407;
            this.GBKFreq[84][83] = 406;
            this.GBKFreq[59][112] = 405;
            this.GBKFreq[124][72] = 404;
            this.GBKFreq[79][99] = 403;
            this.GBKFreq[3][37] = 402;
            this.GBKFreq[114][55] = 401;
            this.GBKFreq[85][152] = 400;
            this.GBKFreq[60][47] = 399;
            this.GBKFreq[65][96] = 398;
            this.GBKFreq[74][110] = 397;
            this.GBKFreq[86][182] = 396;
            this.GBKFreq[50][99] = 395;
            this.GBKFreq[67][186] = 394;
            this.GBKFreq[81][74] = 393;
            this.GBKFreq[80][37] = 392;
            this.GBKFreq[21][60] = 391;
            this.GBKFreq[110][12] = 390;
            this.GBKFreq[60][162] = 389;
            this.GBKFreq[29][115] = 388;
            this.GBKFreq[83][130] = 387;
            this.GBKFreq[52][136] = 386;
            this.GBKFreq[63][114] = 385;
            this.GBKFreq[49][127] = 384;
            this.GBKFreq[83][109] = 383;
            this.GBKFreq[66][128] = 382;
            this.GBKFreq[78][136] = 381;
            this.GBKFreq[81][180] = 380;
            this.GBKFreq[76][104] = 379;
            this.GBKFreq[56][156] = 378;
            this.GBKFreq[61][23] = 377;
            this.GBKFreq[4][30] = 376;
            this.GBKFreq[69][154] = 375;
            this.GBKFreq[100][37] = 374;
            this.GBKFreq[54][177] = 373;
            this.GBKFreq[23][119] = 372;
            this.GBKFreq[71][171] = 371;
            this.GBKFreq[84][146] = 370;
            this.GBKFreq[20][184] = 369;
            this.GBKFreq[86][76] = 368;
            this.GBKFreq[74][132] = 367;
            this.GBKFreq[47][97] = 366;
            this.GBKFreq[82][137] = 365;
            this.GBKFreq[94][56] = 364;
            this.GBKFreq[92][30] = 363;
            this.GBKFreq[19][117] = 362;
            this.GBKFreq[48][173] = 361;
            this.GBKFreq[2][136] = 360;
            this.GBKFreq[7][182] = 359;
            this.GBKFreq[74][188] = 358;
            this.GBKFreq[14][132] = 357;
            this.GBKFreq[62][172] = 356;
            this.GBKFreq[25][39] = 355;
            this.GBKFreq[85][129] = 354;
            this.GBKFreq[64][98] = 353;
            this.GBKFreq[67][127] = 352;
            this.GBKFreq[72][167] = 351;
            this.GBKFreq[57][143] = 350;
            this.GBKFreq[76][187] = 349;
            this.GBKFreq[83][181] = 348;
            this.GBKFreq[84][10] = 347;
            this.GBKFreq[55][166] = 346;
            this.GBKFreq[55][188] = 345;
            this.GBKFreq[13][151] = 344;
            this.GBKFreq[62][124] = 343;
            this.GBKFreq[53][136] = 342;
            this.GBKFreq[106][57] = 341;
            this.GBKFreq[47][166] = 340;
            this.GBKFreq[109][30] = 339;
            this.GBKFreq[78][114] = 338;
            this.GBKFreq[83][19] = 337;
            this.GBKFreq[56][162] = 336;
            this.GBKFreq[60][177] = 335;
            this.GBKFreq[88][9] = 334;
            this.GBKFreq[74][163] = 333;
            this.GBKFreq[52][156] = 332;
            this.GBKFreq[71][180] = 331;
            this.GBKFreq[60][57] = 330;
            this.GBKFreq[72][173] = 329;
            this.GBKFreq[82][91] = 328;
            this.GBKFreq[51][186] = 327;
            this.GBKFreq[75][86] = 326;
            this.GBKFreq[75][78] = 325;
            this.GBKFreq[76][170] = 324;
            this.GBKFreq[60][147] = 323;
            this.GBKFreq[82][75] = 322;
            this.GBKFreq[80][148] = 321;
            this.GBKFreq[86][150] = 320;
            this.GBKFreq[13][95] = 319;
            this.GBKFreq[0][11] = 318;
            this.GBKFreq[84][190] = 317;
            this.GBKFreq[76][166] = 316;
            this.GBKFreq[14][72] = 315;
            this.GBKFreq[67][144] = 314;
            this.GBKFreq[84][44] = 313;
            this.GBKFreq[72][125] = 312;
            this.GBKFreq[66][127] = 311;
            this.GBKFreq[60][25] = 310;
            this.GBKFreq[70][146] = 309;
            this.GBKFreq[79][135] = 308;
            this.GBKFreq[54][135] = 307;
            this.GBKFreq[60][104] = 306;
            this.GBKFreq[55][132] = 305;
            this.GBKFreq[94][2] = 304;
            this.GBKFreq[54][133] = 303;
            this.GBKFreq[56][190] = 302;
            this.GBKFreq[58][174] = 301;
            this.GBKFreq[80][144] = 300;
            this.GBKFreq[85][113] = 299;
            this.KRFreq[31][43] = 600;
            this.KRFreq[19][56] = 599;
            this.KRFreq[38][46] = 598;
            this.KRFreq[3][3] = 597;
            this.KRFreq[29][77] = 596;
            this.KRFreq[19][33] = 595;
            this.KRFreq[30][0] = 594;
            this.KRFreq[29][89] = 593;
            this.KRFreq[31][26] = 592;
            this.KRFreq[31][38] = 591;
            this.KRFreq[32][85] = 590;
            this.KRFreq[15][0] = 589;
            this.KRFreq[16][54] = 588;
            this.KRFreq[15][76] = 587;
            this.KRFreq[31][25] = 586;
            this.KRFreq[23][13] = 585;
            this.KRFreq[28][34] = 584;
            this.KRFreq[18][9] = 583;
            this.KRFreq[29][37] = 582;
            this.KRFreq[22][45] = 581;
            this.KRFreq[19][46] = 580;
            this.KRFreq[16][65] = 579;
            this.KRFreq[23][5] = 578;
            this.KRFreq[26][70] = 577;
            this.KRFreq[31][53] = 576;
            this.KRFreq[27][12] = 575;
            this.KRFreq[30][67] = 574;
            this.KRFreq[31][57] = 573;
            this.KRFreq[20][20] = 572;
            this.KRFreq[30][31] = 571;
            this.KRFreq[20][72] = 570;
            this.KRFreq[15][51] = 569;
            this.KRFreq[3][8] = 568;
            this.KRFreq[32][53] = 567;
            this.KRFreq[27][85] = 566;
            this.KRFreq[25][23] = 565;
            this.KRFreq[15][44] = 564;
            this.KRFreq[32][3] = 563;
            this.KRFreq[31][68] = 562;
            this.KRFreq[30][24] = 561;
            this.KRFreq[29][49] = 560;
            this.KRFreq[27][49] = 559;
            this.KRFreq[23][23] = 558;
            this.KRFreq[31][91] = 557;
            this.KRFreq[31][46] = 556;
            this.KRFreq[19][74] = 555;
            this.KRFreq[27][27] = 554;
            this.KRFreq[3][17] = 553;
            this.KRFreq[20][38] = 552;
            this.KRFreq[21][82] = 551;
            this.KRFreq[28][25] = 550;
            this.KRFreq[32][5] = 549;
            this.KRFreq[31][23] = 548;
            this.KRFreq[25][45] = 547;
            this.KRFreq[32][87] = 546;
            this.KRFreq[18][26] = 545;
            this.KRFreq[24][10] = 544;
            this.KRFreq[26][82] = 543;
            this.KRFreq[15][89] = 542;
            this.KRFreq[28][36] = 541;
            this.KRFreq[28][31] = 540;
            this.KRFreq[16][23] = 539;
            this.KRFreq[16][77] = 538;
            this.KRFreq[19][84] = 537;
            this.KRFreq[23][72] = 536;
            this.KRFreq[38][48] = 535;
            this.KRFreq[23][2] = 534;
            this.KRFreq[30][20] = 533;
            this.KRFreq[38][47] = 532;
            this.KRFreq[39][12] = 531;
            this.KRFreq[23][21] = 530;
            this.KRFreq[18][17] = 529;
            this.KRFreq[30][87] = 528;
            this.KRFreq[29][62] = 527;
            this.KRFreq[29][87] = 526;
            this.KRFreq[34][53] = 525;
            this.KRFreq[32][29] = 524;
            this.KRFreq[35][0] = 523;
            this.KRFreq[24][43] = 522;
            this.KRFreq[36][44] = 521;
            this.KRFreq[20][30] = 520;
            this.KRFreq[39][86] = 519;
            this.KRFreq[22][14] = 518;
            this.KRFreq[29][39] = 517;
            this.KRFreq[28][38] = 516;
            this.KRFreq[23][79] = 515;
            this.KRFreq[24][56] = 514;
            this.KRFreq[29][63] = 513;
            this.KRFreq[31][45] = 512;
            this.KRFreq[23][26] = 511;
            this.KRFreq[15][87] = 510;
            this.KRFreq[30][74] = 509;
            this.KRFreq[24][69] = 508;
            this.KRFreq[20][4] = 507;
            this.KRFreq[27][50] = 506;
            this.KRFreq[30][75] = 505;
            this.KRFreq[24][13] = 504;
            this.KRFreq[30][8] = 503;
            this.KRFreq[31][6] = 502;
            this.KRFreq[25][80] = 501;
            this.KRFreq[36][8] = 500;
            this.KRFreq[15][18] = 499;
            this.KRFreq[39][23] = 498;
            this.KRFreq[16][24] = 497;
            this.KRFreq[31][89] = 496;
            this.KRFreq[15][71] = 495;
            this.KRFreq[15][57] = 494;
            this.KRFreq[30][11] = 493;
            this.KRFreq[15][36] = 492;
            this.KRFreq[16][60] = 491;
            this.KRFreq[24][45] = 490;
            this.KRFreq[37][35] = 489;
            this.KRFreq[24][87] = 488;
            this.KRFreq[20][45] = 487;
            this.KRFreq[31][90] = 486;
            this.KRFreq[32][21] = 485;
            this.KRFreq[19][70] = 484;
            this.KRFreq[24][15] = 483;
            this.KRFreq[26][92] = 482;
            this.KRFreq[37][13] = 481;
            this.KRFreq[39][2] = 480;
            this.KRFreq[23][70] = 479;
            this.KRFreq[27][25] = 478;
            this.KRFreq[15][69] = 477;
            this.KRFreq[19][61] = 476;
            this.KRFreq[31][58] = 475;
            this.KRFreq[24][57] = 474;
            this.KRFreq[36][74] = 473;
            this.KRFreq[21][6] = 472;
            this.KRFreq[30][44] = 471;
            this.KRFreq[15][91] = 470;
            this.KRFreq[27][16] = 469;
            this.KRFreq[29][42] = 468;
            this.KRFreq[33][86] = 467;
            this.KRFreq[29][41] = 466;
            this.KRFreq[20][68] = 465;
            this.KRFreq[25][47] = 464;
            this.KRFreq[22][0] = 463;
            this.KRFreq[18][14] = 462;
            this.KRFreq[31][28] = 461;
            this.KRFreq[15][2] = 460;
            this.KRFreq[23][76] = 459;
            this.KRFreq[38][32] = 458;
            this.KRFreq[29][82] = 457;
            this.KRFreq[21][86] = 456;
            this.KRFreq[24][62] = 455;
            this.KRFreq[31][64] = 454;
            this.KRFreq[38][26] = 453;
            this.KRFreq[32][86] = 452;
            this.KRFreq[22][32] = 451;
            this.KRFreq[19][59] = 450;
            this.KRFreq[34][18] = 449;
            this.KRFreq[18][54] = 448;
            this.KRFreq[38][63] = 447;
            this.KRFreq[36][23] = 446;
            this.KRFreq[35][35] = 445;
            this.KRFreq[32][62] = 444;
            this.KRFreq[28][35] = 443;
            this.KRFreq[27][13] = 442;
            this.KRFreq[31][59] = 441;
            this.KRFreq[29][29] = 440;
            this.KRFreq[15][64] = 439;
            this.KRFreq[26][84] = 438;
            this.KRFreq[21][90] = 437;
            this.KRFreq[20][24] = 436;
            this.KRFreq[16][18] = 435;
            this.KRFreq[22][23] = 434;
            this.KRFreq[31][14] = 433;
            this.KRFreq[15][1] = 432;
            this.KRFreq[18][63] = 431;
            this.KRFreq[19][10] = 430;
            this.KRFreq[25][49] = 429;
            this.KRFreq[36][57] = 428;
            this.KRFreq[20][22] = 427;
            this.KRFreq[15][15] = 426;
            this.KRFreq[31][51] = 425;
            this.KRFreq[24][60] = 424;
            this.KRFreq[31][70] = 423;
            this.KRFreq[15][7] = 422;
            this.KRFreq[28][40] = 421;
            this.KRFreq[18][41] = 420;
            this.KRFreq[15][38] = 419;
            this.KRFreq[32][0] = 418;
            this.KRFreq[19][51] = 417;
            this.KRFreq[34][62] = 416;
            this.KRFreq[16][27] = 415;
            this.KRFreq[20][70] = 414;
            this.KRFreq[22][33] = 413;
            this.KRFreq[26][73] = 412;
            this.KRFreq[20][79] = 411;
            this.KRFreq[23][6] = 410;
            this.KRFreq[24][85] = 409;
            this.KRFreq[38][51] = 408;
            this.KRFreq[29][88] = 407;
            this.KRFreq[38][55] = 406;
            this.KRFreq[32][32] = 405;
            this.KRFreq[27][18] = 404;
            this.KRFreq[23][87] = 403;
            this.KRFreq[35][6] = 402;
            this.KRFreq[34][27] = 401;
            this.KRFreq[39][35] = 400;
            this.KRFreq[30][88] = 399;
            this.KRFreq[32][92] = 398;
            this.KRFreq[32][49] = 397;
            this.KRFreq[24][61] = 396;
            this.KRFreq[18][74] = 395;
            this.KRFreq[23][77] = 394;
            this.KRFreq[23][50] = 393;
            this.KRFreq[23][32] = 392;
            this.KRFreq[23][36] = 391;
            this.KRFreq[38][38] = 390;
            this.KRFreq[29][86] = 389;
            this.KRFreq[36][15] = 388;
            this.KRFreq[31][50] = 387;
            this.KRFreq[15][86] = 386;
            this.KRFreq[39][13] = 385;
            this.KRFreq[34][26] = 384;
            this.KRFreq[19][34] = 383;
            this.KRFreq[16][3] = 382;
            this.KRFreq[26][93] = 381;
            this.KRFreq[19][67] = 380;
            this.KRFreq[24][72] = 379;
            this.KRFreq[29][17] = 378;
            this.KRFreq[23][24] = 377;
            this.KRFreq[25][19] = 376;
            this.KRFreq[18][65] = 375;
            this.KRFreq[30][78] = 374;
            this.KRFreq[27][52] = 373;
            this.KRFreq[22][18] = 372;
            this.KRFreq[16][38] = 371;
            this.KRFreq[21][26] = 370;
            this.KRFreq[34][20] = 369;
            this.KRFreq[15][42] = 368;
            this.KRFreq[16][71] = 367;
            this.KRFreq[17][17] = 366;
            this.KRFreq[24][71] = 365;
            this.KRFreq[18][84] = 364;
            this.KRFreq[15][40] = 363;
            this.KRFreq[31][62] = 362;
            this.KRFreq[15][8] = 361;
            this.KRFreq[16][69] = 360;
            this.KRFreq[29][79] = 359;
            this.KRFreq[38][91] = 358;
            this.KRFreq[31][92] = 357;
            this.KRFreq[20][77] = 356;
            this.KRFreq[3][16] = 355;
            this.KRFreq[27][87] = 354;
            this.KRFreq[16][25] = 353;
            this.KRFreq[36][33] = 352;
            this.KRFreq[37][76] = 351;
            this.KRFreq[30][12] = 350;
            this.KRFreq[26][75] = 349;
            this.KRFreq[25][14] = 348;
            this.KRFreq[32][26] = 347;
            this.KRFreq[23][22] = 346;
            this.KRFreq[20][90] = 345;
            this.KRFreq[19][8] = 344;
            this.KRFreq[38][41] = 343;
            this.KRFreq[34][2] = 342;
            this.KRFreq[39][4] = 341;
            this.KRFreq[27][89] = 340;
            this.KRFreq[28][41] = 339;
            this.KRFreq[28][44] = 338;
            this.KRFreq[24][92] = 337;
            this.KRFreq[34][65] = 336;
            this.KRFreq[39][14] = 335;
            this.KRFreq[21][38] = 334;
            this.KRFreq[19][31] = 333;
            this.KRFreq[37][39] = 332;
            this.KRFreq[33][41] = 331;
            this.KRFreq[38][4] = 330;
            this.KRFreq[23][80] = 329;
            this.KRFreq[25][24] = 328;
            this.KRFreq[37][17] = 327;
            this.KRFreq[22][16] = 326;
            this.KRFreq[22][46] = 325;
            this.KRFreq[33][91] = 324;
            this.KRFreq[24][89] = 323;
            this.KRFreq[30][52] = 322;
            this.KRFreq[29][38] = 321;
            this.KRFreq[38][85] = 320;
            this.KRFreq[15][12] = 319;
            this.KRFreq[27][58] = 318;
            this.KRFreq[29][52] = 317;
            this.KRFreq[37][38] = 316;
            this.KRFreq[34][41] = 315;
            this.KRFreq[31][65] = 314;
            this.KRFreq[29][53] = 313;
            this.KRFreq[22][47] = 312;
            this.KRFreq[22][19] = 311;
            this.KRFreq[26][0] = 310;
            this.KRFreq[37][86] = 309;
            this.KRFreq[35][4] = 308;
            this.KRFreq[36][54] = 307;
            this.KRFreq[20][76] = 306;
            this.KRFreq[30][9] = 305;
            this.KRFreq[30][33] = 304;
            this.KRFreq[23][17] = 303;
            this.KRFreq[23][33] = 302;
            this.KRFreq[38][52] = 301;
            this.KRFreq[15][19] = 300;
            this.KRFreq[28][45] = 299;
            this.KRFreq[29][78] = 298;
            this.KRFreq[23][15] = 297;
            this.KRFreq[33][5] = 296;
            this.KRFreq[17][40] = 295;
            this.KRFreq[30][83] = 294;
            this.KRFreq[18][1] = 293;
            this.KRFreq[30][81] = 292;
            this.KRFreq[19][40] = 291;
            this.KRFreq[24][47] = 290;
            this.KRFreq[17][56] = 289;
            this.KRFreq[39][80] = 288;
            this.KRFreq[30][46] = 287;
            this.KRFreq[16][61] = 286;
            this.KRFreq[26][78] = 285;
            this.KRFreq[26][57] = 284;
            this.KRFreq[20][46] = 283;
            this.KRFreq[25][15] = 282;
            this.KRFreq[25][91] = 281;
            this.KRFreq[21][83] = 280;
            this.KRFreq[30][77] = 279;
            this.KRFreq[35][30] = 278;
            this.KRFreq[30][34] = 277;
            this.KRFreq[20][69] = 276;
            this.KRFreq[35][10] = 275;
            this.KRFreq[29][70] = 274;
            this.KRFreq[22][50] = 273;
            this.KRFreq[18][0] = 272;
            this.KRFreq[22][64] = 271;
            this.KRFreq[38][65] = 270;
            this.KRFreq[22][70] = 269;
            this.KRFreq[24][58] = 268;
            this.KRFreq[19][66] = 267;
            this.KRFreq[30][59] = 266;
            this.KRFreq[37][14] = 265;
            this.KRFreq[16][56] = 264;
            this.KRFreq[29][85] = 263;
            this.KRFreq[31][15] = 262;
            this.KRFreq[36][84] = 261;
            this.KRFreq[39][15] = 260;
            this.KRFreq[39][90] = 259;
            this.KRFreq[18][12] = 258;
            this.KRFreq[21][93] = 257;
            this.KRFreq[24][66] = 256;
            this.KRFreq[27][90] = 255;
            this.KRFreq[25][90] = 254;
            this.KRFreq[22][24] = 253;
            this.KRFreq[36][67] = 252;
            this.KRFreq[33][90] = 251;
            this.KRFreq[15][60] = 250;
            this.KRFreq[23][85] = 249;
            this.KRFreq[34][1] = 248;
            this.KRFreq[39][37] = 247;
            this.KRFreq[21][18] = 246;
            this.KRFreq[34][4] = 245;
            this.KRFreq[28][33] = 244;
            this.KRFreq[15][13] = 243;
            this.KRFreq[32][22] = 242;
            this.KRFreq[30][76] = 241;
            this.KRFreq[20][21] = 240;
            this.KRFreq[38][66] = 239;
            this.KRFreq[32][55] = 238;
            this.KRFreq[32][89] = 237;
            this.KRFreq[25][26] = 236;
            this.KRFreq[16][80] = 235;
            this.KRFreq[15][43] = 234;
            this.KRFreq[38][54] = 233;
            this.KRFreq[39][68] = 232;
            this.KRFreq[22][88] = 231;
            this.KRFreq[21][84] = 230;
            this.KRFreq[21][17] = 229;
            this.KRFreq[20][28] = 228;
            this.KRFreq[32][1] = 227;
            this.KRFreq[33][87] = 226;
            this.KRFreq[38][71] = 225;
            this.KRFreq[37][47] = 224;
            this.KRFreq[18][77] = 223;
            this.KRFreq[37][58] = 222;
            this.KRFreq[34][74] = 221;
            this.KRFreq[32][54] = 220;
            this.KRFreq[27][33] = 219;
            this.KRFreq[32][93] = 218;
            this.KRFreq[23][51] = 217;
            this.KRFreq[20][57] = 216;
            this.KRFreq[22][37] = 215;
            this.KRFreq[39][10] = 214;
            this.KRFreq[39][17] = 213;
            this.KRFreq[33][4] = 212;
            this.KRFreq[32][84] = 211;
            this.KRFreq[34][3] = 210;
            this.KRFreq[28][27] = 209;
            this.KRFreq[15][79] = 208;
            this.KRFreq[34][21] = 207;
            this.KRFreq[34][69] = 206;
            this.KRFreq[21][62] = 205;
            this.KRFreq[36][24] = 204;
            this.KRFreq[16][89] = 203;
            this.KRFreq[18][48] = 202;
            this.KRFreq[38][15] = 201;
            this.KRFreq[36][58] = 200;
            this.KRFreq[21][56] = 199;
            this.KRFreq[34][48] = 198;
            this.KRFreq[21][15] = 197;
            this.KRFreq[39][3] = 196;
            this.KRFreq[16][44] = 195;
            this.KRFreq[18][79] = 194;
            this.KRFreq[25][13] = 193;
            this.KRFreq[29][47] = 192;
            this.KRFreq[38][88] = 191;
            this.KRFreq[20][71] = 190;
            this.KRFreq[16][58] = 189;
            this.KRFreq[35][57] = 188;
            this.KRFreq[29][30] = 187;
            this.KRFreq[29][23] = 186;
            this.KRFreq[34][93] = 185;
            this.KRFreq[30][85] = 184;
            this.KRFreq[15][80] = 183;
            this.KRFreq[32][78] = 182;
            this.KRFreq[37][82] = 181;
            this.KRFreq[22][40] = 180;
            this.KRFreq[21][69] = 179;
            this.KRFreq[26][85] = 178;
            this.KRFreq[31][31] = 177;
            this.KRFreq[28][64] = 176;
            this.KRFreq[38][13] = 175;
            this.KRFreq[25][2] = 174;
            this.KRFreq[22][34] = 173;
            this.KRFreq[28][28] = 172;
            this.KRFreq[24][91] = 171;
            this.KRFreq[33][74] = 170;
            this.KRFreq[29][40] = 169;
            this.KRFreq[15][77] = 168;
            this.KRFreq[32][80] = 167;
            this.KRFreq[30][41] = 166;
            this.KRFreq[23][30] = 165;
            this.KRFreq[24][63] = 164;
            this.KRFreq[30][53] = 163;
            this.KRFreq[39][70] = 162;
            this.KRFreq[23][61] = 161;
            this.KRFreq[37][27] = 160;
            this.KRFreq[16][55] = 159;
            this.KRFreq[22][74] = 158;
            this.KRFreq[26][50] = 157;
            this.KRFreq[16][10] = 156;
            this.KRFreq[34][63] = 155;
            this.KRFreq[35][14] = 154;
            this.KRFreq[17][7] = 153;
            this.KRFreq[15][59] = 152;
            this.KRFreq[27][23] = 151;
            this.KRFreq[18][70] = 150;
            this.KRFreq[32][56] = 149;
            this.KRFreq[37][87] = 148;
            this.KRFreq[17][61] = 147;
            this.KRFreq[18][83] = 146;
            this.KRFreq[23][86] = 145;
            this.KRFreq[17][31] = 144;
            this.KRFreq[23][83] = 143;
            this.KRFreq[35][2] = 142;
            this.KRFreq[18][64] = 141;
            this.KRFreq[27][43] = 140;
            this.KRFreq[32][42] = 139;
            this.KRFreq[25][76] = 138;
            this.KRFreq[19][85] = 137;
            this.KRFreq[37][81] = 136;
            this.KRFreq[38][83] = 135;
            this.KRFreq[35][7] = 134;
            this.KRFreq[16][51] = 133;
            this.KRFreq[27][22] = 132;
            this.KRFreq[16][76] = 131;
            this.KRFreq[22][4] = 130;
            this.KRFreq[38][84] = 129;
            this.KRFreq[17][83] = 128;
            this.KRFreq[24][46] = 127;
            this.KRFreq[33][15] = 126;
            this.KRFreq[20][48] = 125;
            this.KRFreq[17][30] = 124;
            this.KRFreq[30][93] = 123;
            this.KRFreq[28][11] = 122;
            this.KRFreq[28][30] = 121;
            this.KRFreq[15][62] = 120;
            this.KRFreq[17][87] = 119;
            this.KRFreq[32][81] = 118;
            this.KRFreq[23][37] = 117;
            this.KRFreq[30][22] = 116;
            this.KRFreq[32][66] = 115;
            this.KRFreq[33][78] = 114;
            this.KRFreq[21][4] = 113;
            this.KRFreq[31][17] = 112;
            this.KRFreq[39][61] = 111;
            this.KRFreq[18][76] = 110;
            this.KRFreq[15][85] = 109;
            this.KRFreq[31][47] = 108;
            this.KRFreq[19][57] = 107;
            this.KRFreq[23][55] = 106;
            this.KRFreq[27][29] = 105;
            this.KRFreq[29][46] = 104;
            this.KRFreq[33][0] = 103;
            this.KRFreq[16][83] = 102;
            this.KRFreq[39][78] = 101;
            this.KRFreq[32][77] = 100;
            this.KRFreq[36][25] = 99;
            this.KRFreq[34][19] = 98;
            this.KRFreq[38][49] = 97;
            this.KRFreq[19][25] = 96;
            this.KRFreq[23][53] = 95;
            this.KRFreq[28][43] = 94;
            this.KRFreq[31][44] = 93;
            this.KRFreq[36][34] = 92;
            this.KRFreq[16][34] = 91;
            this.KRFreq[35][1] = 90;
            this.KRFreq[19][87] = 89;
            this.KRFreq[18][53] = 88;
            this.KRFreq[29][54] = 87;
            this.KRFreq[22][41] = 86;
            this.KRFreq[38][18] = 85;
            this.KRFreq[22][2] = 84;
            this.KRFreq[20][3] = 83;
            this.KRFreq[39][69] = 82;
            this.KRFreq[30][29] = 81;
            this.KRFreq[28][19] = 80;
            this.KRFreq[29][90] = 79;
            this.KRFreq[17][86] = 78;
            this.KRFreq[15][9] = 77;
            this.KRFreq[39][73] = 76;
            this.KRFreq[15][37] = 75;
            this.KRFreq[35][40] = 74;
            this.KRFreq[33][77] = 73;
            this.KRFreq[27][86] = 72;
            this.KRFreq[36][79] = 71;
            this.KRFreq[23][18] = 70;
            this.KRFreq[34][87] = 69;
            this.KRFreq[39][24] = 68;
            this.KRFreq[26][8] = 67;
            this.KRFreq[33][48] = 66;
            this.KRFreq[39][30] = 65;
            this.KRFreq[33][28] = 64;
            this.KRFreq[16][67] = 63;
            this.KRFreq[31][78] = 62;
            this.KRFreq[32][23] = 61;
            this.KRFreq[24][55] = 60;
            this.KRFreq[30][68] = 59;
            this.KRFreq[18][60] = 58;
            this.KRFreq[15][17] = 57;
            this.KRFreq[23][34] = 56;
            this.KRFreq[20][49] = 55;
            this.KRFreq[15][78] = 54;
            this.KRFreq[24][14] = 53;
            this.KRFreq[19][41] = 52;
            this.KRFreq[31][55] = 51;
            this.KRFreq[21][39] = 50;
            this.KRFreq[35][9] = 49;
            this.KRFreq[30][15] = 48;
            this.KRFreq[20][52] = 47;
            this.KRFreq[35][71] = 46;
            this.KRFreq[20][7] = 45;
            this.KRFreq[29][72] = 44;
            this.KRFreq[37][77] = 43;
            this.KRFreq[22][35] = 42;
            this.KRFreq[20][61] = 41;
            this.KRFreq[31][60] = 40;
            this.KRFreq[20][93] = 39;
            this.KRFreq[27][92] = 38;
            this.KRFreq[28][16] = 37;
            this.KRFreq[36][26] = 36;
            this.KRFreq[18][89] = 35;
            this.KRFreq[21][63] = 34;
            this.KRFreq[22][52] = 33;
            this.KRFreq[24][65] = 32;
            this.KRFreq[31][8] = 31;
            this.KRFreq[31][49] = 30;
            this.KRFreq[33][30] = 29;
            this.KRFreq[37][15] = 28;
            this.KRFreq[18][18] = 27;
            this.KRFreq[25][50] = 26;
            this.KRFreq[29][20] = 25;
            this.KRFreq[35][48] = 24;
            this.KRFreq[38][75] = 23;
            this.KRFreq[26][83] = 22;
            this.KRFreq[21][87] = 21;
            this.KRFreq[27][71] = 20;
            this.KRFreq[32][91] = 19;
            this.KRFreq[25][73] = 18;
            this.KRFreq[16][84] = 17;
            this.KRFreq[25][31] = 16;
            this.KRFreq[17][90] = 15;
            this.KRFreq[18][40] = 14;
            this.KRFreq[17][77] = 13;
            this.KRFreq[17][35] = 12;
            this.KRFreq[23][52] = 11;
            this.KRFreq[23][35] = 10;
            this.KRFreq[16][5] = 9;
            this.KRFreq[23][58] = 8;
            this.KRFreq[19][60] = 7;
            this.KRFreq[30][32] = 6;
            this.KRFreq[38][34] = 5;
            this.KRFreq[23][4] = 4;
            this.KRFreq[23][1] = 3;
            this.KRFreq[27][57] = 2;
            this.KRFreq[39][38] = 1;
            this.KRFreq[32][33] = 0;
            this.JPFreq[3][74] = 600;
            this.JPFreq[3][45] = 599;
            this.JPFreq[3][3] = 598;
            this.JPFreq[3][24] = 597;
            this.JPFreq[3][30] = 596;
            this.JPFreq[3][42] = 595;
            this.JPFreq[3][46] = 594;
            this.JPFreq[3][39] = 593;
            this.JPFreq[3][11] = 592;
            this.JPFreq[3][37] = 591;
            this.JPFreq[3][38] = 590;
            this.JPFreq[3][31] = 589;
            this.JPFreq[3][41] = 588;
            this.JPFreq[3][5] = 587;
            this.JPFreq[3][10] = 586;
            this.JPFreq[3][75] = 585;
            this.JPFreq[3][65] = 584;
            this.JPFreq[3][72] = 583;
            this.JPFreq[37][91] = 582;
            this.JPFreq[0][27] = 581;
            this.JPFreq[3][18] = 580;
            this.JPFreq[3][22] = 579;
            this.JPFreq[3][61] = 578;
            this.JPFreq[3][14] = 577;
            this.JPFreq[24][80] = 576;
            this.JPFreq[4][82] = 575;
            this.JPFreq[17][80] = 574;
            this.JPFreq[30][44] = 573;
            this.JPFreq[3][73] = 572;
            this.JPFreq[3][64] = 571;
            this.JPFreq[38][14] = 570;
            this.JPFreq[33][70] = 569;
            this.JPFreq[3][1] = 568;
            this.JPFreq[3][16] = 567;
            this.JPFreq[3][35] = 566;
            this.JPFreq[3][40] = 565;
            this.JPFreq[4][74] = 564;
            this.JPFreq[4][24] = 563;
            this.JPFreq[42][59] = 562;
            this.JPFreq[3][7] = 561;
            this.JPFreq[3][71] = 560;
            this.JPFreq[3][12] = 559;
            this.JPFreq[15][75] = 558;
            this.JPFreq[3][20] = 557;
            this.JPFreq[4][39] = 556;
            this.JPFreq[34][69] = 555;
            this.JPFreq[3][28] = 554;
            this.JPFreq[35][24] = 553;
            this.JPFreq[3][82] = 552;
            this.JPFreq[28][47] = 551;
            this.JPFreq[3][67] = 550;
            this.JPFreq[37][16] = 549;
            this.JPFreq[26][93] = 548;
            this.JPFreq[4][1] = 547;
            this.JPFreq[26][85] = 546;
            this.JPFreq[31][14] = 545;
            this.JPFreq[4][3] = 544;
            this.JPFreq[4][72] = 543;
            this.JPFreq[24][51] = 542;
            this.JPFreq[27][51] = 541;
            this.JPFreq[27][49] = 540;
            this.JPFreq[22][77] = 539;
            this.JPFreq[27][10] = 538;
            this.JPFreq[29][68] = 537;
            this.JPFreq[20][35] = 536;
            this.JPFreq[41][11] = 535;
            this.JPFreq[24][70] = 534;
            this.JPFreq[36][61] = 533;
            this.JPFreq[31][23] = 532;
            this.JPFreq[43][16] = 531;
            this.JPFreq[23][68] = 530;
            this.JPFreq[32][15] = 529;
            this.JPFreq[3][32] = 528;
            this.JPFreq[19][53] = 527;
            this.JPFreq[40][83] = 526;
            this.JPFreq[4][14] = 525;
            this.JPFreq[36][9] = 524;
            this.JPFreq[4][73] = 523;
            this.JPFreq[23][10] = 522;
            this.JPFreq[3][63] = 521;
            this.JPFreq[39][14] = 520;
            this.JPFreq[3][78] = 519;
            this.JPFreq[33][47] = 518;
            this.JPFreq[21][39] = 517;
            this.JPFreq[34][46] = 516;
            this.JPFreq[36][75] = 515;
            this.JPFreq[41][92] = 514;
            this.JPFreq[37][93] = 513;
            this.JPFreq[4][34] = 512;
            this.JPFreq[15][86] = 511;
            this.JPFreq[46][1] = 510;
            this.JPFreq[37][65] = 509;
            this.JPFreq[3][62] = 508;
            this.JPFreq[32][73] = 507;
            this.JPFreq[21][65] = 506;
            this.JPFreq[29][75] = 505;
            this.JPFreq[26][51] = 504;
            this.JPFreq[3][34] = 503;
            this.JPFreq[4][10] = 502;
            this.JPFreq[30][22] = 501;
            this.JPFreq[35][73] = 500;
            this.JPFreq[17][82] = 499;
            this.JPFreq[45][8] = 498;
            this.JPFreq[27][73] = 497;
            this.JPFreq[18][55] = 496;
            this.JPFreq[25][2] = 495;
            this.JPFreq[3][26] = 494;
            this.JPFreq[45][46] = 493;
            this.JPFreq[4][22] = 492;
            this.JPFreq[4][40] = 491;
            this.JPFreq[18][10] = 490;
            this.JPFreq[32][9] = 489;
            this.JPFreq[26][49] = 488;
            this.JPFreq[3][47] = 487;
            this.JPFreq[24][65] = 486;
            this.JPFreq[4][76] = 485;
            this.JPFreq[43][67] = 484;
            this.JPFreq[3][9] = 483;
            this.JPFreq[41][37] = 482;
            this.JPFreq[33][68] = 481;
            this.JPFreq[43][31] = 480;
            this.JPFreq[19][55] = 479;
            this.JPFreq[4][30] = 478;
            this.JPFreq[27][33] = 477;
            this.JPFreq[16][62] = 476;
            this.JPFreq[36][35] = 475;
            this.JPFreq[37][15] = 474;
            this.JPFreq[27][70] = 473;
            this.JPFreq[22][71] = 472;
            this.JPFreq[33][45] = 471;
            this.JPFreq[31][78] = 470;
            this.JPFreq[43][59] = 469;
            this.JPFreq[32][19] = 468;
            this.JPFreq[17][28] = 467;
            this.JPFreq[40][28] = 466;
            this.JPFreq[20][93] = 465;
            this.JPFreq[18][15] = 464;
            this.JPFreq[4][23] = 463;
            this.JPFreq[3][23] = 462;
            this.JPFreq[26][64] = 461;
            this.JPFreq[44][92] = 460;
            this.JPFreq[17][27] = 459;
            this.JPFreq[3][56] = 458;
            this.JPFreq[25][38] = 457;
            this.JPFreq[23][31] = 456;
            this.JPFreq[35][43] = 455;
            this.JPFreq[4][54] = 454;
            this.JPFreq[35][19] = 453;
            this.JPFreq[22][47] = 452;
            this.JPFreq[42][0] = 451;
            this.JPFreq[23][28] = 450;
            this.JPFreq[46][33] = 449;
            this.JPFreq[36][85] = 448;
            this.JPFreq[31][12] = 447;
            this.JPFreq[3][76] = 446;
            this.JPFreq[4][75] = 445;
            this.JPFreq[36][56] = 444;
            this.JPFreq[4][64] = 443;
            this.JPFreq[25][77] = 442;
            this.JPFreq[15][52] = 441;
            this.JPFreq[33][73] = 440;
            this.JPFreq[3][55] = 439;
            this.JPFreq[43][82] = 438;
            this.JPFreq[27][82] = 437;
            this.JPFreq[20][3] = 436;
            this.JPFreq[40][51] = 435;
            this.JPFreq[3][17] = 434;
            this.JPFreq[27][71] = 433;
            this.JPFreq[4][52] = 432;
            this.JPFreq[44][48] = 431;
            this.JPFreq[27][2] = 430;
            this.JPFreq[17][39] = 429;
            this.JPFreq[31][8] = 428;
            this.JPFreq[44][54] = 427;
            this.JPFreq[43][18] = 426;
            this.JPFreq[43][77] = 425;
            this.JPFreq[4][61] = 424;
            this.JPFreq[19][91] = 423;
            this.JPFreq[31][13] = 422;
            this.JPFreq[44][71] = 421;
            this.JPFreq[20][0] = 420;
            this.JPFreq[23][87] = 419;
            this.JPFreq[21][14] = 418;
            this.JPFreq[29][13] = 417;
            this.JPFreq[3][58] = 416;
            this.JPFreq[26][18] = 415;
            this.JPFreq[4][47] = 414;
            this.JPFreq[4][18] = 413;
            this.JPFreq[3][53] = 412;
            this.JPFreq[26][92] = 411;
            this.JPFreq[21][7] = 410;
            this.JPFreq[4][37] = 409;
            this.JPFreq[4][63] = 408;
            this.JPFreq[36][51] = 407;
            this.JPFreq[4][32] = 406;
            this.JPFreq[28][73] = 405;
            this.JPFreq[4][50] = 404;
            this.JPFreq[41][60] = 403;
            this.JPFreq[23][1] = 402;
            this.JPFreq[36][92] = 401;
            this.JPFreq[15][41] = 400;
            this.JPFreq[21][71] = 399;
            this.JPFreq[41][30] = 398;
            this.JPFreq[32][76] = 397;
            this.JPFreq[17][34] = 396;
            this.JPFreq[26][15] = 395;
            this.JPFreq[26][25] = 394;
            this.JPFreq[31][77] = 393;
            this.JPFreq[31][3] = 392;
            this.JPFreq[46][34] = 391;
            this.JPFreq[27][84] = 390;
            this.JPFreq[23][8] = 389;
            this.JPFreq[16][0] = 388;
            this.JPFreq[28][80] = 387;
            this.JPFreq[26][54] = 386;
            this.JPFreq[33][18] = 385;
            this.JPFreq[31][20] = 384;
            this.JPFreq[31][62] = 383;
            this.JPFreq[30][41] = 382;
            this.JPFreq[33][30] = 381;
            this.JPFreq[45][45] = 380;
            this.JPFreq[37][82] = 379;
            this.JPFreq[15][33] = 378;
            this.JPFreq[20][12] = 377;
            this.JPFreq[18][5] = 376;
            this.JPFreq[28][86] = 375;
            this.JPFreq[30][19] = 374;
            this.JPFreq[42][43] = 373;
            this.JPFreq[36][31] = 372;
            this.JPFreq[17][93] = 371;
            this.JPFreq[4][15] = 370;
            this.JPFreq[21][20] = 369;
            this.JPFreq[23][21] = 368;
            this.JPFreq[28][72] = 367;
            this.JPFreq[4][20] = 366;
            this.JPFreq[26][55] = 365;
            this.JPFreq[21][5] = 364;
            this.JPFreq[19][16] = 363;
            this.JPFreq[23][64] = 362;
            this.JPFreq[40][59] = 361;
            this.JPFreq[37][26] = 360;
            this.JPFreq[26][56] = 359;
            this.JPFreq[4][12] = 358;
            this.JPFreq[33][71] = 357;
            this.JPFreq[32][39] = 356;
            this.JPFreq[38][40] = 355;
            this.JPFreq[22][74] = 354;
            this.JPFreq[3][25] = 353;
            this.JPFreq[15][48] = 352;
            this.JPFreq[41][82] = 351;
            this.JPFreq[41][9] = 350;
            this.JPFreq[25][48] = 349;
            this.JPFreq[31][71] = 348;
            this.JPFreq[43][29] = 347;
            this.JPFreq[26][80] = 346;
            this.JPFreq[4][5] = 345;
            this.JPFreq[18][71] = 344;
            this.JPFreq[29][0] = 343;
            this.JPFreq[43][43] = 342;
            this.JPFreq[23][81] = 341;
            this.JPFreq[4][42] = 340;
            this.JPFreq[44][28] = 339;
            this.JPFreq[23][93] = 338;
            this.JPFreq[17][81] = 337;
            this.JPFreq[25][25] = 336;
            this.JPFreq[41][23] = 335;
            this.JPFreq[34][35] = 334;
            this.JPFreq[4][53] = 333;
            this.JPFreq[28][36] = 332;
            this.JPFreq[4][41] = 331;
            this.JPFreq[25][60] = 330;
            this.JPFreq[23][20] = 329;
            this.JPFreq[3][43] = 328;
            this.JPFreq[24][79] = 327;
            this.JPFreq[29][41] = 326;
            this.JPFreq[30][83] = 325;
            this.JPFreq[3][50] = 324;
            this.JPFreq[22][18] = 323;
            this.JPFreq[18][3] = 322;
            this.JPFreq[39][30] = 321;
            this.JPFreq[4][28] = 320;
            this.JPFreq[21][64] = 319;
            this.JPFreq[4][68] = 318;
            this.JPFreq[17][71] = 317;
            this.JPFreq[27][0] = 316;
            this.JPFreq[39][28] = 315;
            this.JPFreq[30][13] = 314;
            this.JPFreq[36][70] = 313;
            this.JPFreq[20][82] = 312;
            this.JPFreq[33][38] = 311;
            this.JPFreq[44][87] = 310;
            this.JPFreq[34][45] = 309;
            this.JPFreq[4][26] = 308;
            this.JPFreq[24][44] = 307;
            this.JPFreq[38][67] = 306;
            this.JPFreq[38][6] = 305;
            this.JPFreq[30][68] = 304;
            this.JPFreq[15][89] = 303;
            this.JPFreq[24][93] = 302;
            this.JPFreq[40][41] = 301;
            this.JPFreq[38][3] = 300;
            this.JPFreq[28][23] = 299;
            this.JPFreq[26][17] = 298;
            this.JPFreq[4][38] = 297;
            this.JPFreq[22][78] = 296;
            this.JPFreq[15][37] = 295;
            this.JPFreq[25][85] = 294;
            this.JPFreq[4][9] = 293;
            this.JPFreq[4][7] = 292;
            this.JPFreq[27][53] = 291;
            this.JPFreq[39][29] = 290;
            this.JPFreq[41][43] = 289;
            this.JPFreq[25][62] = 288;
            this.JPFreq[4][48] = 287;
            this.JPFreq[28][28] = 286;
            this.JPFreq[21][40] = 285;
            this.JPFreq[36][73] = 284;
            this.JPFreq[26][39] = 283;
            this.JPFreq[22][54] = 282;
            this.JPFreq[33][5] = 281;
            this.JPFreq[19][21] = 280;
            this.JPFreq[46][31] = 279;
            this.JPFreq[20][64] = 278;
            this.JPFreq[26][63] = 277;
            this.JPFreq[22][23] = 276;
            this.JPFreq[25][81] = 275;
            this.JPFreq[4][62] = 274;
            this.JPFreq[37][31] = 273;
            this.JPFreq[40][52] = 272;
            this.JPFreq[29][79] = 271;
            this.JPFreq[41][48] = 270;
            this.JPFreq[31][57] = 269;
            this.JPFreq[32][92] = 268;
            this.JPFreq[36][36] = 267;
            this.JPFreq[27][7] = 266;
            this.JPFreq[35][29] = 265;
            this.JPFreq[37][34] = 264;
            this.JPFreq[34][42] = 263;
            this.JPFreq[27][15] = 262;
            this.JPFreq[33][27] = 261;
            this.JPFreq[31][38] = 260;
            this.JPFreq[19][79] = 259;
            this.JPFreq[4][31] = 258;
            this.JPFreq[4][66] = 257;
            this.JPFreq[17][32] = 256;
            this.JPFreq[26][67] = 255;
            this.JPFreq[16][30] = 254;
            this.JPFreq[26][46] = 253;
            this.JPFreq[24][26] = 252;
            this.JPFreq[35][10] = 251;
            this.JPFreq[18][37] = 250;
            this.JPFreq[3][19] = 249;
            this.JPFreq[33][69] = 248;
            this.JPFreq[31][9] = 247;
            this.JPFreq[45][29] = 246;
            this.JPFreq[3][15] = 245;
            this.JPFreq[18][54] = 244;
            this.JPFreq[3][44] = 243;
            this.JPFreq[31][29] = 242;
            this.JPFreq[18][45] = 241;
            this.JPFreq[38][28] = 240;
            this.JPFreq[24][12] = 239;
            this.JPFreq[35][82] = 238;
            this.JPFreq[17][43] = 237;
            this.JPFreq[28][9] = 236;
            this.JPFreq[23][25] = 235;
            this.JPFreq[44][37] = 234;
            this.JPFreq[23][75] = 233;
            this.JPFreq[23][92] = 232;
            this.JPFreq[0][24] = 231;
            this.JPFreq[19][74] = 230;
            this.JPFreq[45][32] = 229;
            this.JPFreq[16][72] = 228;
            this.JPFreq[16][93] = 227;
            this.JPFreq[45][13] = 226;
            this.JPFreq[24][8] = 225;
            this.JPFreq[25][47] = 224;
            this.JPFreq[28][26] = 223;
            this.JPFreq[43][81] = 222;
            this.JPFreq[32][71] = 221;
            this.JPFreq[18][41] = 220;
            this.JPFreq[26][62] = 219;
            this.JPFreq[41][24] = 218;
            this.JPFreq[40][11] = 217;
            this.JPFreq[43][57] = 216;
            this.JPFreq[34][53] = 215;
            this.JPFreq[20][32] = 214;
            this.JPFreq[34][43] = 213;
            this.JPFreq[41][91] = 212;
            this.JPFreq[29][57] = 211;
            this.JPFreq[15][43] = 210;
            this.JPFreq[22][89] = 209;
            this.JPFreq[33][83] = 208;
            this.JPFreq[43][20] = 207;
            this.JPFreq[25][58] = 206;
            this.JPFreq[30][30] = 205;
            this.JPFreq[4][56] = 204;
            this.JPFreq[17][64] = 203;
            this.JPFreq[23][0] = 202;
            this.JPFreq[44][12] = 201;
            this.JPFreq[25][37] = 200;
            this.JPFreq[35][13] = 199;
            this.JPFreq[20][30] = 198;
            this.JPFreq[21][84] = 197;
            this.JPFreq[29][14] = 196;
            this.JPFreq[30][5] = 195;
            this.JPFreq[37][2] = 194;
            this.JPFreq[4][78] = 193;
            this.JPFreq[29][78] = 192;
            this.JPFreq[29][84] = 191;
            this.JPFreq[32][86] = 190;
            this.JPFreq[20][68] = 189;
            this.JPFreq[30][39] = 188;
            this.JPFreq[15][69] = 187;
            this.JPFreq[4][60] = 186;
            this.JPFreq[20][61] = 185;
            this.JPFreq[41][67] = 184;
            this.JPFreq[16][35] = 183;
            this.JPFreq[36][57] = 182;
            this.JPFreq[39][80] = 181;
            this.JPFreq[4][59] = 180;
            this.JPFreq[4][44] = 179;
            this.JPFreq[40][54] = 178;
            this.JPFreq[30][8] = 177;
            this.JPFreq[44][30] = 176;
            this.JPFreq[31][93] = 175;
            this.JPFreq[31][47] = 174;
            this.JPFreq[16][70] = 173;
            this.JPFreq[21][0] = 172;
            this.JPFreq[17][35] = 171;
            this.JPFreq[21][67] = 170;
            this.JPFreq[44][18] = 169;
            this.JPFreq[36][29] = 168;
            this.JPFreq[18][67] = 167;
            this.JPFreq[24][28] = 166;
            this.JPFreq[36][24] = 165;
            this.JPFreq[23][5] = 164;
            this.JPFreq[31][65] = 163;
            this.JPFreq[26][59] = 162;
            this.JPFreq[28][2] = 161;
            this.JPFreq[39][69] = 160;
            this.JPFreq[42][40] = 159;
            this.JPFreq[37][80] = 158;
            this.JPFreq[15][66] = 157;
            this.JPFreq[34][38] = 156;
            this.JPFreq[28][48] = 155;
            this.JPFreq[37][77] = 154;
            this.JPFreq[29][34] = 153;
            this.JPFreq[33][12] = 152;
            this.JPFreq[4][65] = 151;
            this.JPFreq[30][31] = 150;
            this.JPFreq[27][92] = 149;
            this.JPFreq[4][2] = 148;
            this.JPFreq[4][51] = 147;
            this.JPFreq[23][77] = 146;
            this.JPFreq[4][35] = 145;
            this.JPFreq[3][13] = 144;
            this.JPFreq[26][26] = 143;
            this.JPFreq[44][4] = 142;
            this.JPFreq[39][53] = 141;
            this.JPFreq[20][11] = 140;
            this.JPFreq[40][33] = 139;
            this.JPFreq[45][7] = 138;
            this.JPFreq[4][70] = 137;
            this.JPFreq[3][49] = 136;
            this.JPFreq[20][59] = 135;
            this.JPFreq[21][12] = 134;
            this.JPFreq[33][53] = 133;
            this.JPFreq[20][14] = 132;
            this.JPFreq[37][18] = 131;
            this.JPFreq[18][17] = 130;
            this.JPFreq[36][23] = 129;
            this.JPFreq[18][57] = 128;
            this.JPFreq[26][74] = 127;
            this.JPFreq[35][2] = 126;
            this.JPFreq[38][58] = 125;
            this.JPFreq[34][68] = 124;
            this.JPFreq[29][81] = 123;
            this.JPFreq[20][69] = 122;
            this.JPFreq[39][86] = 121;
            this.JPFreq[4][16] = 120;
            this.JPFreq[16][49] = 119;
            this.JPFreq[15][72] = 118;
            this.JPFreq[26][35] = 117;
            this.JPFreq[32][14] = 116;
            this.JPFreq[40][90] = 115;
            this.JPFreq[33][79] = 114;
            this.JPFreq[35][4] = 113;
            this.JPFreq[23][33] = 112;
            this.JPFreq[19][19] = 111;
            this.JPFreq[31][41] = 110;
            this.JPFreq[44][1] = 109;
            this.JPFreq[22][56] = 108;
            this.JPFreq[31][27] = 107;
            this.JPFreq[32][18] = 106;
            this.JPFreq[27][32] = 105;
            this.JPFreq[37][39] = 104;
            this.JPFreq[42][11] = 103;
            this.JPFreq[29][71] = 102;
            this.JPFreq[32][58] = 101;
            this.JPFreq[46][10] = 100;
            this.JPFreq[17][30] = 99;
            this.JPFreq[38][15] = 98;
            this.JPFreq[29][60] = 97;
            this.JPFreq[4][11] = 96;
            this.JPFreq[38][31] = 95;
            this.JPFreq[40][79] = 94;
            this.JPFreq[28][49] = 93;
            this.JPFreq[28][84] = 92;
            this.JPFreq[26][77] = 91;
            this.JPFreq[22][32] = 90;
            this.JPFreq[33][17] = 89;
            this.JPFreq[23][18] = 88;
            this.JPFreq[32][64] = 87;
            this.JPFreq[4][6] = 86;
            this.JPFreq[33][51] = 85;
            this.JPFreq[44][77] = 84;
            this.JPFreq[29][5] = 83;
            this.JPFreq[46][25] = 82;
            this.JPFreq[19][58] = 81;
            this.JPFreq[4][46] = 80;
            this.JPFreq[15][71] = 79;
            this.JPFreq[18][58] = 78;
            this.JPFreq[26][45] = 77;
            this.JPFreq[45][66] = 76;
            this.JPFreq[34][10] = 75;
            this.JPFreq[19][37] = 74;
            this.JPFreq[33][65] = 73;
            this.JPFreq[44][52] = 72;
            this.JPFreq[16][38] = 71;
            this.JPFreq[36][46] = 70;
            this.JPFreq[20][26] = 69;
            this.JPFreq[30][37] = 68;
            this.JPFreq[4][58] = 67;
            this.JPFreq[43][2] = 66;
            this.JPFreq[30][18] = 65;
            this.JPFreq[19][35] = 64;
            this.JPFreq[15][68] = 63;
            this.JPFreq[3][36] = 62;
            this.JPFreq[35][40] = 61;
            this.JPFreq[36][32] = 60;
            this.JPFreq[37][14] = 59;
            this.JPFreq[17][11] = 58;
            this.JPFreq[19][78] = 57;
            this.JPFreq[37][11] = 56;
            this.JPFreq[28][63] = 55;
            this.JPFreq[29][61] = 54;
            this.JPFreq[33][3] = 53;
            this.JPFreq[41][52] = 52;
            this.JPFreq[33][63] = 51;
            this.JPFreq[22][41] = 50;
            this.JPFreq[4][19] = 49;
            this.JPFreq[32][41] = 48;
            this.JPFreq[24][4] = 47;
            this.JPFreq[31][28] = 46;
            this.JPFreq[43][30] = 45;
            this.JPFreq[17][3] = 44;
            this.JPFreq[43][70] = 43;
            this.JPFreq[34][19] = 42;
            this.JPFreq[20][77] = 41;
            this.JPFreq[18][83] = 40;
            this.JPFreq[17][15] = 39;
            this.JPFreq[23][61] = 38;
            this.JPFreq[40][27] = 37;
            this.JPFreq[16][48] = 36;
            this.JPFreq[39][78] = 35;
            this.JPFreq[41][53] = 34;
            this.JPFreq[40][91] = 33;
            this.JPFreq[40][72] = 32;
            this.JPFreq[18][52] = 31;
            this.JPFreq[35][66] = 30;
            this.JPFreq[39][93] = 29;
            this.JPFreq[19][48] = 28;
            this.JPFreq[26][36] = 27;
            this.JPFreq[27][25] = 26;
            this.JPFreq[42][71] = 25;
            this.JPFreq[42][85] = 24;
            this.JPFreq[26][48] = 23;
            this.JPFreq[28][15] = 22;
            this.JPFreq[3][66] = 21;
            this.JPFreq[25][24] = 20;
            this.JPFreq[27][43] = 19;
            this.JPFreq[27][78] = 18;
            this.JPFreq[45][43] = 17;
            this.JPFreq[27][72] = 16;
            this.JPFreq[40][29] = 15;
            this.JPFreq[41][0] = 14;
            this.JPFreq[19][57] = 13;
            this.JPFreq[15][59] = 12;
            this.JPFreq[29][29] = 11;
            this.JPFreq[4][25] = 10;
            this.JPFreq[21][42] = 9;
            this.JPFreq[23][35] = 8;
            this.JPFreq[33][1] = 7;
            this.JPFreq[4][57] = 6;
            this.JPFreq[17][60] = 5;
            this.JPFreq[25][19] = 4;
            this.JPFreq[22][65] = 3;
            this.JPFreq[42][29] = 2;
            this.JPFreq[27][66] = 1;
            this.JPFreq[26][89] = 0;
        }
    }
}

