/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.gtdc.service;

import com.geoway.jckj.biz.entity.SysUser;
import com.geoway.jckj.biz.enums.UserSysEnum;
import com.geoway.jckj.biz.gtdc.service.impl.GtdcUserServiceImpl;
import com.geoway.jckj.biz.local.service.LocalLoginServiceImpl;
import com.geoway.jckj.biz.util.PasswordUtil;
import com.geoway.landteam.gac.oauth2.mini.GacOauth2Tool;
import com.geoway.landteam.gac.oauth2.mini.client.OAuth2AuthorizedClient;
import com.geoway.landteam.gac.oauth2.mini.client.support.AuthorizationCodeClientRegistration;
import com.geoway.landteam.gac.oauth2.mini.client.support.PasswordClientRegistration;
import com.geoway.landteam.gac.oauth2.mini.core.OAuth2AuthenticationException;
import com.geoway.landteam.gac.oauth2.mini.sub.GacOauth2UserInfo;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.SsoUser;
import com.gw.base.Gw;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GtdcLoginServiceImpl
extends LocalLoginServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(GtdcLoginServiceImpl.class);
    @Autowired
    private PasswordUtil passwordUtil;
    @Autowired
    private GtdcUserServiceImpl userService;

    public String getUserSystem() {
        return UserSysEnum.GTDJ.value;
    }

    public Result<SsoUser> login(String username, String password, String uuid, String code, HttpServletRequest req) {
        this.validateCaptcha(uuid, code);
        Result<SsoUser> ssoUserResult = this.loginByGtdc(username, password, uuid, code, req);
        return ssoUserResult;
    }

    private Result<SsoUser> loginByGtdc(String username, String password, String uuid, String code, HttpServletRequest req) {
        try {
            PasswordClientRegistration passwordClientRegistration = GacOauth2Tool.getGasPasswordClientRegistration();
            OAuth2AuthorizedClient oAuth2AuthorizedClient = passwordClientRegistration.authentication(username, this.passwordUtil.getRealPassword(password));
            GacOauth2UserInfo gacOauth2UserInfo = passwordClientRegistration.getOAuth2UserInfo(username);
            SysUser user = this.userService.query(gacOauth2UserInfo.getUserId());
            HttpSession session = req.getSession(true);
            session.setAttribute(GacOauth2UserInfo.class.getSimpleName(), (Object)gacOauth2UserInfo);
            SsoUser ssoUser = this.convertToSsoUser(user);
            ssoUser.setToken(oAuth2AuthorizedClient.getAccessToken().getTokenValue());
            return Result.createSuccess((Object)ssoUser);
        }
        catch (OAuth2AuthenticationException exception) {
            log.error(exception.getError().getErrorCode(), (Throwable)exception);
            return Result.createError((String)exception.getError().getErrorCode());
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            return Result.createError((String)exception.getMessage());
        }
    }

    public boolean loginOut(HttpServletRequest request, String access_token) {
        try {
            HttpSession session = request.getSession(false);
            if (session != null) {
                Object user = session.getAttribute(GacOauth2UserInfo.class.getSimpleName());
                if (user != null) {
                    AuthorizationCodeClientRegistration sso = GacOauth2Tool.getGasAuthorizationCodeClientRegistration();
                    sso.revokeAuthentication(session.getId());
                }
                Gw.log.info("\u8c03\u7528session.invalidate()", new Object[0]);
            }
            return true;
        }
        catch (Exception exception) {
            Gw.log.error((Throwable)exception);
            return true;
        }
    }
}

