/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.gtdc.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.geoway.jckj.base.exception.ServiceException;
import com.geoway.jckj.base.support.query.MyBatisQueryMapperUtils;
import com.geoway.jckj.biz.dto.UserRelParams;
import com.geoway.jckj.biz.entity.SysUser;
import com.geoway.jckj.biz.enums.UserSysEnum;
import com.geoway.jckj.biz.local.mapper.SysOrganizationMapper;
import com.geoway.jckj.biz.mapper.SysRoleMapper;
import com.geoway.jckj.biz.service.dev.base.IUserService;
import com.geoway.jckj.biz.service.sys.SysUserRoleService;
import com.geoway.landteam.platform.business.BusinessRes3Sdk;
import com.geoway.landteam.platform.business.res3.api.bususer.reso.BusUserInfoReso;
import com.geoway.landteam.platform.business.res3.api.orguser.reso.BusUserDetailPager;
import com.geoway.landteam.platform.business.res3.api.orguser.reso.BusUserDetailReso;
import com.geoway.landteam.platform.business.res3.api.orguser.reso.BusUserSearchReso;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class GtdcUserSysServiceImpl
implements IUserService {
    @Autowired
    private SysRoleMapper sysRoleMapper;
    @Autowired
    private SysOrganizationMapper sysOrganizationMapper;
    @Autowired
    private SysUserRoleService sysUserRoleService;

    public String getUserSystem() {
        return UserSysEnum.GTDJ.value;
    }

    public void saveOrUp(SysUser user, MultipartFile photo, boolean deletePhoto) {
        String otherParams = user.getOtherParams();
        if (StringUtils.isNotBlank((CharSequence)otherParams)) {
            try {
                UserRelParams userParams = (UserRelParams)JSON.parseObject((String)otherParams, UserRelParams.class);
                this.sysUserRoleService.updateUserRole(user.getId(), userParams.getRoles());
            }
            catch (Exception ex) {
                throw new ServiceException("\u9519\u8bef:" + ex.getMessage());
            }
        }
    }

    public void batchSave(List<SysUser> users) {
        this.realizationNot();
    }

    public SysUser query(String userId) {
        BusUserInfoReso useredInfo = BusinessRes3Sdk.getBusUserRes3Service().userInfo(userId);
        return this.getUser(useredInfo);
    }

    public List<SysUser> query(List<String> userIds) {
        this.realizationNot();
        return Collections.emptyList();
    }

    public List<SysUser> queryList(String filterParam) {
        BusUserSearchReso busUserSearchReso = new BusUserSearchReso();
        if (StringUtils.isNotEmpty((CharSequence)filterParam)) {
            MyBatisQueryMapperUtils qum = new MyBatisQueryMapperUtils();
            SysUser sysUser = (SysUser)qum.toJavaType(filterParam, SysUser.class);
            if (sysUser.getName() != null) {
                busUserSearchReso.setUserName(sysUser.getName());
            } else if (sysUser.getAname() != null) {
                busUserSearchReso.setRealName(sysUser.getAname());
            }
        }
        BusUserDetailPager pager = BusinessRes3Sdk.getOrgUserSelectRes3Service().listOrganizationAndBusUserPage(busUserSearchReso, Integer.valueOf(1), Integer.valueOf(10000000));
        List list = pager.getList();
        return list.stream().map(m -> this.getUser((BusUserDetailReso)m)).collect(Collectors.toList());
    }

    public List<SysUser> queryList(String filterParam, boolean withRoleOrg) {
        List<SysUser> users = this.queryList(filterParam);
        if (withRoleOrg) {
            this.wrapperRoleAllNames(users);
            this.wrapperOrgAllNames(users);
        }
        return users;
    }

    public int queryCount(String filterParam) {
        this.realizationNot();
        return 0;
    }

    public IPage<SysUser> queryPage(String filterParam, int page, int size) {
        MyBatisQueryMapperUtils qum;
        SysUser sysUser;
        BusUserSearchReso busUserSearchReso = new BusUserSearchReso();
        if (StringUtils.isNotEmpty((CharSequence)filterParam) && (sysUser = (SysUser)(qum = new MyBatisQueryMapperUtils()).toJavaType(filterParam, SysUser.class)).getName() != null) {
            busUserSearchReso.setUserName(sysUser.getName());
        }
        BusUserDetailPager pager = BusinessRes3Sdk.getOrgUserSelectRes3Service().listOrganizationAndBusUserPage(busUserSearchReso, Integer.valueOf(page), Integer.valueOf(size));
        Page iPage = new Page((long)page, (long)size);
        List<SysUser> users = pager.getList().stream().map(m -> this.getUser((BusUserDetailReso)m)).collect(Collectors.toList());
        this.wrapperOrgAllNames(users);
        this.wrapperRoleAllNames(users);
        iPage.setRecords(users);
        iPage.setTotal(pager.getTotal());
        return iPage;
    }

    public IPage<SysUser> queryPage(String filterParam, int page, int size, boolean containAdmin) {
        throw new ServiceException("\u6682\u672a\u5b9e\u73b0");
    }

    public void delete(String id) {
        this.realizationNot();
    }

    public void batchDelete(String ids) {
        this.realizationNot();
    }

    public void changePassword(String userId, String oldPwd, String newPwd) {
        this.realizationNot();
    }

    public void changePassword(String userId, String password) {
        this.realizationNot();
    }

    public String resetPassword(String userId) {
        throw new ServiceException("\u6682\u672a\u5b9e\u73b0");
    }

    public boolean checkIsResetPassword(String userId) {
        throw new ServiceException("\u6682\u672a\u5b9e\u73b0");
    }

    public void exportUsers(String filterParam, Boolean isTemplate, HttpServletResponse response) {
        this.realizationNot();
    }

    public String importUsers(List<SysUser> userList, Boolean isUpdateSupport, String orgId) {
        throw new ServiceException("\u6682\u672a\u5b9e\u73b0");
    }

    public Boolean changePassword(String phoneNum, String verifyCode, String verifyCodeUid, String password) throws Exception {
        throw new ServiceException("\u6682\u672a\u5b9e\u73b0");
    }

    private SysUser getUser(BusUserInfoReso user) {
        SysUser sysUser = this.creatUser();
        sysUser.setId(user.getMidUserId());
        sysUser.setName(user.getUserName());
        sysUser.setAname(user.getRealName());
        sysUser.setTel(user.getPhone());
        sysUser.setWorktel(user.getPhone());
        sysUser.setEmail(user.getEmail());
        return sysUser;
    }

    private SysUser getUser(BusUserDetailReso user) {
        SysUser sysUser = this.creatUser();
        sysUser.setId(user.getMidUserId());
        sysUser.setName(user.getUserName());
        sysUser.setAname(user.getRealName());
        sysUser.setTel(user.getPhone());
        sysUser.setWorktel(user.getPhone());
        sysUser.setEmail(user.getEmail());
        return sysUser;
    }

    private SysUser creatUser() {
        SysUser sysUser = new SysUser();
        sysUser.setBh("");
        sysUser.setZhiwu("");
        sysUser.setGanwei("0");
        sysUser.setZhiji("0");
        sysUser.setZhicheng("0");
        sysUser.setSex(0);
        sysUser.setWorktype("0");
        sysUser.setAddress("");
        sysUser.setStatus(Short.valueOf((short)0));
        sysUser.setCreatetime(new Date());
        sysUser.setUpdatetime(new Date());
        sysUser.setParams("");
        sysUser.setSource(UserSysEnum.GTDJ.value);
        sysUser.setImgid(null);
        return sysUser;
    }

    private void wrapperRoleAllNames(List<SysUser> users) {
        HashMap allNameCache = new HashMap();
        for (SysUser user : users) {
            List roles = this.sysRoleMapper.queryUserRoles(user.getId());
            List roleAllNames = roles.stream().map(x -> x.getName()).collect(Collectors.toList());
            user.setRoleNames(roleAllNames);
        }
    }

    private void wrapperOrgAllNames(List<SysUser> users) {
        HashMap allNameCache = new HashMap();
        for (SysUser user : users) {
            List orgs = this.sysOrganizationMapper.queryUserOrgs(user.getId());
            List orgAllNames = orgs.stream().map(x -> x.getName()).collect(Collectors.toList());
            user.setOrgNames(orgAllNames);
        }
    }

    private void realizationNot() {
    }
}

