/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.gtdc.controller;

import com.geoway.jckj.base.support.encryption.AESUtils;
import com.geoway.jckj.biz.entity.SysUser;
import com.geoway.jckj.biz.enums.UserSysEnum;
import com.geoway.jckj.biz.gtdc.config.GacHttpSessionListener;
import com.geoway.jckj.biz.gtdc.service.GtdcCustomService;
import com.geoway.jckj.biz.gtdc.service.impl.GtdcUserServiceImpl;
import com.geoway.jckj.biz.util.LoginUtil;
import com.geoway.jckj.biz.util.SysUserUtil;
import com.geoway.landteam.gac.oauth2.mini.GacOauth2Tool;
import com.geoway.landteam.gac.oauth2.mini.client.OAuth2AuthorizedClient;
import com.geoway.landteam.gac.oauth2.mini.client.support.AuthorizationCodeClientRegistration;
import com.geoway.landteam.gac.oauth2.mini.sub.GacOauth2UserInfo;
import com.geoway.sso.client.provider.RpcClientInfoProvider;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.client.util.Oauth2Utils;
import com.gw.base.Gw;
import com.gw.base.util.GutilObject;
import io.swagger.annotations.Api;
import java.net.URI;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"\u56fd\u571f\u8c03\u67e5\u4e91\u5355\u70b9\u767b\u5165"})
@Controller
@RequestMapping(value={"/gtySSO"})
public class GtyLoginController {
    private static final Logger log = LoggerFactory.getLogger(GtyLoginController.class);
    @Autowired
    private GtdcUserServiceImpl gtdcUserService;
    @Autowired
    private RpcClientInfoProvider rpcClientInfoProvider;
    @Autowired
    private GtdcCustomService gtdcCustomService;

    @ApiIgnore
    @GetMapping(value={"/login"})
    public String login(HttpServletRequest request, String redirect_url) throws Exception {
        redirect_url = URLDecoder.decode(AESUtils.encrypt((String)redirect_url, (String)"FWAijk4A2Dwt2MKw"), "UTF-8");
        HttpSession session = request.getSession(true);
        Object user = session.getAttribute(GacOauth2UserInfo.class.getSimpleName());
        if (user == null) {
            AuthorizationCodeClientRegistration sso = GacOauth2Tool.getGasAuthorizationCodeClientRegistration();
            URI uri = sso.getAuthorizationRequestURIWithState(redirect_url);
            redirect_url = uri.toString();
        } else {
            GacOauth2UserInfo userInfo = (GacOauth2UserInfo)user;
            String custom = this.gtdcCustomService.custom(userInfo, request, null);
            redirect_url = custom != null ? custom : LoginUtil.authRedirectUri((String)redirect_url, (String)userInfo.getAccessToken());
        }
        log.error("\u56de\u8c03\u5730\u5740\uff1aredirect:" + redirect_url);
        return "redirect:" + redirect_url;
    }

    @ApiIgnore
    @GetMapping(value={"/loginProcessing"})
    public String loginProcessing(HttpServletRequest request, HttpServletResponse httpResponse, String code, String state) throws Exception {
        AuthorizationCodeClientRegistration sso = GacOauth2Tool.getGasAuthorizationCodeClientRegistration();
        HttpSession session = request.getSession(true);
        String sessionId = session.getId();
        OAuth2AuthorizedClient cd = sso.authentication(sessionId, code, state);
        GacOauth2UserInfo userInfo = sso.getOAuth2UserInfo(sessionId);
        session.setAttribute(GacOauth2UserInfo.class.getSimpleName(), (Object)userInfo);
        String custom = this.gtdcCustomService.custom(userInfo, request, httpResponse);
        if (custom != null) {
            return "redirect:" + custom;
        }
        SysUser user = this.gtdcUserService.query(userInfo.getUserId());
        SsoUser ssoUser = SysUserUtil.convertToSsoUser((SysUser)user);
        ssoUser.setToken(userInfo.getAccessToken());
        ssoUser.setSource(UserSysEnum.GTDJ.value);
        String redirect_url = LoginUtil.authRedirectUri((String)AESUtils.encrypt((String)state, (String)"FWAijk4A2Dwt2MKw"), (String)userInfo.getAccessToken());
        LoginUtil.genereateRpcAccessToken((SsoUser)ssoUser);
        log.error("\u56de\u8c03\u5730\u5740\uff1aredirect:" + redirect_url);
        return "redirect:" + redirect_url;
    }

    @PostMapping(value={"/notifyLogout"})
    @ResponseBody
    public String notifyLogout(@RequestParam(value="access_token") String access_token) {
        Gw.log.info("\u6536\u5230\u4e86\u88ab\u52a8\u767b\u51fa\u8bf7\u6c42\uff0caccess_token:{}", new Object[]{access_token});
        GacHttpSessionListener.forEach((sessionId, session) -> {
            try {
                Object gacOauth2UserObject = session.getAttribute(GacOauth2UserInfo.class.getSimpleName());
                if (gacOauth2UserObject != null) {
                    GacOauth2UserInfo gacOauth2User = (GacOauth2UserInfo)gacOauth2UserObject;
                    Gw.log.info("\u4f1a\u8bdd\u7528\u6237\u7684\uff0caccess_token:{}", new Object[]{gacOauth2User.getAccessToken()});
                    if (GutilObject.equals((Object)gacOauth2User.getAccessToken(), (Object)access_token)) {
                        Gw.log.info("\u83b7\u53d6\u5230\u6709\u4e00\u4e2a\u4f1a\u8bdd\u9700\u8981\u88ab\u6ce8\u9500\uff0csessionId:{}", new Object[]{session.getId()});
                        Oauth2Utils.revokeAccessToken((String)this.rpcClientInfoProvider.getRpcClientInfo().getAppId(), (String)access_token);
                        session.removeAttribute(GacOauth2UserInfo.class.getSimpleName());
                        session.invalidate();
                    }
                }
            }
            catch (Exception e) {
                Gw.log.error((Throwable)e);
            }
        });
        return "OK";
    }
}

