/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.local.service;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.geoway.jckj.base.exception.ServiceException;
import com.geoway.jckj.base.support.query.MPJQueryMapperUtil;
import com.geoway.jckj.biz.entity.SysUser;
import com.geoway.jckj.biz.entity.SysUserLimit;
import com.geoway.jckj.biz.mapper.SysUserLimitMapper;
import com.geoway.jckj.biz.service.dev.base.IUserLimitService;
import com.geoway.jckj.biz.util.PhoneNumberUtil;
import com.github.yulichang.base.MPJBaseServiceImpl;
import com.github.yulichang.interfaces.MPJBaseJoin;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="localUserLimitService")
public class LocalUserLimitServiceImpl
extends MPJBaseServiceImpl<SysUserLimitMapper, SysUserLimit>
implements IUserLimitService {
    @Autowired
    PhoneNumberUtil phoneNumberUtil;

    public IPage<SysUserLimit> queryPage(String filterParam, String sortParam, String username, String tel, int page, int size) {
        try {
            MPJQueryMapperUtil qmu = new MPJQueryMapperUtil();
            if (this.phoneNumberUtil.isTelEncrypt()) {
                filterParam = this.phoneNumberUtil.convertPhoneNumberFilterParam(filterParam);
            }
            MPJLambdaWrapper queryWrapper = qmu.queryMapper(filterParam, sortParam, SysUserLimit.class);
            queryWrapper.selectAll(SysUserLimit.class);
            queryWrapper.selectAs("su", SysUser::getName, SysUserLimit::getUsername);
            queryWrapper.selectAs("su", SysUser::getTel, SysUserLimit::getTel);
            queryWrapper.selectAs("su", SysUser::getEmail, SysUserLimit::getEmail);
            queryWrapper.leftJoin(SysUser.class, "su", SysUser::getId, SysUserLimit::getUserid);
            if (StrUtil.isNotBlank((CharSequence)username)) {
                queryWrapper.or(query -> {
                    MPJLambdaWrapper cfr_ignored_0 = (MPJLambdaWrapper)query.like(SysUser::getName, (Object)username);
                });
            }
            if (StrUtil.isNotBlank((CharSequence)tel)) {
                if (this.phoneNumberUtil.isTelEncrypt()) {
                    queryWrapper.or(query -> {
                        MPJLambdaWrapper cfr_ignored_0 = (MPJLambdaWrapper)query.eq(SysUser::getTelEncrypt, (Object)this.phoneNumberUtil.getEncryptPhoneNumber(tel));
                    });
                } else {
                    queryWrapper.or(query -> {
                        MPJLambdaWrapper cfr_ignored_0 = (MPJLambdaWrapper)query.like(SysUser::getTel, (Object)tel);
                    });
                }
            }
            Page pageT = new Page((long)page, (long)size);
            IPage pageResults = this.selectJoinListPage((IPage)pageT, SysUserLimit.class, (MPJBaseJoin)queryWrapper);
            return pageResults;
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }
}

