/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.local.service;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.geoway.jckj.base.exception.ServiceException;
import com.geoway.jckj.base.support.DateUtils;
import com.geoway.jckj.base.support.ExcelUtil;
import com.geoway.jckj.base.support.StringUtils;
import com.geoway.jckj.base.support.encryption.AESUtils;
import com.geoway.jckj.base.support.encryption.Md5Utils;
import com.geoway.jckj.base.support.query.MPJQueryMapperUtil;
import com.geoway.jckj.biz.config.PasswordConfig;
import com.geoway.jckj.biz.config.SsoConfig;
import com.geoway.jckj.biz.dto.UserRelParams;
import com.geoway.jckj.biz.entity.BaseEntity;
import com.geoway.jckj.biz.entity.SaasEntity;
import com.geoway.jckj.biz.entity.SysBizManage;
import com.geoway.jckj.biz.entity.SysImage;
import com.geoway.jckj.biz.entity.SysOrganization;
import com.geoway.jckj.biz.entity.SysRegion;
import com.geoway.jckj.biz.entity.SysTenant;
import com.geoway.jckj.biz.entity.SysUser;
import com.geoway.jckj.biz.entity.SysUserLimit;
import com.geoway.jckj.biz.entity.SysUserOrganization;
import com.geoway.jckj.biz.entity.SysUserRegion;
import com.geoway.jckj.biz.entity.SysUserRegister;
import com.geoway.jckj.biz.entity.SysUserRole;
import com.geoway.jckj.biz.entity.SysUserSecurity;
import com.geoway.jckj.biz.enums.TenantUserRangeEnum;
import com.geoway.jckj.biz.enums.UserSysEnum;
import com.geoway.jckj.biz.local.mapper.SysUserMapper;
import com.geoway.jckj.biz.mapper.SysRoleMapper;
import com.geoway.jckj.biz.mapper.SysUserLimitMapper;
import com.geoway.jckj.biz.mapper.SysUserRegisterMapper;
import com.geoway.jckj.biz.mapper.SysUserSecurityMapper;
import com.geoway.jckj.biz.service.ISaasEntityService;
import com.geoway.jckj.biz.service.dev.base.IUserOrganizationService;
import com.geoway.jckj.biz.service.dev.base.IUserService;
import com.geoway.jckj.biz.service.dev.unity.IUnityUserOrganizationService;
import com.geoway.jckj.biz.service.login.ICaptchaService;
import com.geoway.jckj.biz.service.sys.SysBizManageService;
import com.geoway.jckj.biz.service.sys.SysImageService;
import com.geoway.jckj.biz.service.sys.SysUserCatalogService;
import com.geoway.jckj.biz.service.sys.SysUserRegionService;
import com.geoway.jckj.biz.service.sys.SysUserRoleService;
import com.geoway.jckj.biz.service.sys.SysUserSecurityService;
import com.geoway.jckj.biz.util.PasswordUtil;
import com.geoway.jckj.biz.util.PhoneNumberUtil;
import com.geoway.jckj.biz.util.SysUserUtil;
import com.geoway.jckj.biz.util.TenantUtil;
import com.geoway.sso.client.enums.RoleLevelEnum;
import com.geoway.sso.client.rpc.SsoUser;
import com.github.yulichang.base.MPJBaseServiceImpl;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="localUserServiceImpl")
public class LocalUserServiceImpl
extends MPJBaseServiceImpl<SysUserMapper, SysUser>
implements ISaasEntityService<SysUser>,
IUserService {
    private static final Logger log = LoggerFactory.getLogger(LocalUserServiceImpl.class);
    @Autowired
    private SysUserRoleService sysUserRoleService;
    @Autowired
    private IUnityUserOrganizationService unityOrganizationService;
    @Autowired
    private SysUserRegionService sysUserRegionService;
    @Autowired
    private SysUserSecurityService sysUserSecurityService;
    @Autowired
    private SysUserSecurityMapper sysUserSecurityMapper;
    @Autowired
    private SysUserMapper sysUserMapper;
    @Autowired
    private SysImageService sysImageService;
    @Autowired
    private SysUserRegisterMapper sysUserRegisterMapper;
    @Autowired
    SysUserLimitMapper sysUserLimitMapper;
    @Autowired
    private ICaptchaService commonService;
    @Autowired
    private PasswordUtil passwordUtil;
    @Autowired
    SysRoleMapper sysRoleMapper;
    @Autowired
    PasswordConfig passwordConfig;
    @Autowired
    PhoneNumberUtil phoneNumberUtil;
    @Autowired
    SysUserCatalogService sysUserCatalogService;
    @Autowired
    SsoConfig ssoConfig;
    @Autowired
    SysBizManageService sysBizManageService;

    public String getUserSystem() {
        return UserSysEnum.JCKJ.value;
    }

    public void saveOrUp(SysUser user, MultipartFile file, boolean deletePhoto) {
        try {
            this.saveUserBaseInfo(user, file, deletePhoto);
            this.saveUserRelInfo(user);
        }
        catch (Exception exception) {
            throw new ServiceException((Throwable)exception);
        }
    }

    protected void saveUserRelInfo(SysUser user) {
        String otherParams = user.getOtherParams();
        if (StringUtils.isNotBlank((CharSequence)otherParams)) {
            try {
                UserRelParams userParams = (UserRelParams)JSON.parseObject((String)otherParams, UserRelParams.class);
                this.sysUserRoleService.updateUserRole(user.getId(), userParams.getRoles());
                ((IUserOrganizationService)this.unityOrganizationService.getLocalService()).updateUserOrg(user.getId(), userParams.getOrganizations());
                this.sysUserRegionService.updateUserRegions(user.getId(), userParams.getRegions());
            }
            catch (Exception ex) {
                throw new ServiceException("\u9519\u8bef:" + ex.getMessage());
            }
        }
    }

    protected void saveUserBaseInfo(SysUser user, MultipartFile file, boolean deletePhoto) {
        try {
            int iCount;
            boolean isAdd;
            SysUser old = null;
            if (StrUtil.isNotBlank((CharSequence)user.getId())) {
                old = (SysUser)this.sysUserMapper.selectById((Serializable)((Object)user.getId()));
            }
            boolean bl = isAdd = old == null;
            if (StrUtil.isBlank((CharSequence)user.getName())) {
                throw new ServiceException("\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String tel = user.getTel();
            if (StrUtil.isBlank((CharSequence)tel)) {
                throw new ServiceException("\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (tel.length() != 11) {
                throw new ServiceException("\u624b\u673a\u53f7\u683c\u5f0f\u9519\u8bef");
            }
            user.setTel(this.phoneNumberUtil.isTelEncrypt() ? this.phoneNumberUtil.getHidePhoneNumber(tel) : tel);
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            wrapper.eq(SysUser::getName, (Object)user.getName());
            if (isAdd) {
                wrapper.eq(SysUser::getSource, (Object)user.getSource());
                user.setCreatetime(new Date());
                if (StrUtil.isBlank((CharSequence)user.getTelEncrypt())) {
                    user.setTelEncrypt(this.phoneNumberUtil.getEncryptPhoneNumber(tel));
                }
            } else {
                wrapper.ne(SysUser::getId, (Object)user.getId());
                wrapper.eq(SysUser::getSource, (Object)old.getSource());
                if (old != null) {
                    user.setCreatetime(old.getCreatetime());
                    user.setUpdatetime(new Date());
                    if (this.phoneNumberUtil.isTelEncrypt()) {
                        if (tel.contains("*")) {
                            if (!tel.equals(old.getTel())) {
                                throw new ServiceException("\u624b\u673a\u53f7\u683c\u5f0f\u9519\u8bef");
                            }
                        } else {
                            user.setTelEncrypt(this.phoneNumberUtil.getEncryptPhoneNumber(tel));
                        }
                    }
                }
            }
            if ((iCount = this.sysUserMapper.selectCount((Wrapper)wrapper).intValue()) > 0) {
                throw new ServiceException("\u8d26\u6237:" + user.getName() + "  \u5df2\u5b58\u5728\uff01");
            }
            if (StrUtil.isBlank((CharSequence)user.getAname())) {
                user.setAname(user.getName());
            }
            if (!isAdd && deletePhoto) {
                this.sysImageService.removeById((Serializable)((Object)user.getImgid()));
                user.setImgid("");
            }
            if (isAdd) {
                this.wrapperEntity((SaasEntity)user);
                this.sysUserMapper.insert(user);
            } else {
                this.sysUserMapper.updateById(user);
            }
            if (file != null && !file.isEmpty()) {
                SysImage sysImage = (SysImage)this.sysImageService.getById((Serializable)((Object)user.getImgid()));
                if (sysImage == null) {
                    sysImage = new SysImage();
                    sysImage.setObjectid(user.getId());
                    sysImage.setType(Integer.valueOf(3));
                }
                sysImage.setImage(file.getBytes());
                this.sysImageService.saveOrUpdate((Object)sysImage);
                LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
                updateWrapper.set(SysUser::getImgid, (Object)sysImage.getId());
                updateWrapper.eq(SysUser::getId, (Object)user.getId());
                this.sysUserMapper.update(null, (Wrapper)updateWrapper);
            }
            if (isAdd) {
                String password;
                String resetPassword = "";
                if (StrUtil.isNotBlank((CharSequence)user.getPassword())) {
                    password = user.getPassword();
                } else {
                    resetPassword = this.passwordUtil.getInitRealPassrowd();
                    password = Md5Utils.getMD5Str((String)resetPassword, (String)"UTF-8");
                }
                this.setNewUserPassword(user.getId(), password, resetPassword);
            }
        }
        catch (Exception exception) {
            throw new ServiceException((Throwable)exception);
        }
    }

    private void setNewUserPassword(String userId, String password, String resetPassword) {
        SysUserSecurity sysUserSecurity = (SysUserSecurity)this.sysUserSecurityService.getById((Serializable)((Object)userId));
        if (sysUserSecurity == null) {
            sysUserSecurity = new SysUserSecurity();
            sysUserSecurity.setId(userId);
        }
        sysUserSecurity.setPassword(password);
        sysUserSecurity.setResetPassword(resetPassword);
        sysUserSecurity.setExpiretime(DateUtils.addDays((Date)new Date(), (int)this.passwordConfig.getExpireDays()));
        this.sysUserSecurityService.saveOrUpdate((Object)sysUserSecurity);
    }

    public void batchSave(List<SysUser> users) {
        this.saveOrUpdateBatch(users);
    }

    public SysUser query(String userId) {
        SysUser sysUser = (SysUser)this.sysUserMapper.selectById((Serializable)((Object)userId));
        SysUserUtil.wrapperUsers(Collections.singletonList(sysUser));
        return sysUser;
    }

    public List<SysUser> query(List<String> userIds) {
        ArrayList<SysUser> restult = new ArrayList<SysUser>();
        if (userIds.isEmpty()) {
            return restult;
        }
        List idGroups = Lists.partition(userIds, (int)10000);
        for (List ids : idGroups) {
            restult.addAll(this.sysUserMapper.selectBatchIds(ids));
        }
        SysUserUtil.wrapperUserCatalogs(restult);
        return restult;
    }

    public List<SysUser> queryList(String filterParam) {
        return this.queryList(filterParam, true);
    }

    public List<SysUser> queryList(String filterParam, boolean withRoleOrg) {
        try {
            MPJLambdaWrapper<SysUser> queryWrapper = this.buildLambdaWrapper(filterParam, "");
            this.addOrderByWrapper(queryWrapper);
            List users = this.sysUserMapper.selectList((Wrapper)queryWrapper);
            if (withRoleOrg) {
                SysUserUtil.wrapperUsers((List)users);
            } else {
                SysUserUtil.wrapperUserCatalogs((List)users);
            }
            return users;
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public int queryCount(String filterParam) {
        try {
            MPJLambdaWrapper<SysUser> queryWrapper = this.buildLambdaWrapper(filterParam, "");
            Page pages = new Page(1L, 1L);
            IPage pageUsers = this.sysUserMapper.selectPage((IPage)pages, (Wrapper)queryWrapper);
            return (int)pageUsers.getTotal();
        }
        catch (Exception exception) {
            throw new ServiceException((Throwable)exception);
        }
    }

    public IPage<SysUser> queryPage(String filterParam, int page, int size, List<String> inUserIds, List<String> notInUserIds) {
        try {
            MPJLambdaWrapper<SysUser> queryWrapper = this.buildLambdaWrapper(filterParam, "");
            if (inUserIds != null && inUserIds.size() > 0) {
                queryWrapper.in(SysUser::getId, inUserIds);
            }
            if (notInUserIds != null && notInUserIds.size() > 0) {
                queryWrapper.notIn(SysUser::getId, notInUserIds);
            }
            this.addOrderByWrapper(queryWrapper);
            long start = System.currentTimeMillis();
            Page pages = new Page((long)page, (long)size);
            IPage pageUsers = this.sysUserMapper.selectPage((IPage)pages, (Wrapper)queryWrapper);
            List users = pageUsers.getRecords();
            System.out.println("\u5206\u9875\u67e5\u8be2\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
            start = System.currentTimeMillis();
            SysUserUtil.wrapperUsers((List)users);
            this.wrapperResetPassword(users);
            System.out.println("wrapperUsers\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
            return pageUsers;
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public IPage<SysUser> queryPage(String filterParam, int page, int size, boolean containAdmin, boolean containBizAdmin, boolean containTenantAdmin) {
        try {
            ArrayList<String> notInIds = new ArrayList<String>();
            if (!containAdmin) {
                List adminUserIds = this.sysUserCatalogService.getUserIdByCatalog(RoleLevelEnum.superAdmin);
                notInIds.addAll(adminUserIds);
            }
            if (!containBizAdmin) {
                List bizAdminUserIds = this.sysUserCatalogService.getUserIdByCatalog(RoleLevelEnum.bizAdmin);
                notInIds.addAll(bizAdminUserIds);
            }
            if (!containTenantAdmin) {
                List tenantAdminUserIds = this.sysUserCatalogService.getUserIdByCatalog(RoleLevelEnum.tenantAdmin);
                notInIds.addAll(tenantAdminUserIds);
            }
            return this.queryPage(filterParam, page, size, null, notInIds);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public IPage<SysUser> queryPage(String filterParam, int page, int size, boolean containAdmin) {
        return this.queryPage(filterParam, page, size, containAdmin, true, true);
    }

    public IPage<SysUser> queryPage(String filterParam, int page, int size) {
        return this.queryPage(filterParam, page, size, true);
    }

    private void wrapperResetPassword(List<SysUser> users) {
        if (users == null || users.isEmpty()) {
            return;
        }
        List sysUserSecurities = this.sysUserSecurityMapper.selectBatchIds((Collection)users.stream().map(f -> f.getId()).collect(Collectors.toList()));
        for (SysUser user : users) {
            SysUserSecurity sysUserSecurity = sysUserSecurities.stream().filter(g -> g.getId().equals(user.getId())).findAny().orElse(null);
            if (sysUserSecurity == null) continue;
            user.setResetPassword(sysUserSecurity.getResetPassword());
        }
    }

    public MPJLambdaWrapper<SysUser> buildLambdaWrapper(String filterParam, String sortParam) {
        try {
            filterParam = this.convertTelParam(filterParam);
            MPJQueryMapperUtil mpjQueryMapperUtil = new MPJQueryMapperUtil();
            MPJLambdaWrapper queryWrapper = mpjQueryMapperUtil.queryMapper(filterParam, sortParam, SysUser.class);
            RoleLevelEnum roleLevelEnum = this.getUserLevel();
            switch (roleLevelEnum) {
                case bizAdmin: {
                    SsoUser ssoUser = this.getUser();
                    SysBizManage sysBizManage = this.sysBizManageService.queryByUserId(ssoUser.getUserid());
                    List<String> orgIdPaths = sysBizManage.getOrganizations().stream().map(f -> f.getIdpath()).collect(Collectors.toList());
                    List<String> regionIdPaths = sysBizManage.getRegions().stream().map(f -> f.getIdpath()).collect(Collectors.toList());
                    this.wrapperLeftJoinMapper((MPJLambdaWrapper<SysUser>)queryWrapper, orgIdPaths, regionIdPaths);
                    queryWrapper.and(wrapper -> {
                        this.wrapperQueryMapper((MPJLambdaWrapper<SysUser>)wrapper, orgIdPaths, regionIdPaths);
                        ((MPJLambdaWrapper)wrapper.or()).eq(BaseEntity::getCreatorid, (Object)ssoUser.getId());
                    });
                    queryWrapper.selectAll(SysUser.class);
                    queryWrapper.distinct();
                    break;
                }
                case superAdmin: 
                case tenantAdmin: 
                case commonUser: 
                case guest: 
                case None: {
                    if (TenantUtil.isSuperTenant()) break;
                    SysTenant tenant = this.getTenant();
                    List<String> tenantOrgIdPaths = tenant.getOrganizations().stream().map(f -> f.getIdpath()).collect(Collectors.toList());
                    List<String> tenantRegionIdPaths = tenant.getRegions().stream().map(f -> f.getIdpath()).collect(Collectors.toList());
                    this.wrapperLeftJoinMapper((MPJLambdaWrapper<SysUser>)queryWrapper, tenantOrgIdPaths, tenantRegionIdPaths);
                    queryWrapper.and(wrapper -> {
                        this.wrapperQueryMapper((MPJLambdaWrapper<SysUser>)wrapper, tenantOrgIdPaths, tenantRegionIdPaths);
                        ((MPJLambdaWrapper)wrapper.or()).eq(SaasEntity::getTenantid, (Object)tenant.getId());
                        if (tenant.getUsers().size() > 0) {
                            ((MPJLambdaWrapper)wrapper.or()).in(SysUser::getId, (Collection)tenant.getUsers().stream().map(f -> f.getId()).collect(Collectors.toList()));
                        }
                    });
                    queryWrapper.selectAll(SysUser.class);
                    queryWrapper.distinct();
                }
            }
            return queryWrapper;
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    private void wrapperLeftJoinMapper(MPJLambdaWrapper<SysUser> wrapper, List<String> orgIdPaths, List<String> regionIdPaths) {
        TenantUserRangeEnum userRangeEnum = TenantUserRangeEnum.getEnumByValue((int)this.ssoConfig.getTenantUserRange());
        if ((userRangeEnum == TenantUserRangeEnum.ORG || userRangeEnum == TenantUserRangeEnum.REGION_ORG) && orgIdPaths.size() > 0) {
            wrapper.leftJoin(SysUserOrganization.class, SysUserOrganization::getUserid, SysUser::getId);
            wrapper.leftJoin(SysOrganization.class, SysOrganization::getId, SysUserOrganization::getOrgid);
        }
        if ((userRangeEnum == TenantUserRangeEnum.REGION || userRangeEnum == TenantUserRangeEnum.REGION_ORG) && regionIdPaths.size() > 0) {
            wrapper.leftJoin(SysUserRegion.class, SysUserRegion::getUserid, SysUser::getId);
            wrapper.leftJoin(SysRegion.class, SysRegion::getId, SysUserRegion::getRegionid);
        }
    }

    private void wrapperQueryMapper(MPJLambdaWrapper<SysUser> wrapper, List<String> orgIdPaths, List<String> regionIdPaths) {
        TenantUserRangeEnum userRangeEnum = TenantUserRangeEnum.getEnumByValue((int)this.ssoConfig.getTenantUserRange());
        if ((userRangeEnum == TenantUserRangeEnum.ORG || userRangeEnum == TenantUserRangeEnum.REGION_ORG) && orgIdPaths.size() > 0) {
            for (String orgIdPath : orgIdPaths) {
                ((MPJLambdaWrapper)wrapper.or()).likeRight(SysOrganization::getIdpath, (Object)orgIdPath);
            }
        }
        if ((userRangeEnum == TenantUserRangeEnum.REGION || userRangeEnum == TenantUserRangeEnum.REGION_ORG) && regionIdPaths.size() > 0) {
            for (String regionIdPath : regionIdPaths) {
                ((MPJLambdaWrapper)wrapper.or()).likeRight(SysRegion::getIdpath, (Object)regionIdPath);
            }
        }
    }

    private void addOrderByWrapper(MPJLambdaWrapper<SysUser> queryWrapper) {
        queryWrapper.orderByAsc((Object)"f_name");
    }

    private String convertTelParam(String filterParam) throws Exception {
        if (StrUtil.isBlank((CharSequence)filterParam)) {
            return filterParam;
        }
        if (!this.phoneNumberUtil.isTelEncrypt()) {
            return filterParam;
        }
        return this.phoneNumberUtil.convertPhoneNumberFilterParam(filterParam);
    }

    public void delete(String id) {
        if (StringUtils.isEmpty((String)id)) {
            throw new ServiceException("\u4f20\u9012\u7684\u3010id\u3011\u4e3a\u7a7a\uff01");
        }
        SysUser sysUser = (SysUser)this.sysUserMapper.selectById((Serializable)((Object)id));
        LambdaQueryWrapper uerRoleWarpper = Wrappers.lambdaQuery();
        uerRoleWarpper.eq(SysUserRole::getUserid, (Object)id);
        this.sysUserRoleService.remove((Wrapper)uerRoleWarpper);
        ((IUserOrganizationService)this.unityOrganizationService.getLocalService()).removeByOrgUserId("", id);
        LambdaQueryWrapper uerRegionWarpper = Wrappers.lambdaQuery();
        uerRegionWarpper.eq(SysUserRegion::getUserid, (Object)id);
        this.sysUserRegionService.remove((Wrapper)uerRegionWarpper);
        this.sysUserMapper.deleteById((Serializable)((Object)id));
        this.sysUserSecurityService.removeById((Serializable)((Object)id));
        if (StrUtil.isNotBlank((CharSequence)sysUser.getImgid())) {
            this.sysImageService.removeById((Serializable)((Object)sysUser.getImgid()));
        }
        this.sysUserRegisterMapper.delete((Wrapper)Wrappers.lambdaQuery(SysUserRegister.class).eq(SysUserRegister::getName, (Object)sysUser.getName()));
        LambdaQueryWrapper uerLimitWarpper = Wrappers.lambdaQuery();
        uerLimitWarpper.eq(SysUserLimit::getUserid, (Object)id);
        this.sysUserLimitMapper.delete((Wrapper)uerLimitWarpper);
    }

    public void batchDelete(String ids) {
        if (StrUtil.isBlank((CharSequence)ids)) {
            return;
        }
        List<String> idList = Arrays.asList(ids.split(","));
        for (String id : idList) {
            this.delete(id);
        }
    }

    public void exportUsers(String filterParam, Boolean isTemplate, HttpServletResponse response) {
        try {
            MPJLambdaWrapper<SysUser> queryWrapper = this.buildLambdaWrapper(filterParam, "");
            this.addOrderByWrapper(queryWrapper);
            List users = new ArrayList();
            if (!isTemplate.booleanValue()) {
                users = this.sysUserMapper.selectList((Wrapper)queryWrapper);
                SysUserUtil.wrapperUserCatalogs(users);
            }
            ExcelUtil.exportExcel(users, null, (String)"\u7528\u6237\u5217\u8868", SysUser.class, (String)"\u5bfc\u51fa\u7528\u6237\u4fe1\u606f", (boolean)true, (HttpServletResponse)response);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public String importUsers(List<SysUser> userList, Boolean isUpdateSupport, String orgId) {
        try {
            if (StringUtils.isNull(userList) || userList.size() == 0) {
                throw new ServiceException("\u5bfc\u5165\u7528\u6237\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            int successNum = 0;
            int failureNum = 0;
            StringBuilder successMsg = new StringBuilder();
            StringBuilder failureMsg = new StringBuilder();
            Date now = new Date();
            for (SysUser user : userList) {
                try {
                    LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
                    wrapper.eq(SysUser::getName, (Object)user.getName());
                    SysUser oldUser = (SysUser)this.sysUserMapper.selectOne((Wrapper)wrapper);
                    if (ObjectUtil.isNull((Object)oldUser)) {
                        this.saveExcelUser(user);
                        successMsg.append("<br/>" + ++successNum + "\u3001\u8d26\u53f7 " + user.getName() + " \u5bfc\u5165\u6210\u529f");
                    } else if (isUpdateSupport.booleanValue()) {
                        user.setId(oldUser.getId());
                        this.saveExcelUser(user);
                        successMsg.append("<br/>" + ++successNum + "\u3001\u8d26\u53f7 " + user.getName() + " \u66f4\u65b0\u6210\u529f");
                    } else {
                        failureMsg.append("<br/>" + ++failureNum + "\u3001\u8d26\u53f7 " + user.getName() + " \u5df2\u5b58\u5728");
                        continue;
                    }
                    if (!StrUtil.isNotBlank((CharSequence)orgId) || !StrUtil.isNotBlank((CharSequence)user.getId())) continue;
                    SysUserOrganization sysUserOrganization = new SysUserOrganization();
                    sysUserOrganization.setUserid(user.getId());
                    sysUserOrganization.setOrgid(orgId);
                    ((IUserOrganizationService)this.unityOrganizationService.getLocalService()).saveOne(sysUserOrganization);
                }
                catch (Exception ex) {
                    String msg = "<br/>" + ++failureNum + "\u3001\u8d26\u53f7 " + user.getName() + " \u5bfc\u5165\u5931\u8d25\uff1a";
                    failureMsg.append(msg + ex.getMessage());
                    log.error(msg, (Throwable)ex);
                }
            }
            if (failureNum > 0) {
                failureMsg.insert(0, "\u5f88\u62b1\u6b49\uff0c\u5bfc\u5165\u5931\u8d25\uff01\u5171 " + failureNum + " \u6761\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u9519\u8bef\u5982\u4e0b\uff1a");
                throw new ServiceException(failureMsg.toString());
            }
            successMsg.insert(0, "\u606d\u559c\u60a8\uff0c\u6570\u636e\u5df2\u5168\u90e8\u5bfc\u5165\u6210\u529f\uff01\u5171 " + successNum + " \u6761\uff0c\u6570\u636e\u5982\u4e0b\uff1a");
            return successMsg.toString();
        }
        catch (Exception exception) {
            throw new ServiceException((Throwable)exception);
        }
    }

    public Boolean changePassword(String phoneNum, String verifyCode, String verifyCodeUid, String password) throws Exception {
        String verifyStr = this.commonService.queryCaptcha(verifyCodeUid);
        if (StrUtil.isBlank((CharSequence)verifyStr)) {
            throw new ServiceException("\u65e0\u6548\u7684\u9a8c\u8bc1\u7801");
        }
        JSONObject jsonObject = JSON.parseObject((String)verifyStr);
        if (!verifyCode.equals(jsonObject.getString("verifyCode"))) {
            throw new ServiceException("\u65e0\u6548\u7684\u9a8c\u8bc1\u7801");
        }
        List<SysUser> users = this.queryList("telEncrypt_EQ_" + AESUtils.encrypt((String)phoneNum, (String)"FWAijk4A2Dwt2MKw"));
        if (users == null || users.size() == 0) {
            throw new ServiceException("\u6b64\u624b\u673a\u53f7\u7801\u672a\u6ce8\u518c");
        }
        this.changePassword(users.get(0).getId(), password);
        return true;
    }

    public void changePassword(String userId, String oldPwd, String newPwd) {
        SysUserSecurity userSecurity = (SysUserSecurity)this.sysUserSecurityMapper.selectById((Serializable)((Object)userId));
        if (userSecurity == null) {
            throw new ServiceException("\u672a\u67e5\u8be2\u5230\u7528\u6237\u5b89\u5168\u4fe1\u606f");
        }
        if (!userSecurity.getPassword().equals(this.passwordUtil.getMD5Password(oldPwd))) {
            throw new ServiceException("\u7528\u6237\u539f\u5bc6\u7801\u9519\u8bef\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u539f\u5bc6\u7801");
        }
        if (userSecurity.getPassword().equals(this.passwordUtil.getMD5Password(newPwd))) {
            throw new ServiceException("\u65b0\u5bc6\u7801\u548c\u539f\u5bc6\u7801\u4e0d\u80fd\u76f8\u540c");
        }
        userSecurity.setResetPassword("");
        userSecurity.setPassword(this.passwordUtil.getMD5Password(newPwd));
        userSecurity.setExpiretime(DateUtils.addDays((Date)new Date(), (int)this.passwordConfig.getExpireDays()));
        this.sysUserSecurityMapper.updateById((Object)userSecurity);
    }

    public void changePassword(String userId, String password) {
        SysUserSecurity sysUserSecurity = (SysUserSecurity)this.sysUserSecurityService.getById((Serializable)((Object)userId));
        if (sysUserSecurity == null) {
            sysUserSecurity = new SysUserSecurity();
            sysUserSecurity.setId(userId);
        }
        sysUserSecurity.setPassword(this.passwordUtil.getMD5Password(password));
        sysUserSecurity.setExpiretime(DateUtils.addDays((Date)new Date(), (int)this.passwordConfig.getExpireDays()));
        sysUserSecurity.setResetPassword("");
        this.sysUserSecurityService.saveOrUpdate((Object)sysUserSecurity);
    }

    public String resetPassword(String userId) {
        SysUserSecurity sysUserSecurity = (SysUserSecurity)this.sysUserSecurityService.getById((Serializable)((Object)userId));
        if (sysUserSecurity == null) {
            throw new ServiceException("\u8be5\u7528\u6237\u4e0d\u652f\u6301\u5bc6\u7801\u91cd\u7f6e");
        }
        String resetPassword = this.passwordUtil.getInitRealPassrowd();
        String password = Md5Utils.getMD5Str((String)resetPassword, (String)"UTF-8");
        sysUserSecurity.setResetPassword(resetPassword);
        sysUserSecurity.setPassword(password);
        sysUserSecurity.setExpiretime(DateUtils.addYears((Date)new Date(), (int)100));
        this.sysUserSecurityService.saveOrUpdate((Object)sysUserSecurity);
        return resetPassword;
    }

    public boolean checkIsResetPassword(String userId) {
        SysUserSecurity sysUserSecurity = (SysUserSecurity)this.sysUserSecurityMapper.selectById((Serializable)((Object)userId));
        if (sysUserSecurity == null) {
            return false;
        }
        return this.passwordConfig.getForceChangeInitPWD() != false && StrUtil.isNotBlank((CharSequence)sysUserSecurity.getResetPassword());
    }

    private void saveExcelUser(SysUser sysUser) {
        try {
            this.saveOrUp(sysUser, null, false);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

