/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.local.service;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.geoway.jckj.base.exception.ServiceException;
import com.geoway.jckj.base.support.StringUtils;
import com.geoway.jckj.base.support.query.MPJQueryMapperUtil;
import com.geoway.jckj.biz.entity.SaasEntity;
import com.geoway.jckj.biz.entity.SysBizManage;
import com.geoway.jckj.biz.entity.SysOrganization;
import com.geoway.jckj.biz.entity.SysTenant;
import com.geoway.jckj.biz.entity.SysUser;
import com.geoway.jckj.biz.entity.SysUserOrganization;
import com.geoway.jckj.biz.entity.SysUserSecurity;
import com.geoway.jckj.biz.local.mapper.SysOrganizationMapper;
import com.geoway.jckj.biz.local.mapper.SysUserMapper;
import com.geoway.jckj.biz.mapper.SysUserSecurityMapper;
import com.geoway.jckj.biz.service.ISaasEntityService;
import com.geoway.jckj.biz.service.dev.base.IOrganizationService;
import com.geoway.jckj.biz.service.dev.base.IUserOrganizationService;
import com.geoway.jckj.biz.service.dev.base.IUserService;
import com.geoway.jckj.biz.service.dev.unity.IUnityUserOrganizationService;
import com.geoway.jckj.biz.service.dev.unity.IUnityUserService;
import com.geoway.jckj.biz.service.oauth2.IOauth2Service;
import com.geoway.jckj.biz.service.sys.SysBizManageService;
import com.geoway.jckj.biz.service.sys.SysUserRoleService;
import com.geoway.jckj.biz.util.SysUserUtil;
import com.geoway.jckj.biz.util.TenantUtil;
import com.geoway.sso.client.enums.RoleLevelEnum;
import com.geoway.sso.client.rpc.SsoUser;
import com.github.yulichang.base.MPJBaseServiceImpl;
import com.github.yulichang.interfaces.MPJBaseJoin;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="localOrganizationService")
public class LocalOrganizationServiceImpl
extends MPJBaseServiceImpl<SysOrganizationMapper, SysOrganization>
implements ISaasEntityService<SysOrganization>,
IOrganizationService {
    @Autowired
    SysOrganizationMapper sysOrganizationMapper;
    @Autowired
    IUnityUserOrganizationService unityUserOrganizationService;
    @Autowired
    IUnityUserService unityUserService;
    @Autowired
    IOauth2Service auth2Service;
    @Autowired
    SysUserMapper sysUserMapper;
    @Autowired
    SysUserRoleService sysUserRoleService;
    @Autowired
    SysBizManageService sysBizManageService;
    @Autowired
    private SysUserSecurityMapper sysUserSecurityMapper;

    public void saveOrUp(SysOrganization org) throws Exception {
        if (StrUtil.isBlank((CharSequence)org.getPid())) {
            org.setPid("0");
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysOrganization::getPid, (Object)org.getPid());
        if (StrUtil.isNotBlank((CharSequence)org.getId())) {
            wrapper.ne(SysOrganization::getId, (Object)org.getId());
        }
        wrapper.eq(SysOrganization::getName, (Object)org.getName());
        int iCount = this.count((Wrapper)wrapper);
        if (iCount > 0) {
            throw new ServiceException("\u7ec4\u7ec7\u540d\u79f0\u5df2\u5b58\u5728");
        }
        if (StrUtil.isBlank((CharSequence)org.getId())) {
            SysOrganization pOrg = (SysOrganization)this.sysOrganizationMapper.selectById((Serializable)((Object)org.getPid()));
            Integer maxOrder = this.sysOrganizationMapper.queryMaxOrderByPid(org.getPid());
            int order = maxOrder == null ? 1 : maxOrder + 1;
            org.setSort(Integer.valueOf(order));
            Long id = IdWorker.getId();
            org.setId(id.toString());
            int level = pOrg == null ? 1 : pOrg.getLevel() + 1;
            org.setLevel(Integer.valueOf(level));
            org.setIdpath(pOrg == null ? org.getId() : pOrg.getIdpath() + "->" + org.getId());
            this.wrapperEntity((SaasEntity)org);
        } else {
            SysOrganization oldOrg = (SysOrganization)this.sysOrganizationMapper.selectById((Serializable)((Object)org.getId()));
            org.setLevel(oldOrg.getLevel());
        }
        this.saveOrUpdate(org);
    }

    public void batchSave(List<SysOrganization> orgs) throws Exception {
        for (SysOrganization org : orgs) {
            this.saveOrUp(org);
        }
    }

    public List<SysOrganization> queryTree(String filterParam, boolean bindUser) throws Exception {
        List<SysOrganization> list = this.queryList(filterParam);
        if (bindUser) {
            this.bindUsersToOrg(list);
        }
        return this.constructTree(list);
    }

    public List<SysOrganization> queryTreeNoUser(String filterParam) throws Exception {
        MPJLambdaWrapper<SysOrganization> queryWrapper = this.buildLambdaWrapper(filterParam, "");
        List list = this.sysOrganizationMapper.selectList((Wrapper)queryWrapper);
        return this.constructTree(list);
    }

    public List<SysOrganization> queryList(String filterParam) throws Exception {
        if (filterParam == null) {
            filterParam = "";
        }
        MPJLambdaWrapper<SysOrganization> queryWrapper = this.buildLambdaWrapper(filterParam, "");
        List list = this.sysOrganizationMapper.selectList((Wrapper)queryWrapper);
        return list;
    }

    public List<SysOrganization> queryListById(String id) throws Exception {
        if (id == null) {
            throw new Exception("\u673a\u6784ID\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        List<SysOrganization> list = this.sysOrganizationMapper.getOrgListById(id);
        this.bindUsersToOrg(list);
        return this.constructTree(list);
    }

    public List<SysOrganization> queryAllParentOrg(String id) {
        if (id == null) {
            throw new ServiceException("\u673a\u6784ID\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        List<SysOrganization> result = this.sysOrganizationMapper.getAllParentOrg(id);
        Collections.reverse(result);
        return result;
    }

    public List<SysOrganization> queryAllChildOrg(String id) {
        if (id == null) {
            throw new ServiceException("\u673a\u6784ID\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        List<SysOrganization> list = this.sysOrganizationMapper.getOrgListById(id);
        return list;
    }

    public IPage<SysOrganization> queryPage(String filterParam, int page, int size) throws Exception {
        if (filterParam == null) {
            filterParam = "";
        }
        MPJLambdaWrapper<SysOrganization> queryWrapper = this.buildLambdaWrapper(filterParam, "");
        Page pages = new Page((long)page, (long)size);
        Page results = (Page)this.sysOrganizationMapper.selectPage((IPage)pages, (Wrapper)queryWrapper);
        return results;
    }

    public SysOrganization findOneById(String id, String filterParam) throws Exception {
        SysOrganization org = (SysOrganization)this.sysOrganizationMapper.selectById((Serializable)((Object)id));
        if (filterParam == null) {
            filterParam = "";
        }
        filterParam = filterParam + ";pid_EQ_" + id;
        MPJQueryMapperUtil qmu = new MPJQueryMapperUtil();
        MPJLambdaWrapper queryWrapper = qmu.queryMapper(filterParam, "", SysOrganization.class);
        List orgs = this.sysOrganizationMapper.selectList((Wrapper)queryWrapper);
        if (org != null) {
            org.setChildren(orgs);
        }
        return org;
    }

    public SysOrganization findOneByName(String name, String filterParam) throws Exception {
        MPJLambdaWrapper<SysOrganization> queryWrapper = this.buildLambdaWrapper("", "");
        queryWrapper.eq(SysOrganization::getName, (Object)name);
        SysOrganization org = (SysOrganization)this.sysOrganizationMapper.selectOne((Wrapper)queryWrapper);
        if (org == null) {
            return org;
        }
        if (filterParam == null) {
            filterParam = "";
        }
        filterParam = filterParam + ";pid_EQ_" + org.getId();
        queryWrapper = this.buildLambdaWrapper(filterParam, "");
        List orgs = this.sysOrganizationMapper.selectList((Wrapper)queryWrapper);
        if (org != null) {
            org.setChildren(orgs);
        }
        return org;
    }

    public void batchDelete(String ids) throws Exception {
        if (StrUtil.isBlank((CharSequence)ids)) {
            return;
        }
        List<String> idList = Arrays.asList(ids.split(","));
        for (String id : idList) {
            this.deleteById(id);
        }
    }

    public void resetIdPathFieldValue() {
        this.sysOrganizationMapper.resetIdPathFieldValue();
    }

    public void bindUsers(String orgId, String userIds) {
        if (StrUtil.isBlank((CharSequence)userIds)) {
            return;
        }
        String[] userIdArr = userIds.split(",");
        ArrayList<SysUserOrganization> userOrgs = new ArrayList<SysUserOrganization>();
        List<String> userIdList = Arrays.asList(userIdArr);
        for (String userId : userIdList) {
            SysUserOrganization userOrg = new SysUserOrganization();
            userOrg.setUserid(userId);
            userOrg.setOrgid(orgId);
            userOrgs.add(userOrg);
        }
        ((IUserOrganizationService)this.unityUserOrganizationService.getLocalService()).removeByOrgUserIds(orgId, userIdList);
        ((IUserOrganizationService)this.unityUserOrganizationService.getLocalService()).saveBatch(userOrgs);
    }

    public void bindOneUser(String orgId, String userId) {
        ((IUserOrganizationService)this.unityUserOrganizationService.getLocalService()).removeByOrgUserId(orgId, userId);
        SysUserOrganization userOrg = new SysUserOrganization();
        userOrg.setUserid(userId);
        userOrg.setOrgid(orgId);
        ((IUserOrganizationService)this.unityUserOrganizationService.getLocalService()).saveOne(userOrg);
    }

    public void removeBindUser(String orgId, String userIds) {
        String[] userIdArr;
        for (String userId : userIdArr = userIds.split(",")) {
            ((IUserOrganizationService)this.unityUserOrganizationService.getLocalService()).removeByOrgUserId(orgId, userId);
        }
    }

    public List<SysUser> queryRelUsers(String orgId) {
        List organizations = ((IUserOrganizationService)this.unityUserOrganizationService.getLocalService()).queryByOrgId(orgId);
        return ((IUserService)this.unityUserService.getLocalService()).query(organizations.stream().map(f -> f.getUserid()).collect(Collectors.toList()));
    }

    public IPage<SysUser> queryAllRelUsers(String orgId, String filterParam, String sortParam, int page, int size) throws Exception {
        List<SysOrganization> allOrgs = ((SysOrganizationMapper)this.getBaseMapper()).getOrgListById(orgId);
        List orgIds = allOrgs.stream().map(i -> i.getId()).collect(Collectors.toList());
        MPJLambdaWrapper queryWrapper = ((ISaasEntityService)this.unityUserService.getLocalService()).buildLambdaWrapper(filterParam, sortParam);
        queryWrapper.leftJoin(SysUserOrganization.class, SysUserOrganization::getUserid, SysUser::getId);
        if (orgIds.size() == 0) {
            queryWrapper.eq(SysUserOrganization::getOrgid, (Object)orgId);
        } else {
            queryWrapper.in(SysUserOrganization::getOrgid, orgIds);
        }
        Page pages = new Page((long)page, (long)size);
        IPage results = this.sysUserMapper.selectJoinPage((IPage)pages, SysUser.class, (MPJBaseJoin)queryWrapper);
        SysUserUtil.wrapperUsers((List)results.getRecords());
        this.wrapperResetPassword(results.getRecords());
        return results;
    }

    private void wrapperResetPassword(List<SysUser> users) {
        if (users == null || users.isEmpty()) {
            return;
        }
        List sysUserSecurities = this.sysUserSecurityMapper.selectBatchIds((Collection)users.stream().map(f -> f.getId()).collect(Collectors.toList()));
        for (SysUser user : users) {
            SysUserSecurity sysUserSecurity = sysUserSecurities.stream().filter(g -> g.getId().equals(user.getId())).findAny().orElse(null);
            if (sysUserSecurity == null) continue;
            user.setResetPassword(sysUserSecurity.getResetPassword());
        }
    }

    private IPage<SysUser> queryOrgUsers(List<String> orgId, String noOrgId, String noRoleId, String filterParam, String sortParam, int page, int size) throws Exception {
        List userIds;
        if (StrUtil.isBlank((CharSequence)sortParam)) {
            sortParam = "SORT_createtime_DESC";
        }
        if (filterParam == null) {
            filterParam = "";
        }
        MPJLambdaWrapper queryWrapper = ((ISaasEntityService)this.unityUserService.getLocalService()).buildLambdaWrapper(filterParam, sortParam);
        if (orgId != null && orgId.size() > 0) {
            if (!queryWrapper.checkJoinTable(SysUserOrganization.class)) {
                queryWrapper.leftJoin(SysUserOrganization.class, SysUserOrganization::getUserid, SysUser::getId);
            }
            if (!queryWrapper.checkJoinTable(SysOrganization.class)) {
                queryWrapper.leftJoin(SysOrganization.class, SysOrganization::getId, SysUserOrganization::getOrgid);
            }
            queryWrapper.in(SysUserOrganization::getOrgid, orgId);
        }
        if (StrUtil.isNotBlank((CharSequence)noOrgId) && (userIds = ((IUserOrganizationService)this.unityUserOrganizationService.getLocalService()).queryOrgUserIds(noOrgId)).size() > 0) {
            queryWrapper.notIn(SysUser::getId, (Collection)userIds);
        }
        if (StrUtil.isNotBlank((CharSequence)noRoleId) && (userIds = this.sysUserRoleService.queryRoleUserIds(noRoleId)).size() > 0) {
            queryWrapper.notIn(SysUser::getId, (Collection)userIds);
        }
        queryWrapper.selectAll(SysUser.class);
        queryWrapper.distinct();
        Page pages = new Page((long)page, (long)size);
        IPage results = this.sysUserMapper.selectJoinPage((IPage)pages, SysUser.class, (MPJBaseJoin)queryWrapper);
        SysUserUtil.wrapperUsers((List)results.getRecords());
        this.wrapperResetPassword(results.getRecords());
        return results;
    }

    public IPage<SysUser> queryOrgUsers(String orgId, String noOrgId, String noRoleId, String filterParam, String sortParam, int page, int size) throws Exception {
        ArrayList<String> orgIds = new ArrayList<String>();
        if (StrUtil.isNotBlank((CharSequence)orgId)) {
            orgIds.add(orgId);
        }
        return this.queryOrgUsers(orgIds, noOrgId, noRoleId, filterParam, sortParam, page, size);
    }

    public IPage<SysUser> queryAllRelUsers(String orgId, String noOrgId, String noRoleId, String filterParam, String sortParam, int page, int size) throws Exception {
        List<SysOrganization> allOrgs = ((SysOrganizationMapper)this.getBaseMapper()).getOrgListById(orgId);
        List<String> orgIds = allOrgs.stream().map(i -> i.getId()).collect(Collectors.toList());
        if (orgIds.size() == 0) {
            return new Page();
        }
        return this.queryOrgUsers(orgIds, noOrgId, noRoleId, filterParam, sortParam, page, size);
    }

    public List<SysUser> queryNonOrgUsers() {
        try {
            MPJLambdaWrapper queryWrapper = ((ISaasEntityService)this.unityUserService.getLocalService()).buildLambdaWrapper("", "");
            queryWrapper.leftJoin(SysUserOrganization.class, SysUserOrganization::getUserid, SysUser::getId);
            queryWrapper.isNull(SysUserOrganization::getOrgid);
            List allUsers = this.sysUserMapper.selectList((Wrapper)queryWrapper);
            SysUserUtil.wrapperUsers((List)allUsers);
            this.wrapperResetPassword(allUsers);
            return allUsers;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public int queryCount(String filterParam) throws Exception {
        if (filterParam == null) {
            filterParam = "";
        }
        MPJLambdaWrapper<SysOrganization> queryWrapper = this.buildLambdaWrapper(filterParam, "");
        Page pages = new Page(1L, 1L);
        IPage pageUsers = this.sysOrganizationMapper.selectPage((IPage)pages, (Wrapper)queryWrapper);
        return (int)pageUsers.getTotal();
    }

    public List<SysOrganization> queryUserOrgs(String userId) {
        List<SysOrganization> organizations = this.sysOrganizationMapper.queryUserOrgs(userId);
        if (TenantUtil.isSuperTenant() || organizations.size() == 0) {
            return organizations;
        }
        MPJLambdaWrapper<SysOrganization> queryWrapper = this.buildLambdaWrapper("", "");
        queryWrapper.in(SysOrganization::getId, (Collection)organizations.stream().map(f -> f.getId()).collect(Collectors.toList()));
        return this.sysOrganizationMapper.selectList((Wrapper)queryWrapper);
    }

    public void bindUsersToOrg(List<SysOrganization> list) {
        List subUsers;
        String orgId;
        List userOrgs = ((IUserOrganizationService)this.unityUserOrganizationService.getLocalService()).queryList("");
        List userIds = userOrgs.stream().map(f -> f.getUserid()).collect(Collectors.toList());
        List users = ((IUserService)this.unityUserService.getLocalService()).query(userIds);
        if (users.isEmpty() || userOrgs.isEmpty()) {
            return;
        }
        HashMap sysUserMap = new HashMap();
        users.forEach(f -> sysUserMap.put(f.getId(), f));
        HashMap mapUser = new HashMap();
        Map<String, List<SysUserOrganization>> groupedUserOrgs = userOrgs.stream().filter(f -> StrUtil.isNotBlank((CharSequence)f.getOrgid())).collect(Collectors.groupingBy(SysUserOrganization::getOrgid));
        for (Map.Entry<String, List<SysUserOrganization>> kv : groupedUserOrgs.entrySet()) {
            orgId = kv.getKey();
            subUsers = new ArrayList();
            mapUser.put(orgId, subUsers);
            kv.getValue().forEach(f -> {
                if (sysUserMap.containsKey(f.getUserid())) {
                    subUsers.add(sysUserMap.get(f.getUserid()));
                }
            });
        }
        for (SysOrganization org : list) {
            orgId = org.getId();
            if (!mapUser.containsKey(orgId)) continue;
            subUsers = (List)mapUser.get(orgId);
            org.setBindUsers(subUsers);
        }
    }

    private void deleteById(String id) throws Exception {
        int iCount = ((IUserOrganizationService)this.unityUserOrganizationService.getLocalService()).queryByOrgId(id).size();
        if (iCount > 0) {
            throw new Exception("\u8be5\u7ec4\u7ec7\u4e0b\u5df2\u5173\u8054\u7528\u6237\uff0c\u4e0d\u80fd\u5220\u9664!");
        }
        this.sysOrganizationMapper.deleteById((Serializable)((Object)id));
    }

    public List<SysOrganization> constructTree(List<SysOrganization> list) {
        int minLevel = 99;
        HashMap mapParam = new HashMap();
        for (SysOrganization org : list) {
            String key = org.getPid();
            if (!StringUtils.isEmpty((String)key) && !key.equals("-1")) {
                if (mapParam.containsKey(key)) {
                    ((List)mapParam.get(key)).add(org);
                } else {
                    ArrayList<SysOrganization> childList = new ArrayList<SysOrganization>();
                    childList.add(org);
                    mapParam.put(key, childList);
                }
            }
            if (org.getLevel() >= minLevel) continue;
            minLevel = org.getLevel();
        }
        ArrayList<SysOrganization> results = new ArrayList<SysOrganization>();
        for (SysOrganization org : list) {
            String key = org.getId();
            if (StringUtils.isNotBlank((CharSequence)key) && mapParam.containsKey(key)) {
                org.setChildren((List)mapParam.get(key));
                org.setChildCount(LocalOrganizationServiceImpl.doCount(org).intValue());
            }
            if (org.getLevel() != minLevel) continue;
            results.add(org);
        }
        return results;
    }

    private static Integer doCount(SysOrganization org) {
        List orgList = org.getChildren();
        Integer sum = 0;
        if (orgList == null || orgList.size() == 0) {
            if (org.getChildCount() > 0) {
                return org.getChildCount();
            }
            return sum;
        }
        if (orgList != null && orgList.size() > 0) {
            for (SysOrganization child : orgList) {
                Integer numCount = orgList.size() + org.getChildCount();
                sum = sum + numCount;
                LocalOrganizationServiceImpl.doCount(child);
            }
        }
        return sum;
    }

    public MPJLambdaWrapper<SysOrganization> buildLambdaWrapper(String filterParam, String sortParam) {
        try {
            MPJQueryMapperUtil qmu = new MPJQueryMapperUtil();
            MPJLambdaWrapper queryWrapper = qmu.queryMapper(filterParam, sortParam, SysOrganization.class);
            RoleLevelEnum roleLevelEnum = this.getUserLevel();
            switch (roleLevelEnum) {
                case bizAdmin: {
                    SsoUser ssoUser = this.getUser();
                    SysBizManage sysBizManage = this.sysBizManageService.queryByUserId(ssoUser.getUserid());
                    List<String> orgIdPaths = sysBizManage.getOrganizations().stream().map(f -> f.getIdpath()).collect(Collectors.toList());
                    this.wrapperQueryMapper((MPJLambdaWrapper<SysOrganization>)queryWrapper, orgIdPaths);
                    break;
                }
                default: {
                    if (TenantUtil.isSuperTenant()) break;
                    SysTenant sysTenant = this.getTenant();
                    List<String> tenatOrgIdPaths = sysTenant.getOrganizations().stream().map(f -> f.getIdpath()).collect(Collectors.toList());
                    this.wrapperQueryMapper((MPJLambdaWrapper<SysOrganization>)queryWrapper, tenatOrgIdPaths);
                }
            }
            return queryWrapper;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private void wrapperQueryMapper(MPJLambdaWrapper<SysOrganization> queryWrapper, List<String> orgIdPaths) {
        if (orgIdPaths.size() == 0) {
            queryWrapper.in(SysOrganization::getLevel, new Object[]{-100});
        } else {
            queryWrapper.and(wrapper -> {
                for (String orgIdPath : orgIdPaths) {
                    ((MPJLambdaWrapper)wrapper.or()).likeRight(SysOrganization::getIdpath, (Object)orgIdPath);
                }
            });
        }
    }
}

