/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.local.service;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.geoway.jckj.base.exception.ServiceException;
import com.geoway.jckj.base.support.query.MPJQueryMapperUtil;
import com.geoway.jckj.biz.config.SsoConfig;
import com.geoway.jckj.biz.entity.BaseEntity;
import com.geoway.jckj.biz.entity.SaasEntity;
import com.geoway.jckj.biz.entity.SysBizManage;
import com.geoway.jckj.biz.entity.SysOrganization;
import com.geoway.jckj.biz.entity.SysRegion;
import com.geoway.jckj.biz.entity.SysTenant;
import com.geoway.jckj.biz.entity.SysUser;
import com.geoway.jckj.biz.entity.SysUserLimit;
import com.geoway.jckj.biz.entity.SysUserOrganization;
import com.geoway.jckj.biz.entity.SysUserRegion;
import com.geoway.jckj.biz.enums.TenantUserRangeEnum;
import com.geoway.jckj.biz.mapper.SysUserLimitMapper;
import com.geoway.jckj.biz.service.dev.base.IUserLimitService;
import com.geoway.jckj.biz.util.BizManageUtil;
import com.geoway.jckj.biz.util.LoginUtil;
import com.geoway.jckj.biz.util.PhoneNumberUtil;
import com.geoway.jckj.biz.util.TenantUtil;
import com.geoway.sso.client.enums.RoleLevelEnum;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.client.util.CommonLoginUserUtil;
import com.github.yulichang.base.MPJBaseServiceImpl;
import com.github.yulichang.interfaces.MPJBaseJoin;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="localUserLimitService")
public class LocalUserLimitServiceImpl
extends MPJBaseServiceImpl<SysUserLimitMapper, SysUserLimit>
implements IUserLimitService {
    @Autowired
    SsoConfig ssoConfig;
    @Autowired
    PhoneNumberUtil phoneNumberUtil;

    public IPage<SysUserLimit> queryPage(String filterParam, String sortParam, String username, String tel, int page, int size) {
        try {
            MPJQueryMapperUtil qmu = new MPJQueryMapperUtil();
            if (this.phoneNumberUtil.isTelEncrypt()) {
                filterParam = this.phoneNumberUtil.convertPhoneNumberFilterParam(filterParam);
            }
            MPJLambdaWrapper queryWrapper = qmu.queryMapper(filterParam, sortParam, SysUserLimit.class);
            queryWrapper.selectAll(SysUserLimit.class);
            queryWrapper.selectAs("su", SysUser::getName, SysUserLimit::getUsername);
            queryWrapper.selectAs("su", SysUser::getTel, SysUserLimit::getTel);
            queryWrapper.selectAs("su", SysUser::getEmail, SysUserLimit::getEmail);
            queryWrapper.leftJoin(SysUser.class, "su", SysUser::getId, SysUserLimit::getUserid);
            if (StrUtil.isNotBlank((CharSequence)username)) {
                queryWrapper.or(query -> {
                    MPJLambdaWrapper cfr_ignored_0 = (MPJLambdaWrapper)query.like(SysUser::getName, (Object)username);
                });
            }
            if (StrUtil.isNotBlank((CharSequence)tel)) {
                if (this.phoneNumberUtil.isTelEncrypt()) {
                    queryWrapper.or(query -> {
                        MPJLambdaWrapper cfr_ignored_0 = (MPJLambdaWrapper)query.eq(SysUser::getTelEncrypt, (Object)this.phoneNumberUtil.getEncryptPhoneNumber(tel));
                    });
                } else {
                    queryWrapper.or(query -> {
                        MPJLambdaWrapper cfr_ignored_0 = (MPJLambdaWrapper)query.like(SysUser::getTel, (Object)tel);
                    });
                }
            }
            RoleLevelEnum roleLevelEnum = LoginUtil.getUserLevel();
            switch (roleLevelEnum) {
                case bizAdmin: {
                    SsoUser ssoUser = CommonLoginUserUtil.getUser();
                    SysBizManage bizManage = BizManageUtil.getBizManage();
                    List<String> bizOrgIdPaths = bizManage.getOrganizations().stream().map(f -> f.getIdpath()).collect(Collectors.toList());
                    List<String> bizRegionIdPaths = bizManage.getRegions().stream().map(f -> f.getIdpath()).collect(Collectors.toList());
                    this.wrapperLeftJoinMapper((MPJLambdaWrapper<SysUserLimit>)queryWrapper, bizOrgIdPaths, bizRegionIdPaths);
                    queryWrapper.and(wrapper -> {
                        this.wrapperQueryMapper((MPJLambdaWrapper<SysUserLimit>)wrapper, bizOrgIdPaths, bizRegionIdPaths);
                        ((MPJLambdaWrapper)wrapper.or()).eq(BaseEntity::getCreatorid, (Object)ssoUser.getId());
                    });
                    break;
                }
                default: {
                    if (TenantUtil.isSuperTenant()) break;
                    SysTenant tenant = TenantUtil.getTenant();
                    List<String> orgIdPaths = tenant.getOrganizations().stream().map(f -> f.getIdpath()).collect(Collectors.toList());
                    List<String> regionIdPaths = tenant.getRegions().stream().map(f -> f.getIdpath()).collect(Collectors.toList());
                    this.wrapperLeftJoinMapper((MPJLambdaWrapper<SysUserLimit>)queryWrapper, orgIdPaths, regionIdPaths);
                    queryWrapper.and(wrapper -> {
                        this.wrapperQueryMapper((MPJLambdaWrapper<SysUserLimit>)wrapper, orgIdPaths, regionIdPaths);
                        ((MPJLambdaWrapper)wrapper.or()).eq(SaasEntity::getTenantid, (Object)tenant.getId());
                        if (tenant.getUsers().size() > 0) {
                            ((MPJLambdaWrapper)wrapper.or()).in(SysUser::getId, (Collection)tenant.getUsers().stream().map(f -> f.getId()).collect(Collectors.toList()));
                        }
                    });
                }
            }
            Page pageT = new Page((long)page, (long)size);
            IPage pageResults = this.selectJoinListPage((IPage)pageT, SysUserLimit.class, (MPJBaseJoin)queryWrapper);
            return pageResults;
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    private void wrapperLeftJoinMapper(MPJLambdaWrapper<SysUserLimit> wrapper, List<String> orgIdPaths, List<String> regionIdPaths) {
        TenantUserRangeEnum userRangeEnum = TenantUserRangeEnum.getEnumByValue((int)this.ssoConfig.getTenantUserRange());
        if ((userRangeEnum == TenantUserRangeEnum.ORG || userRangeEnum == TenantUserRangeEnum.REGION_ORG) && orgIdPaths.size() > 0) {
            wrapper.leftJoin(SysUserOrganization.class, SysUserOrganization::getUserid, SysUser::getId);
            wrapper.leftJoin(SysOrganization.class, SysOrganization::getId, SysUserOrganization::getOrgid);
        }
        if ((userRangeEnum == TenantUserRangeEnum.REGION || userRangeEnum == TenantUserRangeEnum.REGION_ORG) && regionIdPaths.size() > 0) {
            wrapper.leftJoin(SysUserRegion.class, SysUserRegion::getUserid, SysUser::getId);
            wrapper.leftJoin(SysRegion.class, SysRegion::getId, SysUserRegion::getRegionid);
        }
    }

    private void wrapperQueryMapper(MPJLambdaWrapper<SysUserLimit> wrapper, List<String> orgIdPaths, List<String> regionIdPaths) {
        TenantUserRangeEnum userRangeEnum = TenantUserRangeEnum.getEnumByValue((int)this.ssoConfig.getTenantUserRange());
        if ((userRangeEnum == TenantUserRangeEnum.ORG || userRangeEnum == TenantUserRangeEnum.REGION_ORG) && orgIdPaths.size() > 0) {
            for (String orgIdPath : orgIdPaths) {
                ((MPJLambdaWrapper)wrapper.or()).likeRight(SysOrganization::getIdpath, (Object)orgIdPath);
            }
        }
        if ((userRangeEnum == TenantUserRangeEnum.REGION || userRangeEnum == TenantUserRangeEnum.REGION_ORG) && regionIdPaths.size() > 0) {
            for (String regionIdPath : regionIdPaths) {
                ((MPJLambdaWrapper)wrapper.or()).likeRight(SysRegion::getIdpath, (Object)regionIdPath);
            }
        }
    }
}

