/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.local.service;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.jckj.base.exception.ServiceException;
import com.geoway.jckj.base.support.query.MyBatisQueryMapperUtils;
import com.geoway.jckj.biz.entity.SysUser;
import com.geoway.jckj.biz.entity.SysUserOrganization;
import com.geoway.jckj.biz.local.mapper.SysUserMapper;
import com.geoway.jckj.biz.local.mapper.SysUserOrganizationMapper;
import com.geoway.jckj.biz.service.dev.base.IUserOrganizationService;
import com.geoway.jckj.biz.util.BizManageUtil;
import com.geoway.jckj.biz.util.LoginUtil;
import com.geoway.jckj.biz.util.TenantUtil;
import com.geoway.sso.client.annotation.OpLog;
import com.geoway.sso.client.enums.OpTypeEnum;
import com.geoway.sso.client.enums.RoleLevelEnum;
import com.github.yulichang.interfaces.MPJBaseJoin;
import com.github.yulichang.toolkit.MPJWrappers;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="localUserOrganizationService")
public class LocalUserOrganizationServiceImpl
extends ServiceImpl<SysUserOrganizationMapper, SysUserOrganization>
implements IUserOrganizationService {
    @Autowired
    private SysUserOrganizationMapper sysUserOrganizationMapper;
    @Autowired
    SysUserMapper sysUserMapper;

    @OpLog(name="\u4fee\u6539\u7528\u6237\u6240\u5c5e\u7ec4\u7ec7", opType=OpTypeEnum.update)
    public void updateUserOrg(String userId, List<String> orgIds) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysUserOrganization::getUserid, (Object)userId);
        RoleLevelEnum userLevel = LoginUtil.getUserLevel();
        switch (userLevel) {
            case bizAdmin: {
                List bizOrgIds = BizManageUtil.getBizManageOrgIds();
                if (bizOrgIds.size() == 0) {
                    wrapper.eq(SysUserOrganization::getOrgid, (Object)UUID.randomUUID().toString());
                    break;
                }
                wrapper.in(SysUserOrganization::getOrgid, (Collection)bizOrgIds);
                break;
            }
            default: {
                if (TenantUtil.isSuperTenant()) break;
                List tenantOrgIds = TenantUtil.getTenantOrgIds();
                if (tenantOrgIds.size() == 0) {
                    wrapper.eq(SysUserOrganization::getOrgid, (Object)UUID.randomUUID().toString());
                    break;
                }
                wrapper.in(SysUserOrganization::getOrgid, (Collection)tenantOrgIds);
            }
        }
        this.sysUserOrganizationMapper.delete((Wrapper)wrapper);
        if (orgIds == null) {
            return;
        }
        ArrayList<SysUserOrganization> userOrgs = new ArrayList<SysUserOrganization>();
        for (String orgId : orgIds) {
            SysUserOrganization userOrg = new SysUserOrganization();
            userOrg.setUserid(userId);
            userOrg.setOrgid(orgId);
            userOrgs.add(userOrg);
        }
        if (userOrgs.size() > 0) {
            for (SysUserOrganization userOrg : userOrgs) {
                this.sysUserOrganizationMapper.insert(userOrg);
            }
        }
    }

    public void updateOrgUsers(String orgId, List<String> userIds) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysUserOrganization::getOrgid, (Object)orgId);
        this.sysUserOrganizationMapper.delete((Wrapper)wrapper);
        ArrayList<SysUserOrganization> userOrgs = new ArrayList<SysUserOrganization>();
        for (String userId : userIds) {
            SysUserOrganization userOrg = new SysUserOrganization();
            userOrg.setUserid(userId);
            userOrg.setOrgid(orgId);
            userOrgs.add(userOrg);
        }
        if (userOrgs.size() > 0) {
            for (SysUserOrganization userOrg : userOrgs) {
                this.sysUserOrganizationMapper.insert(userOrg);
            }
        }
    }

    public void saveBatch(List<SysUserOrganization> userOrgs) {
        super.saveBatch(userOrgs);
    }

    public void saveOne(SysUserOrganization userOrg) {
        this.sysUserOrganizationMapper.insert(userOrg);
    }

    public void removeByOrgUserId(String orgId, String userId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        if (StrUtil.isNotEmpty((CharSequence)orgId)) {
            wrapper.eq(SysUserOrganization::getOrgid, (Object)orgId);
        }
        if (StrUtil.isNotEmpty((CharSequence)userId)) {
            wrapper.eq(SysUserOrganization::getUserid, (Object)userId);
        }
        this.sysUserOrganizationMapper.delete((Wrapper)wrapper);
    }

    public void removeByOrgUserIds(String orgId, List<String> userIds) {
        if (userIds == null || userIds.size() == 0) {
            return;
        }
        if (StrUtil.isBlank((CharSequence)orgId)) {
            return;
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysUserOrganization::getOrgid, (Object)orgId);
        wrapper.in(SysUserOrganization::getUserid, userIds);
        this.remove((Wrapper)wrapper);
    }

    public List<String> queryOrgUserIds(String orgId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysUserOrganization::getOrgid, (Object)orgId);
        List<String> userIds = this.list((Wrapper)wrapper).stream().map(i -> i.getUserid()).collect(Collectors.toList());
        return userIds;
    }

    public List<SysUserOrganization> queryByOrgId(String orgId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysUserOrganization::getOrgid, (Object)orgId);
        return this.sysUserOrganizationMapper.selectList((Wrapper)wrapper);
    }

    public List<SysUserOrganization> queryList(String filterParam) {
        try {
            MyBatisQueryMapperUtils qmu = new MyBatisQueryMapperUtils();
            QueryWrapper queryWrapper = qmu.queryMapper(filterParam, SysUserOrganization.class);
            return this.sysUserOrganizationMapper.selectList((Wrapper)queryWrapper);
        }
        catch (Exception exception) {
            throw new ServiceException((Throwable)exception);
        }
    }

    public List<SysUser> queryUsersByOrgsIds(List<String> orgIds) {
        if (orgIds == null || orgIds.size() == 0) {
            return new ArrayList<SysUser>();
        }
        MPJLambdaWrapper queyyWrapper = MPJWrappers.lambdaJoin();
        queyyWrapper.leftJoin(SysUserOrganization.class, SysUserOrganization::getUserid, SysUser::getId);
        queyyWrapper.in(SysUserOrganization::getOrgid, orgIds);
        return this.sysUserMapper.selectJoinList(SysUser.class, (MPJBaseJoin)queyyWrapper);
    }
}

