package com.geoway.jckj.biz.entity;

import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;
import java.util.List;

/**
 * 系统
 * @author: wujing
 * @Date: 2021/11/15
 */
@Data
@NoArgsConstructor
@TableName(value = "sys_system")
public class SysSystem extends SaasEntity {

    @TableId(value = "f_id", type = IdType.INPUT)
    private String id;

    /**
     * 系统名称
     */
    @TableField(value = "f_name")
    private String name;

    /**
     * 关键字
     */
    @TableField(value = "f_key")
    private String key;

    /**
     * 版本
     */
    @TableField(value = "f_version")
    private String version;

    /**
     * 系统图标
     */
    @TableField(value = "f_icon")
    private String icon;

    /**
     * 所属公司
     */
    @TableField(value = "f_company")
    private String company;

    /**
     * 地址
     */
    @TableField(value = "f_url")
    private String url;

    /**
     * 后端地址
     */
    @TableField(value = "f_backendurl")
    private String backendUrl;

    /**
     * 系统类型（1.注册的应用2.构建的系统)
     */
    @TableField(value = "f_type")
    private Integer type;

    /**
     * 创建时间
     */
    @TableField(value = "f_createtime", fill = FieldFill.INSERT)
    private Date createtime;

    /**
     * 主题id
     */
    @TableField(value = "f_themeid")
    private String themeid;

    /**
     * 样式
     */
    @TableField(value = "f_style")
    private String style;

    /**
     * 是否内置应用（0.否 1.是）
     */
    @TableField(value = "f_inner")
    private Integer inner;

    /**
     * 分組id
     */
    @TableField(value = "f_groupid")
    private String groupid;

    /**
     *logo id
     */
    @TableField(value = "f_logid")
    private String logoid;

    /**
     *背景 id
     */
    @TableField(value = "f_bgid")
    private String bgid;


    @TableField(value = "f_params")
    private String params;

    /**
     * 系统状态
     */
    @TableField(value = "f_state")
    private Integer state=1;


    /**
     * 系统地址是否可访问（0不可访问，1可访问）
     */
    @TableField(value = "f_access")
    private int access =1;

    @TableField(value = "f_bz")
    private String bz;



    @TableField(exist = false)
    @ApiModelProperty(hidden=true)
    private List<SysMenu> sysMenu;

    @TableField(exist = false)
    @ApiModelProperty(hidden=true)
    private List<SysMenu> uCenterMenu;

    @TableField(exist = false)
    @ApiModelProperty(hidden=true)
    private int spaceStatus =-1;

    /**
     * 展示名称：租户自己创建的显示
     */
    @TableField(exist = false)
    @ApiModelProperty(hidden=true)
    private String displayName;
    @TableField(exist = false)
    private static final long serialVersionUID = 1L;

}
