package com.geoway.jckj.biz.mapper;

import com.geoway.jckj.biz.entity.SysRegion;
import com.github.yulichang.base.MPJBaseMapper;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
* @author daidongdong
* @description 针对表【sys_region】的数据库操作Mapper
* @createDate 2022-01-20 15:42:06
* @Entity com.geoway.ns.design.biz.entity.SysRegion
*/
@Repository
public interface SysRegionMapper extends MPJBaseMapper<SysRegion> {

    /**
     * 查询用户关联组织机构
     * @param userId
     * @return
     */
    List<SysRegion> queryUserRegions(String userId);

    /**
     * 按照代码递归查询其下所有辖区
     * @return
     */
    List<SysRegion> getRegionListByCode(String regionCode);


    /**
     * 按照代码递归查询其下所有辖区
     * @return
     */
    List<SysRegion> getRegionListById(String id);


    /**
     * 按照代码递归查询其上级区划
     * @return
     */
    List<SysRegion> getAllParentRegion(String regionCode);
    /**
     * 按照代码递归查询其上级区划
     * @return
     */
    List<SysRegion> getAllParentRegionById(String id);


}




