package com.geoway.jckj.biz.service;

import cn.hutool.core.util.StrUtil;
import com.geoway.jckj.biz.entity.BaseEntity;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.client.util.CommonLoginUserUtil;
import com.google.common.reflect.TypeToken;

/**
 * @author 连世忠
 * @ClassName IBaseEntityService
 * @Description TODO
 * @date 2025/3/18 8:23
 * @Version 1.0
 */
public interface IBaseEntityService<T extends BaseEntity> {
    /**
     * 获取用户id
     * @return
     */
    default  String getUserId(){
        SsoUser ssoUser=getUser();
        return ssoUser!=null?ssoUser.getUserid():"";
    }
    /**
     * 获取用户
     * @return
     */
    default SsoUser getUser(){
      return CommonLoginUserUtil.getUser();
    }

    default String getQueryUserId(){
        return CommonLoginUserUtil.getQueryUserId();
    }
    default void wrapperEntity(T baseEntity){
        if(StrUtil.isBlank(baseEntity.getCreatorid())){
            baseEntity.setCreatorid(baseEntity.getCreatorid());
        }
    }

    /**
     * 获取泛型的类型
     * @return
     */
    default  Class getClassT(){
        TypeToken<T> typeToken = new TypeToken<T>(getClass()) {};
        @SuppressWarnings("unchecked")
        Class<T> clazz = (Class<T>) typeToken.getRawType();
        return clazz;
        //Class superClass = getClass();
        //Type genericSuperclass = superClass.getGenericSuperclass();
       // while (!(genericSuperclass instanceof ParameterizedType)) {
            //superClass = superClass.getSuperclass();
            //genericSuperclass = superClass.getGenericSuperclass();
        //}
        //Map<String,Object> param=new HashMap<>();
        //Class<T> classT = (Class<T>) ((ParameterizedType) genericSuperclass).getActualTypeArguments()[0];
        //return classT;
    }
}
