package com.geoway.jckj.biz.service;

import cn.hutool.core.util.StrUtil;
import com.geoway.jckj.base.exception.ServiceException;
import com.geoway.jckj.base.support.query.MPJQueryMapperUtil;
import com.geoway.jckj.biz.entity.SaasEntity;
import com.geoway.jckj.biz.entity.SysTenant;
import com.geoway.jckj.biz.util.TenantUtil;
import com.github.yulichang.wrapper.MPJLambdaWrapper;

import static com.geoway.jckj.biz.constants.TenantConstants.AdminTenantId;

/**
 * @author 连世忠
 * @ClassName ISaasService
 * @Description TODO
 * @date 2025/3/17 10:58
 * @Version 1.0
 */
public interface ISaasEntityService<T extends SaasEntity> extends IBaseEntityService<T>  {




    /**
     *获取租户信息
     * @return
     */
    default SysTenant getTenant(){
        return TenantUtil.getTenant();
    }
    /**
     * 获取租户ID
     * @return
     */
    default  String getTenantId(){
        return TenantUtil.getTenantId();
    }
    /**
     * 获取查询方法
     * @return
     */
    default MPJLambdaWrapper<T> buildLambdaWrapper(String filterParam,String sortParam){
        try {
            if(filterParam==null){
                filterParam="";
            }
            if(sortParam==null){
                sortParam="";
            }
            MPJQueryMapperUtil<T> qmu = new MPJQueryMapperUtil<>();
            MPJLambdaWrapper<T> queryWrapper = qmu.queryMapper(filterParam,sortParam, getClassT());
            queryWrapper.eq(T::getTenantid, getTenantId());
            return queryWrapper;
        }catch (Exception exception){
            throw new ServiceException(exception);
        }
    }

    /**
     * 给实体附上id
     * @param entity
     */
    @Override
    default void wrapperEntity(T entity){
        if(StrUtil.isBlank(entity.getTenantid())||entity.getTenantid().equals(AdminTenantId)){
            entity.setTenantid(getTenantId());
        }
        IBaseEntityService.super.wrapperEntity(entity);
    }
}
