package com.geoway.jckj.biz.service.dev.base;

import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.SsoUser;

import javax.servlet.http.HttpServletRequest;

/**
 * @author ALMJ
 * @desc 用户服务接口
 */
public interface ILoginService extends IUserSystem {
    /**
     * 手机一键登入
     * @param processId
     * @param token
     * @param authCode
     * @param req
     * @return
     */
    Result<SsoUser> loginByOne(String processId, String token, String authCode, HttpServletRequest req);
    /**
     * Ca证书登入
     * @param caUserCert
     * @param caOauthName
     * @param req
     * @return
     */
    Result<SsoUser> loginByCa(String caUserCert, String caOauthName, HttpServletRequest req);

    /**
     * 短信验证码登入
     * @param tel
     * @param uuid
     * @param code
     * @param req
     * @return
     */
    Result<SsoUser> loginBySms(String tel, String uuid, String code, HttpServletRequest req);
    /**
     * 账号密码+验证码登入
     * @param username
     * @param password
     * @param uuid
     * @param code
     * @param req
     * @return
     */
    Result<SsoUser> login(String username, String password,String uuid,String code,HttpServletRequest req);

    /**
     * 账号密码+无验证码登入
     * @param username
     * @param password
     * @return
     */
    Result<SsoUser> login(String username, String password);

    /**
     * 登出
     * @param request
     * @param access_token
     */
    boolean loginOut(HttpServletRequest request, String access_token);
}
