package com.geoway.jckj.biz.service.dev.unity.impl;

import com.geoway.jckj.biz.service.dev.unity.IUnity;
import com.geoway.jckj.biz.service.dev.unity.UnityUtil;
import com.geoway.jckj.biz.service.dev.base.IUserSystem;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author 连世忠
 * @ClassName UntityBaseImpl
 * @Description TODO
 * @date 2025/4/30 16:20
 * @Version 1.0
 */
public abstract   class UnityBaseImpl<T extends IUserSystem> implements IUserSystem, IUnity<T> {
    /**
     * 获取用户体系类型：0、集成框架（默认），1、国土调查云 2、uis用户 3、外部的用户体系 ...
     * @return
     */
    @Override
    public String getUserSystem(){
        return "unity";
    }

    @Override
    public List<T> getServices(){
        return UnityUtil.getServices(getDeaultT());
    }

    @Override
    public T getService(){
        IUserSystem result= UnityUtil.getService(getDeaultT());
        return (T)result;
    }

    @Override
    public T getDefaultService() {
        IUserSystem result= UnityUtil.getDefaultService(getDeaultT());
        return (T)result;
    }

    @Override
    public T getLocalService() {
        IUserSystem result= UnityUtil.getLocalService(getDeaultT());
        return (T)result;
    }


    /**
     * 获取泛型的类型
     * @return
     */
    private   Class getDeaultT(){
        Class superClass = getClass();
        Type genericSuperclass = superClass.getGenericSuperclass();
        while (!(genericSuperclass instanceof ParameterizedType)) {
            superClass = superClass.getSuperclass();
            genericSuperclass = superClass.getGenericSuperclass();
        }
        Map<String,Object> param=new HashMap<>();
        Class<T> classT = (Class<T>) ((ParameterizedType) genericSuperclass).getActualTypeArguments()[0];
        return classT;
    }

}
