package com.geoway.jckj.biz.service.login;


import cn.hutool.captcha.AbstractCaptcha;
import cn.hutool.captcha.LineCaptcha;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Map;

/**
 * @author ALMJ
 * @desc 应用服务接口
 */
public interface ICaptchaService {
    /**
     * 生成验证码
     *
     * @param width
     * @param height
     * @return
     */
    AbstractCaptcha createImageCaptcha(String width, String height);

    void storeCaptcha(String sessionId, String captchaText);

    String queryCaptcha(String sessionId);

    /**
     * 移除
     * @param sessionId
     * @return
     */
    void removeCaptcha(String sessionId);
    /**
     * 登录验证码验证服务
     *
     * @param code 验证码
     * @return
     */
    boolean validateCaptcha(String code, String storeCode);
}
